/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.android.annotation.BindSqlType;
import com.abubusoft.kripton.android.annotation.BindTransaction;
import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.ModelClass;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.ForeignKeyNotFoundException;
import com.abubusoft.kripton.processor.exceptions.IncompatibleAttributesInAnnotationException;
import com.abubusoft.kripton.processor.exceptions.InvalidDefinition;
import com.abubusoft.kripton.processor.exceptions.InvalidKindForAnnotationException;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.exceptions.InvalidPropertyToColumnConversion;
import com.abubusoft.kripton.processor.exceptions.InvalidTypeForAnnotationException;
import com.abubusoft.kripton.processor.exceptions.KriptonProcessorException;
import com.abubusoft.kripton.processor.exceptions.MissedAnnotationOnClass;
import com.abubusoft.kripton.processor.exceptions.PropertyVisibilityException;
import com.abubusoft.kripton.processor.exceptions.UnknownClassInJQLException;
import com.abubusoft.kripton.processor.exceptions.UnknownParamUsedInJQLException;
import com.abubusoft.kripton.processor.exceptions.UnknownPropertyInJQLException;
import com.abubusoft.kripton.processor.exceptions.UnsupportedFieldTypeException;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public abstract class AssertKripton {
    public static void assertTrue(boolean expression, String messageFormat, Object ... args) {
        if (!expression) {
            throw new KriptonProcessorException(String.format(messageFormat, args));
        }
    }

    public static void assertTrueOrInvalidMethodSignException(boolean expression, SQLiteModelMethod method, String messageFormat, Object ... args) {
        if (!expression) {
            throw new InvalidMethodSignException(method, String.format(messageFormat, args));
        }
    }

    public static void assertTrueOrInvalidMethodSignException(boolean expression, SQLiteModelMethod method) {
        if (!expression) {
            throw new InvalidMethodSignException(method);
        }
    }

    public static void failWithInvalidMethodSignException(boolean expression, SQLiteModelMethod method) {
        AssertKripton.assertTrueOrInvalidMethodSignException(!expression, method);
    }

    public static void failWithInvalidMethodSignException(boolean expression, SQLiteModelMethod method, String messageFormat, Object ... args) {
        AssertKripton.assertTrueOrInvalidMethodSignException(!expression, method, messageFormat, args);
    }

    public static void fail(String messageFormat, Object ... args) {
        AssertKripton.assertTrue(false, messageFormat, args);
    }

    public static void failIncompatibleAttributesInAnnotationException(String messageFormat, Object ... args) {
        throw new IncompatibleAttributesInAnnotationException(String.format(messageFormat, args));
    }

    public static void fail(boolean expression, String messageFormat, Object ... args) {
        AssertKripton.assertTrue(!expression, messageFormat, args);
    }

    public static void assertTrueOrUnsupportedFieldTypeException(boolean expression, TypeName typeName) {
        if (!expression) {
            throw new UnsupportedFieldTypeException(typeName);
        }
    }

    public static void assertTrueOrInvalidKindForAnnotationException(boolean expression, Element element, Class<? extends Annotation> annotationClazz) {
        if (!expression) {
            String msg = String.format("%s %s, only class can be annotated with @%s annotation", new Object[]{element.getKind(), element, annotationClazz.getSimpleName()});
            throw new InvalidKindForAnnotationException(msg);
        }
    }

    public static void assertTrueOrInvalidTypeForAnnotationMethodParameterException(boolean expression, Element classElement, ExecutableElement methodElement, VariableElement parameterElement, Class<? extends Annotation> annotationClazz) {
        if (!expression) {
            String msg = String.format("In method '%s.%s', parameter '%s' has an invalid type '%s' for @%s annotation", classElement.getSimpleName().toString(), methodElement.getSimpleName().toString(), parameterElement.getSimpleName().toString(), parameterElement.asType(), annotationClazz.getSimpleName());
            throw new InvalidTypeForAnnotationException(msg);
        }
    }

    public static void assertNotNull(Object value, KriptonProcessorException exception) {
        if (value == null) {
            throw exception;
        }
    }

    public static void assertTrueOrUnknownPropertyInJQLException(boolean expression, JQLContext method, String columnName) {
        if (!expression) {
            throw new UnknownPropertyInJQLException(method, columnName);
        }
    }

    public static void assertTrueOrUnknownClassInJQLException(boolean expression, SQLiteModelMethod method, String className) {
        if (!expression) {
            throw new UnknownClassInJQLException(method, className);
        }
    }

    public static void assertTrueOrUnknownParamInJQLException(boolean expression, SQLiteModelMethod method, String paramName) {
        if (!expression) {
            throw new UnknownParamUsedInJQLException(method, paramName);
        }
    }

    public static void failUnknownPropertyInJQLException(SQLiteModelMethod method, Class<? extends Annotation> annotationClazz, AnnotationAttributeType attribute, String fieldName) {
        throw new UnknownPropertyInJQLException(method, annotationClazz, attribute, fieldName);
    }

    public static void assertTrueOrInvalidPropertyName(boolean expression, SQLProperty item1, SQLProperty item2) {
        if (!expression) {
            String msg = String.format("Properties '%s#%s' and '%s#%s' must have same column name", item1.getParent().name, item1.name, item2.getParent().name, item2.name);
            throw new InvalidPropertyToColumnConversion(msg);
        }
    }

    public static void asserTrueOrForeignKeyNotFound(boolean expression, SQLiteEntity currentEntity, ClassName entity) {
        if (!expression) {
            throw new ForeignKeyNotFoundException(currentEntity, entity);
        }
    }

    public static void asserTrueOrMissedAnnotationOnClassException(boolean expression, TypeElement daoElement, String entityName) {
        if (!expression) {
            String msg = String.format("Dao '%s' referes a bean '%s' without @%s or @%s annotation", daoElement.getQualifiedName(), TypeUtility.className(entityName), BindType.class.getSimpleName(), BindSqlType.class.getSimpleName());
            throw new MissedAnnotationOnClass(msg);
        }
    }

    public static void asserTrueOrUnspecifiedBeanException(boolean expression, SQLiteDatabaseSchema schema, SQLiteEntity entity, String foreignClassName) {
        if (!expression) {
            String msg = String.format("In dao definition '%s' is referred a bean definition '%s' that is not defined in '%s' schema", entity.getSimpleName(), foreignClassName, ((TypeElement)schema.getElement()).getQualifiedName().toString());
            throw new InvalidDefinition(msg);
        }
    }

    public static void assertTrueOfInvalidDefinition(boolean expression, ModelProperty property, String message) {
        if (!expression) {
            String msg = String.format("In class '%s', property '%s' has invalid definition: %s", property.getParent().getElement().asType().toString(), property.getName(), message);
            throw new InvalidDefinition(msg);
        }
    }

    public static void assertTrueOfInvalidDefinition(boolean expression, SQLProperty property, String message) {
        if (!expression) {
            String msg = String.format("In class '%s', property '%s' has invalid definition: %s", property.getParent().getElement().asType().toString(), property.getName(), message);
            throw new InvalidDefinition(msg);
        }
    }

    public static void assertTrueOrInvalidGlobalTypeApdaterException(boolean expression, SQLiteDatabaseSchema sqLiteDatabaseSchema, String typeAdapter, String typeAdapter2) {
        if (!expression) {
            String msg = String.format("In data source '%s', there are two or more global type adapter that cover type '%s': '%s' and '%s'", ((TypeElement)sqLiteDatabaseSchema.getElement()).getQualifiedName(), TypeAdapterHelper.detectSourceType(typeAdapter), typeAdapter, typeAdapter2);
            throw new InvalidDefinition(msg);
        }
    }

    public static void assertTrueOfInvalidConstructor(boolean expression, ModelClass<?> entity) {
        if (!expression) {
            String msg = String.format("Class '%s' has no constructor without parameters (to be a mutable class) or with all parameters (to be an immutable class).", ((TypeElement)entity.getElement()).getQualifiedName());
            throw new InvalidDefinition(msg);
        }
    }

    public static void assertTrueOfInvalidConstructorProperty(boolean expression, ModelClass<?> entity, String fieldName) {
        if (!expression) {
            String msg = String.format("In class '%s' the constructor '%s' parameters has different type than associated property type.", ((TypeElement)entity.getElement()).getQualifiedName(), fieldName);
            throw new InvalidDefinition(msg);
        }
    }

    public static void assertTrueOfInvalidWritable(boolean expression, ModelClass<?> entity) {
        if (!expression) {
            String msg = String.format("In class '%s' there are readonly properties and no valid constructor to define all properties.", ((TypeElement)entity.getElement()).getQualifiedName());
            throw new PropertyVisibilityException(msg);
        }
    }

    public static void assertTrueOrInvalidMethodSignException(boolean expression, SQLiteDatabaseSchema sqLiteDatabaseSchema, ExecutableElement methodElement) {
        if (!expression) {
            String msg = String.format("In data source definition '%s', method %s must be static to decorated with @%s annotation.", ((TypeElement)sqLiteDatabaseSchema.getElement()).getQualifiedName(), methodElement.getSimpleName(), BindTransaction.class.getSimpleName());
            throw new PropertyVisibilityException(msg);
        }
    }
}

