/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import java.util.List;
import java.util.Map;

public class ModelAnnotation {
    protected String name;
    protected Map<String, String> attributes;

    public String getName() {
        return this.name;
    }

    public ModelAnnotation(String name, Map<String, String> attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    public String getAttribute(AnnotationAttributeType attribute) {
        return this.attributes.get(attribute.getValue());
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getSimpleName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    public String getAttributeAsClassName(AnnotationAttributeType attribute) {
        String temp = this.attributes.get(attribute.getValue());
        if (StringUtils.hasText((String)temp)) {
            temp = temp.replace(".class", "");
        }
        return temp;
    }

    public boolean getAttributeAsBoolean(AnnotationAttributeType attribute) {
        String temp = this.attributes.get(attribute.getValue());
        return Boolean.parseBoolean(temp);
    }

    public List<String> getAttributeAsArray(AnnotationAttributeType attribute) {
        String temp = this.attributes.get(attribute.getValue());
        return AnnotationUtility.extractAsArrayOfString(temp);
    }

    public int getAttributeAsInt(AnnotationAttributeType attribute) {
        String temp = this.attributes.get(attribute.getValue());
        return Integer.parseInt(temp);
    }
}

