/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core.reflect;

import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelClass;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.PropertyFactory;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.PropertyVisibilityException;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public abstract class PropertyUtility {
    static Converter<String, String> converterField2Method = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    static Logger logger = Logger.getGlobal();
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";

    public static <P extends ModelProperty, T extends ModelClass<P>> void buildProperties(Elements elementUtils, T entity, PropertyFactory<T, P> factoryProperty, AnnotationUtility.AnnotationFilter propertyAnnotationFilter, PropertyCreatedListener<T, P> listener) {
        List<? extends Element> listA = elementUtils.getAllMembers((TypeElement)entity.getElement());
        ArrayList<Element> list = new ArrayList<Element>(listA);
        HashMap propertyMap = new HashMap();
        if (propertyAnnotationFilter != null) {
            AnnotationUtility.forEachAnnotations(entity.getElement(), propertyAnnotationFilter, null);
        }
        PropertyUtility.extractFields(entity, factoryProperty, list, propertyMap);
        list = null;
        String parentClassName = ((TypeElement)entity.getElement()).getSuperclass().toString();
        while (parentClassName != null && !Object.class.getCanonicalName().equals(parentClassName)) {
            TypeElement parentTypeElement = BaseProcessor.elementUtils.getTypeElement(parentClassName);
            if (parentTypeElement != null) {
                List<? extends Element> parentList = elementUtils.getAllMembers(parentTypeElement);
                list = new ArrayList<Element>(parentList);
                PropertyUtility.extractFields(entity, factoryProperty, list, propertyMap);
                parentClassName = parentTypeElement.getSuperclass().toString();
                continue;
            }
            parentClassName = null;
        }
        String propertyName = "";
        Converter converter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
        int status = 0;
        for (ModelProperty p : propertyMap.values()) {
            entity.add((ModelProperty)p);
        }
        list = new ArrayList<Element>(listA);
        for (Element item : list) {
            ExecutableElement method;
            String methodName = item.getSimpleName().toString();
            if (item.getKind() != ElementKind.METHOD || !item.getModifiers().contains((Object)Modifier.PUBLIC) || (method = (ExecutableElement)item).getParameters().size() > 1) continue;
            status = -1;
            if (methodName.startsWith(GET_PREFIX)) {
                status = 0;
                propertyName = methodName.substring(GET_PREFIX.length());
            } else if (methodName.startsWith(IS_PREFIX)) {
                status = 1;
                propertyName = methodName.substring(IS_PREFIX.length());
            } else if (methodName.startsWith(SET_PREFIX)) {
                status = 2;
                propertyName = methodName.substring(SET_PREFIX.length());
            }
            if (!propertyMap.containsKey(propertyName = (String)converter.convert((Object)propertyName))) continue;
            ModelProperty currentKriptonField = (ModelProperty)propertyMap.get(propertyName);
            TypeMirror paramTypeMirror = method.getParameters().size() == 1 ? method.getParameters().get(0).asType() : null;
            TypeMirror returnTypeMirror = method.getReturnType();
            if (status == 0 && currentKriptonField.isType(entity.resolveTypeVariable(TypeUtility.typeName(returnTypeMirror)))) {
                currentKriptonField.setFieldWithGetter(true);
                continue;
            }
            if (status == 1 && currentKriptonField.isType(entity.resolveTypeVariable(TypeUtility.typeName(returnTypeMirror)))) {
                currentKriptonField.setFieldWithIs(true);
                continue;
            }
            if (status != 2 || !currentKriptonField.isType(entity.resolveTypeVariable(TypeUtility.typeName(paramTypeMirror)))) continue;
            currentKriptonField.setFieldWithSetter(true);
        }
        if (listener != null) {
            ArrayList listPropertiesToFilter = new ArrayList(entity.getCollection());
            entity.getImmutableCollection().addAll(entity.getCollection());
            for (ModelProperty item : listPropertiesToFilter) {
                if (listener.onProperty(entity, item)) continue;
                entity.getCollection().remove(item);
            }
        }
    }

    private static <P extends ModelProperty, T extends ModelClass<P>> void extractFields(T entity, PropertyFactory<T, P> factoryProperty, List<Element> list, Map<String, P> propertyMap) {
        for (Element item : list) {
            if (item.getKind() != ElementKind.FIELD || !PropertyUtility.modifierIsAcceptable(item) || propertyMap.containsKey(item.getSimpleName().toString())) continue;
            P field = factoryProperty.createProperty(entity, item);
            propertyMap.put(((ModelEntity)field).getName(), field);
        }
    }

    static boolean modifierIsAcceptable(Element item) {
        Object[] values;
        for (Object i : values = new Object[]{Modifier.NATIVE, Modifier.STATIC, Modifier.ABSTRACT}) {
            if (!item.getModifiers().contains(i)) continue;
            return false;
        }
        return true;
    }

    public static String getter(ModelProperty property) {
        if (property.isPublicField()) {
            return property.getName();
        }
        if (property.isFieldWithGetter()) {
            return GET_PREFIX + (String)converterField2Method.convert((Object)property.getName()) + "()";
        }
        if (property.isFieldWithIs()) {
            return IS_PREFIX + (String)converterField2Method.convert((Object)property.getName()) + "()";
        }
        throw new PropertyVisibilityException(String.format("In class '%s' property '%s' can not be read", property.getParent().getElement().asType(), property.getName()));
    }

    public static String getter(String beanName, TypeName beanClass, ModelProperty property) {
        return beanName + (beanClass != null ? "." + PropertyUtility.getter(property) : "");
    }

    public static String setter(TypeName beanClass, String beanName, ModelProperty property) {
        if (property.getParent() != null && ((ModelClass)property.getParent()).isImmutablePojo()) {
            return ImmutableUtility.IMMUTABLE_PREFIX + property.getName();
        }
        String prefix = "";
        if (beanName != null) {
            prefix = beanName + ".";
        }
        if (property.isPublicField()) {
            return prefix + property.getName();
        }
        if (property.isFieldWithSetter()) {
            return prefix + SET_PREFIX + (String)converterField2Method.convert((Object)property.getName());
        }
        throw new PropertyVisibilityException(String.format("property '%s' of class '%s' can not be modify", property.getName(), property.getParent().getElement().asType()));
    }

    public static String setter(TypeName beanClass, String beanName, ModelProperty property, String value) {
        if (property.getParent() != null && ((ModelClass)property.getParent()).isImmutablePojo()) {
            return ImmutableUtility.IMMUTABLE_PREFIX + property.getName() + "=" + value;
        }
        return beanName + (beanClass != null ? "." + PropertyUtility.setter(property, value) : "=" + value);
    }

    private static String setter(ModelProperty property, String value) {
        if (property.getParent() != null && ((ModelClass)property.getParent()).isImmutablePojo()) {
            return ImmutableUtility.IMMUTABLE_PREFIX + property.getName() + "=" + value;
        }
        if (property.isPublicField()) {
            return property.getName() + "=" + value;
        }
        if (property.isFieldWithSetter()) {
            return SET_PREFIX + (String)converterField2Method.convert((Object)property.getName()) + "(" + value + ")";
        }
        throw new PropertyVisibilityException(String.format("property '%s' of class '%s' can not be modify", property.getName(), property.getParent().getElement().asType()));
    }

    public static interface PropertyCreatedListener<T extends ModelClass<? extends E>, E extends ModelProperty> {
        public boolean onProperty(T var1, E var2);
    }
}

