/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core.reflect;

import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.BindTypeSubProcessor;
import com.abubusoft.kripton.processor.core.ModelClass;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.abubusoft.kripton.processor.utils.LiteralType;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor7;

public abstract class TypeUtility {
    private static final String JAVA_LANG_ENUM = "java.lang.Enum<?>";

    public static boolean isTypeIncludedIn(TypeName value, Type ... types) {
        for (Type item : types) {
            if (!value.equals((Object)TypeUtility.typeName(item))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTypeEquals(TypeName value, TypeName value2) {
        return value.equals((Object)value2);
    }

    public static boolean isTypePrimitive(TypeName value) {
        return TypeUtility.isTypeIncludedIn(value, Byte.TYPE, Character.TYPE, Boolean.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    }

    public static boolean isTypeWrappedPrimitive(TypeName value) {
        return TypeUtility.isTypeIncludedIn(value, new Type[]{Byte.class, Character.class, Boolean.class, Short.class, Integer.class, Long.class, Float.class, Double.class});
    }

    public static boolean isEquals(TypeName value, String className) {
        return TypeUtility.isEquals(value, TypeUtility.typeName(className));
    }

    public static boolean isByteArray(TypeName value) {
        return value.toString().equals(Byte.TYPE.getCanonicalName() + "[]");
    }

    public static boolean isString(TypeName value) {
        return value.toString().equals(String.class.getCanonicalName());
    }

    public static boolean isNullable(TypeName value) {
        return !TypeUtility.isTypePrimitive(value);
    }

    public static boolean isEquals(TypeName value, ModelClass<?> entity) {
        return TypeUtility.isEquals(value, entity.getName());
    }

    public static boolean isEquals(TypeName value, TypeName kindOfParameter) {
        return value.toString().equals(kindOfParameter.toString());
    }

    public static ClassName classNameWithSuffix(String packageName, String className, String suffix) {
        return ClassName.get((String)packageName, (String)(className + suffix), (String[])new String[0]);
    }

    public static ClassName className(String className) {
        int index = className.lastIndexOf(".");
        if (index > 0) {
            return TypeUtility.classNameWithSuffix(className.substring(0, index), className.substring(index + 1), "");
        }
        return ClassName.get((String)"", (String)className, (String[])new String[0]);
    }

    public static ClassName className(Class<?> clazz) {
        return ClassName.get(clazz);
    }

    public static TypeName typeName(Type type) {
        return TypeName.get((Type)type);
    }

    public static TypeName typeName(TypeMirror typeMirror) {
        TypeName[] values;
        LiteralType literalType = LiteralType.of(typeMirror.toString());
        if (literalType.isArray()) {
            return ArrayTypeName.of((TypeName)TypeUtility.typeName(literalType.getRawType()));
        }
        if (literalType.isCollection()) {
            return ParameterizedTypeName.get((ClassName)TypeUtility.className(literalType.getRawType()), (TypeName[])new TypeName[]{TypeUtility.typeName(literalType.getTypeParameter())});
        }
        for (TypeName item : values = new TypeName[]{TypeName.BOOLEAN, TypeName.BYTE, TypeName.CHAR, TypeName.DOUBLE, TypeName.FLOAT, TypeName.INT, TypeName.LONG, TypeName.SHORT, TypeName.VOID}) {
            if (!typeMirror.toString().equals(item.toString())) continue;
            return item;
        }
        return TypeName.get((TypeMirror)typeMirror);
    }

    public static TypeName typeName(String packageName, String typeName) {
        return TypeUtility.classNameWithSuffix(packageName, typeName, "");
    }

    public static ClassName mergeTypeNameWithSuffix(TypeName typeName, String typeNameSuffix) {
        ClassName className = TypeUtility.className(typeName.toString());
        return TypeUtility.classNameWithSuffix(className.packageName(), className.simpleName(), typeNameSuffix);
    }

    public static TypeName typeName(String typeName) {
        TypeName[] values;
        for (TypeName item : values = new TypeName[]{TypeName.BOOLEAN, TypeName.BYTE, TypeName.CHAR, TypeName.DOUBLE, TypeName.FLOAT, TypeName.INT, TypeName.LONG, TypeName.SHORT, TypeName.VOID}) {
            if (!item.toString().equals(typeName)) continue;
            return item;
        }
        LiteralType literalName = LiteralType.of(typeName);
        if (literalName.isParametrizedType()) {
            return ParameterizedTypeName.get((ClassName)TypeUtility.className(literalName.getRawType()), (TypeName[])new TypeName[]{TypeUtility.typeName(literalName.getTypeParameter())});
        }
        if (literalName.isArray()) {
            return ArrayTypeName.of((TypeName)TypeUtility.typeName(literalName.getRawType()));
        }
        return ClassName.bestGuess((String)typeName);
    }

    public static TypeName typeName(Element element) {
        return TypeName.get((TypeMirror)element.asType());
    }

    public static boolean isNullable(ModelProperty property) {
        return TypeUtility.isNullable(property.getPropertyType().getTypeName());
    }

    public static void checkTypeCompatibility(SQLiteModelMethod method, Pair<String, TypeName> item, ModelProperty property) {
        if (!TypeUtility.isEquals((TypeName)item.value1, property.getPropertyType().getTypeName())) {
            throw new InvalidMethodSignException(method, String.format("property '%s' is type '%s' and method parameter '%s' is type '%s': they must have same type", property.getName(), property.getPropertyType().getTypeName(), item.value0, ((TypeName)item.value1).toString()));
        }
    }

    public static void beginStringConversion(MethodSpec.Builder methodBuilder, ModelProperty property) {
        TypeName modelType = TypeUtility.typeName(property.getElement().asType());
        TypeUtility.beginStringConversion(methodBuilder, modelType);
    }

    public static void beginStringConversion(MethodSpec.Builder methodBuilder, TypeName typeMirror) {
        SQLTransform transform = SQLTransformer.lookup(typeMirror);
        switch (transform.getColumnType()) {
            case TEXT: {
                return;
            }
            case BLOB: {
                methodBuilder.addCode("new String(", new Object[0]);
                break;
            }
            case INTEGER: 
            case REAL: {
                methodBuilder.addCode("String.valueOf(", new Object[0]);
                break;
            }
        }
    }

    public static void endStringConversion(MethodSpec.Builder methodBuilder, ModelProperty property) {
        TypeName modelType = TypeUtility.typeName(property.getElement().asType());
        TypeUtility.endStringConversion(methodBuilder, modelType);
    }

    public static void endStringConversion(MethodSpec.Builder methodBuilder, TypeName typeMirror) {
        SQLTransform transform = SQLTransformer.lookup(typeMirror);
        switch (transform.getColumnType()) {
            case TEXT: {
                return;
            }
            case BLOB: {
                methodBuilder.addCode(",$T.UTF_8)", new Object[]{StandardCharsets.class});
                break;
            }
            case INTEGER: 
            case REAL: {
                methodBuilder.addCode(")", new Object[0]);
                break;
            }
        }
    }

    public static boolean isArray(TypeName typeName) {
        return typeName instanceof ArrayTypeName;
    }

    public static TypeName typeName(TypeElement element, String suffix) {
        String fullName = element.getQualifiedName().toString() + suffix;
        int lastIndex = fullName.lastIndexOf(".");
        String packageName = fullName.substring(0, lastIndex);
        String className = fullName.substring(lastIndex + 1);
        return TypeUtility.typeName(packageName, className);
    }

    public static ClassName className(String packageName, String className) {
        return TypeUtility.classNameWithSuffix(packageName, className, "");
    }

    public static TypeName parameterizedTypeName(ClassName rawClass, TypeName paramClass) {
        return ParameterizedTypeName.get((ClassName)rawClass, (TypeName[])new TypeName[]{paramClass});
    }

    public static String simpleName(TypeName clazzName) {
        String clazz = clazzName.toString();
        int index = clazz.lastIndexOf(".");
        if (index > 0) {
            clazz = clazz.substring(index + 1);
        }
        return clazz;
    }

    public static ArrayTypeName arrayTypeName(Type type) {
        return ArrayTypeName.of((Type)type);
    }

    public static boolean isEnum(TypeName typeName) {
        return TypeUtility.isEnum(typeName.toString());
    }

    public static boolean isEnum(String className) {
        try {
            DeclaredType superclassDeclaredType;
            TypeElement typeElement;
            TypeMirror superclass;
            TypeElement element = BindTypeSubProcessor.elementUtils.getTypeElement(className);
            return element instanceof TypeElement && (superclass = (typeElement = element).getSuperclass()) instanceof DeclaredType && JAVA_LANG_ENUM.equals(TypeUtility.getCanonicalTypeName(superclassDeclaredType = (DeclaredType)superclass));
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static List<TypeName> convert(List<? extends TypeMirror> input) {
        ArrayList<TypeName> result = new ArrayList<TypeName>();
        for (TypeMirror typeMirror : input) {
            result.add(TypeUtility.typeName(typeMirror));
        }
        return result;
    }

    public static List<TypeName> getTypeArguments(TypeElement element) {
        final ArrayList<TypeName> result = new ArrayList<TypeName>();
        if (element.getKind() == ElementKind.CLASS) {
            if (element.getSuperclass() instanceof DeclaredType) {
                result.addAll(TypeUtility.convert(((DeclaredType)element.getSuperclass()).getTypeArguments()));
            }
        } else if (element.getKind() == ElementKind.INTERFACE) {
            List<? extends TypeMirror> interfaces = element.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                typeMirror.accept(new SimpleTypeVisitor7<Void, Void>(){

                    @Override
                    public Void visitDeclared(DeclaredType t, Void p) {
                        result.addAll(TypeUtility.convert(t.getTypeArguments()));
                        return null;
                    }
                }, null);
            }
        }
        return result;
    }

    private static String getCanonicalTypeName(DeclaredType declaredType) {
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            return typeString.toString();
        }
        return declaredType.toString();
    }

    public static boolean isCollection(TypeName typeName) {
        return TypeUtility.isAssignable(typeName, Collection.class);
    }

    public static boolean isCollectionOfType(TypeName typeName, TypeName elementTypeName) {
        return TypeUtility.isAssignable(typeName, Collection.class) && TypeUtility.isEquals((TypeName)((ParameterizedTypeName)typeName).typeArguments.get(0), elementTypeName);
    }

    public static boolean isList(TypeName typeName) {
        return TypeUtility.isAssignable(typeName, List.class);
    }

    public static boolean isSet(TypeName typeName) {
        return TypeUtility.isAssignable(typeName, Set.class);
    }

    public static boolean isMap(TypeName typeName) {
        return TypeUtility.isAssignable(typeName, Map.class);
    }

    public static boolean isAssignable(TypeName typeName, Class<?> assignableClazz) {
        try {
            if (typeName instanceof ParameterizedTypeName) {
                typeName = ((ParameterizedTypeName)typeName).rawType;
            } else if (typeName instanceof ArrayTypeName) {
                typeName = ((ArrayTypeName)typeName).componentType;
            }
            Class<?> resolvedType = Class.forName(typeName.toString());
            return assignableClazz.isAssignableFrom(resolvedType);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String extractPackageName(TypeElement element) {
        String fullName = element.getQualifiedName().toString();
        if (fullName.lastIndexOf(".") > 0) {
            return fullName.substring(0, fullName.lastIndexOf("."));
        }
        return "";
    }

    public static String getDefaultValue(TypeName value) {
        if (!TypeUtility.isTypePrimitive(value)) {
            return null;
        }
        if (value == TypeName.BOOLEAN) {
            return "false";
        }
        if (value == TypeName.BYTE) {
            return "(byte)0";
        }
        if (value == TypeName.CHAR) {
            return "(char)0";
        }
        if (value == TypeName.DOUBLE) {
            return "0.0";
        }
        if (value == TypeName.FLOAT) {
            return "0.0f";
        }
        if (value == TypeName.INT) {
            return "0";
        }
        if (value == TypeName.LONG) {
            return "0";
        }
        if (value == TypeName.SHORT) {
            return "(short)0";
        }
        return "0";
    }
}

