/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.element;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.Finder;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneratedTypeElement
implements Finder<SQLProperty> {
    public String packageName;
    public TypeSpec typeSpec;
    protected String tableName;
    public Set<SQLiteEntity> referedEntities = new HashSet<SQLiteEntity>();
    public List<String> index = new ArrayList<String>();
    public List<SQLProperty> properties = new ArrayList<SQLProperty>();

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public GeneratedTypeElement(String packageName, TypeSpec typeSpec, String tableName, String index) {
        this.packageName = packageName;
        this.typeSpec = typeSpec;
        this.tableName = tableName;
        if (StringUtils.hasText((String)index)) {
            this.index.add(index);
        }
    }

    public String getQualifiedName() {
        if (StringUtils.hasText((String)this.packageName)) {
            return this.packageName + "." + this.typeSpec.name;
        }
        return this.typeSpec.name;
    }

    public String getName() {
        return this.getQualifiedName();
    }

    @Override
    public String getSimpleName() {
        return this.typeSpec.name;
    }

    @Override
    public List<SQLProperty> getCollection() {
        return this.properties;
    }

    public TypeName getClassName() {
        return TypeUtility.className(this.getQualifiedName());
    }

    @Override
    public SQLProperty findPropertyByName(String name) {
        name = name.toLowerCase();
        for (SQLProperty item : this.properties) {
            if (!item.getName().toLowerCase().equals(name)) continue;
            return item;
        }
        return null;
    }
}

