/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sharedprefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.abubusoft.kripton.android.KriptonLibrary;
import com.abubusoft.kripton.android.LiveDataHandler;
import com.abubusoft.kripton.android.annotation.BindSharedPreferences;
import com.abubusoft.kripton.android.sharedprefs.AbstractSharedPreference;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.KriptonLiveDataManager;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ManagedPropertyPersistenceHelper;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsEntity;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsProperty;
import com.abubusoft.kripton.processor.sharedprefs.transform.PrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.PrefsTransformer;
import com.abubusoft.kripton.processor.sharedprefs.transform.ReadType;
import com.abubusoft.kripton.processor.sharedprefs.transform.SetPrefsTransformation;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public abstract class BindSharedPreferencesBuilder {
    protected static final String PREFIX = "Bind";
    protected static final String SUFFIX_SHARED_PREFERENCE = "SharedPreferences";
    protected static final String SUFFIX_PREFERENCE = "Preferences";
    protected static TypeSpec.Builder builder;

    public static String getBuildPreferenceName(ModelEntity<?> entity) {
        String beanClassName = entity.getElement().getSimpleName().toString();
        String suffix = beanClassName.endsWith(SUFFIX_SHARED_PREFERENCE) ? "" : (beanClassName.endsWith(SUFFIX_PREFERENCE) ? "" : SUFFIX_SHARED_PREFERENCE);
        String className = PREFIX + beanClassName + suffix;
        return className;
    }

    public static String generate(Elements elementUtils, Filer filer, PrefsEntity entity) throws IOException {
        Converter converter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
        String beanClassName = ((TypeElement)entity.getElement()).getSimpleName().toString();
        String className = BindSharedPreferencesBuilder.getBuildPreferenceName(entity);
        ModelAnnotation annotation = entity.getAnnotation(BindSharedPreferences.class);
        String sharedPreferenceName = annotation.getAttribute(AnnotationAttributeType.VALUE);
        boolean generateRx = entity.hasRxProperties();
        boolean generateLiveData = entity.hasLiveDataProperties();
        PackageElement pkg = elementUtils.getPackageOf((Element)entity.getElement());
        String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindSharedPreferences.class, packageName, className);
        builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(AbstractSharedPreference.class);
        BindTypeContext context = new BindTypeContext(builder, TypeUtility.typeName(entity.getElement()), Modifier.PRIVATE);
        builder.addJavadoc("This class is the shared preference binder defined for $T\n\n", new Object[]{entity.getElement()});
        JavadocUtility.generateJavadocGeneratedBy(builder);
        builder.addJavadoc("@see $T\n", new Object[]{entity.getElement()});
        if (StringUtils.hasText((String)sharedPreferenceName)) {
            builder.addField(FieldSpec.builder(String.class, (String)"SHARED_PREFERENCE_NAME", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{converter.convert((Object)entity.getSimpleName().toString())}).addJavadoc("shared preferences typeName for $T\n", new Object[]{entity.getElement()}).build());
        }
        builder.addField(FieldSpec.builder((TypeName)TypeUtility.className(beanClassName), (String)"defaultBean", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addJavadoc("working instance of bean\n", new Object[0]).build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"edit").addJavadoc("create an editor to modify shared preferences\n", new Object[0]).returns(TypeUtility.typeName("BindEditor")).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addStatement("return new $T()", new Object[]{TypeUtility.typeName("BindEditor")});
        builder.addMethod(methodBuilder.build());
        BindSharedPreferencesBuilder.generateEditor(entity);
        BindSharedPreferencesBuilder.generateCreate(sharedPreferenceName, beanClassName, generateRx, generateLiveData);
        BindSharedPreferencesBuilder.generateConstructor(entity, sharedPreferenceName, beanClassName);
        BindSharedPreferencesBuilder.generateRefresh(sharedPreferenceName, className);
        BindSharedPreferencesBuilder.generateRxSupport(sharedPreferenceName, beanClassName, generateRx, entity);
        BindSharedPreferencesBuilder.generateLiveDataSupport(sharedPreferenceName, beanClassName, generateLiveData, entity);
        BindSharedPreferencesBuilder.generateResetMethod(entity);
        BindSharedPreferencesBuilder.generateReadMethod(entity);
        BindSharedPreferencesBuilder.generateWriteMethod(entity);
        BindSharedPreferencesBuilder.generateSingleReadMethod(entity);
        List fields = entity.getCollection();
        ArrayList<PrefsProperty> filteredFields = new ArrayList<PrefsProperty>();
        for (PrefsProperty item : fields) {
            if (SetPrefsTransformation.isStringSet(item)) continue;
            filteredFields.add(item);
        }
        ManagedPropertyPersistenceHelper.generateFieldPersistance(context, filteredFields, ManagedPropertyPersistenceHelper.PersistType.STRING, false, Modifier.PROTECTED);
        BindSharedPreferencesBuilder.generateInstance(className);
        TypeSpec typeSpec = builder.build();
        JavaWriterHelper.writeJava2File(filer, packageName, typeSpec);
        return className;
    }

    private static void generateCreate(String sharedPreferenceName, String beanClassName, boolean generateRx, boolean generateLiveData) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"createPrefs").addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc("create prefs\n", new Object[0]);
        if (StringUtils.hasText((String)sharedPreferenceName)) {
            method.addCode("// using typeName attribute of annotation @BindSharedPreferences as typeName\n", new Object[0]);
            method.addStatement("prefs=$T.getContext().getSharedPreferences(SHARED_PREFERENCE_NAME, $T.MODE_PRIVATE)", new Object[]{KriptonLibrary.class, Context.class});
        } else {
            method.addCode("// no typeName specified, using default shared preferences\n", new Object[0]);
            method.addStatement("prefs=$T.getDefaultSharedPreferences($T.getContext())", new Object[]{PreferenceManager.class, KriptonLibrary.class});
        }
        if (generateRx) {
            method.addStatement("prefs.registerOnSharedPreferenceChangeListener(rxListener)", new Object[0]);
        }
        if (generateLiveData) {
            method.addStatement("prefs.registerOnSharedPreferenceChangeListener(liveDataListener)", new Object[0]);
        }
        builder.addMethod(method.build());
    }

    private static void generateLiveDataSupport(String sharedPreferenceName, String beanClassName, boolean generateLiveData, PrefsEntity entity) {
        if (!generateLiveData) {
            return;
        }
        FieldSpec fs = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Pair.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(WeakReference.class), (TypeName[])new TypeName[]{ClassName.get(LiveDataHandler.class)})})}), (String)"liveDatas", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer(CodeBlock.of((String)"new $T<$T<String, WeakReference<$T>>>()", (Object[])new Object[]{CopyOnWriteArrayList.class, Pair.class, LiveDataHandler.class})).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"rawtypes\"", new Object[0]).build()).build();
        builder.addField(fs);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"registryLiveData").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, "key", new Modifier[0]).addParameter((TypeName)ClassName.get(LiveDataHandler.class), "value", new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"rawtypes\"", new Object[0]).build()).addStatement("liveDatas.add(new Pair<String , WeakReference<$T>>(key, new WeakReference<$T>(value)))", new Object[]{LiveDataHandler.class, LiveDataHandler.class});
        builder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"updateLiveData").addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"rawtypes\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, "key", new Modifier[0]).addParameter(Object.class, "value", new Modifier[0]).beginControlFlow("for (Pair<String, WeakReference<$T>> item : liveDatas)", new Object[]{LiveDataHandler.class}).beginControlFlow("if (item.value0.equals(key) && item.value1.get() != null)", new Object[0]).addStatement("item.value1.get().invalidate()", new Object[0]).endControlFlow().endControlFlow();
        builder.addMethod(methodBuilder.build());
        Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        MethodSpec.Builder methodBuilder2 = MethodSpec.methodBuilder((String)"onSharedPreferenceChanged").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SharedPreferences.class, "sharedPreferences", new Modifier[]{Modifier.FINAL}).addParameter(String.class, "key", new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder runBuilder = MethodSpec.methodBuilder((String)"run").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        runBuilder.beginControlFlow("switch (key)", new Object[0]);
        for (PrefsProperty item : entity.getCollection()) {
            if (!item.isGenerateLiveData()) continue;
            PrefsTransform transform = item.hasTypeAdapter() ? PrefsTransformer.lookup(item.typeAdapter.getDataTypeTypename()) : PrefsTransformer.lookup(item);
            TypeName typeName = item.getPropertyType().getTypeName();
            if (TypeUtility.isTypePrimitive(typeName)) {
                typeName = typeName.box();
            }
            BindSharedPreferencesBuilder.generateMethodAsLiveData((Converter<String, String>)converter, typeName, item);
            runBuilder.addComment("$L - $L", new Object[]{item.getPreferenceKey(), item.getName()});
            runBuilder.addCode("case $S: {\n", new Object[]{item.getPreferenceKey()});
            transform.generateReadProperty(runBuilder, "sharedPreferences", TypeUtility.typeName(item.getElement().asType()), "defaultBean", item, false, ReadType.VALUE);
            runBuilder.addCode("\n", new Object[0]);
            runBuilder.addStatement("updateLiveData($S, _value)", new Object[]{item.getPreferenceKey()});
            runBuilder.addStatement("return", new Object[0]);
            runBuilder.addCode("}\n", new Object[0]);
        }
        runBuilder.addStatement("default: return", new Object[0]);
        runBuilder.endControlFlow();
        TypeSpec innerBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface(Runnable.class).addMethod(runBuilder.build()).build();
        methodBuilder2.addStatement("$T.getExecutorService().execute($L)", new Object[]{KriptonLibrary.class, innerBuilder});
        TypeSpec innerBuilder2 = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface(SharedPreferences.OnSharedPreferenceChangeListener.class).addMethod(methodBuilder2.build()).build();
        FieldSpec.Builder f = FieldSpec.builder((TypeName)ClassName.get(SharedPreferences.OnSharedPreferenceChangeListener.class), (String)"liveDataListener", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc("Listener used to propagate shared prefs changes through RX\n", new Object[0]).initializer("$L", new Object[]{innerBuilder2});
        builder.addField(f.build());
    }

    private static void generateMethodAsLiveData(Converter<String, String> converter, TypeName typeName, PrefsProperty property) {
        ParameterizedTypeName liveDataType = ParameterizedTypeName.get((ClassName)KriptonLiveDataManager.getInstance().getLiveDataHandlerClazz(), (TypeName[])new TypeName[]{typeName});
        String className = BindSharedPreferencesBuilder.getBuildPreferenceName(property.getParent());
        MethodSpec.Builder computeBuilder = MethodSpec.methodBuilder((String)"compute").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(typeName).addAnnotation(Override.class);
        computeBuilder.addStatement("$L.this.refresh()", new Object[]{className});
        computeBuilder.addStatement("return $L.this.get$L()", new Object[]{className, converter.convert((Object)property.getName())});
        TypeSpec liveDataBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)liveDataType).addMethod(computeBuilder.build()).build();
        MethodSpec ms = MethodSpec.methodBuilder((String)("get" + (String)converter.convert((Object)property.getName()) + "AsLiveData")).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)KriptonLiveDataManager.getInstance().getMutableLiveDataClazz(), (TypeName[])new TypeName[]{typeName})).addJavadoc("Obtains an LiveData to <code>$L</code> property\n\n", new Object[]{property.getName()}).addJavadoc("@return\nan LiveData to <code>$L</code> property\n", new Object[]{property.getName()}).addStatement("$T liveData=$L", new Object[]{liveDataType, liveDataBuilder}).addStatement("registryLiveData($S, liveData)", new Object[]{property.getPreferenceKey()}).addStatement("return liveData.getLiveData()", new Object[0]).build();
        builder.addMethod(ms);
    }

    private static void generateRxSupport(String sharedPreferenceName, String beanClassName, boolean generateRx, PrefsEntity entity) {
        if (!generateRx) {
            return;
        }
        Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onSharedPreferenceChanged").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SharedPreferences.class, "sharedPreferences", new Modifier[0]).addParameter(String.class, "key", new Modifier[0]);
        methodBuilder.beginControlFlow("switch (key)", new Object[0]);
        for (PrefsProperty item : entity.getCollection()) {
            if (!item.isGenerateRx()) continue;
            PrefsTransform transform = item.hasTypeAdapter() ? PrefsTransformer.lookup(item.typeAdapter.getDataTypeTypename()) : PrefsTransformer.lookup(item);
            TypeName typeName = item.getPropertyType().getTypeName();
            if (TypeUtility.isTypePrimitive(typeName)) {
                typeName = typeName.box();
            }
            String subjectFieldName = item.getName() + "Subject";
            FieldSpec fs = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Subject.class), (TypeName[])new TypeName[]{typeName}), (String)subjectFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc("subject for field $L - shared pref $L\n", new Object[]{item.getName(), item.getPreferenceKey()}).initializer(CodeBlock.of((String)"$T.create()", (Object[])new Object[]{BehaviorSubject.class})).build();
            MethodSpec ms = MethodSpec.methodBuilder((String)("get" + (String)converter.convert((Object)item.getName()) + "AsObservable")).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Subject.class), (TypeName[])new TypeName[]{typeName})).addJavadoc("Obtains an observable to <code>$L</code> property\n\n", new Object[]{item.getName()}).addJavadoc("@return\nan observable to <code>$L</code> property\n", new Object[]{item.getName()}).addStatement("return $L", new Object[]{subjectFieldName}).build();
            methodBuilder.addComment("$L - $L", new Object[]{item.getPreferenceKey(), item.getName()});
            methodBuilder.addCode("case $S: {\n", new Object[]{item.getPreferenceKey()});
            transform.generateReadProperty(methodBuilder, "sharedPreferences", TypeUtility.typeName(item.getElement().asType()), "defaultBean", item, false, ReadType.VALUE);
            methodBuilder.addCode("\n", new Object[0]);
            if (!TypeUtility.isTypePrimitive(item.getPropertyType().getTypeName())) {
                methodBuilder.beginControlFlow("if (_value!=null)", new Object[0]);
            }
            methodBuilder.addStatement("$L.onNext(_value)", new Object[]{subjectFieldName});
            if (!TypeUtility.isTypePrimitive(item.getPropertyType().getTypeName())) {
                methodBuilder.endControlFlow();
            }
            methodBuilder.addStatement("return", new Object[0]);
            methodBuilder.addCode("}\n", new Object[]{subjectFieldName});
            builder.addField(fs);
            builder.addMethod(ms);
        }
        methodBuilder.addStatement("default: return", new Object[0]);
        methodBuilder.endControlFlow();
        TypeSpec innerBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface(SharedPreferences.OnSharedPreferenceChangeListener.class).addMethod(methodBuilder.build()).build();
        FieldSpec.Builder f = FieldSpec.builder((TypeName)ClassName.get(SharedPreferences.OnSharedPreferenceChangeListener.class), (String)"rxListener", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc("Listener used to propagate shared prefs changes through RX\n", new Object[0]).initializer("$L", new Object[]{innerBuilder});
        builder.addField(f.build());
    }

    private static void generateEditor(PrefsEntity entity) {
        Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        TypeSpec.Builder innerClassBuilder = TypeSpec.classBuilder((String)"BindEditor").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("editor class for shared preferences\n", new Object[0]).superclass(TypeUtility.typeName("AbstractEditor"));
        innerClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (PrefsProperty item : entity.getCollection()) {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("put" + (String)converter.convert((Object)item.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(item.getElement()), "value", new Modifier[0]).addJavadoc("modifier for property $L\n", new Object[]{item.getName()}).returns(TypeUtility.typeName("BindEditor"));
            TypeName type = item.hasTypeAdapter() ? TypeUtility.typeName(item.typeAdapter.dataType) : TypeUtility.typeName(item.getElement());
            PrefsTransform transform = PrefsTransformer.lookup(type);
            transform.generateWriteProperty(builder, "editor", null, "value", item);
            builder.addCode("\n", new Object[0]);
            builder.addStatement("return this", new Object[0]);
            innerClassBuilder.addMethod(builder.build());
            builder = MethodSpec.methodBuilder((String)("remove" + (String)converter.convert((Object)item.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("remove property $L\n", new Object[]{item.getName()}).returns(TypeUtility.typeName("BindEditor"));
            builder.addStatement("editor.remove($S)", new Object[]{item.getPreferenceKey()});
            builder.addStatement("return this", new Object[0]);
            innerClassBuilder.addMethod(builder.build());
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"clear").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("clear all properties\n", new Object[0]).returns(TypeUtility.typeName("BindEditor"));
        builder.addStatement("editor.clear()", new Object[0]);
        builder.addStatement("return this", new Object[0]);
        innerClassBuilder.addMethod(builder.build());
        BindSharedPreferencesBuilder.builder.addType(innerClassBuilder.build());
    }

    private static void generateInstance(String className) {
        builder.addField(FieldSpec.builder((TypeName)TypeUtility.className(className), (String)"instance", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addJavadoc("instance of shared preferences\n", new Object[0]).build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.SYNCHRONIZED}).addJavadoc("get instance of shared preferences\n", new Object[0]).returns((TypeName)TypeUtility.className(className));
        methodBuilder.beginControlFlow("if (instance==null)", new Object[0]);
        methodBuilder.addStatement("instance=new $L()", new Object[]{TypeUtility.className(className)});
        methodBuilder.addComment("read and write instance to sync with default values", new Object[0]);
        methodBuilder.addStatement("instance.write(instance.read())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("return instance;\n", new Object[0]);
        builder.addMethod(methodBuilder.build());
    }

    private static void generateConstructor(PrefsEntity entity, String sharedPreferenceName, String beanClassName) {
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc("constructor\n", new Object[0]);
        method.addStatement("createPrefs()", new Object[0]);
        if (entity.isImmutablePojo()) {
            ImmutableUtility.generateImmutableVariableInit(entity, method);
            ImmutableUtility.generateImmutableEntityCreation(entity, method, "defaultBean", false);
        } else {
            method.addStatement("defaultBean=new $T()", new Object[]{TypeUtility.className(beanClassName)});
        }
        builder.addMethod(method.build());
    }

    private static void generateRefresh(String sharedPreferenceName, String className) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"refresh").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("force to refresh values\n", new Object[0]).returns((TypeName)TypeUtility.className(className));
        method.addStatement("createPrefs()", new Object[0]);
        method.addStatement("return this", new Object[0]);
        builder.addMethod(method.build());
    }

    private static void generateResetMethod(PrefsEntity entity) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"reset").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("reset shared preferences\n", new Object[0]).returns(Void.TYPE);
        if (entity.isImmutablePojo()) {
            ImmutableUtility.generateImmutableVariableInit(entity, method);
            ImmutableUtility.generateImmutableEntityCreation(entity, method, "bean", true);
        } else {
            method.addStatement("$T bean=new $T()", new Object[]{entity.getElement(), entity.getElement()});
        }
        method.addStatement("write(bean)", new Object[0]);
        builder.addMethod(method.build());
    }

    private static void generateWriteMethod(PrefsEntity entity) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"write").addJavadoc("write bean entirely\n\n", new Object[0]).addJavadoc("@param bean bean to entirely write\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(entity.getName()), "bean", new Modifier[0]).returns(Void.TYPE);
        method.addStatement("$T editor=prefs.edit()", new Object[]{SharedPreferences.Editor.class});
        for (PrefsProperty item : entity.getCollection()) {
            PrefsTransform transform = item.hasTypeAdapter() ? PrefsTransformer.lookup(item.typeAdapter.getDataTypeTypename()) : PrefsTransformer.lookup(item);
            transform.generateWriteProperty(method, "editor", TypeUtility.typeName(entity.getElement()), "bean", item);
            method.addCode("\n", new Object[0]);
        }
        method.addCode("\n", new Object[0]);
        method.addStatement("editor.commit()", new Object[0]);
        builder.addMethod(method.build());
    }

    private static void generateReadMethod(PrefsEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("read bean entirely\n\n", new Object[0]).addJavadoc("@return read bean\n", new Object[0]).returns(TypeUtility.typeName(entity.getName()));
        if (entity.isImmutablePojo()) {
            methodBuilder.addCode("\n", new Object[0]);
            methodBuilder.addComment("initialize temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        } else {
            methodBuilder.addStatement("$T bean=new $T()", new Object[]{TypeUtility.typeName(entity.getName()), TypeUtility.typeName(entity.getName())});
        }
        for (PrefsProperty item : entity.getCollection()) {
            PrefsTransform transform = item.hasTypeAdapter() ? PrefsTransformer.lookup(item.typeAdapter.getDataTypeTypename()) : PrefsTransformer.lookup(item);
            if (entity.isImmutablePojo()) {
                transform.generateReadProperty(methodBuilder, "prefs", TypeUtility.typeName(item.getElement().asType()), null, item, true, ReadType.NONE);
            } else {
                transform.generateReadProperty(methodBuilder, "prefs", TypeUtility.typeName(item.getElement().asType()), "bean", item, true, ReadType.NONE);
            }
            methodBuilder.addCode("\n", new Object[0]);
        }
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("reset temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "bean", true);
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addStatement("return bean", new Object[0]);
        builder.addMethod(methodBuilder.build());
    }

    private static void generateSingleReadMethod(PrefsEntity entity) {
        Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        for (PrefsProperty item : entity.getCollection()) {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("get" + (String)converter.convert((Object)item.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("reads property <code>$L</code> from shared pref with key <code>$L</code>\n\n", new Object[]{item.getName(), item.getPreferenceKey()}).addJavadoc("@return property $L value\n", new Object[]{item.getName()}).returns(item.getPropertyType().getTypeName());
            PrefsTransform transform = item.hasTypeAdapter() ? PrefsTransformer.lookup(item.typeAdapter.getDataTypeTypename()) : PrefsTransformer.lookup(item);
            transform.generateReadProperty(methodBuilder, "prefs", TypeUtility.typeName(item.getElement().asType()), "defaultBean", item, false, ReadType.RETURN);
            builder.addMethod(methodBuilder.build());
        }
    }
}

