/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sharedprefs.transform;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsProperty;
import com.abubusoft.kripton.processor.sharedprefs.transform.AbstractPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.ReadType;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.math.BigInteger;

abstract class AbstractNumberPrefsTransform
extends AbstractPrefsTransform {
    protected String METHOD_CONVERSION = "toString";
    protected Class<?> clazz = BigInteger.class;
    protected String defaultValue = "0";

    public AbstractNumberPrefsTransform() {
        super(false);
    }

    @Override
    public void generateReadProperty(MethodSpec.Builder methodBuilder, String preferenceName, TypeName beanClass, String beanName, PrefsProperty property, boolean readAll, ReadType readType) {
        if (readAll) {
            methodBuilder.beginControlFlow("", new Object[0]);
        }
        methodBuilder.addStatement("String temp=$L.getString($S, $S)", new Object[]{preferenceName, property.getPreferenceKey(), this.defaultValue});
        if (readAll) {
            methodBuilder.addCode(PropertyUtility.setter(beanClass, beanName, property) + (!property.isPublicField() && beanName != null ? "(" : "="), new Object[0]);
        }
        switch (readType) {
            case NONE: {
                break;
            }
            case RETURN: {
                methodBuilder.addCode("return ", new Object[0]);
                break;
            }
            case VALUE: {
                methodBuilder.addCode("$T _value=", new Object[]{property.getPropertyType().getTypeName()});
            }
        }
        methodBuilder.addCode("($T.hasText(temp)) ? ", new Object[]{StringUtils.class});
        methodBuilder.addCode("new $T(temp)", new Object[]{this.clazz});
        methodBuilder.addCode(": $L", new Object[]{PropertyUtility.getter("defaultBean", beanClass, property)});
        if (readAll) {
            methodBuilder.addCode(!property.isPublicField() && beanName != null ? ")" : "", new Object[0]);
        }
        methodBuilder.addCode(";\n", new Object[0]);
        if (readAll) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateWriteProperty(MethodSpec.Builder methodBuilder, String editorName, TypeName beanClass, String beanName, PrefsProperty property) {
        if (beanClass != null) {
            methodBuilder.addCode("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
            methodBuilder.addCode("$L.putString($S,$L.$L() );", new Object[]{editorName, property.getPreferenceKey(), PropertyUtility.getter(beanName, beanClass, property), this.METHOD_CONVERSION});
            methodBuilder.addCode(" else ", new Object[0]);
            methodBuilder.addCode("$L.putString($S, null);", new Object[]{editorName, property.getPreferenceKey()});
        } else {
            methodBuilder.addCode("if ($L!=null) ", new Object[]{beanName});
            methodBuilder.addCode("$L.putString($S,$L.$L());", new Object[]{editorName, property.getPreferenceKey(), beanName, this.METHOD_CONVERSION});
            methodBuilder.addCode(" else ", new Object[0]);
            methodBuilder.addCode("$L.remove($S);", new Object[]{editorName, property.getPreferenceKey()});
        }
    }
}

