/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sharedprefs.transform;

import com.abubusoft.kripton.common.PrefsTypeAdapterUtils;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsProperty;
import com.abubusoft.kripton.processor.sharedprefs.transform.AbstractPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.ReadType;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

abstract class AbstractPrimitivePrefsTransform
extends AbstractPrefsTransform {
    protected boolean nullable;
    protected String SIMPLE_TYPE;
    protected String PREFS_CONVERT;
    protected String PREFS_TYPE;
    protected String PREFS_DEFAULT_VALUE;

    public AbstractPrimitivePrefsTransform(boolean nullable) {
        super(true);
        this.nullable = nullable;
    }

    public AbstractPrimitivePrefsTransform(boolean nullable, boolean typeAware) {
        super(typeAware);
        this.nullable = nullable;
    }

    @Override
    public void generateReadProperty(MethodSpec.Builder methodBuilder, String preferenceName, TypeName beanClass, String beanName, PrefsProperty property, boolean readAll, ReadType readType) {
        if (readAll) {
            methodBuilder.addCode(PropertyUtility.setter(beanClass, beanName, property) + (!property.isPublicField() && beanName != null ? "(" : "="), new Object[0]);
        }
        switch (readType) {
            case NONE: {
                break;
            }
            case RETURN: {
                methodBuilder.addCode("return ", new Object[0]);
                break;
            }
            case VALUE: {
                methodBuilder.addCode("$T _value=", new Object[]{property.getPropertyType().getTypeName()});
            }
        }
        String tempPre = "";
        String tempPost = "";
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("$T.getAdapter($T.class).toJava(", new Object[]{PrefsTypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz)});
            tempPre = String.format("%s.getAdapter(%s.class).toData(", PrefsTypeAdapterUtils.class.getSimpleName(), TypeUtility.className(property.typeAdapter.adapterClazz).simpleName());
            tempPost = ")";
        }
        if (this.nullable) {
            methodBuilder.addCode(this.SIMPLE_TYPE + "$L.get" + this.PREFS_TYPE + "($S, " + this.SIMPLE_TYPE + "($L==null?" + this.PREFS_DEFAULT_VALUE + ":" + tempPre + "$L" + tempPost + "))", new Object[]{preferenceName, property.getPreferenceKey(), PropertyUtility.getter("defaultBean", beanClass, property), PropertyUtility.getter("defaultBean", beanClass, property)});
        } else {
            methodBuilder.addCode(this.SIMPLE_TYPE + "$L.get" + this.PREFS_TYPE + "($S, " + this.SIMPLE_TYPE + tempPre + "$L" + tempPost + ")", new Object[]{preferenceName, property.getPreferenceKey(), PropertyUtility.getter("defaultBean", beanClass, property)});
        }
        if (readAll) {
            methodBuilder.addCode(!property.isPublicField() && beanName != null ? ")" : "", new Object[0]);
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode(")", new Object[0]);
        }
        methodBuilder.addCode(";", new Object[0]);
    }

    @Override
    public void generateWriteProperty(MethodSpec.Builder methodBuilder, String editorName, TypeName beanClass, String beanName, PrefsProperty property) {
        if (this.nullable) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        methodBuilder.addCode("$L.put" + this.PREFS_TYPE + "($S,", new Object[]{editorName, property.getPreferenceKey()});
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("$T.getAdapter($T.class).toData(", new Object[]{PrefsTypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz)});
        }
        methodBuilder.addCode(this.PREFS_CONVERT + "$L", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode(")", new Object[0]);
        }
        methodBuilder.addCode(");\n", new Object[0]);
        if (this.nullable) {
            methodBuilder.endControlFlow();
        }
    }
}

