/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sharedprefs.transform;

import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.PrefsTypeAdapterUtils;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsProperty;
import com.abubusoft.kripton.processor.sharedprefs.transform.AbstractGeneratedPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.ReadType;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Set;

public class SetPrefsTransformation
extends AbstractGeneratedPrefsTransform {
    public SetPrefsTransformation() {
        super(true);
    }

    @Override
    public void generateReadProperty(MethodSpec.Builder methodBuilder, String preferenceName, TypeName beanClass, String beanName, PrefsProperty property, boolean readAll, ReadType readType) {
        boolean isStringSet = SetPrefsTransformation.isStringSet(property);
        String tempPre = "";
        String tempPost = "";
        String tempPreDefaultValue = "";
        String tempPostDefaultValue = "";
        if (readAll) {
            methodBuilder.beginControlFlow("", new Object[0]);
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addComment("Use $T to convert objects", new Object[]{PrefsTypeAdapterUtils.class});
            tempPre = String.format("%s.getAdapter(%s.class).toJava(", PrefsTypeAdapterUtils.class.getSimpleName(), TypeUtility.className(property.typeAdapter.adapterClazz).simpleName());
            tempPost = ")";
            tempPreDefaultValue = String.format("%s.getAdapter(%s.class).toData(", PrefsTypeAdapterUtils.class.getSimpleName(), TypeUtility.className(property.typeAdapter.adapterClazz).simpleName());
            tempPostDefaultValue = ")";
        }
        if (isStringSet) {
            methodBuilder.addStatement("$T<String> temp=$L.getStringSet($S, " + tempPreDefaultValue + "defaultBean" + "." + PropertyUtility.getter(property) + tempPostDefaultValue + ")", new Object[]{Set.class, preferenceName, property.getPreferenceKey()});
            if (readAll) {
                methodBuilder.addCode(PropertyUtility.setter(beanClass, beanName, property) + (!property.isPublicField() && beanName != null ? "(" : "="), new Object[0]);
            }
            switch (readType) {
                case NONE: {
                    break;
                }
                case RETURN: {
                    methodBuilder.addCode("return ", new Object[0]);
                    break;
                }
                case VALUE: {
                    methodBuilder.addCode("$T _value=", new Object[]{property.getPropertyType().getTypeName()});
                }
            }
            methodBuilder.addCode(tempPre, new Object[0]);
            ParameterizedTypeName typeName = property.hasTypeAdapter() ? (ParameterizedTypeName)TypeUtility.typeName(property.typeAdapter.dataType) : (ParameterizedTypeName)TypeUtility.typeName(property.getElement().asType());
            if (TypeUtility.isEquals((TypeName)typeName.rawType, Set.class.getCanonicalName())) {
                methodBuilder.addCode("temp", new Object[0]);
            } else {
                methodBuilder.addCode("new $T<String>(temp)", new Object[]{typeName.rawType});
            }
            methodBuilder.addCode(tempPost, new Object[0]);
            if (readAll) {
                methodBuilder.addCode(!property.isPublicField() ? ")" : "", new Object[0]);
            }
            methodBuilder.addCode(";\n", new Object[0]);
        } else {
            methodBuilder.addStatement("String temp=$L.getString($S, null)", new Object[]{preferenceName, property.getPreferenceKey()});
            if (readAll) {
                methodBuilder.addCode(PropertyUtility.setter(beanClass, beanName, property) + (!property.isPublicField() ? "(" : "=") + "", new Object[0]);
            }
            switch (readType) {
                case NONE: {
                    break;
                }
                case RETURN: {
                    methodBuilder.addCode("return ", new Object[0]);
                    break;
                }
                case VALUE: {
                    methodBuilder.addCode("$T _value=", new Object[]{property.getPropertyType().getTypeName()});
                }
            }
            methodBuilder.addCode("$T.hasText(temp) ? ", new Object[]{StringUtils.class});
            methodBuilder.addCode("parse$L(temp)", new Object[]{formatter.convert((Object)property.getName())});
            methodBuilder.addCode(": $L", new Object[]{PropertyUtility.getter("defaultBean", beanClass, property)});
            if (readAll) {
                methodBuilder.addCode(!property.isPublicField() && beanName != null ? ")" : "", new Object[0]);
            }
            methodBuilder.addCode(";\n", new Object[0]);
        }
        if (readAll) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateWriteProperty(MethodSpec.Builder methodBuilder, String editorName, TypeName beanClass, String beanName, PrefsProperty property) {
        boolean isStringSet;
        Converter formatter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        String tempPre = "";
        String tempPost = "";
        if (property.hasTypeAdapter()) {
            methodBuilder.addComment("Use $T to convert objects", new Object[]{PrefsTypeAdapterUtils.class});
            tempPre = String.format("%s.getAdapter(%s.class).toData(", PrefsTypeAdapterUtils.class.getSimpleName(), TypeUtility.className(property.typeAdapter.adapterClazz).simpleName());
            tempPost = ")";
        }
        if (!(isStringSet = SetPrefsTransformation.isStringSet(property))) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
            methodBuilder.addStatement("String temp=serialize$L($L)", new Object[]{formatter.convert((Object)property.getName()), PropertyUtility.getter(beanName, beanClass, property)});
            methodBuilder.addStatement("$L.putString($S,temp)", new Object[]{editorName, property.getPreferenceKey()});
            methodBuilder.nextControlFlow(" else ", new Object[0]);
            methodBuilder.addStatement("$L.remove($S)", new Object[]{editorName, property.getPreferenceKey()});
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addStatement("$L.putStringSet($S," + tempPre + "$L" + tempPost + ")", new Object[]{editorName, property.getPreferenceKey(), PropertyUtility.getter(beanName, beanClass, property)});
        }
    }

    public static boolean isStringSet(PrefsProperty property) {
        boolean isStringSet = false;
        TypeName typeName = property.hasTypeAdapter() ? TypeUtility.typeName(property.typeAdapter.dataType) : TypeUtility.typeName(property.getElement().asType());
        if (typeName instanceof ParameterizedTypeName && TypeUtility.isSet(typeName)) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (TypeUtility.isEquals((TypeName)parameterizedTypeName.typeArguments.get(0), String.class.getCanonicalName())) {
                isStringSet = true;
            }
        }
        return isStringSet;
    }
}

