/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.OnReadBeanListener;
import com.abubusoft.kripton.android.sqlite.OnReadCursorListener;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.KriptonLiveDataManager;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.BindDaoFactoryBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDataSourceBuilder;
import com.abubusoft.kripton.processor.sqlite.SelectBuilderUtility;
import com.abubusoft.kripton.processor.sqlite.SelectPaginatedResultHelper;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlModifyBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlSelectBuilder;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListenerImpl;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractSelectCodeGenerator
implements SelectBuilderUtility.SelectCodeGenerator {
    public static final String LIVE_DATA_PREFIX = "ForLiveData";
    SelectBuilderUtility.SelectType selectType;

    protected void generateSubQueries(MethodSpec.Builder methodBuilder, SQLiteModelMethod method) {
        SQLiteEntity entity = method.getEntity();
        for (Triple<String, String, SQLiteModelMethod> item : method.childrenSelects) {
            String setter;
            String idGetter;
            TypeName entityTypeName = TypeUtility.typeName(entity.getElement());
            if (entity.isImmutablePojo()) {
                idGetter = ImmutableUtility.IMMUTABLE_PREFIX + entity.getPrimaryKey().getName();
                setter = ImmutableUtility.IMMUTABLE_PREFIX + ((SQLProperty)entity.findRelationByParentProperty((String)((String)item.value0)).value0).getName() + "=" + String.format("this.daoFactory.get%s().%s(%s)", ((SQLiteModelMethod)item.value2).getParent().getName(), ((SQLiteModelMethod)item.value2).getName(), idGetter);
            } else {
                idGetter = PropertyUtility.getter("resultBean", entityTypeName, entity.getPrimaryKey());
                setter = PropertyUtility.setter(entityTypeName, "resultBean", (ModelProperty)entity.findRelationByParentProperty((String)((String)item.value0)).value0, String.format("this.daoFactory.get%s().%s(%s)", ((SQLiteModelMethod)item.value2).getParent().getName(), ((SQLiteModelMethod)item.value2).getName(), idGetter));
            }
            methodBuilder.addComment("sub query: $L", new Object[]{setter});
            methodBuilder.addStatement("$L", new Object[]{setter});
        }
    }

    @Override
    public void generate(TypeSpec.Builder classBuilder, boolean mapFields, SQLiteModelMethod method) {
        Set<JQLProjection> fieldList = JQLChecker.getInstance().extractProjections(method, method.jql.value, method.getEntity());
        MethodSpec.Builder methodBuilder = this.generateMethodBuilder(method);
        this.generateCommonPart(method, classBuilder, methodBuilder, fieldList, true);
        methodBuilder.addComment("Specialized part - $L - BEGIN", new Object[]{this.getClass().getSimpleName()});
        this.generateSpecializedPart(method, classBuilder, methodBuilder, fieldList, this.selectType.isMapFields());
        methodBuilder.addComment("Specialized part - $L - END", new Object[]{this.getClass().getSimpleName()});
        if (!method.isPagedLiveData()) {
            classBuilder.addMethod(methodBuilder.build());
        }
    }

    @Override
    public void generateLiveData(TypeSpec.Builder classBuilder, SQLiteModelMethod method) {
        TypeSpec batchBuilder;
        SQLiteDaoDefinition daoDefinition = method.getParent();
        Set<JQLProjection> fieldList = JQLChecker.getInstance().extractProjections(method, method.jql.value, method.getEntity());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.getName().replaceAll(LIVE_DATA_PREFIX, "")).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addJavadoc("<h2>Live data</h2>\n", new Object[0]);
        methodBuilder.addJavadoc("<p>This method open a connection internally.</p>\n\n", new Object[0]);
        this.generateCommonPart(method, classBuilder, methodBuilder, fieldList, GenerationType.NO_CONTENT, (TypeName)method.liveDataReturnClass, true, false, new JavadocPart[0]);
        boolean pagedLiveData = method.isPagedLiveData();
        if (pagedLiveData) {
            SelectBuilderUtility.SelectType.PAGED_RESULT.generate(classBuilder, method);
            String pageResultName = SelectPaginatedResultHelper.getCurrentPagedResultClass();
            SelectPaginatedResultHelper.createPagedResult(method, pageResultName, methodBuilder);
        }
        ClassName dataSourceClazz = BindDataSourceBuilder.generateDataSourceName(daoDefinition.getParent());
        ClassName daoFactoryClazz = TypeUtility.className(BindDaoFactoryBuilder.generateDaoFactoryName(daoDefinition.getParent()));
        ClassName batchClazz = TypeUtility.mergeTypeNameWithSuffix((TypeName)dataSourceClazz, ".Batch");
        List<Pair<String, TypeName>> methodParameters = method.getParameters();
        StringBuilder buffer = new StringBuilder();
        String separator = "";
        for (Pair<String, TypeName> item : methodParameters) {
            buffer.append(separator + (String)item.value0);
            separator = ", ";
        }
        ClassName handlerClass = KriptonLiveDataManager.getInstance().getLiveDataHandlerClazz();
        if (pagedLiveData) {
            handlerClass = KriptonLiveDataManager.getInstance().getPagedLiveDataHandlerClazz();
            batchBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)batchClazz, (TypeName[])new TypeName[]{method.getReturnClass()})).addMethod(MethodSpec.methodBuilder((String)"onExecute").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)daoFactoryClazz, (String)"daoFactory", (Modifier[])new Modifier[0]).build()).returns(method.getReturnClass()).addStatement("return paginatedResult.execute(daoFactory)", new Object[0]).build()).build();
            TypeSpec.Builder liveDataBuilderBuilder = TypeSpec.anonymousClassBuilder((String)"paginatedResult", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)handlerClass, (TypeName[])new TypeName[]{method.getReturnClass()})).addMethod(MethodSpec.methodBuilder((String)"compute").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(method.getReturnClass()).addStatement("return $T.getInstance().executeBatch($L)", new Object[]{dataSourceClazz, batchBuilder}).build());
            TypeSpec liveDataBuilder = liveDataBuilderBuilder.build();
            methodBuilder.addStatement("final $T builder=$L", new Object[]{ParameterizedTypeName.get((ClassName)handlerClass, (TypeName[])new TypeName[]{method.getReturnClass()}), liveDataBuilder});
        } else {
            batchBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)batchClazz, (TypeName[])new TypeName[]{method.getReturnClass()})).addMethod(MethodSpec.methodBuilder((String)"onExecute").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)daoFactoryClazz, (String)"daoFactory", (Modifier[])new Modifier[0]).build()).returns(method.getReturnClass()).addStatement("return daoFactory.get$L().$L($L)", new Object[]{daoDefinition.getName(), method.getName() + LIVE_DATA_PREFIX, buffer.toString()}).build()).build();
            TypeSpec.Builder liveDataBuilderBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)handlerClass, (TypeName[])new TypeName[]{method.getReturnClass()})).addMethod(MethodSpec.methodBuilder((String)"compute").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(method.getReturnClass()).addStatement("return $T.getInstance().executeBatch($L)", new Object[]{dataSourceClazz, batchBuilder}).build());
            TypeSpec liveDataBuilder = liveDataBuilderBuilder.build();
            methodBuilder.addStatement("final $T builder=$L", new Object[]{ParameterizedTypeName.get((ClassName)handlerClass, (TypeName[])new TypeName[]{method.getReturnClass()}), liveDataBuilder});
        }
        methodBuilder.addStatement("registryLiveData(builder)", new Object[0]);
        methodBuilder.addStatement("return builder.getLiveData()", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }

    public void generateCommonPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean generateSqlField) {
        this.generateCommonPart(method, classBuilder, methodBuilder, fieldList, GenerationType.ALL, null, generateSqlField, false, new JavadocPart[0]);
    }

    public void generateCommonPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, GenerationType generationType, TypeName forcedReturnType, boolean generateSqlField, boolean countQuery, JavadocPart ... javadocParts) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        TypeName returnTypeName = forcedReturnType;
        if (returnTypeName == null) {
            returnTypeName = method.getReturnClass();
        }
        ModelAnnotation annotation = method.getAnnotation(BindSqlSelect.class);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<String> paramGetters = new ArrayList<String>();
        ArrayList<TypeName> paramTypeNames = new ArrayList<TypeName>();
        ArrayList<String> usedBeanPropertyNames = new ArrayList<String>();
        HashSet<String> usedMethodParameters = new HashSet<String>();
        final One whereJQL = new One((Object)"");
        final One havingJQL = new One((Object)"");
        final One groupJQL = new One((Object)"");
        final One orderJQL = new One((Object)"");
        JQLChecker.getInstance().replaceVariableStatements(method, method.jql.value, new JQLReplaceVariableStatementListenerImpl(){

            @Override
            public String onWhere(String statement) {
                whereJQL.value0 = statement;
                return null;
            }

            @Override
            public String onOrderBy(String statement) {
                orderJQL.value0 = statement;
                return null;
            }

            @Override
            public String onHaving(String statement) {
                havingJQL.value0 = statement;
                return null;
            }

            @Override
            public String onGroup(String statement) {
                groupJQL.value0 = statement;
                return null;
            }
        });
        SqlAnalyzer analyzer = new SqlAnalyzer();
        analyzer.execute(BaseProcessor.elementUtils, method, (String)whereJQL.value0);
        paramGetters.addAll(analyzer.getParamGetters());
        paramNames.addAll(analyzer.getParamNames());
        paramTypeNames.addAll(analyzer.getParamTypeNames());
        usedBeanPropertyNames.addAll(analyzer.getUsedBeanPropertyNames());
        usedMethodParameters.addAll(analyzer.getUsedMethodParameters());
        analyzer.execute(BaseProcessor.elementUtils, method, (String)havingJQL.value0);
        paramGetters.addAll(analyzer.getParamGetters());
        paramNames.addAll(analyzer.getParamNames());
        paramTypeNames.addAll(analyzer.getParamTypeNames());
        usedBeanPropertyNames.addAll(analyzer.getUsedBeanPropertyNames());
        usedMethodParameters.addAll(analyzer.getUsedMethodParameters());
        analyzer.execute(BaseProcessor.elementUtils, method, (String)groupJQL.value0);
        paramGetters.addAll(analyzer.getParamGetters());
        paramNames.addAll(analyzer.getParamNames());
        paramTypeNames.addAll(analyzer.getParamTypeNames());
        usedBeanPropertyNames.addAll(analyzer.getUsedBeanPropertyNames());
        usedMethodParameters.addAll(analyzer.getUsedMethodParameters());
        analyzer.execute(BaseProcessor.elementUtils, method, (String)orderJQL.value0);
        paramGetters.addAll(analyzer.getParamGetters());
        paramNames.addAll(analyzer.getParamNames());
        paramTypeNames.addAll(analyzer.getParamTypeNames());
        usedBeanPropertyNames.addAll(analyzer.getUsedBeanPropertyNames());
        usedMethodParameters.addAll(analyzer.getUsedMethodParameters());
        if (method.hasDynamicWhereConditions()) {
            AssertKripton.assertTrueOrInvalidMethodSignException(!usedMethodParameters.contains(method.dynamicWhereParameterName), method, " parameter %s is used like SQL parameter and dynamic WHERE condition.", method.dynamicOrderByParameterName);
            usedMethodParameters.add(method.dynamicWhereParameterName);
            if (method.hasDynamicWhereArgs()) {
                AssertKripton.assertTrueOrInvalidMethodSignException(!usedMethodParameters.contains(method.dynamicWhereArgsParameterName), method, " parameter %s is used like SQL parameter and dynamic WHERE ARGS condition.", method.dynamicWhereArgsParameterName);
                usedMethodParameters.add(method.dynamicWhereArgsParameterName);
            }
        }
        if (method.hasDynamicOrderByConditions()) {
            AssertKripton.assertTrueOrInvalidMethodSignException(!usedMethodParameters.contains(method.dynamicOrderByParameterName), method, " parameter %s is used like SQL parameter and dynamic ORDER BY condition.", method.dynamicOrderByParameterName);
            usedMethodParameters.add(method.dynamicOrderByParameterName);
        }
        if (method.hasDynamicPageSizeConditions()) {
            AssertKripton.assertTrueOrInvalidMethodSignException(!usedMethodParameters.contains(method.dynamicPageSizeName), method, " parameter %s is used like SQL parameter and dynamic page size of LIMIT condition.", method.dynamicPageSizeName);
            usedMethodParameters.add(method.dynamicPageSizeName);
        }
        if (generationType.generateMethodSign) {
            this.generateMethodSignature(method, methodBuilder, returnTypeName, new ParameterSpec[0]);
        }
        if (!countQuery) {
            JavadocUtility.generateJavaDocForSelect(methodBuilder, paramNames, method, annotation, fieldList, this.selectType, javadocParts);
        }
        methodBuilder.addComment("common part generation - BEGIN", new Object[0]);
        if (generationType.generateMethodContent) {
            SqlSelectBuilder.SplittedSql splittedSql = SqlSelectBuilder.generateSQL(method, methodBuilder, countQuery);
            if (countQuery) {
                splittedSql.sqlBasic = String.format(splittedSql.sqlBasic, "count(*)");
            }
            methodBuilder.addStatement("$T _contentValues=contentValues()", new Object[]{KriptonContentValues.class});
            if (method.hasDynamicParts()) {
                AbstractSelectCodeGenerator.generateSQLBuild(method, methodBuilder, splittedSql, countQuery);
                methodBuilder.addStatement("String _sql=_sqlBuilder.toString()", new Object[0]);
            } else {
                String sql;
                String sqlName = "";
                sqlName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, method.buildSQLName());
                if (countQuery) {
                    sql = SqlSelectBuilder.convertJQL2SQL(method, true);
                    sql = "SELECT COUNT(*) FROM (" + sql + ")";
                    classBuilder.addField(FieldSpec.builder(String.class, (String)sqlName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{sql}).addJavadoc("SQL definition for method $L\n", new Object[]{method.getName()}).build());
                } else if (generateSqlField) {
                    sql = SqlSelectBuilder.convertJQL2SQL(method, true);
                    classBuilder.addField(FieldSpec.builder(String.class, (String)sqlName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{sql}).addJavadoc("SQL definition for method $L\n", new Object[]{method.getName()}).build());
                } else {
                    sqlName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, method.buildSQLNameWithCurrentCounter());
                }
                methodBuilder.addComment("query SQL is statically defined", new Object[0]);
                methodBuilder.addStatement("String _sql=$L", new Object[]{sqlName});
            }
            StringBuilder logArgsBuffer = new StringBuilder();
            methodBuilder.addComment("add where arguments", new Object[0]);
            String separator = "";
            int i = 0;
            String beanName = null;
            beanName = method.findEntityProperty();
            for (String methodParam : paramGetters) {
                TypeName paramTypeName;
                boolean rawParameters;
                boolean bl = rawParameters = ((String)paramNames.get(i)).indexOf(".") == -1;
                if (method.jql.spreadParams.contains(method.findParameterAliasByName(methodParam))) {
                    String sizeMethod = "";
                    String elementMethod = "";
                    TypeName paramCollTypeName = (TypeName)paramTypeNames.get(i);
                    if (paramCollTypeName instanceof ArrayTypeName) {
                        sizeMethod = "length";
                        elementMethod = "[_i]";
                        paramTypeName = ((ArrayTypeName)paramCollTypeName).componentType;
                    } else if (paramCollTypeName instanceof ParameterizedTypeName) {
                        sizeMethod = "size()";
                        elementMethod = ".get(_i)";
                        paramTypeName = (TypeName)((ParameterizedTypeName)paramCollTypeName).typeArguments.get(0);
                    } else {
                        paramTypeName = TypeName.get(String.class);
                    }
                    methodBuilder.beginControlFlow("if ($L!=null)", new Object[]{methodParam});
                    methodBuilder.addComment("$L is managed as spread param", new Object[]{methodParam});
                    methodBuilder.beginControlFlow("for (int _i=0; _i<$L.$L;_i++)", new Object[]{methodParam, sizeMethod});
                    methodBuilder.addCode(" _contentValues.addWhereArgs(", new Object[0]);
                    this.generateRawWhereArg(method, methodBuilder, paramTypeName, TypeUtility.isNullable(paramTypeName), methodParam, methodParam + elementMethod);
                    methodBuilder.addCode(");\n", new Object[0]);
                    methodBuilder.endControlFlow();
                    methodBuilder.endControlFlow();
                } else {
                    paramTypeName = (TypeName)paramTypeNames.get(i);
                    methodBuilder.addCode("_contentValues.addWhereArgs(", new Object[0]);
                    logArgsBuffer.append(separator + "%s");
                    boolean nullable = TypeUtility.isNullable(paramTypeName);
                    if (rawParameters) {
                        this.generateRawWhereArg(method, methodBuilder, paramTypeName, nullable, methodParam);
                    } else {
                        SQLProperty property;
                        SQLProperty sQLProperty = property = usedBeanPropertyNames.get(i) == null ? null : (SQLProperty)entity.get((String)usedBeanPropertyNames.get(i));
                        if (nullable && property == null && !method.hasAdapterForParam(methodParam)) {
                            methodBuilder.addCode("($L==null?\"\":", new Object[]{methodParam});
                        }
                        TypeUtility.beginStringConversion(methodBuilder, paramTypeName);
                        SQLTransformer.javaProperty2WhereCondition(methodBuilder, method, beanName, paramTypeName, property);
                        TypeUtility.endStringConversion(methodBuilder, paramTypeName);
                        if (nullable && property == null && !method.hasAdapterForParam(methodParam)) {
                            methodBuilder.addCode(")", new Object[0]);
                        }
                    }
                    methodBuilder.addCode(");\n", new Object[0]);
                }
                separator = ", ";
                ++i;
            }
            methodBuilder.addStatement("String[] _sqlArgs=_contentValues.whereArgsAsArray()", new Object[0]);
            if (daoDefinition.isLogEnabled()) {
                methodBuilder.addComment("log section for select BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (_context.isLogEnabled())", new Object[0]);
                methodBuilder.addComment("manage log", new Object[0]);
                methodBuilder.addStatement("$T.info(_sql)", new Object[]{Logger.class});
                SqlBuilderHelper.generateLogForWhereParameters(method, methodBuilder);
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section for select END", new Object[0]);
            }
            ClassName cursorClass = ClassName.bestGuess((String)"android.database.Cursor");
            if (generationType.generateCloseableCursor) {
                methodBuilder.beginControlFlow("try ($T _cursor = database().rawQuery(_sql, _sqlArgs))", new Object[]{cursorClass});
            } else {
                methodBuilder.addStatement("$T _cursor = database().rawQuery(_sql, _sqlArgs)", new Object[]{cursorClass});
            }
            if (daoDefinition.isLogEnabled()) {
                methodBuilder.addComment("log section BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (_context.isLogEnabled())", new Object[0]);
                methodBuilder.addCode("$T.info(\"Rows found: %s\",_cursor.getCount());\n", new Object[]{Logger.class});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section END", new Object[0]);
            }
            switch (this.selectType) {
                case LISTENER_CURSOR: {
                    ClassName readCursorListenerToExclude = ClassName.get(OnReadCursorListener.class);
                    AbstractSelectCodeGenerator.checkUnusedParameters(method, usedMethodParameters, (TypeName)readCursorListenerToExclude);
                    break;
                }
                case LISTENER_BEAN: {
                    ParameterizedTypeName readBeanListenerToExclude = ParameterizedTypeName.get((ClassName)ClassName.get(OnReadBeanListener.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)((TypeElement)entity.getElement()).asType())});
                    AbstractSelectCodeGenerator.checkUnusedParameters(method, usedMethodParameters, (TypeName)readBeanListenerToExclude);
                    break;
                }
                default: {
                    AbstractSelectCodeGenerator.checkUnusedParameters(method, usedMethodParameters, null);
                }
            }
        }
        methodBuilder.addComment("common part generation - END", new Object[0]);
    }

    private void generateRawWhereArg(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, TypeName paramTypeName, boolean nullable, String item) {
        this.generateRawWhereArg(method, methodBuilder, paramTypeName, nullable, item, item);
    }

    private void generateRawWhereArg(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, TypeName paramTypeName, boolean nullable, String methodItem, String item) {
        if (nullable && !method.hasAdapterForParam(methodItem)) {
            methodBuilder.addCode("($L==null?\"\":", new Object[]{item});
        }
        TypeUtility.beginStringConversion(methodBuilder, paramTypeName);
        SQLTransformer.javaMethodParam2WhereConditions(methodBuilder, method, methodItem, item, paramTypeName);
        TypeUtility.endStringConversion(methodBuilder, paramTypeName);
        if (nullable && !method.hasAdapterForParam(methodItem)) {
            methodBuilder.addCode(")", new Object[0]);
        }
    }

    protected MethodSpec.Builder generateMethodBuilder(SQLiteModelMethod method) {
        MethodSpec.Builder methodBuilder = method.hasLiveData() ? MethodSpec.methodBuilder((String)(method.getName() + LIVE_DATA_PREFIX)).addModifiers(new Modifier[]{Modifier.PROTECTED}) : MethodSpec.methodBuilder((String)method.getName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        return methodBuilder;
    }

    protected void generateMethodSignature(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, TypeName returnTypeName, ParameterSpec ... additionalParameterSpec) {
        boolean finalParameter = false;
        if (method.hasLiveData() && returnTypeName.equals((Object)method.liveDataReturnClass)) {
            finalParameter = true;
        }
        for (Pair<String, TypeName> item : method.getParameters()) {
            ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)((TypeName)item.value1), (String)((String)item.value0), (Modifier[])new Modifier[0]);
            if (finalParameter) {
                builder.addModifiers(new Modifier[]{Modifier.FINAL});
            }
            methodBuilder.addParameter(builder.build());
        }
        for (ParameterSpec item : additionalParameterSpec) {
            methodBuilder.addParameter(item);
        }
        methodBuilder.returns(returnTypeName);
    }

    public abstract void generateSpecializedPart(SQLiteModelMethod var1, TypeSpec.Builder var2, MethodSpec.Builder var3, Set<JQLProjection> var4, boolean var5);

    @Override
    public void setSelectResultTye(SelectBuilderUtility.SelectType value) {
        this.selectType = value;
    }

    public static void checkUnusedParameters(SQLiteModelMethod method, Set<String> usedMethodParameters, TypeName excludedClasses) {
        int usedCount;
        int paramsCount = method.getParameters().size();
        if (paramsCount > (usedCount = usedMethodParameters.size())) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (Pair<String, TypeName> item : method.getParameters()) {
                if (excludedClasses != null && ((TypeName)item.value1).equals((Object)excludedClasses)) {
                    ++usedCount;
                    continue;
                }
                if (usedMethodParameters.contains(item.value0)) continue;
                sb.append(separator + "'" + (String)item.value0 + "'");
                separator = ", ";
            }
            if (paramsCount > usedCount) {
                throw new InvalidMethodSignException(method, "unused parameter(s) " + sb.toString());
            }
        }
    }

    private static void generateSQLBuild(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, SqlSelectBuilder.SplittedSql splittedSql, boolean countQuery) {
        methodBuilder.addStatement("$T _sqlBuilder=sqlBuilder()", new Object[]{StringBuilder.class});
        methodBuilder.addStatement("_sqlBuilder.append($S)", new Object[]{splittedSql.sqlBasic.trim()});
        SqlModifyBuilder.generateInitForDynamicWhereVariables(method, methodBuilder, method.dynamicWhereParameterName, method.dynamicWhereArgsParameterName);
        if (method.jql.isOrderBy()) {
            methodBuilder.addStatement("String _sortOrder=$L", new Object[]{method.jql.paramOrderBy});
        }
        SqlBuilderHelper.generateWhereCondition(methodBuilder, method, false);
        SqlSelectBuilder.generateDynamicPartOfQuery(method, methodBuilder, splittedSql, countQuery);
    }

    public static enum GenerationType {
        ALL(true, true, true),
        NO_CLOSE_CURSOR(true, true, false),
        NO_METHOD_SIGN(false, true, true),
        NO_CONTENT(true, false, true);

        public final boolean generateMethodSign;
        public final boolean generateMethodContent;
        public final boolean generateCloseableCursor;

        private GenerationType(boolean generateMethodSign, boolean generateMethodContent, boolean generateCloseableCursor) {
            this.generateMethodSign = generateMethodSign;
            this.generateMethodContent = generateMethodContent;
            this.generateCloseableCursor = generateCloseableCursor;
        }
    }

    public static class JavadocPart {
        public final JavadocPartType javadocPartType;
        public final String name;
        public final String description;

        JavadocPart(JavadocPartType javadocPartType, String name, String description) {
            this.javadocPartType = javadocPartType;
            this.name = name;
            this.description = description;
        }

        public static JavadocPart build(JavadocPartType javadocPartType, String name, String description) {
            return new JavadocPart(javadocPartType, name, description);
        }
    }

    public static enum JavadocPartType {
        ADD_PARAMETER,
        RETURN;

    }
}

