/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import com.abubusoft.kripton.android.KriptonLibrary;
import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindContentProvider;
import com.abubusoft.kripton.android.annotation.BindContentProviderEntry;
import com.abubusoft.kripton.android.annotation.BindContentProviderPath;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractBuilder;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class BindContentProviderBuilder
extends AbstractBuilder {
    protected Map<String, ContentEntry> uriSet = new TreeMap<String, ContentEntry>();
    public static final String PREFIX = "Bind";
    public static final String SUFFIX = "ContentProvider";

    public BindContentProviderBuilder(Elements elementUtils, Filer filer, SQLiteDatabaseSchema model) {
        super(elementUtils, filer, model);
    }

    public static void generate(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        BindContentProviderBuilder visitorDao = new BindContentProviderBuilder(elementUtils, filer, schema);
        visitorDao.build(elementUtils, filer, schema);
    }

    public void build(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        this.uriSet.clear();
        String dataSourceName = schema.getName();
        String dataSourceNameClazz = PREFIX + dataSourceName;
        String contentProviderName = PREFIX + dataSourceName.replace("DataSource", "") + SUFFIX;
        PackageElement pkg = elementUtils.getPackageOf((Element)schema.getElement());
        String packageName = pkg.isUnnamed() ? null : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindContentProvider.class, packageName, contentProviderName);
        this.classBuilder = TypeSpec.classBuilder((String)contentProviderName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(ContentProvider.class);
        this.classBuilder.addJavadoc("<p>This is the content provider generated for {@link $L}</p>\n\n", new Object[]{dataSourceName});
        this.classBuilder.addJavadoc("<h2>Content provider authority:</h2>\n", new Object[0]);
        this.classBuilder.addJavadoc("<pre>$L</pre>\n\n", new Object[]{schema.contentProvider.authority});
        this.generateOnCreate(dataSourceNameClazz);
        this.generateOnShutdown(dataSourceNameClazz);
        this.classBuilder.addField(FieldSpec.builder(String.class, (String)"URI", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC, Modifier.FINAL}).initializer("$S", new Object[]{schema.contentProviderUri()}).addJavadoc("<p>content provider's URI.</p>\n<pre>$L</pre>\n", new Object[]{schema.contentProviderUri()}).build());
        this.classBuilder.addField(FieldSpec.builder((TypeName)TypeUtility.className(dataSourceNameClazz), (String)"dataSource", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addJavadoc("<p>datasource singleton</p>\n", new Object[0]).build());
        this.classBuilder.addField(FieldSpec.builder(String.class, (String)"AUTHORITY", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("<p>Content provider authority</p>\n", new Object[0]).initializer("$S", new Object[]{schema.contentProvider.authority}).build());
        this.classBuilder.addField(FieldSpec.builder(UriMatcher.class, (String)"sURIMatcher", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addJavadoc("<p>URI matcher</p>\n", new Object[0]).initializer("new $T($T.NO_MATCH)", new Object[]{UriMatcher.class, UriMatcher.class}).build());
        CodeBlock.Builder staticBuilder = CodeBlock.builder();
        Converter daoConstantConverter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
        ArrayList<FieldSpec> listFieldUri = new ArrayList<FieldSpec>();
        ArrayList<FieldSpec> listFieldString = new ArrayList<FieldSpec>();
        ArrayList<FieldSpec> listFieldIndex = new ArrayList<FieldSpec>();
        ArrayList<FieldSpec> listFieldAlias = new ArrayList<FieldSpec>();
        for (SQLiteDaoDefinition daoDefinition : schema.getCollection()) {
            String pathConstantName = "PATH_" + (String)daoConstantConverter.convert((Object)daoDefinition.getEntitySimplyClassName());
            if (!daoDefinition.contentProviderEnabled) continue;
            for (SQLiteModelMethod daoMethod : daoDefinition.getCollection()) {
                if (!daoMethod.contentProviderEntryPathEnabled) continue;
                ContentEntry entry = this.uriSet.get(daoMethod.contentProviderEntryPathTemplate);
                if (entry == null) {
                    entry = new ContentEntry(daoMethod.contentProviderEntryPath);
                    this.uriSet.put(daoMethod.contentProviderEntryPathTemplate, entry);
                    entry.path = daoMethod.contentProviderEntryPath;
                    entry.uriTemplate = daoMethod.contentProviderEntryPathTemplate;
                    entry.pathCostant = pathConstantName;
                    entry.pathIndex = pathConstantName;
                }
                switch (daoMethod.jql.operationType) {
                    case INSERT: {
                        AssertKripton.fail(entry.insert != null, String.format("In DAO '%s', there are more than one %s statement associated to content provider path '%s'", new Object[]{daoDefinition.getName().toString(), daoMethod.jql.operationType, entry.path}), new Object[0]);
                        entry.insert = daoMethod;
                        break;
                    }
                    case UPDATE: {
                        AssertKripton.fail(entry.update != null, String.format("In DAO '%s', there are more than one %s statement associated to content provider path '%s'", new Object[]{daoDefinition.getName().toString(), daoMethod.jql.operationType, entry.path}), new Object[0]);
                        entry.update = daoMethod;
                        break;
                    }
                    case SELECT: {
                        AssertKripton.fail(entry.select != null, String.format("In DAO '%s', there are more than one %s statement associated to content provider path '%s'", new Object[]{daoDefinition.getName().toString(), daoMethod.jql.operationType, entry.path}), new Object[0]);
                        entry.select = daoMethod;
                        break;
                    }
                    case DELETE: {
                        AssertKripton.fail(entry.delete != null, String.format("In DAO '%s', there are more than one %s statement associated to content provider path '%s'", new Object[]{daoDefinition.getName().toString(), daoMethod.jql.operationType, entry.path}), new Object[0]);
                        entry.delete = daoMethod;
                    }
                }
            }
        }
        ArrayList<Pair> listUriSet = new ArrayList<Pair>();
        for (Map.Entry<String, ContentEntry> entry : this.uriSet.entrySet()) {
            Pair item = new Pair((Object)entry.getKey(), (Object)entry.getValue());
            listUriSet.add(item);
        }
        Comparator<Pair<String, ContentEntry>> c = new Comparator<Pair<String, ContentEntry>>(){

            @Override
            public int compare(Pair<String, ContentEntry> lhs, Pair<String, ContentEntry> rhs) {
                return ((String)lhs.value0).compareTo((String)rhs.value0);
            }
        };
        Collections.sort(listUriSet, c);
        HashSet<String> alreadyUsedName = new HashSet<String>();
        Converter format = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
        int i = 1;
        for (Pair entry : listUriSet) {
            ((ContentEntry)entry.value1).pathCostant = ((ContentEntry)entry.value1).pathCostant + "_" + i;
            ((ContentEntry)entry.value1).pathIndex = ((ContentEntry)entry.value1).pathIndex + "_" + i + "_INDEX";
            ((ContentEntry)entry.value1).pathValue = i++;
            listFieldString.add(FieldSpec.builder(String.class, (String)((ContentEntry)entry.value1).pathCostant, (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$S", (Object[])new Object[]{((ContentEntry)entry.value1).uriTemplate})).build());
            listFieldIndex.add(FieldSpec.builder(Integer.TYPE, (String)((ContentEntry)entry.value1).pathIndex, (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$L", (Object[])new Object[]{((ContentEntry)entry.value1).pathValue})).build());
            listFieldUri.add(FieldSpec.builder(Uri.class, (String)("URI_" + ((ContentEntry)entry.value1).pathCostant), (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).addJavadoc("<p>Uri</p>\n", new Object[0]).addJavadoc("<pre>$L/$L</pre>\n", new Object[]{schema.contentProviderUri().replace("*", "[*]"), ((ContentEntry)entry.value1).uriTemplate.replace("*", "[*]")}).initializer(CodeBlock.of((String)"Uri.parse(URI+\"/$L\")", (Object[])new Object[]{((ContentEntry)entry.value1).uriTemplate})).build());
            this.generateURIForMethod(schema, listFieldAlias, alreadyUsedName, (Converter<String, String>)format, (Pair<String, ContentEntry>)entry, ((ContentEntry)entry.value1).delete);
            this.generateURIForMethod(schema, listFieldAlias, alreadyUsedName, (Converter<String, String>)format, (Pair<String, ContentEntry>)entry, ((ContentEntry)entry.value1).insert);
            this.generateURIForMethod(schema, listFieldAlias, alreadyUsedName, (Converter<String, String>)format, (Pair<String, ContentEntry>)entry, ((ContentEntry)entry.value1).select);
            this.generateURIForMethod(schema, listFieldAlias, alreadyUsedName, (Converter<String, String>)format, (Pair<String, ContentEntry>)entry, ((ContentEntry)entry.value1).update);
            staticBuilder.addStatement("sURIMatcher.addURI(AUTHORITY, $L, $L)", new Object[]{((ContentEntry)entry.value1).pathCostant, ((ContentEntry)entry.value1).pathIndex});
        }
        for (FieldSpec f : listFieldUri) {
            this.classBuilder.addField(f);
        }
        for (FieldSpec f : listFieldString) {
            this.classBuilder.addField(f);
        }
        for (FieldSpec f : listFieldIndex) {
            this.classBuilder.addField(f);
        }
        for (FieldSpec f : listFieldAlias) {
            this.classBuilder.addField(f);
        }
        this.classBuilder.addStaticBlock(staticBuilder.build());
        this.generateQuery(schema);
        this.generateInsert(schema);
        this.generateUpdate(schema);
        this.generateDelete(schema);
        this.generateGetType(schema);
        this.classBuilder.addJavadoc("\n\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        TypeSpec typeSpec = this.classBuilder.build();
        JavaWriterHelper.writeJava2File(filer, packageName, typeSpec);
    }

    private void generateURIForMethod(SQLiteDatabaseSchema schema, List<FieldSpec> listFieldAlias, Set<String> alreadyUsedName, Converter<String, String> format, Pair<String, ContentEntry> entry, SQLiteModelMethod method) {
        if (method == null) {
            return;
        }
        String alias = "URI_" + ((ContentEntry)entry.value1).pathCostant.substring(0, ((ContentEntry)entry.value1).pathCostant.lastIndexOf("_")).replace("PATH_", "") + "_" + (String)format.convert((Object)method.getName());
        if (!alreadyUsedName.contains(alias)) {
            String contentUri = schema.contentProviderUri().replace("*", "[*]") + "/" + ((ContentEntry)entry.value1).uriTemplate.replace("*", "[*]");
            String contentUriWithParameter = method.contentProviderUri().replace("*", "[*]");
            listFieldAlias.add(FieldSpec.builder(Uri.class, (String)alias, (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC}).addJavadoc("<h2>URI standard</h2>\n<pre>$L</pre></p>\n", new Object[]{contentUri}).addJavadoc("<h2>URI with parameters</h2>\n<pre>$L</pre>\n\n", new Object[]{contentUriWithParameter}).addJavadoc("<p>Method associated to this URI is {@link $LImpl#$L}</p>\n", new Object[]{method.getParent().getName(), method.contentProviderMethodName}).initializer(CodeBlock.of((String)("URI_" + ((ContentEntry)entry.value1).pathCostant), (Object[])new Object[0])).build());
            alreadyUsedName.add(alias);
        }
    }

    private void generateInsert(SQLiteDatabaseSchema schema) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Uri.class);
        methodBuilder.addParameter(Uri.class, "uri", new Modifier[0]);
        methodBuilder.addParameter(ContentValues.class, "contentValues", new Modifier[0]);
        boolean hasOperation = this.hasOperationOfType(schema, methodBuilder, JQL.JQLType.INSERT);
        if (!hasOperation) {
            methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.DELETE});
            this.classBuilder.addMethod(methodBuilder.build());
            return;
        }
        this.defineJavadocHeaderForContentOperation(methodBuilder, "insert");
        methodBuilder.addStatement("long _id=-1", new Object[0]);
        methodBuilder.addStatement("$T _returnURL=null", new Object[]{Uri.class});
        methodBuilder.beginControlFlow("switch (sURIMatcher.match(uri))", new Object[0]);
        for (Map.Entry<String, ContentEntry> item : this.uriSet.entrySet()) {
            if (item.getValue().insert == null) continue;
            this.defineJavadocForContentUri(methodBuilder, item.getValue().insert);
            methodBuilder.beginControlFlow("case $L:", new Object[]{item.getValue().pathIndex});
            methodBuilder.addStatement("_id=dataSource.get$L().$L(uri, contentValues)", new Object[]{item.getValue().insert.getParent().getName(), item.getValue().insert.contentProviderMethodName});
            methodBuilder.addStatement("_returnURL=Uri.withAppendedPath(uri, String.valueOf(_id))", new Object[0]);
            methodBuilder.addStatement("break", new Object[0]);
            methodBuilder.endControlFlow();
        }
        this.defineJavadocFooterForContentOperation(methodBuilder);
        methodBuilder.beginControlFlow("default:", new Object[0]);
        methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.INSERT});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        if (hasOperation) {
            if (schema.generateLog) {
                methodBuilder.addComment("log section for content provider insert BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (dataSource.isLogEnabled())", new Object[0]);
                methodBuilder.addStatement("$T.info(\"Element is created with URI '%s'\", _returnURL)", new Object[]{Logger.class});
                methodBuilder.addStatement("$T.info(\"Changes are notified for URI '%s'\", uri)", new Object[]{Logger.class});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section for content provider insert END", new Object[0]);
            }
            methodBuilder.addStatement("getContext().getContentResolver().notifyChange(uri, null)", new Object[0]);
            methodBuilder.addStatement("return _returnURL", new Object[0]);
        }
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void defineJavadocForContentUri(MethodSpec.Builder builder, SQLiteModelMethod method) {
        String contentUri = method.contentProviderUri().replace("*", "[*]");
        this.classBuilder.addJavadoc("<tr><td><pre>$L</pre></td><td>{@link $LImpl#$L}</td></tr>\n", new Object[]{contentUri, method.getParent().getName(), method.contentProviderMethodName});
        builder.addJavadoc("<tr><td><pre>$L</pre></td><td>{@link $LImpl#$L}</td></tr>\n", new Object[]{contentUri, method.getParent().getName(), method.contentProviderMethodName});
    }

    private void generateDelete(SQLiteDatabaseSchema schema) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"delete").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE);
        methodBuilder.addParameter(Uri.class, "uri", new Modifier[0]);
        methodBuilder.addParameter(String.class, "selection", new Modifier[0]);
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.arrayTypeName(String.class), (String)"selectionArgs", (Modifier[])new Modifier[0]).build());
        boolean hasOperation = this.hasOperationOfType(schema, methodBuilder, JQL.JQLType.DELETE);
        if (!hasOperation) {
            methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.DELETE});
            this.classBuilder.addMethod(methodBuilder.build());
            return;
        }
        methodBuilder.addStatement("int returnRowDeleted=-1", new Object[0]);
        methodBuilder.beginControlFlow("switch (sURIMatcher.match(uri))", new Object[0]);
        this.defineJavadocHeaderForContentOperation(methodBuilder, "delete");
        for (Map.Entry<String, ContentEntry> item : this.uriSet.entrySet()) {
            if (item.getValue().delete == null) continue;
            this.defineJavadocForContentUri(methodBuilder, item.getValue().delete);
            methodBuilder.beginControlFlow("case $L:", new Object[]{item.getValue().pathIndex});
            methodBuilder.addCode("// URI: $L\n", new Object[]{item.getValue().delete.contentProviderUri()});
            methodBuilder.addStatement("returnRowDeleted=dataSource.get$L().$L(uri, selection, selectionArgs)", new Object[]{item.getValue().delete.getParent().getName(), item.getValue().delete.contentProviderMethodName});
            methodBuilder.addStatement("break", new Object[0]);
            methodBuilder.endControlFlow();
        }
        this.defineJavadocFooterForContentOperation(methodBuilder);
        methodBuilder.beginControlFlow("default:", new Object[0]);
        methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.DELETE});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        if (hasOperation) {
            if (schema.generateLog) {
                methodBuilder.addComment("log section for content provider delete BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (dataSource.isLogEnabled())", new Object[0]);
                methodBuilder.addStatement("$T.info(\"Changes are notified for URI %s\", uri)", new Object[]{Logger.class});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section for content provider delete END", new Object[0]);
            }
            methodBuilder.addStatement("getContext().getContentResolver().notifyChange(uri, null)", new Object[0]);
        }
        methodBuilder.addCode("return returnRowDeleted;\n", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generateUpdate(SQLiteDatabaseSchema schema) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE);
        methodBuilder.addParameter(Uri.class, "uri", new Modifier[0]);
        methodBuilder.addParameter(ContentValues.class, "contentValues", new Modifier[0]);
        methodBuilder.addParameter(String.class, "selection", new Modifier[0]);
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.arrayTypeName(String.class), (String)"selectionArgs", (Modifier[])new Modifier[0]).build());
        boolean hasOperation = this.hasOperationOfType(schema, methodBuilder, JQL.JQLType.UPDATE);
        if (!hasOperation) {
            methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.UPDATE});
            this.classBuilder.addMethod(methodBuilder.build());
            return;
        }
        this.defineJavadocHeaderForContentOperation(methodBuilder, "update");
        methodBuilder.addStatement("int returnRowUpdated=1", new Object[0]);
        methodBuilder.beginControlFlow("switch (sURIMatcher.match(uri))", new Object[0]);
        for (Map.Entry<String, ContentEntry> item : this.uriSet.entrySet()) {
            if (item.getValue().update == null) continue;
            this.defineJavadocForContentUri(methodBuilder, item.getValue().update);
            methodBuilder.beginControlFlow("case $L:", new Object[]{item.getValue().pathIndex});
            methodBuilder.addCode("// URI: $L\n", new Object[]{item.getValue().update.contentProviderUri()});
            methodBuilder.addStatement("returnRowUpdated=dataSource.get$L().$L(uri, contentValues, selection, selectionArgs)", new Object[]{item.getValue().update.getParent().getName(), item.getValue().update.contentProviderMethodName});
            methodBuilder.addStatement("break", new Object[0]);
            methodBuilder.endControlFlow();
        }
        this.defineJavadocFooterForContentOperation(methodBuilder);
        methodBuilder.beginControlFlow("default:", new Object[0]);
        methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.UPDATE});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        if (hasOperation) {
            if (schema.generateLog) {
                methodBuilder.addComment("log section BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (dataSource.isLogEnabled())", new Object[0]);
                methodBuilder.addStatement("$T.info(\"Changes are notified for URI %s\", uri)", new Object[]{Logger.class});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section END", new Object[0]);
            }
            methodBuilder.addStatement("getContext().getContentResolver().notifyChange(uri, null)", new Object[0]);
        }
        methodBuilder.addStatement("return returnRowUpdated", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void defineJavadocFooterForContentOperation(MethodSpec.Builder methodBuilder) {
        this.classBuilder.addJavadoc("</table>\n\n", new Object[0]);
        methodBuilder.addJavadoc("</table>\n\n", new Object[0]);
    }

    private void defineJavadocHeaderForContentOperation(MethodSpec.Builder builder, String value) {
        builder.addJavadoc("\n<h2>Supported $L operations</h2>\n", new Object[]{value});
        builder.addJavadoc("<table>\n", new Object[0]);
        builder.addJavadoc("<tr><th>URI</th><th>DAO.METHOD</th></tr>\n", new Object[0]);
        this.classBuilder.addJavadoc("<h2>Supported $L operations</h2>\n", new Object[]{value});
        this.classBuilder.addJavadoc("<table>\n", new Object[0]);
        this.classBuilder.addJavadoc("<tr><th>URI</th><th>DAO.METHOD</th></tr>\n", new Object[0]);
    }

    private boolean hasOperationOfType(SQLiteDatabaseSchema schema, MethodSpec.Builder methodBuilder, JQL.JQLType jqlType) {
        boolean hasOperation = false;
        for (SQLiteDaoDefinition daoDefinition : schema.getCollection()) {
            if (((TypeElement)daoDefinition.getElement()).getAnnotation(BindContentProviderPath.class) == null) continue;
            for (SQLiteModelMethod daoMethod : daoDefinition.getCollection()) {
                if (daoMethod.jql.operationType != jqlType || !daoMethod.hasAnnotation(BindContentProviderEntry.class)) continue;
                hasOperation = true;
            }
        }
        return hasOperation;
    }

    private void generateGetType(SQLiteDatabaseSchema schema) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getType").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class);
        methodBuilder.addParameter(Uri.class, "uri", new Modifier[0]);
        methodBuilder.beginControlFlow("switch (sURIMatcher.match(uri))", new Object[0]);
        for (Map.Entry<String, ContentEntry> item : this.uriSet.entrySet()) {
            methodBuilder.beginControlFlow("case $L:", new Object[]{item.getValue().pathIndex});
            methodBuilder.addStatement("return $S", new Object[]{item.getValue().getContentType()});
            methodBuilder.endControlFlow();
        }
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, "getType"});
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generateOnCreate(String dataSourceNameClazz) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onCreate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.TYPE);
        methodBuilder.addJavadoc("<p>Create datasource and open database in read mode.</p>\n", new Object[0]);
        methodBuilder.addJavadoc("\n", new Object[0]);
        methodBuilder.addJavadoc("@see android.content.ContentProvider#onCreate()\n", new Object[0]);
        methodBuilder.beginControlFlow("if ($T.getContext()==null)", new Object[]{KriptonLibrary.class});
        methodBuilder.addStatement("KriptonLibrary.init(getContext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("dataSource = $L.getInstance()", new Object[]{dataSourceNameClazz});
        methodBuilder.addStatement("dataSource.openWritableDatabase()", new Object[0]);
        methodBuilder.addCode("return true;\n", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generateOnShutdown(String dataSourceNameClazz) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"shutdown").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Void.TYPE);
        methodBuilder.addJavadoc("<p>Close database.</p>\n", new Object[0]);
        methodBuilder.addJavadoc("\n", new Object[0]);
        methodBuilder.addJavadoc("@see android.content.ContentProvider#shutdown()\n", new Object[0]);
        methodBuilder.addStatement("super.shutdown()", new Object[0]);
        methodBuilder.addStatement("dataSource.close()", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generateQuery(SQLiteDatabaseSchema schema) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"query").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Cursor.class);
        methodBuilder.addParameter(Uri.class, "uri", new Modifier[0]);
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.arrayTypeName(String.class), (String)"projection", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(String.class, "selection", new Modifier[0]);
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.arrayTypeName(String.class), (String)"selectionArgs", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(String.class, "sortOrder", new Modifier[0]);
        boolean hasOperation = this.hasOperationOfType(schema, methodBuilder, JQL.JQLType.SELECT);
        if (!hasOperation) {
            methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.SELECT});
            this.classBuilder.addMethod(methodBuilder.build());
            return;
        }
        methodBuilder.addStatement("$T returnCursor=null", new Object[]{Cursor.class});
        for (SQLiteDaoDefinition sQLiteDaoDefinition : schema.getCollection()) {
            for (SQLiteModelMethod daoMethod : sQLiteDaoDefinition.getCollection()) {
                if (daoMethod.jql.operationType == JQL.JQLType.SELECT) continue;
            }
        }
        this.defineJavadocHeaderForContentOperation(methodBuilder, "query");
        methodBuilder.beginControlFlow("switch (sURIMatcher.match(uri))", new Object[0]);
        for (Map.Entry entry : this.uriSet.entrySet()) {
            if (((ContentEntry)entry.getValue()).select == null) continue;
            this.defineJavadocForContentUri(methodBuilder, ((ContentEntry)entry.getValue()).select);
            methodBuilder.beginControlFlow("case $L:", new Object[]{((ContentEntry)entry.getValue()).pathIndex});
            methodBuilder.addCode("// URI: $L\n", new Object[]{((ContentEntry)entry.getValue()).select.contentProviderUri()});
            methodBuilder.addStatement("returnCursor=dataSource.get$L().$L(uri, projection, selection, selectionArgs, sortOrder)", new Object[]{((ContentEntry)entry.getValue()).select.getParent().getName(), ((ContentEntry)entry.getValue()).select.contentProviderMethodName});
            methodBuilder.addStatement("break", new Object[0]);
            methodBuilder.endControlFlow();
        }
        methodBuilder.beginControlFlow("default:", new Object[0]);
        methodBuilder.addStatement("throw new $T(\"Unknown URI for $L operation: \" + uri)", new Object[]{IllegalArgumentException.class, JQL.JQLType.SELECT});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        this.defineJavadocFooterForContentOperation(methodBuilder);
        if (hasOperation) {
            methodBuilder.addStatement("return returnCursor", new Object[0]);
        }
        this.classBuilder.addMethod(methodBuilder.build());
    }

    public static class ContentEntry {
        public String path;
        public String uri_index;
        public SQLiteModelMethod insert;
        public SQLiteModelMethod update;
        public SQLiteModelMethod delete;
        public SQLiteModelMethod select;
        public String pathCostant;
        public String pathIndex;
        public String uriTemplate;
        public int pathValue;

        public ContentEntry(String path) {
            this.path = path;
        }

        public String getContentType() {
            SQLiteModelMethod[] methods;
            String type = "item";
            String typeName = null;
            for (SQLiteModelMethod item : methods = new SQLiteModelMethod[]{this.insert, this.update, this.delete, this.select}) {
                String value;
                BindContentProviderEntry.MultiplicityResultType multiplicity;
                if (item == null) continue;
                if (typeName == null) {
                    typeName = item.getParent().contentProviderTypeName;
                }
                if ((multiplicity = BindContentProviderEntry.MultiplicityResultType.valueOf((String)(value = AnnotationUtility.extractAsEnumerationValue(item.getElement(), BindContentProviderEntry.class, AnnotationAttributeType.MULTIPLICITY_RESULT)))) != BindContentProviderEntry.MultiplicityResultType.MANY && (multiplicity != BindContentProviderEntry.MultiplicityResultType.DEFAULT || item.jql.operationType != JQL.JQLType.SELECT)) continue;
                type = "dir";
            }
            return "vnd.android.cursor." + type + "/vnd." + typeName;
        }
    }
}

