/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.Cursor;
import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.ModelElementVisitor;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractBuilder;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class BindCursorBuilder
extends AbstractBuilder
implements ModelElementVisitor<SQLiteEntity, SQLProperty> {
    public static final String PREFIX = "Bind";
    public static final String SUFFIX = "Cursor";
    private int counter;

    public BindCursorBuilder(Elements elementUtils, Filer filer, SQLiteDatabaseSchema model) {
        super(elementUtils, filer, model);
    }

    public static void generate(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        BindCursorBuilder visitor = new BindCursorBuilder(elementUtils, filer, schema);
        for (SQLiteEntity item : schema.getEntities()) {
            visitor.visit(schema, item);
        }
    }

    @Override
    public void visit(SQLiteDatabaseSchema schema, SQLiteEntity entity) throws Exception {
        String classCursorName = PREFIX + entity.getSimpleName() + SUFFIX;
        PackageElement pkg = this.elementUtils.getPackageOf((Element)entity.getElement());
        String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
        ClassName className = TypeUtility.className(packageName, classCursorName);
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDataSource.class, packageName, classCursorName);
        this.classBuilder = TypeSpec.classBuilder((String)classCursorName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.classBuilder.addJavadoc("<p>", new Object[0]);
        this.classBuilder.addJavadoc("\nCursor implementation for entity <code>$L</code>\n", new Object[]{entity.getSimpleName()});
        this.classBuilder.addJavadoc("</p>\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        this.classBuilder.addJavadoc(" @see $T\n", new Object[]{TypeUtility.className(((TypeElement)entity.getElement()).getQualifiedName().toString())});
        FieldSpec fieldSpec = FieldSpec.builder(Cursor.class, (String)"cursor", (Modifier[])new Modifier[]{Modifier.PROTECTED}).addJavadoc("Cursor used to read database\n", new Object[0]).build();
        this.classBuilder.addField(fieldSpec);
        this.classBuilder.addMethod(MethodSpec.constructorBuilder().addJavadoc("<p>Constructor</p>\n\n", new Object[0]).addJavadoc("@param cursor cursor used to read from database\n", new Object[0]).addParameter(Cursor.class, "cursor", new Modifier[0]).addCode("wrap(cursor);\n", new Object[0]).build());
        MethodSpec.Builder wrapMethodBuilder = MethodSpec.methodBuilder((String)"wrap").addJavadoc("<p>Wrap cursor with this class</p>\n\n", new Object[0]).addJavadoc("@param cursor cursor to include\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Cursor.class, "cursor", new Modifier[0]).returns((TypeName)className).addCode("this.cursor=cursor;\n", new Object[0]);
        this.counter = 0;
        wrapMethodBuilder.addCode("\n", new Object[0]);
        for (ModelProperty item : entity.getCollection()) {
            wrapMethodBuilder.addCode("index$L=cursor.getColumnIndex($S);\n", new Object[]{this.counter, ((SQLProperty)item).columnName});
            ++this.counter;
        }
        wrapMethodBuilder.addCode("\n", new Object[0]);
        wrapMethodBuilder.addCode("return this;\n", new Object[0]);
        this.classBuilder.addMethod(wrapMethodBuilder.build());
        this.classBuilder.addMethod(this.generateExecuteMethod(packageName, entity).build());
        this.classBuilder.addMethod(this.generateExecuteListener(packageName, entity).build());
        this.classBuilder.addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addParameter(Cursor.class, "cursor", new Modifier[0]).returns((TypeName)TypeUtility.className(packageName, classCursorName)).addJavadoc("<p>Create a binded cursor starting from a cursor</p>\n\n", new Object[0]).addJavadoc("@param cursor to wrap\n", new Object[0]).addCode("return new " + classCursorName + "(cursor);\n", new Object[0]).build());
        this.counter = 0;
        for (ModelProperty item : entity.getCollection()) {
            item.accept(this);
        }
        TypeSpec typeSpec = this.classBuilder.build();
        JavaWriterHelper.writeJava2File(this.filer, packageName, typeSpec);
    }

    private MethodSpec.Builder generateExecuteMethod(String packageName, SQLiteEntity entity) {
        ParameterizedTypeName parameterizedReturnTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(ArrayList.class), (TypeName[])new TypeName[]{TypeUtility.className(packageName, entity.getSimpleName())});
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"execute").addJavadoc("<p>Execute the cursor and read all rows from database.</p>\n\n", new Object[0]).addJavadoc("@return list of beans\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)parameterizedReturnTypeName);
        TypeName entityClass = TypeUtility.typeName(entity.getElement());
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("$T resultList=new $T(cursor.getCount());\n", new Object[]{parameterizedReturnTypeName, parameterizedReturnTypeName});
        methodBuilder.addCode("$T resultBean=new $T();\n", new Object[]{entityClass, entityClass});
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (cursor.moveToFirst())", new Object[0]);
        methodBuilder.beginControlFlow("do\n", new Object[0]);
        methodBuilder.addCode("resultBean=new $T();\n\n", new Object[]{entityClass});
        int i = 0;
        for (ModelProperty item : entity.getCollection()) {
            methodBuilder.addCode("if (index$L>=0 && !cursor.isNull(index$L)) { ", new Object[]{i, i});
            SQLTransformer.cursor2Java(methodBuilder, entityClass, item, "resultBean", "cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            methodBuilder.addCode("}\n", new Object[0]);
            ++i;
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("resultList.add(resultBean);\n", new Object[0]);
        methodBuilder.endControlFlow("while (cursor.moveToNext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("cursor.close();\n", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("return resultList;\n", new Object[0]);
        return methodBuilder;
    }

    private MethodSpec.Builder generateExecuteListener(String packageName, SQLiteEntity entity) {
        String interfaceName = "On" + entity.getSimpleName() + "Listener";
        TypeSpec.Builder listenerInterface = TypeSpec.interfaceBuilder((String)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.methodBuilder((String)"onRow").addJavadoc("Method executed for each row extracted from database\n\n", new Object[0]).addJavadoc("@param bean loaded from database. Only selected columns/fields are valorized\n", new Object[0]).addJavadoc("@param rowPosition position of row\n", new Object[0]).addJavadoc("@param rowCount total number of rows\n", new Object[0]).addParameter(ParameterSpec.builder((TypeName)TypeUtility.typeName(entity.getElement()), (String)"bean", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Integer.TYPE, (String)"rowPosition", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Integer.TYPE, (String)"rowCount", (Modifier[])new Modifier[0]).build()).returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        ClassName interfaceType = TypeUtility.className(interfaceName);
        listenerInterface.addJavadoc("<p>Listener for row read from database.</p>\n", new Object[0]);
        TypeSpec listenerClass = listenerInterface.build();
        this.classBuilder.addType(listenerClass);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"executeListener").addJavadoc("Method executed for each row extracted from database. For each row specified listener will be invoked.\n\n", new Object[0]).addJavadoc("@param listener listener to invoke for each row\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)interfaceType, (String)"listener", (Modifier[])new Modifier[0]).build()).returns(TypeName.VOID);
        TypeName entityClass = TypeUtility.typeName(entity.getElement());
        methodBuilder.addCode("$T resultBean=new $T();\n", new Object[]{entityClass, entityClass});
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (cursor.moveToFirst())", new Object[0]);
        methodBuilder.beginControlFlow("do\n", new Object[0]);
        int i = 0;
        for (ModelProperty item : entity.getCollection()) {
            methodBuilder.addCode("if (index$L>=0) { ", new Object[]{i});
            SQLTransformer.resetBean(methodBuilder, entityClass, "resultBean", item, "cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            methodBuilder.addCode("}\n", new Object[0]);
            ++i;
        }
        methodBuilder.addCode("\n", new Object[0]);
        i = 0;
        for (ModelProperty item : entity.getCollection()) {
            methodBuilder.addCode("if (index$L>=0 && !cursor.isNull(index$L)) { ", new Object[]{i, i});
            SQLTransformer.cursor2Java(methodBuilder, entityClass, item, "resultBean", "cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            methodBuilder.addCode("}\n", new Object[0]);
            ++i;
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("listener.onRow(resultBean, cursor.getPosition(),cursor.getCount());\n", new Object[0]);
        methodBuilder.endControlFlow("while (cursor.moveToNext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("cursor.close();\n", new Object[0]);
        return methodBuilder;
    }

    @Override
    public void visit(SQLProperty property) throws Exception {
        this.classBuilder.addField(FieldSpec.builder(Integer.TYPE, (String)("index" + this.counter++), (Modifier[])new Modifier[]{Modifier.PROTECTED}).addJavadoc("Index for column $S\n", new Object[]{property.getName()}).build());
    }
}

