/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.sqlite.SQLiteDatabase;
import com.abubusoft.kripton.android.KriptonLibrary;
import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.android.sqlite.AbstractDataSource;
import com.abubusoft.kripton.android.sqlite.DataSourceOptions;
import com.abubusoft.kripton.android.sqlite.SQLContext;
import com.abubusoft.kripton.android.sqlite.SQLContextInSessionImpl;
import com.abubusoft.kripton.android.sqlite.SQLiteEvent;
import com.abubusoft.kripton.android.sqlite.SQLiteTable;
import com.abubusoft.kripton.android.sqlite.SQLiteUpdateTask;
import com.abubusoft.kripton.android.sqlite.SQLiteUpdateTaskHelper;
import com.abubusoft.kripton.android.sqlite.TransactionResult;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.KriptonOptions;
import com.abubusoft.kripton.processor.Version;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.element.GeneratedTypeElement;
import com.abubusoft.kripton.processor.exceptions.CircularRelationshipException;
import com.abubusoft.kripton.processor.sqlite.AbstractBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDaoBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDaoFactoryBuilder;
import com.abubusoft.kripton.processor.sqlite.BindTableGenerator;
import com.abubusoft.kripton.processor.sqlite.SchemaUtility;
import com.abubusoft.kripton.processor.sqlite.core.EntitySorter;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.subjects.PublishSubject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class BindDataSourceBuilder
extends AbstractBuilder {
    private static final String DATA_SOURCE_SINGLE_THREAD_NAME = "DataSourceSingleThread";
    public static final String PREFIX = "Bind";
    public static final String SUFFIX = "DataSource";

    public BindDataSourceBuilder(Elements elementUtils, Filer filer, SQLiteDatabaseSchema model) {
        super(elementUtils, filer, model);
    }

    public static void generate(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        BindDaoFactoryBuilder visitor = new BindDaoFactoryBuilder(elementUtils, filer, schema);
        visitor.buildDaoFactoryInterface(elementUtils, filer, schema);
        String daoFactoryName = BindDaoFactoryBuilder.generateDaoFactoryName(schema);
        BindDataSourceBuilder visitorDao = new BindDataSourceBuilder(elementUtils, filer, schema);
        visitorDao.buildDataSource(elementUtils, filer, schema, daoFactoryName);
        BindDataSourceBuilder.generateSchema(schema);
    }

    private static void generateSchema(SQLiteDatabaseSchema schema) throws FileNotFoundException, IOException {
        if (!schema.generateSchema) {
            return;
        }
        String schemaCreation = BindDataSourceBuilder.defineFileName(schema);
        String schemaLocation = KriptonOptions.getSchemaLocation();
        File schemaCreatePath = new File(schemaLocation).getAbsoluteFile();
        File schemaCreateFile = new File(schemaLocation, schemaCreation).getAbsoluteFile();
        schemaCreatePath.mkdirs();
        AnnotationProcessorUtilis.infoOnGeneratedFile(BindDataSource.class, schemaCreateFile);
        FileOutputStream fos = new FileOutputStream(schemaCreateFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
        bw.write("------------------------------------------------------------------------------------\n");
        bw.write("--\n");
        bw.write("-- Filename: " + schemaCreation + "\n");
        bw.write("--\n");
        bw.write(String.format("-- Date: %s", new Date().toString()) + "\n");
        bw.write("--\n");
        if (!BindDataSourceSubProcessor.JUNIT_TEST_MODE) {
            bw.write(String.format("-- This file was generated by Kripton Annotation Processor v. %s\n", Version.getVersion()));
            bw.write(String.format("--\n", new Object[0]));
        }
        bw.write("------------------------------------------------------------------------------------\n");
        bw.newLine();
        for (String sql : schema.sqlForCreate) {
            bw.write(sql);
            bw.newLine();
        }
        bw.close();
    }

    static String defineFileName(SQLiteDatabaseSchema model) {
        int lastIndex = model.fileName.lastIndexOf(".");
        String schemaName = model.fileName;
        if (lastIndex > -1) {
            schemaName = model.fileName.substring(0, lastIndex);
        }
        schemaName = schemaName.toLowerCase() + "_schema_" + model.version + ".sql";
        return schemaName;
    }

    public static ClassName generateDataSourceName(SQLiteDatabaseSchema schema) {
        String dataSourceName = schema.getName();
        dataSourceName = PREFIX + dataSourceName;
        PackageElement pkg = BaseProcessor.elementUtils.getPackageOf((Element)schema.getElement());
        String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
        return ClassName.get((String)packageName, (String)dataSourceName, (String[])new String[0]);
    }

    public void buildDataSource(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema, String daoFactoryName) throws Exception {
        String tableName;
        MethodSpec.Builder methodBuilder;
        TypeName daoImplName;
        ClassName daoFactoryClazz = TypeUtility.className(daoFactoryName);
        Converter convert = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
        ClassName dataSourceClassName = BindDataSourceBuilder.generateDataSourceName(schema);
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDataSource.class, dataSourceClassName);
        this.classBuilder = TypeSpec.classBuilder((String)dataSourceClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(AbstractDataSource.class).addSuperinterface((TypeName)daoFactoryClazz).addSuperinterface(TypeUtility.typeName(((TypeElement)schema.getElement()).asType()));
        this.classBuilder.addJavadoc("<p>\n", new Object[0]);
        this.classBuilder.addJavadoc("Implementation of the $L datasource.\n", new Object[]{schema.getName()});
        this.classBuilder.addJavadoc("This class expose database interface through Dao attribute.\n", new Object[]{schema.getName()});
        this.classBuilder.addJavadoc("</p>\n\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        this.classBuilder.addJavadoc("@see $T\n", new Object[]{TypeUtility.className(schema.getName())});
        this.classBuilder.addJavadoc("@see $T\n", new Object[]{daoFactoryClazz});
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            daoImplName = BindDaoBuilder.daoTypeName(dao);
            this.classBuilder.addJavadoc("@see $T\n", new Object[]{dao.getElement()});
            this.classBuilder.addJavadoc("@see $T\n", new Object[]{daoImplName});
            String entity = BindDataSourceSubProcessor.generateEntityName(dao, dao.getEntity());
            this.classBuilder.addJavadoc("@see $T\n", new Object[]{TypeUtility.typeName(entity)});
        }
        this.classBuilder.addField(FieldSpec.builder((TypeName)dataSourceClassName, (String)"instance", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.VOLATILE}).addJavadoc("<p>datasource singleton</p>\n", new Object[0]).build());
        this.classBuilder.addField(FieldSpec.builder(Object.class, (String)"mutex", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).addJavadoc("<p>Mutex to manage multithread access to instance</p>\n", new Object[0]).initializer("new Object()", new Object[0]).build());
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            daoImplName = BindDaoBuilder.daoTypeName(dao);
            this.classBuilder.addField(FieldSpec.builder((TypeName)daoImplName, (String)((String)convert.convert((Object)dao.getName())), (Modifier[])new Modifier[]{Modifier.PROTECTED}).addJavadoc("<p>dao instance</p>\n", new Object[0]).initializer("new $T(this)", new Object[]{daoImplName}).build());
            MethodSpec.Builder methodBuilder2 = MethodSpec.methodBuilder((String)("get" + dao.getName())).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BindDaoBuilder.daoTypeName(dao));
            methodBuilder2.addCode("return $L;\n", new Object[]{convert.convert((Object)dao.getName())});
            this.classBuilder.addMethod(methodBuilder2.build());
        }
        if (schema.generateRx) {
            this.generateRx(dataSourceClassName, daoFactoryName);
            for (SQLiteDaoDefinition dao : schema.getCollection()) {
                methodBuilder = MethodSpec.methodBuilder((String)("get" + dao.getEntitySimplyClassName() + "Subject")).addModifiers(new Modifier[]{Modifier.PUBLIC});
                methodBuilder.addStatement("return $L.getSubject()", new Object[]{CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, (String)convert.convert((Object)dao.getName()))}).returns((TypeName)ParameterizedTypeName.get(PublishSubject.class, (Type[])new Type[]{SQLiteEvent.class}));
                this.classBuilder.addMethod(methodBuilder.build());
            }
        }
        this.generateMethodExecuteTransaction(daoFactoryName);
        this.generateMethodExecuteAsyncTransaction(daoFactoryName, true);
        this.generateMethodExecuteAsyncTransaction(daoFactoryName, false);
        this.generateMethodAsyncBatch(daoFactoryName, true);
        this.generateMethodAsyncBatch(daoFactoryName, false);
        this.generateMethodExecuteBatch(daoFactoryName);
        this.generateTransactions(schema);
        this.generateInstanceOrBuild(schema, dataSourceClassName.simpleName(), true);
        this.generateOpen(dataSourceClassName.simpleName());
        this.generateOpenReadOnly(dataSourceClassName.simpleName());
        this.generateConstructor(schema);
        List<SQLiteEntity> orderedEntities = BindDataSourceBuilder.orderEntitiesList(schema);
        boolean useForeignKey = this.generateOnCreate(schema, orderedEntities);
        this.generateOnUpgrade(schema, orderedEntities);
        this.generateOnConfigure(useForeignKey);
        BindDataSourceBuilder.generateDaoUids(this.classBuilder, schema);
        methodBuilder = MethodSpec.methodBuilder((String)"clearCompiledStatements").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            methodBuilder.addStatement("$T.clearCompiledStatements()", new Object[]{TypeUtility.className(((TypeElement)dao.getElement()).getQualifiedName().toString() + "Impl")});
        }
        this.classBuilder.addMethod(methodBuilder.build());
        this.generateDataSourceSingleThread(schema, dataSourceClassName.simpleName());
        this.generateInstanceOrBuild(schema, dataSourceClassName.simpleName(), false);
        FieldSpec.Builder f = FieldSpec.builder((TypeName)ArrayTypeName.of(SQLiteTable.class), (String)"TABLES", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addJavadoc("List of tables compose datasource\n", new Object[0]);
        CodeBlock.Builder c = CodeBlock.builder();
        String s = "";
        c.add("{", new Object[0]);
        for (SQLiteEntity sQLiteEntity : schema.getEntities()) {
            tableName = BindTableGenerator.getTableClassName(sQLiteEntity.getName());
            c.add(s + "new $T()", new Object[]{TypeUtility.className(tableName)});
            s = ", ";
        }
        for (GeneratedTypeElement generatedTypeElement : schema.generatedEntities) {
            tableName = BindTableGenerator.getTableClassName(generatedTypeElement.getQualifiedName());
            c.add(s + "new $T()", new Object[]{TypeUtility.className(tableName)});
            s = ", ";
        }
        c.add("}", new Object[0]);
        f.initializer(c.build());
        this.classBuilder.addField(f.build());
        this.classBuilder.addMethod(MethodSpec.methodBuilder((String)"tables").addJavadoc("List of tables compose datasource:\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return TABLES", new Object[0]).returns((TypeName)ArrayTypeName.of(SQLiteTable.class)).build());
        TypeSpec typeSpec = this.classBuilder.build();
        JavaWriterHelper.writeJava2File(filer, dataSourceClassName.packageName(), typeSpec);
    }

    public void generateTransactions(SQLiteDatabaseSchema schema) {
        SchemaUtility.generateTransaction(this.classBuilder, schema, false);
    }

    private void generateConstructor(SQLiteDatabaseSchema schema) {
        MethodSpec.Builder methodBuilder = MethodSpec.constructorBuilder().addParameter(DataSourceOptions.class, "options", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED});
        methodBuilder.addStatement("super($S, $L, options)", new Object[]{schema.fileName, schema.version});
        this.classBuilder.addMethod(methodBuilder.build());
    }

    public static void generateDaoUids(TypeSpec.Builder classBuilder, SQLiteDatabaseSchema schema) {
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            classBuilder.addField(FieldSpec.builder(Integer.TYPE, (String)dao.daoUidName, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).initializer("" + dao.daoUidValue, new Object[0]).addJavadoc("Unique identifier for Dao $L\n", new Object[]{dao.getName()}).build());
        }
    }

    private void generateDataSourceSingleThread(SQLiteDatabaseSchema schema, String dataSourceName) {
        String daoFieldName;
        String daoFactoryName = BindDaoFactoryBuilder.generateDaoFactoryName(schema);
        TypeSpec.Builder clazzBuilder = TypeSpec.classBuilder((String)DATA_SOURCE_SINGLE_THREAD_NAME).addSuperinterface(TypeUtility.typeName(daoFactoryName));
        clazzBuilder.addField(FieldSpec.builder(SQLContextInSessionImpl.class, (String)"_context", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addStatement("_context=new $T($L.this)", new Object[]{SQLContextInSessionImpl.class, dataSourceName});
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            TypeName daoImplName = BindDaoBuilder.daoTypeName(dao);
            daoFieldName = this.extractDaoFieldNameForInternalDataSource(dao);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("get" + dao.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("\nretrieve dao $L\n", new Object[]{dao.getName()}).returns(daoImplName);
            methodBuilder.beginControlFlow("if ($L==null)", new Object[]{daoFieldName});
            methodBuilder.addStatement("$L=new $T(this)", new Object[]{daoFieldName, daoImplName});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return $L", new Object[]{daoFieldName});
            clazzBuilder.addMethod(methodBuilder.build());
            clazzBuilder.addField(FieldSpec.builder((TypeName)daoImplName, (String)daoFieldName, (Modifier[])new Modifier[]{Modifier.PROTECTED}).build());
        }
        clazzBuilder.addMethod(constructorBuilder.build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"context").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(SQLContext.class);
        methodBuilder.addAnnotation(Override.class);
        methodBuilder.addStatement("return _context", new Object[0]);
        clazzBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"onSessionOpened").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE);
        if (schema.hasLiveData()) {
            methodBuilder.addComment("support for live data", new Object[0]);
            methodBuilder.addStatement("_context.onSessionOpened()", new Object[0]);
        }
        clazzBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"onSessionClear").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE);
        if (schema.hasLiveData()) {
            methodBuilder.addComment("support for live data", new Object[0]);
            methodBuilder.addStatement("_context.onSessionOpened()", new Object[0]);
        }
        clazzBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"onSessionClosed").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE);
        if (schema.hasLiveData()) {
            methodBuilder.addComment("support for live data", new Object[0]);
            methodBuilder.addStatement("$T daosWithEvents=_context.onSessionClosed()", new Object[]{ParameterizedTypeName.get(Set.class, (Type[])new Type[]{Integer.class})});
            for (SQLiteDaoDefinition dao : schema.getCollection()) {
                daoFieldName = this.extractDaoFieldNameForInternalDataSource(dao);
                if (dao.hasLiveData()) {
                    methodBuilder.beginControlFlow("if ($L!=null && daosWithEvents.contains($L))", new Object[]{daoFieldName, dao.daoUidName});
                    methodBuilder.addStatement("$L.invalidateLiveData()", new Object[]{daoFieldName});
                    methodBuilder.endControlFlow();
                    continue;
                }
                methodBuilder.addComment("$S has no live data", new Object[]{daoFieldName});
            }
        }
        clazzBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"bindToThread").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeUtility.typeName(DATA_SOURCE_SINGLE_THREAD_NAME));
        methodBuilder.addStatement("return this", new Object[0]);
        clazzBuilder.addMethod(methodBuilder.build());
        this.classBuilder.addField(FieldSpec.builder((TypeName)TypeUtility.typeName(DATA_SOURCE_SINGLE_THREAD_NAME), (String)"_daoFactorySingleThread", (Modifier[])new Modifier[]{Modifier.PROTECTED}).addJavadoc("Used only in transactions (that can be executed one for time\n", new Object[0]).initializer("new DataSourceSingleThread()", new Object[0]).build());
        SchemaUtility.generateTransaction(clazzBuilder, schema, false);
        this.classBuilder.addType(clazzBuilder.build());
    }

    private String extractDaoFieldNameForInternalDataSource(SQLiteDaoDefinition dao) {
        return "_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, dao.getName());
    }

    private void generateInstanceOrBuild(SQLiteDatabaseSchema schema, String schemaName, boolean instance) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)(instance ? "getInstance" : "build")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeUtility.className(schemaName));
        if (!instance) {
            methodBuilder.addParameter(DataSourceOptions.class, "options", new Modifier[0]);
            methodBuilder.addJavadoc("<p>Build instance. This method can be used only one time, on the application start.</p>\n", new Object[0]);
        } else {
            methodBuilder.addJavadoc("<p>Retrieve instance.</p>\n", new Object[0]);
        }
        methodBuilder.addStatement("$T result=instance", new Object[]{TypeUtility.className(schemaName)});
        methodBuilder.beginControlFlow("if (result==null)", new Object[0]);
        methodBuilder.beginControlFlow("synchronized(mutex)", new Object[0]);
        methodBuilder.addStatement("result=instance", new Object[0]);
        methodBuilder.beginControlFlow("if (result==null)", new Object[0]);
        if (instance) {
            methodBuilder.addCode("$T options=$T.builder()", new Object[]{DataSourceOptions.class, DataSourceOptions.class});
            if (schema.configCursorFactoryClazz != null) {
                methodBuilder.addCode("\n\t.cursorFactory(new $T())", new Object[]{TypeUtility.className(schema.configCursorFactoryClazz)});
            }
            if (schema.configDatabaseErrorHandlerClazz != null) {
                methodBuilder.addCode("\n\t.errorHandler(new $T())", new Object[]{TypeUtility.className(schema.configDatabaseErrorHandlerClazz)});
            }
            if (schema.configDatabaseLifecycleHandlerClazz != null) {
                methodBuilder.addCode("\n\t.databaseLifecycleHandler(new $T())", new Object[]{TypeUtility.className(schema.configDatabaseLifecycleHandlerClazz)});
            }
            if (schema.configPopulatorClazz != null) {
                methodBuilder.addCode("\n\t.populator(new $T())", new Object[]{TypeUtility.className(schema.configPopulatorClazz)});
            }
            methodBuilder.addCode("\n\t.inMemory($L)", new Object[]{schema.configInMemory});
            methodBuilder.addCode("\n\t.log($L)", new Object[]{schema.configLogEnabled});
            if (schema.configUpdateTasks != null && schema.configUpdateTasks.size() > 0) {
                for (Pair<Integer, String> task : schema.configUpdateTasks) {
                    methodBuilder.addCode("\n\t.addUpdateTask($L, new $T())", new Object[]{task.value0, TypeUtility.className((String)task.value1)});
                }
            }
            methodBuilder.addCode("\n\t.build();\n", new Object[]{DataSourceOptions.class, DataSourceOptions.class});
        }
        methodBuilder.addStatement("instance=result=new $L(options)", new Object[]{schemaName});
        this.generatePopulate(schema, methodBuilder, instance);
        if (!instance) {
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("throw new $T($S)", new Object[]{KriptonRuntimeException.class, "Datasource " + schemaName + " is already builded"});
        }
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        if (!instance) {
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("throw new $T($S)", new Object[]{KriptonRuntimeException.class, "Datasource " + schemaName + " is already builded"});
        }
        methodBuilder.endControlFlow();
        methodBuilder.addCode("return result;\n", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generatePopulate(SQLiteDatabaseSchema schema, MethodSpec.Builder methodBuilder, boolean instance) {
        methodBuilder.beginControlFlow("try", new Object[0]);
        methodBuilder.addStatement("instance.openWritableDatabase()", new Object[0]);
        methodBuilder.addStatement("instance.close()", new Object[0]);
        if (instance && schema.configPopulatorClazz != null || !instance) {
            methodBuilder.addComment("force database DDL run", new Object[0]);
            methodBuilder.beginControlFlow("if (options.populator!=null && instance.justCreated)", new Object[0]);
            methodBuilder.addComment("run populator only a time", new Object[0]);
            methodBuilder.addStatement("instance.justCreated=false", new Object[0]);
            methodBuilder.addComment("run populator", new Object[0]);
            methodBuilder.addStatement("options.populator.execute()", new Object[0]);
            methodBuilder.endControlFlow();
        }
        methodBuilder.nextControlFlow("catch($T e)", new Object[]{Throwable.class});
        methodBuilder.addStatement("$T.error(e.getMessage())", new Object[]{Logger.class});
        methodBuilder.addStatement("e.printStackTrace()", new Object[0]);
        methodBuilder.endControlFlow();
    }

    private void generateOpen(String schemaName) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"open").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeUtility.className(schemaName));
        methodBuilder.addJavadoc("Retrieve data source instance and open it.\n", new Object[0]);
        methodBuilder.addJavadoc("@return opened dataSource instance.\n", new Object[0]);
        methodBuilder.addStatement("$L instance=getInstance()", new Object[]{schemaName});
        methodBuilder.addStatement("instance.openWritableDatabase()", new Object[0]);
        methodBuilder.addCode("return instance;\n", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generateOpenReadOnly(String schemaName) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"openReadOnly").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeUtility.className(schemaName));
        methodBuilder.addJavadoc("Retrieve data source instance and open it in read only mode.\n", new Object[0]);
        methodBuilder.addJavadoc("@return opened dataSource instance.\n", new Object[0]);
        methodBuilder.addStatement("$L instance=getInstance()", new Object[]{schemaName});
        methodBuilder.addStatement("instance.openReadOnlyDatabase()", new Object[0]);
        methodBuilder.addCode("return instance;\n", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private boolean generateOnCreate(SQLiteDatabaseSchema schema, List<SQLiteEntity> orderedEntities) {
        boolean useForeignKey = false;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onCreate").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addParameter(SQLiteDatabase.class, "database", new Modifier[0]);
        methodBuilder.addJavadoc("onCreate\n", new Object[0]);
        methodBuilder.addCode("// generate tables\n", new Object[0]);
        if (schema.isLogEnabled()) {
            methodBuilder.addComment("log section create BEGIN", new Object[0]);
            methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
            methodBuilder.beginControlFlow("if (options.inMemory)", new Object[0]);
            methodBuilder.addStatement("$T.info(\"Create database in memory\")", new Object[]{Logger.class});
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("$T.info(\"Create database '%s' version %s\",this.name, this.version)", new Object[]{Logger.class});
            methodBuilder.endControlFlow();
            methodBuilder.endControlFlow();
            methodBuilder.addComment("log section create END", new Object[0]);
        }
        for (SQLiteEntity sQLiteEntity : orderedEntities) {
            if (schema.isLogEnabled()) {
                methodBuilder.addComment("log section create BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
                methodBuilder.addStatement("$T.info(\"DDL: %s\",$T.CREATE_TABLE_SQL)", new Object[]{Logger.class, BindTableGenerator.tableClassName(null, sQLiteEntity)});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section create END", new Object[0]);
            }
            methodBuilder.addStatement("database.execSQL($T.CREATE_TABLE_SQL)", new Object[]{BindTableGenerator.tableClassName(null, sQLiteEntity)});
            if (sQLiteEntity.referedEntities.size() <= 0) continue;
            useForeignKey = true;
        }
        if (schema.generatedEntities.size() > 0) {
            useForeignKey = true;
        }
        for (GeneratedTypeElement generatedTypeElement : schema.generatedEntities) {
            if (schema.isLogEnabled()) {
                methodBuilder.addComment("log section BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
                methodBuilder.addStatement("$T.info(\"DDL: %s\",$T.CREATE_TABLE_SQL)", new Object[]{Logger.class, TypeUtility.className(BindTableGenerator.getTableClassName(generatedTypeElement.getQualifiedName()))});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section END", new Object[0]);
            }
            methodBuilder.addStatement("database.execSQL($T.CREATE_TABLE_SQL)", new Object[]{TypeUtility.className(BindTableGenerator.getTableClassName(generatedTypeElement.getQualifiedName()))});
        }
        methodBuilder.beginControlFlow("if (options.databaseLifecycleHandler != null)", new Object[0]);
        methodBuilder.addStatement("options.databaseLifecycleHandler.onCreate(database)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("justCreated=true", new Object[0]);
        this.classBuilder.addMethod(methodBuilder.build());
        return useForeignKey;
    }

    private void generateOnUpgrade(SQLiteDatabaseSchema schema, List<SQLiteEntity> orderedEntities) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onUpgrade").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addParameter(SQLiteDatabase.class, "database", new Modifier[0]);
        methodBuilder.addParameter(Integer.TYPE, "previousVersion", new Modifier[0]);
        methodBuilder.addParameter(Integer.TYPE, "currentVersion", new Modifier[0]);
        methodBuilder.addJavadoc("onUpgrade\n", new Object[0]);
        Collections.reverse(orderedEntities);
        if (schema.isLogEnabled()) {
            methodBuilder.addComment("log section BEGIN", new Object[0]);
            methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
            methodBuilder.addStatement("$T.info(\"Update database '%s' from version %s to version %s\",this.name, previousVersion, currentVersion)", new Object[]{Logger.class});
            methodBuilder.endControlFlow();
            methodBuilder.addComment("log section END", new Object[0]);
        }
        methodBuilder.addComment("if we have a list of update task, try to execute them", new Object[0]);
        methodBuilder.beginControlFlow("if (options.updateTasks != null)", new Object[0]);
        methodBuilder.addStatement("$T<$T> tasks = buildTaskList(previousVersion, currentVersion)", new Object[]{List.class, SQLiteUpdateTask.class});
        methodBuilder.beginControlFlow("for ($T task : tasks)", new Object[]{SQLiteUpdateTask.class});
        methodBuilder.addComment("log section BEGIN", new Object[0]);
        methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
        methodBuilder.addStatement("$T.info(\"Begin update database from version %s to %s\", previousVersion, previousVersion+1)", new Object[]{Logger.class});
        methodBuilder.endControlFlow();
        methodBuilder.addComment("log section END", new Object[0]);
        methodBuilder.addStatement("task.execute(database, previousVersion, previousVersion+1)", new Object[0]);
        methodBuilder.addComment("log section BEGIN", new Object[0]);
        methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
        methodBuilder.addStatement("$T.info(\"End update database from version %s to %s\", previousVersion, previousVersion+1)", new Object[]{Logger.class});
        methodBuilder.endControlFlow();
        methodBuilder.addComment("log section END", new Object[0]);
        methodBuilder.addStatement("previousVersion++", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addComment("drop all tables", new Object[0]);
        methodBuilder.addStatement("$T.dropTablesAndIndices(database)", new Object[]{SQLiteUpdateTaskHelper.class});
        Collections.reverse(orderedEntities);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("// generate tables\n", new Object[0]);
        for (SQLiteEntity sQLiteEntity : orderedEntities) {
            if (schema.isLogEnabled()) {
                methodBuilder.addComment("log section BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
                methodBuilder.addCode("$T.info(\"DDL: %s\",$T.CREATE_TABLE_SQL);\n", new Object[]{Logger.class, BindTableGenerator.tableClassName(null, sQLiteEntity)});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section END", new Object[0]);
            }
            methodBuilder.addCode("database.execSQL($T.CREATE_TABLE_SQL);\n", new Object[]{BindTableGenerator.tableClassName(null, sQLiteEntity)});
        }
        for (GeneratedTypeElement generatedTypeElement : schema.generatedEntities) {
            if (schema.isLogEnabled()) {
                methodBuilder.addComment("log section BEGIN", new Object[0]);
                methodBuilder.beginControlFlow("if (this.logEnabled)", new Object[0]);
                methodBuilder.addStatement("$T.info(\"DDL: %s\",$T.CREATE_TABLE_SQL)", new Object[]{Logger.class, TypeUtility.className(BindTableGenerator.getTableClassName(generatedTypeElement.getQualifiedName()))});
                methodBuilder.endControlFlow();
                methodBuilder.addComment("log section END", new Object[0]);
            }
            methodBuilder.addStatement("database.execSQL($T.CREATE_TABLE_SQL)", new Object[]{TypeUtility.className(BindTableGenerator.getTableClassName(generatedTypeElement.getQualifiedName()))});
        }
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("if (options.databaseLifecycleHandler != null)", new Object[0]);
        methodBuilder.addStatement("options.databaseLifecycleHandler.onUpdate(database, previousVersion, currentVersion, true)", new Object[0]);
        methodBuilder.endControlFlow();
        this.classBuilder.addMethod(methodBuilder.build());
    }

    private void generateOnConfigure(boolean useForeignKey) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onConfigure").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addParameter(SQLiteDatabase.class, "database", new Modifier[0]);
        methodBuilder.addJavadoc("onConfigure\n", new Object[0]);
        methodBuilder.addCode("// configure database\n", new Object[0]);
        if (useForeignKey) {
            methodBuilder.addStatement("database.setForeignKeyConstraintsEnabled(true)", new Object[0]);
        }
        methodBuilder.beginControlFlow("if (options.databaseLifecycleHandler != null)", new Object[0]);
        methodBuilder.addStatement("options.databaseLifecycleHandler.onConfigure(database)", new Object[0]);
        methodBuilder.endControlFlow();
        this.classBuilder.addMethod(methodBuilder.build());
    }

    public static List<SQLiteEntity> orderEntitiesList(SQLiteDatabaseSchema schema) {
        List<SQLiteEntity> entities = schema.getEntitiesAsList();
        Collections.sort(entities, new Comparator<SQLiteEntity>(){

            @Override
            public int compare(SQLiteEntity lhs, SQLiteEntity rhs) {
                return lhs.getTableName().compareTo(rhs.getTableName());
            }
        });
        List<SQLiteEntity> list = schema.getEntitiesAsList();
        EntitySorter<SQLiteEntity> sorder = new EntitySorter<SQLiteEntity>(list){

            @Override
            public Collection<SQLiteEntity> getDependencies(SQLiteEntity item) {
                return item.referedEntities;
            }

            @Override
            public void generateError(SQLiteEntity item) {
                throw new CircularRelationshipException(item);
            }
        };
        return sorder.order();
    }

    public void generatExecuteTransactionRx(ClassName dataSourceName, String daoFactory, RxType rxType) {
        String parameterName = "transaction";
        ParameterizedTypeName returnTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(rxType.clazz), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        ParameterizedTypeName observableTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(rxType.clazz.getPackage().getName(), rxType.clazz.getSimpleName() + "OnSubscribe"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        ParameterizedTypeName emitterTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(rxType.clazz.getPackage().getName(), rxType.clazz.getSimpleName() + "Emitter"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        TypeSpec innerEmitter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)observableTypeName).addMethod(MethodSpec.methodBuilder((String)"subscribe").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)emitterTypeName, "emitter", new Modifier[0]).returns(Void.TYPE).addStatement("boolean needToOpened=!$L.this.isOpenInWriteMode()", new Object[]{dataSourceName.simpleName()}).addStatement("boolean success=false", new Object[0]).addCode("@SuppressWarnings(\"resource\")\n", new Object[0]).addStatement("$T connection=needToOpened ? openWritableDatabase() : database()", new Object[]{SQLiteDatabase.class}).addStatement("$L currentDaoFactory=_daoFactorySingleThread.bindToThread()", new Object[]{DATA_SOURCE_SINGLE_THREAD_NAME}).addStatement("currentDaoFactory.onSessionOpened()", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("connection.beginTransaction()", new Object[0]).beginControlFlow("if (transaction != null && $T.$L==transaction.onExecute(currentDaoFactory, emitter))", new Object[]{TransactionResult.class, TransactionResult.COMMIT}).addStatement("connection.setTransactionSuccessful()", new Object[0]).addStatement("success=true", new Object[0]).endControlFlow().addStatement(rxType.onComplete ? "emitter.onComplete()" : "// no onComplete", new Object[0]).nextControlFlow("catch($T e)", new Object[]{Throwable.class}).addStatement("$T.error(e.getMessage())", new Object[]{Logger.class}).addStatement("e.printStackTrace()", new Object[0]).addStatement("emitter.onError(e)", new Object[0]).addStatement("currentDaoFactory.onSessionClear()", new Object[0]).nextControlFlow("finally", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("connection.endTransaction()", new Object[0]).nextControlFlow("catch($T e)", new Object[]{Throwable.class}).endControlFlow().addCode("if (needToOpened) { close(); }\n", new Object[0]).addCode("if (success) { currentDaoFactory.onSessionClosed(); } else { currentDaoFactory.onSessionClear(); }\n", new Object[0]).endControlFlow().addStatement("return", new Object[0]).build()).build();
        MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).addParameter((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(dataSourceName.toString(), rxType.clazz.getSimpleName() + "Transaction"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), parameterName, new Modifier[]{Modifier.FINAL}).returns((TypeName)returnTypeName);
        executeMethod.addStatement("$T emitter=$L", new Object[]{observableTypeName, innerEmitter});
        if (rxType == RxType.FLOWABLE) {
            executeMethod.addStatement("$T result=$T.create(emitter, $T.BUFFER)", new Object[]{returnTypeName, rxType.clazz, BackpressureStrategy.class});
        } else {
            executeMethod.addStatement("$T result=$T.create(emitter)", new Object[]{returnTypeName, rxType.clazz});
        }
        executeMethod.addStatement("if (globalSubscribeOn!=null) result.subscribeOn(globalSubscribeOn)", new Object[0]);
        executeMethod.addStatement("if (globalObserveOn!=null) result.observeOn(globalObserveOn)", new Object[0]);
        executeMethod.addStatement("return result", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
    }

    public void generatExecuteBatchRx(ClassName dataSourceName, String daoFactory, RxType rxType) {
        String parameterName = "batch";
        ParameterizedTypeName returnTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(rxType.clazz), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        ParameterizedTypeName observableTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(rxType.clazz.getPackage().getName(), rxType.clazz.getSimpleName() + "OnSubscribe"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        ParameterizedTypeName emitterTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(rxType.clazz.getPackage().getName(), rxType.clazz.getSimpleName() + "Emitter"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        TypeSpec innerEmitter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)observableTypeName).addMethod(MethodSpec.methodBuilder((String)"subscribe").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)emitterTypeName, "emitter", new Modifier[0]).returns(Void.TYPE).addStatement("boolean needToOpened=writeMode?!$L.this.isOpenInWriteMode(): !$L.this.isOpen()", new Object[]{dataSourceName.simpleName(), dataSourceName.simpleName()}).addCode("if (needToOpened) { if (writeMode) { openWritableDatabase(); } else { openReadOnlyDatabase(); }}\n", new Object[]{SQLiteDatabase.class}).addStatement("$L currentDaoFactory=new DataSourceSingleThread()", new Object[]{DATA_SOURCE_SINGLE_THREAD_NAME}).addStatement("currentDaoFactory.onSessionOpened()", new Object[0]).beginControlFlow("try", new Object[0]).addCode("if ($L != null) { $L.onExecute(currentDaoFactory, emitter); }\n", new Object[]{parameterName, parameterName}).addStatement(rxType.onComplete ? "emitter.onComplete()" : "// no onComplete", new Object[0]).nextControlFlow("catch($T e)", new Object[]{Throwable.class}).addStatement("$T.error(e.getMessage())", new Object[]{Logger.class}).addStatement("e.printStackTrace()", new Object[0]).addStatement("emitter.onError(e)", new Object[0]).nextControlFlow("finally", new Object[0]).addCode("if (needToOpened) { close(); }\n", new Object[0]).addStatement("currentDaoFactory.onSessionClosed()", new Object[0]).endControlFlow().addStatement("return", new Object[0]).build()).build();
        MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"executeBatch").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).addParameter((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(dataSourceName.toString(), rxType.clazz.getSimpleName() + "Batch"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), parameterName, new Modifier[]{Modifier.FINAL}).addParameter(TypeName.BOOLEAN, "writeMode", new Modifier[]{Modifier.FINAL}).returns((TypeName)returnTypeName);
        executeMethod.addStatement("$T emitter=$L", new Object[]{observableTypeName, innerEmitter});
        if (rxType == RxType.FLOWABLE) {
            executeMethod.addStatement("$T result=$T.create(emitter, $T.BUFFER)", new Object[]{returnTypeName, rxType.clazz, BackpressureStrategy.class});
        } else {
            executeMethod.addStatement("$T result=$T.create(emitter)", new Object[]{returnTypeName, rxType.clazz});
        }
        executeMethod.addStatement("if (globalSubscribeOn!=null) result.subscribeOn(globalSubscribeOn)", new Object[0]);
        executeMethod.addStatement("if (globalObserveOn!=null) result.observeOn(globalObserveOn)", new Object[0]);
        executeMethod.addStatement("return result", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
        executeMethod = MethodSpec.methodBuilder((String)"executeBatch").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).addParameter((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(dataSourceName.toString(), rxType.clazz.getSimpleName() + "Batch"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), parameterName, new Modifier[]{Modifier.FINAL}).returns((TypeName)returnTypeName);
        executeMethod.addStatement("return executeBatch($L, false)", new Object[]{parameterName});
        this.classBuilder.addMethod(executeMethod.build());
    }

    public void generateRx(ClassName dataSourceName, String daoFactory) {
        this.classBuilder.addField(FieldSpec.builder(Scheduler.class, (String)"globalSubscribeOn", (Modifier[])new Modifier[]{Modifier.PROTECTED}).build());
        this.classBuilder.addMethod(MethodSpec.methodBuilder((String)"globalSubscribeOn").returns((TypeName)dataSourceName).addParameter(Scheduler.class, "scheduler", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.globalSubscribeOn=scheduler", new Object[0]).addStatement("return this", new Object[0]).build());
        this.classBuilder.addField(FieldSpec.builder(Scheduler.class, (String)"globalObserveOn", (Modifier[])new Modifier[]{Modifier.PROTECTED}).build());
        this.classBuilder.addMethod(MethodSpec.methodBuilder((String)"globalObserveOn").addParameter(Scheduler.class, "scheduler", new Modifier[0]).returns((TypeName)dataSourceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.globalObserveOn=scheduler", new Object[0]).addStatement("return this", new Object[0]).build());
        this.generateRxInterface(daoFactory, RxInterfaceType.BATCH, ObservableEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.TRANSACTION, ObservableEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.BATCH, SingleEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.TRANSACTION, SingleEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.BATCH, FlowableEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.TRANSACTION, FlowableEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.BATCH, MaybeEmitter.class);
        this.generateRxInterface(daoFactory, RxInterfaceType.TRANSACTION, MaybeEmitter.class);
        this.generatExecuteTransactionRx(dataSourceName, daoFactory, RxType.OBSERVABLE);
        this.generatExecuteTransactionRx(dataSourceName, daoFactory, RxType.SINGLE);
        this.generatExecuteTransactionRx(dataSourceName, daoFactory, RxType.FLOWABLE);
        this.generatExecuteTransactionRx(dataSourceName, daoFactory, RxType.MAYBE);
        this.generatExecuteBatchRx(dataSourceName, daoFactory, RxType.OBSERVABLE);
        this.generatExecuteBatchRx(dataSourceName, daoFactory, RxType.SINGLE);
        this.generatExecuteBatchRx(dataSourceName, daoFactory, RxType.FLOWABLE);
        this.generatExecuteBatchRx(dataSourceName, daoFactory, RxType.MAYBE);
    }

    private void generateRxInterface(String daoFactory, RxInterfaceType interfaceType, Class<?> clazz) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(clazz), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        String preExecutorName = clazz.getSimpleName().replace("Emitter", "");
        String postExecutorName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, interfaceType.toString());
        if (interfaceType == RxInterfaceType.BATCH) {
            this.classBuilder.addType(TypeSpec.interfaceBuilder((String)(preExecutorName + postExecutorName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).addMethod(MethodSpec.methodBuilder((String)"onExecute").addParameter((TypeName)TypeUtility.className(daoFactory), "daoFactory", new Modifier[0]).addParameter((TypeName)parameterizedTypeName, "emitter", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Void.TYPE).build()).build());
        } else {
            this.classBuilder.addType(TypeSpec.interfaceBuilder((String)(preExecutorName + postExecutorName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).addMethod(MethodSpec.methodBuilder((String)"onExecute").addParameter((TypeName)TypeUtility.className(daoFactory), "daoFactory", new Modifier[0]).addParameter((TypeName)parameterizedTypeName, "emitter", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(TransactionResult.class).build()).build());
        }
    }

    private void generateMethodAsyncBatch(String daoFactory, boolean withErrorListener) {
        String transationExecutorName = "Batch";
        MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"executeBatchAsync").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Future.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addParameter((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(transationExecutorName), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "commands", new Modifier[]{Modifier.FINAL});
        if (withErrorListener) {
            executeMethod.addParameter(Boolean.TYPE, "writeMode", new Modifier[]{Modifier.FINAL});
        }
        ParameterizedTypeName futureType = ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        TypeSpec innerBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)futureType).addMethod(MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeVariableName.get((String)"T")).addException(Exception.class).addStatement(withErrorListener ? "return executeBatch(commands, writeMode)" : "return executeBatch(commands, false)", new Object[0]).build()).build();
        executeMethod.addStatement("return $T.getExecutorService().submit($L)", new Object[]{KriptonLibrary.class, innerBuilder});
        executeMethod.addJavadoc("<p>Executes a batch command in async mode. This method <strong>is thread safe</strong> to avoid concurrent problems. The drawback is only one transaction at time can be executed. The database will be open in write mode. This method uses default error listener to intercept errors.</p>\n", new Object[0]);
        executeMethod.addJavadoc("\n", new Object[0]);
        executeMethod.addJavadoc("@param commands\n\tcommands to execute\n", new Object[0]);
        if (withErrorListener) {
            executeMethod.addJavadoc("@param writeMode\n\true if you need to writeable connection\n", new Object[0]);
        }
        executeMethod.addJavadoc("@return <code>true</code> when transaction successful finished\n", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
    }

    private void generateMethodExecuteAsyncTransaction(String daoFactory, boolean withErrorListener) {
        String transationExecutorName = "Transaction";
        MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"executeAsync").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(Future.class, (Type[])new Type[]{Boolean.class})).addParameter((TypeName)TypeUtility.className(transationExecutorName), "transaction", new Modifier[]{Modifier.FINAL});
        if (withErrorListener) {
            executeMethod.addParameter(AbstractDataSource.OnErrorListener.class, "onErrorListener", new Modifier[]{Modifier.FINAL});
        }
        ParameterizedTypeName futureType = ParameterizedTypeName.get(Callable.class, (Type[])new Type[]{Boolean.class});
        TypeSpec innerBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)futureType).addMethod(MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.class).addException(Exception.class).addStatement("return execute(transaction, onErrorListener)", new Object[0]).build()).build();
        executeMethod.addStatement("return $T.getExecutorService().submit($L)", new Object[]{KriptonLibrary.class, innerBuilder});
        executeMethod.addJavadoc("<p>Executes a transaction in async mode. This method <strong>is thread safe</strong> to avoid concurrent problems. The drawback is only one transaction at time can be executed. The database will be open in write mode. This method uses default error listener to intercept errors.</p>\n", new Object[0]);
        executeMethod.addJavadoc("\n", new Object[0]);
        executeMethod.addJavadoc("@param transaction\n\ttransaction to execute\n", new Object[0]);
        if (withErrorListener) {
            executeMethod.addJavadoc("@param onErrorListener\n\tlistener for errors\n", new Object[0]);
        }
        executeMethod.addJavadoc("@return <code>true</code> when transaction successful finished\n", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
    }

    public void generateMethodExecuteTransaction(String daoFactory) {
        String transationExecutorName = "Transaction";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(AbstractDataSource.AbstractExecutable.class), (TypeName[])new TypeName[]{TypeUtility.className(daoFactory)});
        this.classBuilder.addType(TypeSpec.interfaceBuilder((String)transationExecutorName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)parameterizedTypeName).addJavadoc("Rapresents transational operation.\n", new Object[0]).addMethod(MethodSpec.methodBuilder((String)"onExecute").addParameter((TypeName)TypeUtility.className(daoFactory), "daoFactory", new Modifier[0]).addJavadoc("Execute transation. Method need to return {@link TransactionResult#COMMIT} to commit results\nor {@link TransactionResult#ROLLBACK} to rollback.", new Object[0]).addJavadoc("\nIf exception is thrown, a rollback will be done.", new Object[0]).addJavadoc("\n\n@param daoFactory\n@return\n@throws Throwable\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(TransactionResult.class).build()).build());
        MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter((TypeName)TypeUtility.className(transationExecutorName), "transaction", new Modifier[0]);
        executeMethod.addJavadoc("<p>Executes a transaction. This method <strong>is thread safe</strong> to avoid concurrent problems. The drawback is only one transaction at time can be executed. The database will be open in write mode. This method uses default error listener to intercept errors.</p>\n", new Object[0]);
        executeMethod.addJavadoc("\n", new Object[0]);
        executeMethod.addJavadoc("@param transaction\n\ttransaction to execute\n", new Object[0]);
        executeMethod.addJavadoc("@return <code>true</code> if transaction successful finished\n", new Object[0]);
        executeMethod.addStatement("return execute(transaction, onErrorListener)", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
        executeMethod = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeUtility.className(transationExecutorName), "transaction", new Modifier[0]).returns(Boolean.TYPE).addParameter((TypeName)TypeUtility.className(AbstractDataSource.OnErrorListener.class), "onErrorListener", new Modifier[0]);
        executeMethod.addStatement("boolean needToOpened=!this.isOpenInWriteMode()", new Object[0]);
        executeMethod.addStatement("boolean success=false", new Object[0]);
        executeMethod.addCode("@SuppressWarnings(\"resource\")\n", new Object[0]);
        executeMethod.addStatement("$T connection=needToOpened ? openWritableDatabase() : database()", new Object[]{SQLiteDatabase.class});
        executeMethod.addStatement("$L currentDaoFactory=_daoFactorySingleThread.bindToThread()", new Object[]{DATA_SOURCE_SINGLE_THREAD_NAME});
        executeMethod.addStatement("currentDaoFactory.onSessionOpened()", new Object[0]);
        executeMethod.beginControlFlow("try", new Object[0]);
        executeMethod.addCode("connection.beginTransaction();\n", new Object[0]);
        executeMethod.beginControlFlow("if (transaction!=null && $T.$L == transaction.onExecute(currentDaoFactory))", new Object[]{TransactionResult.class, TransactionResult.COMMIT});
        executeMethod.addStatement("connection.setTransactionSuccessful()", new Object[0]);
        executeMethod.addStatement("success=true", new Object[0]);
        executeMethod.endControlFlow();
        executeMethod.nextControlFlow("catch($T e)", new Object[]{Throwable.class});
        executeMethod.addStatement("$T.error(e.getMessage())", new Object[]{Logger.class});
        executeMethod.addStatement("e.printStackTrace()", new Object[0]);
        executeMethod.addStatement("if (onErrorListener!=null) onErrorListener.onError(e)", new Object[0]);
        executeMethod.nextControlFlow("finally", new Object[0]);
        executeMethod.beginControlFlow("try", new Object[0]);
        executeMethod.addStatement("connection.endTransaction()", new Object[0]);
        executeMethod.nextControlFlow("catch ($T e)", new Object[]{Throwable.class});
        executeMethod.addStatement("$T.warn(\"error closing transaction %s\", e.getMessage())", new Object[]{Logger.class});
        executeMethod.endControlFlow();
        executeMethod.addCode("if (needToOpened) { close(); }\n", new Object[0]);
        executeMethod.addCode("if (success) { currentDaoFactory.onSessionClosed(); } else { currentDaoFactory.onSessionClear(); }\n", new Object[0]);
        executeMethod.endControlFlow();
        executeMethod.addStatement("return success", new Object[0]);
        executeMethod.addJavadoc("<p>Executes a transaction. This method <strong>is thread safe</strong> to avoid concurrent problems. The drawback is only one transaction at time can be executed. The database will be open in write mode.</p>\n", new Object[0]);
        executeMethod.addJavadoc("\n", new Object[0]);
        executeMethod.addJavadoc("@param transaction\n\ttransaction to execute\n", new Object[0]);
        executeMethod.addJavadoc("@param onErrorListener\n\terror listener\n", new Object[0]);
        executeMethod.addJavadoc("@return <code>true</code> if transaction successful finished\n", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
    }

    public void generateMethodExecuteBatch(String daoFactory) {
        String transationExecutorName = "Batch";
        this.classBuilder.addType(TypeSpec.interfaceBuilder((String)transationExecutorName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).addJavadoc("Rapresents batch operation.\n", new Object[0]).addMethod(MethodSpec.methodBuilder((String)"onExecute").addJavadoc("Execute batch operations.", new Object[0]).addJavadoc("\n\n@param daoFactory\n@throws Throwable\n", new Object[0]).addParameter((TypeName)TypeUtility.className(daoFactory), "daoFactory", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"T")).build()).build());
        MethodSpec.Builder executeMethod = MethodSpec.methodBuilder((String)"executeBatch").addTypeVariable(TypeVariableName.get((String)"T")).addJavadoc("<p>Executes a batch opening a read only connection. This method <strong>is thread safe</strong> to avoid concurrent problems.</p>\n\n", new Object[0]).addJavadoc("@param commands\n\tbatch to execute\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(transationExecutorName), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "commands", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"T"));
        executeMethod.addStatement("return executeBatch(commands, false)", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
        executeMethod = MethodSpec.methodBuilder((String)"executeBatch").addJavadoc("<p>Executes a batch. This method <strong>is thread safe</strong> to avoid concurrent problems. The drawback is only one transaction at time can be executed. if <code>writeMode</code> is set to false, multiple batch operations is allowed.</p>\n", new Object[0]).addTypeVariable(TypeVariableName.get((String)"T")).addJavadoc("\n", new Object[0]).addJavadoc("@param commands\n\tbatch to execute\n", new Object[0]).addJavadoc("@param writeMode\n\ttrue to open connection in write mode, false to open connection in read only mode\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(transationExecutorName), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "commands", new Modifier[0]).addParameter(Boolean.TYPE, "writeMode", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"T"));
        executeMethod.addStatement("boolean needToOpened=writeMode?!this.isOpenInWriteMode(): !this.isOpen()", new Object[0]);
        executeMethod.addCode("if (needToOpened) { if (writeMode) { openWritableDatabase(); } else { openReadOnlyDatabase(); }}\n", new Object[]{SQLiteDatabase.class});
        executeMethod.addStatement("$L currentDaoFactory=new DataSourceSingleThread()", new Object[]{DATA_SOURCE_SINGLE_THREAD_NAME});
        executeMethod.addStatement("currentDaoFactory.onSessionOpened()", new Object[0]);
        executeMethod.beginControlFlow("try", new Object[0]);
        executeMethod.beginControlFlow("if (commands!=null)", new Object[0]);
        executeMethod.addStatement("return commands.onExecute(currentDaoFactory)", new Object[0]);
        executeMethod.endControlFlow();
        executeMethod.nextControlFlow("catch($T e)", new Object[]{Throwable.class});
        executeMethod.addStatement("$T.error(e.getMessage())", new Object[]{Logger.class});
        executeMethod.addStatement("e.printStackTrace()", new Object[0]);
        executeMethod.addStatement("throw(e)", new Object[0]);
        executeMethod.nextControlFlow("finally", new Object[0]);
        executeMethod.addCode("if (needToOpened) { close(); }\n", new Object[0]);
        executeMethod.addStatement("currentDaoFactory.onSessionClosed()", new Object[0]);
        executeMethod.endControlFlow();
        executeMethod.addStatement("return null", new Object[0]);
        this.classBuilder.addMethod(executeMethod.build());
    }

    private static enum RxType {
        OBSERVABLE(Observable.class, true),
        SINGLE(Single.class, false),
        MAYBE(Maybe.class, false),
        FLOWABLE(Flowable.class, true);

        public Class<?> clazz;
        public boolean onComplete;

        private RxType(Class<?> clazz, boolean onComplete) {
            this.clazz = clazz;
            this.onComplete = onComplete;
        }
    }

    private static enum RxInterfaceType {
        BATCH,
        TRANSACTION;

    }
}

