/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindDao;
import com.abubusoft.kripton.android.annotation.BindDaoMany2Many;
import com.abubusoft.kripton.android.annotation.BindGeneratedDao;
import com.abubusoft.kripton.android.annotation.BindSqlColumn;
import com.abubusoft.kripton.android.annotation.BindSqlDelete;
import com.abubusoft.kripton.android.annotation.BindSqlInsert;
import com.abubusoft.kripton.android.annotation.BindSqlParam;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.annotation.BindSqlType;
import com.abubusoft.kripton.android.sqlite.ForeignKeyAction;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.bind.model.many2many.M2MEntity;
import com.abubusoft.kripton.processor.bind.model.many2many.M2MModel;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.element.GeneratedTypeElement;
import com.abubusoft.kripton.processor.sqlite.AbstractBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class BindM2MBuilder
extends AbstractBuilder {
    public static final String PREFIX = "Bind";
    public static final String SUFFIX = "Cursor";
    private static Set<GeneratedTypeElement> entityResult = new HashSet<GeneratedTypeElement>();
    private static Set<GeneratedTypeElement> daoResult = new HashSet<GeneratedTypeElement>();

    public static TypeName findPrimaryKeyFieldType(String entityFullName) {
        TypeElement typeElement;
        TypeElement element = BaseProcessor.elementUtils.getTypeElement(entityFullName);
        List<? extends Element> list = BaseProcessor.elementUtils.getAllMembers(element);
        Element idField = null;
        for (Element element2 : list) {
            if (element2.getKind() != ElementKind.FIELD) continue;
            String enumValue = AnnotationUtility.extractAsEnumerationValue(element2, BindSqlColumn.class, AnnotationAttributeType.COLUMN_TYPE);
            if (StringUtils.hasText((String)enumValue) && (ColumnType.valueOf((String)enumValue) == ColumnType.PRIMARY_KEY || ColumnType.valueOf((String)enumValue) == ColumnType.PRIMARY_KEY_UNMANGED)) {
                return TypeUtility.typeName(element2);
            }
            if (!element2.getSimpleName().toString().equals("id")) continue;
            idField = element2;
        }
        if (idField != null) {
            return TypeUtility.typeName(idField.asType());
        }
        String parentClassName = element.getSuperclass().toString();
        if (parentClassName != null && !Object.class.getCanonicalName().equals(parentClassName) && (typeElement = BaseProcessor.elementUtils.getTypeElement(parentClassName)) != null) {
            return BindM2MBuilder.findPrimaryKeyFieldType(parentClassName);
        }
        return null;
    }

    public BindM2MBuilder(Filer filer) {
        super(BaseProcessor.elementUtils, filer, null);
    }

    public static Pair<Set<GeneratedTypeElement>, Set<GeneratedTypeElement>> generate(Filer filer, M2MModel model) {
        entityResult.clear();
        daoResult.clear();
        BindM2MBuilder visitor = new BindM2MBuilder(filer);
        for (M2MEntity item : model.getEntities()) {
            visitor.generate(item);
        }
        Pair result = new Pair();
        result.value0 = entityResult;
        result.value1 = daoResult;
        return result;
    }

    public void generate(M2MEntity entity) {
        this.generateEntity(entity);
        this.generateDaoPart(entity);
    }

    private void generateDaoPart(M2MEntity entity) {
        String daoClassName = entity.daoName.simpleName();
        String daoPackageName = entity.daoName.packageName();
        String entityPackageName = entity.getPackageName();
        String generatedDaoClassName = "Generated" + daoClassName;
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDaoMany2Many.class, daoPackageName, generatedDaoClassName);
        this.classBuilder = TypeSpec.interfaceBuilder((String)generatedDaoClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(BindDao.class).addMember("value", "$T.class", new Object[]{TypeUtility.className(entityPackageName, entity.name)}).build()).addAnnotation(AnnotationSpec.builder(BindGeneratedDao.class).addMember("dao", "$T.class", new Object[]{entity.daoName}).build()).addAnnotation(AnnotationSpec.builder(BindDaoMany2Many.class).addMember("entity1", "$T.class", new Object[]{entity.entity1Name}).addMember("entity2", "$T.class", new Object[]{entity.entity2Name}).build()).addSuperinterface((TypeName)entity.daoName);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        if (entity.generateMethods) {
            this.generateSelects(entity, entityPackageName);
            this.generateDeletes(entity, entityPackageName);
            this.generateInsert(entity, entityPackageName);
        }
        TypeSpec typeSpec = this.classBuilder.build();
        try {
            JavaWriterHelper.writeJava2File(this.filer, daoPackageName, typeSpec);
        }
        catch (IOException e) {
            throw new KriptonRuntimeException((Throwable)e);
        }
        GeneratedTypeElement daoPartElement = new GeneratedTypeElement(daoPackageName, this.classBuilder.build(), null, null);
        daoResult.add(daoPartElement);
    }

    private void generateSelects(M2MEntity entity, String packageName) {
        MethodSpec methodSpec;
        String idPart = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, entity.idName);
        String methodName = "";
        String workId = "";
        methodName = "selectBy" + idPart;
        if (!this.isMethodAlreadyDefined(entity, methodName)) {
            methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlSelect.class).addMember("where", "$S", new Object[]{entity.idName + "=" + SqlAnalyzer.PARAM_PREFIX + entity.idName + SqlAnalyzer.PARAM_SUFFIX}).build()).addParameter(ParameterSpec.builder((TypeName)entity.propertyPrimaryKey, (String)entity.idName, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{entity.idName}).build()).build()).returns((TypeName)TypeUtility.className(packageName, entity.name)).build();
            this.classBuilder.addMethod(methodSpec);
        }
        methodName = entity.entity1Name.simpleName() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, entity.idName);
        workId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName);
        methodName = "selectBy" + methodName;
        if (!this.isMethodAlreadyDefined(entity, methodName)) {
            methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlSelect.class).addMember("where", "$S", new Object[]{workId + "=" + SqlAnalyzer.PARAM_PREFIX + workId + SqlAnalyzer.PARAM_SUFFIX}).build()).addParameter(ParameterSpec.builder((TypeName)entity.propertyKey1, (String)workId, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{workId}).build()).build()).returns(TypeUtility.parameterizedTypeName(TypeUtility.className(List.class), (TypeName)TypeUtility.className(packageName, entity.name))).build();
            this.classBuilder.addMethod(methodSpec);
        }
        methodName = entity.entity2Name.simpleName() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, entity.idName);
        workId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName);
        methodName = "selectBy" + methodName;
        if (!this.isMethodAlreadyDefined(entity, methodName)) {
            methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlSelect.class).addMember("where", "$S", new Object[]{workId + "=" + SqlAnalyzer.PARAM_PREFIX + workId + SqlAnalyzer.PARAM_SUFFIX}).build()).addParameter(ParameterSpec.builder((TypeName)entity.propertyKey2, (String)workId, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{workId}).build()).build()).returns(TypeUtility.parameterizedTypeName(TypeUtility.className(List.class), (TypeName)TypeUtility.className(packageName, entity.name))).build();
            this.classBuilder.addMethod(methodSpec);
        }
    }

    private boolean isMethodAlreadyDefined(M2MEntity entity, final String methodName) {
        final One found = new One((Object)false);
        SqlBuilderHelper.forEachMethods(entity.daoElement, new AnnotationUtility.MethodFoundListener(){

            @Override
            public void onMethod(ExecutableElement executableMethod) {
                if (executableMethod.getSimpleName().toString().equals(methodName)) {
                    found.value0 = true;
                }
            }
        });
        return (Boolean)found.value0;
    }

    private void generateDeletes(M2MEntity entity, String packageName) {
        MethodSpec methodSpec;
        String idPart = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, entity.idName);
        String methodName = "";
        String workId = "";
        methodName = "deleteBy" + idPart;
        if (!this.isMethodAlreadyDefined(entity, methodName)) {
            methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlDelete.class).addMember("where", "$S", new Object[]{entity.idName + "=" + SqlAnalyzer.PARAM_PREFIX + entity.idName + SqlAnalyzer.PARAM_SUFFIX}).build()).addParameter(ParameterSpec.builder((TypeName)entity.propertyPrimaryKey, (String)entity.idName, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{entity.idName}).build()).build()).returns(Integer.TYPE).build();
            this.classBuilder.addMethod(methodSpec);
        }
        methodName = entity.entity1Name.simpleName() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, entity.idName);
        workId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName);
        methodName = "deleteBy" + methodName;
        if (!this.isMethodAlreadyDefined(entity, methodName)) {
            methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlDelete.class).addMember("where", "$S", new Object[]{workId + "=" + SqlAnalyzer.PARAM_PREFIX + workId + SqlAnalyzer.PARAM_SUFFIX}).build()).addParameter(ParameterSpec.builder((TypeName)entity.propertyKey1, (String)workId, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{workId}).build()).build()).returns(Integer.TYPE).build();
            this.classBuilder.addMethod(methodSpec);
        }
        methodName = entity.entity2Name.simpleName() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, entity.idName);
        workId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName);
        methodName = "deleteBy" + methodName;
        if (!this.isMethodAlreadyDefined(entity, methodName)) {
            methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlDelete.class).addMember("where", "$S", new Object[]{workId + "=" + SqlAnalyzer.PARAM_PREFIX + workId + SqlAnalyzer.PARAM_SUFFIX}).build()).addParameter(ParameterSpec.builder((TypeName)entity.propertyKey2, (String)workId, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{workId}).build()).build()).returns(Integer.TYPE).build();
            this.classBuilder.addMethod(methodSpec);
        }
    }

    private void generateInsert(M2MEntity entity, String packageName) {
        if (!this.isMethodAlreadyDefined(entity, "insert")) {
            MethodSpec methodSpec = MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(BindSqlInsert.class).build()).addParameter(ParameterSpec.builder((TypeName)TypeUtility.className(packageName, entity.name), (String)"bean", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(BindSqlParam.class).addMember("value", "$S", new Object[]{"bean"}).build()).build()).returns(Integer.TYPE).build();
            this.classBuilder.addMethod(methodSpec);
        }
    }

    private void generateEntity(M2MEntity entity) {
        entity.propertyPrimaryKey = TypeName.LONG;
        entity.propertyKey1 = BindM2MBuilder.findPrimaryKeyFieldType(entity.entity1Name.toString());
        entity.propertyKey2 = BindM2MBuilder.findPrimaryKeyFieldType(entity.entity2Name.toString());
        if (!entity.needToCreate) {
            return;
        }
        String tableName = entity.tableName;
        String entityClassName = entity.name;
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDaoMany2Many.class, entity.getPackageName(), entityClassName);
        Converter converterFK = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        Converter converterFieldName = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
        Converter converterField2ColumnName = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
        String fkPrefix = (String)converterFK.convert((Object)entity.idName);
        String fk1Name = (String)converterField2ColumnName.convert((Object)(entity.entity1Name.simpleName() + fkPrefix));
        String fk2Name = (String)converterField2ColumnName.convert((Object)(entity.entity2Name.simpleName() + fkPrefix));
        String field1Name = (String)converterFieldName.convert((Object)(entity.entity1Name.simpleName() + fkPrefix));
        String field2Name = (String)converterFieldName.convert((Object)(entity.entity2Name.simpleName() + fkPrefix));
        ArrayList<SQLProperty> properties = new ArrayList<SQLProperty>();
        SQLProperty property = new SQLProperty(entity.idName, (TypeName)entity.getClassName(), entity.propertyPrimaryKey);
        property.columnType = ColumnType.PRIMARY_KEY;
        property.columnName = entity.idName;
        property.setNullable(false);
        property.setPrimaryKey(true);
        property.foreignParentClassName = null;
        properties.add(property);
        property = new SQLProperty(field1Name, (TypeName)entity.getClassName(), entity.propertyKey1);
        property.columnType = ColumnType.INDEXED;
        property.columnName = fk1Name;
        property.setNullable(false);
        property.setPrimaryKey(false);
        property.onDeleteAction = ForeignKeyAction.CASCADE;
        property.foreignParentClassName = entity.entity1Name.toString();
        properties.add(property);
        property = new SQLProperty(field2Name, (TypeName)entity.getClassName(), entity.propertyKey2);
        property.columnType = ColumnType.INDEXED;
        property.columnName = fk2Name;
        property.setNullable(false);
        property.setPrimaryKey(false);
        property.onDeleteAction = ForeignKeyAction.CASCADE;
        property.foreignParentClassName = entity.entity2Name.toString();
        properties.add(property);
        this.classBuilder = TypeSpec.classBuilder((String)entityClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(BindSqlType.class).addMember("name", "$S", new Object[]{tableName}).build());
        if (entity.immutable) {
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            for (SQLProperty p : properties) {
                constructorBuilder.addParameter(ParameterSpec.builder((TypeName)p.getPropertyType().getTypeName(), (String)p.getName(), (Modifier[])new Modifier[0]).build());
                constructorBuilder.addStatement("this.$L=$L", new Object[]{p.getName(), p.getName()});
            }
            this.classBuilder.addMethod(constructorBuilder.build());
        }
        Modifier fieldModifier = entity.immutable ? Modifier.PRIVATE : Modifier.PUBLIC;
        this.classBuilder.addJavadoc("<p>", new Object[0]);
        this.classBuilder.addJavadoc("\nGenerated entity implementation for <code>$L</code>\n", new Object[]{entity.name});
        this.classBuilder.addJavadoc("</p>\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        Object fieldSpec = FieldSpec.builder((TypeName)entity.propertyPrimaryKey, (String)entity.idName, (Modifier[])new Modifier[]{fieldModifier}).addJavadoc("Primary key\n", new Object[0]).addAnnotation(AnnotationSpec.builder(BindSqlColumn.class).addMember("columnType", "$T.$L", new Object[]{ColumnType.class, ColumnType.PRIMARY_KEY}).build()).build();
        this.classBuilder.addField((FieldSpec)fieldSpec);
        fieldSpec = FieldSpec.builder((TypeName)entity.propertyKey1, (String)field1Name, (Modifier[])new Modifier[]{fieldModifier}).addJavadoc("Foreign key to $T model class\n", new Object[]{entity.entity1Name}).addAnnotation(AnnotationSpec.builder(BindSqlColumn.class).addMember(AnnotationAttributeType.PARENT_ENTITY.getValue(), "$T.class", new Object[]{entity.entity1Name}).addMember(AnnotationAttributeType.ON_DELETE.getValue(), "$T.$L", new Object[]{ForeignKeyAction.class, ForeignKeyAction.CASCADE}).build()).build();
        this.classBuilder.addField((FieldSpec)fieldSpec);
        fieldSpec = FieldSpec.builder((TypeName)entity.propertyKey2, (String)field2Name, (Modifier[])new Modifier[]{fieldModifier}).addJavadoc("Foreign key to $T model class\n", new Object[]{entity.entity2Name}).addAnnotation(AnnotationSpec.builder(BindSqlColumn.class).addMember(AnnotationAttributeType.PARENT_ENTITY.getValue(), "$T.class", new Object[]{entity.entity2Name}).addMember(AnnotationAttributeType.ON_DELETE.getValue(), "$T.$L", new Object[]{ForeignKeyAction.class, ForeignKeyAction.CASCADE}).build()).build();
        this.classBuilder.addField((FieldSpec)fieldSpec);
        if (entity.immutable) {
            for (SQLProperty p : properties) {
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, p.getName()))).returns(p.getPropertyType().getTypeName()).addStatement("return this.$L", new Object[]{p.getName()}).addModifiers(new Modifier[]{Modifier.PUBLIC});
                this.classBuilder.addMethod(methodBuilder.build());
            }
        }
        TypeSpec typeSpec = this.classBuilder.build();
        try {
            JavaWriterHelper.writeJava2File(this.filer, entity.getPackageName(), typeSpec);
        }
        catch (IOException e) {
            throw new KriptonRuntimeException((Throwable)e);
        }
        GeneratedTypeElement entityElement = new GeneratedTypeElement(entity.getPackageName(), this.classBuilder.build(), tableName, fk1Name + ", " + fk2Name);
        entityElement.properties = properties;
        entityResult.add(entityElement);
    }
}

