/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.android.annotation.BindSqlType;
import com.abubusoft.kripton.android.sqlite.ForeignKeyAction;
import com.abubusoft.kripton.android.sqlite.SQLiteTable;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.Finder;
import com.abubusoft.kripton.processor.core.ManagedPropertyPersistenceHelper;
import com.abubusoft.kripton.processor.core.ModelElementVisitor;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.element.GeneratedTypeElement;
import com.abubusoft.kripton.processor.exceptions.InvalidBeanTypeException;
import com.abubusoft.kripton.processor.exceptions.InvalidForeignKeyTypeException;
import com.abubusoft.kripton.processor.exceptions.NoDaoElementFound;
import com.abubusoft.kripton.processor.sqlite.AbstractBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDataSourceBuilder;
import com.abubusoft.kripton.processor.sqlite.FindIndexesVisitor;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.apache.commons.lang3.StringUtils;

public class BindTableGenerator
extends AbstractBuilder
implements ModelElementVisitor<SQLiteEntity, SQLProperty> {
    public static final String SUFFIX = "Table";
    private Converter<String, String> columnNameToUpperCaseConverter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);

    public BindTableGenerator(Elements elementUtils, Filer filer, SQLiteDatabaseSchema model) {
        super(elementUtils, filer, model);
    }

    public static void generate(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema, Set<GeneratedTypeElement> generatedEntities) throws Exception {
        BindTableGenerator visitor = new BindTableGenerator(elementUtils, filer, schema);
        List<SQLiteEntity> orderedEntities = BindDataSourceBuilder.orderEntitiesList(schema);
        HashMap<String, String> tableNames = new HashMap<String, String>();
        for (SQLiteEntity sQLiteEntity : orderedEntities) {
            if (tableNames.containsKey(sQLiteEntity.getTableName().toLowerCase())) {
                AssertKripton.fail("Table name '%s' is mapped to entities '%s' and '%s'", sQLiteEntity.getTableName(), sQLiteEntity.getName(), tableNames.get(sQLiteEntity.getTableName()));
                continue;
            }
            tableNames.put(sQLiteEntity.getTableName().toLowerCase(), sQLiteEntity.getName());
        }
        for (GeneratedTypeElement generatedTypeElement : generatedEntities) {
            if (tableNames.containsKey(generatedTypeElement.getTableName().toLowerCase())) {
                AssertKripton.fail("Table name '%s' is mapped to entities '%s' and '%s'", generatedTypeElement.getTableName(), generatedTypeElement.getName(), tableNames.get(generatedTypeElement.getTableName()));
                continue;
            }
            tableNames.put(generatedTypeElement.getTableName().toLowerCase(), generatedTypeElement.getName());
        }
        for (SQLiteEntity sQLiteEntity : orderedEntities) {
            visitor.visit(schema, sQLiteEntity);
        }
        for (GeneratedTypeElement generatedTypeElement : generatedEntities) {
            visitor.visit(schema, generatedTypeElement);
        }
    }

    @Override
    private void visit(SQLiteDatabaseSchema schema, GeneratedTypeElement entity) throws Exception {
        int indexCounter = 0;
        String classTableName = BindTableGenerator.getTableClassName(entity.getSimpleName());
        PackageElement pkg = this.elementUtils.getPackageElement(entity.packageName);
        String packageName = pkg.isUnnamed() ? null : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDataSource.class, packageName, classTableName);
        this.classBuilder = TypeSpec.classBuilder((String)classTableName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SQLiteTable.class);
        BindTypeContext context = new BindTypeContext(this.classBuilder, TypeUtility.typeName(packageName, classTableName), Modifier.STATIC, Modifier.PRIVATE);
        this.classBuilder.addJavadoc("<p>", new Object[0]);
        this.classBuilder.addJavadoc("\nEntity <code>$L</code> is associated to table <code>$L</code>\n", new Object[]{entity.getSimpleName(), entity.getTableName()});
        this.classBuilder.addJavadoc("This class represents table associated to entity.\n", new Object[0]);
        this.classBuilder.addJavadoc("</p>\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        this.classBuilder.addJavadoc(" @see $T\n", new Object[]{TypeUtility.className(entity.getName())});
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)"TABLE_NAME", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("\"$L\"", new Object[]{entity.getTableName()}).addJavadoc("Costant represents typeName of table $L\n", new Object[]{entity.getTableName()}).build();
        this.classBuilder.addField(fieldSpec);
        StringBuilder bufferTable = new StringBuilder();
        StringBuilder bufferForeignKey = new StringBuilder();
        StringBuilder bufferIndexesCreate = new StringBuilder();
        StringBuilder bufferDropTable = new StringBuilder();
        StringBuilder bufferIndexesDrop = new StringBuilder();
        bufferTable.append("CREATE TABLE " + entity.getTableName());
        String separator = "";
        bufferTable.append(" (");
        ArrayList<String> uniqueConstraintColumn = new ArrayList<String>();
        for (SQLProperty sQLProperty : entity.getCollection()) {
            bufferTable.append(separator);
            bufferTable.append(sQLProperty.columnName);
            if (sQLProperty.getPropertyType() == null) {
                bufferTable.append(" " + SQLTransformer.lookup(TypeName.LONG).getColumnTypeAsString());
            } else {
                bufferTable.append(" " + SQLTransformer.lookup(sQLProperty.getPropertyType().getTypeName()).getColumnTypeAsString());
            }
            switch (sQLProperty.columnType) {
                case PRIMARY_KEY: {
                    bufferTable.append(" PRIMARY KEY AUTOINCREMENT NOT NULL");
                    break;
                }
                case PRIMARY_KEY_UNMANGED: {
                    bufferTable.append(" PRIMARY KEY NOT NULL");
                    break;
                }
                case UNIQUE: {
                    bufferTable.append(" UNIQUE");
                    break;
                }
                case INDEXED: {
                    bufferIndexesCreate.append(String.format(" CREATE INDEX idx_%s_%s ON %s(%s);", entity.getTableName(), sQLProperty.columnName, entity.getTableName(), sQLProperty.columnName));
                    bufferIndexesDrop.append(String.format(" DROP INDEX IF EXISTS idx_%s_%s;", entity.getTableName(), sQLProperty.columnName));
                    uniqueConstraintColumn.add(sQLProperty.columnName);
                    break;
                }
            }
            boolean nullable = sQLProperty.isNullable();
            if (!nullable && sQLProperty.columnType != ColumnType.PRIMARY_KEY && sQLProperty.columnType != ColumnType.PRIMARY_KEY_UNMANGED) {
                bufferTable.append(" NOT NULL");
            }
            String foreignClassName = sQLProperty.foreignParentClassName;
            if (sQLProperty.isForeignKey()) {
                SQLiteEntity reference = this.model.getEntity(foreignClassName);
                if (reference == null) {
                    boolean found = false;
                    for (SQLiteDaoDefinition daoDefinition : schema.getCollection()) {
                        if (!daoDefinition.getEntityClassName().equals(foreignClassName)) continue;
                        found = true;
                    }
                    if (!found) {
                        throw new NoDaoElementFound(schema, TypeUtility.className(foreignClassName));
                    }
                    throw new InvalidBeanTypeException(sQLProperty, foreignClassName);
                }
                bufferForeignKey.append(", FOREIGN KEY(" + sQLProperty.columnName + ") REFERENCES " + reference.getTableName() + "(" + reference.getPrimaryKey().columnName + ")");
                if (sQLProperty.onDeleteAction != ForeignKeyAction.NO_ACTION) {
                    bufferForeignKey.append(" ON DELETE " + sQLProperty.onDeleteAction.toString().replaceAll("_", " "));
                }
                if (sQLProperty.onUpdateAction != ForeignKeyAction.NO_ACTION) {
                    bufferForeignKey.append(" ON UPDATE " + sQLProperty.onUpdateAction.toString().replaceAll("_", " "));
                }
                if (!entity.getClassName().equals((Object)TypeUtility.typeName(reference.getElement()))) {
                    entity.referedEntities.add(reference);
                }
            }
            separator = ", ";
        }
        bufferTable.append(bufferForeignKey.toString());
        bufferTable.append(String.format(", UNIQUE (%s)", StringUtils.join(uniqueConstraintColumn, (String)", ")));
        bufferTable.append(");");
        if (bufferIndexesCreate.length() > 0) {
            bufferTable.append(bufferIndexesCreate.toString());
        }
        Triple<String, String, String> multiIndexes = BindTableGenerator.buildIndexes(entity, false, indexCounter);
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)multiIndexes.value0))) {
            bufferTable.append((String)multiIndexes.value0 + ";");
            bufferIndexesDrop.append((String)multiIndexes.value1 + ";");
        }
        FieldSpec.Builder fieldSpec2 = FieldSpec.builder(String.class, (String)"CREATE_TABLE_SQL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC});
        fieldSpec2.addJavadoc("<p>\nDDL to create table $L\n</p>\n", new Object[]{entity.getTableName()});
        fieldSpec2.addJavadoc("\n<pre>$L</pre>\n", new Object[]{bufferTable.toString()});
        this.classBuilder.addField(fieldSpec2.initializer("$S", new Object[]{bufferTable.toString()}).build());
        if (bufferIndexesDrop.length() > 0) {
            bufferDropTable.append(bufferIndexesDrop.toString());
        }
        bufferDropTable.append("DROP TABLE IF EXISTS " + entity.getTableName() + ";");
        FieldSpec fieldSpec3 = FieldSpec.builder(String.class, (String)"DROP_TABLE_SQL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC}).initializer("$S", new Object[]{bufferDropTable.toString()}).addJavadoc("<p>\nDDL to drop table $L\n</p>\n", new Object[]{entity.getTableName()}).addJavadoc("\n<pre>$L</pre>\n", new Object[]{bufferDropTable.toString()}).build();
        this.classBuilder.addField(fieldSpec3);
        for (ModelProperty modelProperty : entity.getCollection()) {
            modelProperty.accept(this);
        }
        ManagedPropertyPersistenceHelper.generateFieldPersistance(context, entity.getCollection(), ManagedPropertyPersistenceHelper.PersistType.BYTE, true, Modifier.STATIC, Modifier.PUBLIC);
        this.model.sqlForCreate.add(bufferTable.toString());
        this.model.sqlForDrop.add(bufferDropTable.toString());
        this.generateColumnsArray(entity);
        TypeSpec typeSpec = this.classBuilder.build();
        JavaWriterHelper.writeJava2File(this.filer, packageName, typeSpec);
    }

    public static String getTableClassName(String entityName) {
        return entityName + SUFFIX;
    }

    public static ClassName tableClassName(SQLiteDaoDefinition dao, SQLiteEntity entity) {
        String entityName = BindDataSourceSubProcessor.generateEntityQualifiedName(dao, entity);
        return TypeUtility.className(entityName + SUFFIX);
    }

    @Override
    public void visit(SQLiteDatabaseSchema schema, SQLiteEntity entity) throws Exception {
        int indexCounter = 0;
        String classTableName = BindTableGenerator.getTableClassName(entity.getSimpleName());
        FindIndexesVisitor indexVisitor = new FindIndexesVisitor();
        List<? extends AnnotationMirror> annotationMirrors = ((TypeElement)entity.getElement()).getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            if (!BindSqlType.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                String key = entry.getKey().getSimpleName().toString();
                entry.getValue().accept(indexVisitor, key);
            }
        }
        PackageElement pkg = this.elementUtils.getPackageOf((Element)entity.getElement());
        String string = pkg.isUnnamed() ? null : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDataSource.class, string, classTableName);
        this.classBuilder = TypeSpec.classBuilder((String)classTableName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SQLiteTable.class);
        BindTypeContext context = new BindTypeContext(this.classBuilder, TypeUtility.typeName(string, classTableName), Modifier.STATIC, Modifier.PRIVATE);
        this.classBuilder.addJavadoc("<p>", new Object[0]);
        this.classBuilder.addJavadoc("\nEntity <code>$L</code> is associated to table <code>$L</code>\n", new Object[]{entity.getSimpleName(), entity.getTableName()});
        this.classBuilder.addJavadoc("This class represents table associated to entity.\n", new Object[0]);
        this.classBuilder.addJavadoc("</p>\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        this.classBuilder.addJavadoc(" @see $T\n", new Object[]{TypeUtility.className(entity.getName())});
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)"TABLE_NAME", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("\"$L\"", new Object[]{entity.getTableName()}).addJavadoc("Costant represents typeName of table $L\n", new Object[]{entity.getTableName()}).build();
        this.classBuilder.addField(fieldSpec);
        StringBuilder bufferTable = new StringBuilder();
        StringBuilder bufferForeignKey = new StringBuilder();
        StringBuilder bufferIndexesCreate = new StringBuilder();
        StringBuilder bufferDropTable = new StringBuilder();
        StringBuilder bufferIndexesDrop = new StringBuilder();
        bufferTable.append("CREATE TABLE " + entity.getTableName());
        String separator = "";
        bufferTable.append(" (");
        for (ModelProperty item : entity.getCollection()) {
            bufferTable.append(separator);
            bufferTable.append(((SQLProperty)item).columnName);
            bufferTable.append(" " + SQLTransformer.columnTypeAsString((SQLProperty)item));
            switch (((SQLProperty)item).columnType) {
                case PRIMARY_KEY: 
                case PRIMARY_KEY_UNMANGED: {
                    bufferTable.append(" PRIMARY KEY");
                    if (!item.isType(new Type[]{String.class}) && ((SQLProperty)item).columnType == ColumnType.PRIMARY_KEY) {
                        bufferTable.append(" AUTOINCREMENT");
                    }
                    bufferTable.append(" NOT NULL");
                    break;
                }
                case UNIQUE: {
                    bufferTable.append(" UNIQUE");
                    break;
                }
                case INDEXED: {
                    bufferIndexesCreate.append(String.format(" CREATE INDEX idx_%s_%s ON %s(%s);", entity.getTableName(), ((SQLProperty)item).columnName, entity.getTableName(), ((SQLProperty)item).columnName));
                    bufferIndexesDrop.append(String.format(" DROP INDEX IF EXISTS idx_%s_%s;", entity.getTableName(), ((SQLProperty)item).columnName));
                    break;
                }
            }
            boolean nullable = ((SQLProperty)item).isNullable();
            if (!nullable && ((SQLProperty)item).columnType != ColumnType.PRIMARY_KEY && ((SQLProperty)item).columnType != ColumnType.PRIMARY_KEY_UNMANGED) {
                bufferTable.append(" NOT NULL");
            }
            String foreignClassName = ((SQLProperty)item).foreignParentClassName;
            if (((SQLProperty)item).isForeignKey()) {
                SQLiteEntity reference = this.model.getEntity(foreignClassName);
                if (reference == null) {
                    boolean found = false;
                    for (SQLiteDaoDefinition daoDefinition : schema.getCollection()) {
                        if (!daoDefinition.getEntityClassName().equals(foreignClassName)) continue;
                        found = true;
                    }
                    if (!found) {
                        throw new NoDaoElementFound(schema, TypeUtility.className(foreignClassName));
                    }
                    throw new InvalidBeanTypeException((SQLProperty)item, foreignClassName);
                }
                if (!TypeUtility.isTypeIncludedIn(item.getPropertyType().getTypeName(), new Type[]{Long.class, Long.TYPE, String.class})) {
                    throw new InvalidForeignKeyTypeException((SQLProperty)item);
                }
                bufferForeignKey.append(", FOREIGN KEY(" + ((SQLProperty)item).columnName + ") REFERENCES " + reference.getTableName() + "(" + reference.getPrimaryKey().columnName + ")");
                if (((SQLProperty)item).onDeleteAction != ForeignKeyAction.NO_ACTION) {
                    bufferForeignKey.append(" ON DELETE " + ((SQLProperty)item).onDeleteAction.toString().replaceAll("_", " "));
                }
                if (((SQLProperty)item).onUpdateAction != ForeignKeyAction.NO_ACTION) {
                    bufferForeignKey.append(" ON UPDATE " + ((SQLProperty)item).onUpdateAction.toString().replaceAll("_", " "));
                }
                if (!entity.equals(reference)) {
                    entity.referedEntities.add(reference);
                }
            }
            separator = ", ";
        }
        bufferTable.append(bufferForeignKey.toString());
        Triple<String, String, String> multiIndexes = BindTableGenerator.buldIndexes(entity, indexVisitor.getUniqueIndexes(), true, indexCounter);
        bufferTable.append((String)multiIndexes.value2);
        bufferTable.append(");");
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)multiIndexes.value0))) {
            bufferTable.append((String)multiIndexes.value0 + ";");
            bufferIndexesDrop.append((String)multiIndexes.value1 + ";");
        }
        if (bufferIndexesCreate.length() > 0) {
            bufferTable.append(bufferIndexesCreate.toString());
        }
        multiIndexes = BindTableGenerator.buldIndexes(entity, indexVisitor.getNotUniqueIndexes(), false, indexCounter);
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)multiIndexes.value0))) {
            bufferTable.append((String)multiIndexes.value0 + ";");
            bufferIndexesDrop.append((String)multiIndexes.value1 + ";");
        }
        FieldSpec.Builder fieldSpec2 = FieldSpec.builder(String.class, (String)"CREATE_TABLE_SQL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC});
        fieldSpec2.addJavadoc("<p>\nDDL to create table $L\n</p>\n", new Object[]{entity.getTableName()});
        fieldSpec2.addJavadoc("\n<pre>$L</pre>\n", new Object[]{bufferTable.toString()});
        this.classBuilder.addField(fieldSpec2.initializer("$S", new Object[]{bufferTable.toString()}).build());
        if (bufferIndexesDrop.length() > 0) {
            bufferDropTable.append(bufferIndexesDrop.toString());
        }
        bufferDropTable.append("DROP TABLE IF EXISTS " + entity.getTableName() + ";");
        FieldSpec fieldSpec3 = FieldSpec.builder(String.class, (String)"DROP_TABLE_SQL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC}).initializer("$S", new Object[]{bufferDropTable.toString()}).addJavadoc("<p>\nDDL to drop table $L\n</p>\n", new Object[]{entity.getTableName()}).addJavadoc("\n<pre>$L</pre>\n", new Object[]{bufferDropTable.toString()}).build();
        this.classBuilder.addField(fieldSpec3);
        for (ModelProperty item : entity.getCollection()) {
            item.accept(this);
        }
        ManagedPropertyPersistenceHelper.generateFieldPersistance(context, entity.getCollection(), ManagedPropertyPersistenceHelper.PersistType.BYTE, true, Modifier.STATIC, Modifier.PUBLIC);
        this.model.sqlForCreate.add(bufferTable.toString());
        this.model.sqlForDrop.add(bufferDropTable.toString());
        this.generateColumnsArray(entity);
        TypeSpec typeSpec = this.classBuilder.build();
        JavaWriterHelper.writeJava2File(this.filer, string, typeSpec);
    }

    private void generateColumnsArray(Finder<SQLProperty> entity) {
        FieldSpec.Builder sp = FieldSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"COLUMNS", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PRIVATE, Modifier.FINAL});
        String s = "";
        StringBuilder buffer = new StringBuilder();
        for (SQLProperty property : entity.getCollection()) {
            buffer.append(s + "COLUMN_" + (String)this.columnNameToUpperCaseConverter.convert((Object)property.getName()));
            s = ", ";
        }
        this.classBuilder.addField(sp.addJavadoc("Columns array\n", new Object[0]).initializer("{" + buffer.toString() + "}", new Object[0]).build());
        this.classBuilder.addMethod(MethodSpec.methodBuilder((String)"columns").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Columns array\n", new Object[0]).addAnnotation(Override.class).returns((TypeName)ArrayTypeName.of(String.class)).addStatement("return COLUMNS", new Object[0]).build());
        this.classBuilder.addMethod(MethodSpec.methodBuilder((String)"name").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("table name\n", new Object[0]).addAnnotation(Override.class).returns(TypeName.get(String.class)).addStatement("return TABLE_NAME", new Object[0]).build());
    }

    public static Triple<String, String, String> buldIndexes(final SQLiteEntity entity, ArrayList<Pair<List<String>, Boolean>> indexList, boolean unique, int counter) {
        Triple result = new Triple();
        result.value0 = "";
        result.value1 = "";
        result.value2 = "";
        if (indexList.size() == 0) {
            return result;
        }
        String uniqueString = unique ? "UNIQUE " : "";
        ArrayList<String> listCreateIndex = new ArrayList<String>();
        ArrayList<String> listDropIndex = new ArrayList<String>();
        ArrayList<String> listUniqueConstraint = new ArrayList<String>();
        for (Pair<List<String>, Boolean> index : indexList) {
            final ArrayList listUniqueFields = new ArrayList();
            String createIndex = String.format(" CREATE %sINDEX idx_%s_%s on %s (%s)", uniqueString, entity.getTableName(), counter++, entity.getTableName(), StringUtils.join((Iterable)((Iterable)index.value0), (String)", "));
            String dropIndex = String.format(" DROP INDEX IF EXISTS idx_%s_%s", entity.getTableName(), counter);
            final One fieldCounter = new One((Object)0);
            createIndex = JQLChecker.getInstance().replace(new JQLContext(){

                @Override
                public String getContextDescription() {
                    return "While table definition generation for entity " + entity.getName();
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public String getParentName() {
                    return null;
                }

                @Override
                public Finder<SQLProperty> findEntityByName(String entityName) {
                    return null;
                }
            }, createIndex, (JQLReplacerListener)new JQLReplacerListenerImpl(null){

                @Override
                public String onColumnName(String columnName) {
                    Integer n = (Integer)fieldCounter.value0;
                    One one = fieldCounter;
                    one.value0 = (Integer)one.value0 + 1;
                    Integer n2 = one.value0;
                    SQLProperty property = (SQLProperty)entity.findPropertyByName(columnName);
                    AssertKripton.assertTrue(property != null, "class '%s' in @%s(indexes) use unknown property '%s'", entity.getName(), BindSqlType.class.getSimpleName(), columnName);
                    listUniqueFields.add(property.columnName);
                    return property.columnName;
                }

                @Override
                public String onColumnFullyQualifiedName(String tableName, String columnName) {
                    AssertKripton.fail("Inconsistent state", new Object[0]);
                    return null;
                }
            });
            AssertKripton.assertTrue((Integer)fieldCounter.value0 > 0, "class '%s' have @%s(indexes) with no well formed indexes", entity.getName(), BindSqlType.class.getSimpleName());
            if (unique) {
                listUniqueConstraint.add(String.format(", UNIQUE (%s)", StringUtils.join(listUniqueFields, (String)", ")));
            }
            listCreateIndex.add(createIndex);
            listDropIndex.add(dropIndex);
        }
        result.value0 = StringUtils.join(listCreateIndex, (String)";");
        result.value1 = StringUtils.join(listDropIndex, (String)";");
        result.value2 = StringUtils.join(listUniqueConstraint, (String)"");
        return result;
    }

    public static Triple<String, String, String> buildIndexes(GeneratedTypeElement entity, boolean unique, int counter) {
        Triple result = new Triple();
        result.value0 = "";
        result.value1 = "";
        result.value2 = "";
        List<String> indexes = entity.index;
        String uniqueString = "UNIQUE ";
        if (indexes == null || indexes.size() == 0) {
            return result;
        }
        ArrayList<String> listCreateIndex = new ArrayList<String>();
        ArrayList<String> listDropIndex = new ArrayList<String>();
        for (String index : indexes) {
            String createIndex = String.format(" CREATE %sINDEX idx_%s_%s on %s (%s)", uniqueString, entity.getTableName(), counter++, entity.getTableName(), index);
            String dropIndex = String.format(" DROP INDEX IF EXISTS idx_%s_%s", entity.getTableName(), counter);
            listCreateIndex.add(createIndex);
            listDropIndex.add(dropIndex);
        }
        result.value0 = StringUtils.join(listCreateIndex, (String)";");
        result.value1 = StringUtils.join(listDropIndex, (String)";");
        return result;
    }

    @Override
    public void visit(SQLProperty kriptonProperty) {
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)("COLUMN_" + (String)this.columnNameToUpperCaseConverter.convert((Object)kriptonProperty.getName())), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{kriptonProperty.columnName}).addJavadoc("Entity's property <code>$L</code> is associated to table column <code>$L</code>. This costant represents column name.\n", new Object[]{kriptonProperty.getName(), kriptonProperty.columnName}).addJavadoc("\n @see $T#$L\n", new Object[]{kriptonProperty.getEntityTypeName(), kriptonProperty.getName()}).build();
        this.classBuilder.addField(fieldSpec);
    }
}

