/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.util.Elements;

public abstract class CodeBuilderUtility {
    public static List<SQLProperty> extractUsedProperties(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, Class<? extends Annotation> annotationClazz) {
        SQLiteEntity entity = method.getEntity();
        ArrayList<SQLProperty> listPropertyInContentValue = new ArrayList<SQLProperty>();
        Set<String> foundColumns = JQLChecker.getInstance().extractColumnsToInsertOrUpdate(method, method.jql.value, entity);
        for (SQLProperty item : entity.getCollection()) {
            if (foundColumns.size() > 0 && !foundColumns.contains(item.getName())) continue;
            listPropertyInContentValue.add(item);
        }
        return listPropertyInContentValue;
    }

    public static void generateContentValuesFromEntity(Elements elementUtils, SQLiteModelMethod method, Class<? extends Annotation> annotationClazz, MethodSpec.Builder methodBuilder, List<String> alreadyUsedBeanPropertiesNames) {
        String entityName = (String)method.getParameters().get((int)0).value0;
        CodeBuilderUtility.generateContentValuesFromEntity(elementUtils, method, entityName, annotationClazz, methodBuilder, alreadyUsedBeanPropertiesNames);
    }

    public static void generateContentValuesFromEntity(Elements elementUtils, SQLiteModelMethod method, String entityName, Class<? extends Annotation> annotationClazz, MethodSpec.Builder methodBuilder, List<String> alreadyUsedBeanPropertiesNames) {
        SQLiteEntity entity = method.getEntity();
        TypeName entityClassName = TypeUtility.typeName(entity.getElement());
        AssertKripton.assertTrueOrInvalidMethodSignException(!method.hasAdapterForParam(entityName), method, "method's parameter '%s' can not use a type adapter", entityName);
        Set<String> updateColumns = JQLChecker.getInstance().extractColumnsToInsertOrUpdate(method, method.jql.value, entity);
        for (String columnName : updateColumns) {
            SQLProperty item = (SQLProperty)entity.get(columnName);
            AssertKripton.assertTrueOrUnknownPropertyInJQLException(item != null, method, columnName);
            if (method.isLogEnabled()) {
                methodBuilder.addCode("_contentValues.put($S, ", new Object[]{item.columnName});
            } else {
                methodBuilder.addCode("_contentValues.put(", new Object[0]);
            }
            SQLTransformer.javaProperty2ContentValues(methodBuilder, entityClassName, entityName, item);
            methodBuilder.addCode(");\n", new Object[0]);
        }
        methodBuilder.addCode("\n", new Object[0]);
    }
}

