/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.sqlite.SQLiteStatement;
import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.KriptonDatabaseWrapper;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.exceptions.PropertyNotFoundException;
import com.abubusoft.kripton.processor.sqlite.GenericSQLHelper;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlInsertBuilder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class InsertRawHelper
implements SqlInsertBuilder.InsertCodeGenerator {
    @Override
    public void generate(TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, boolean mapFields, SQLiteModelMethod method, TypeName returnType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        this.generateJavaDoc(methodBuilder, method, returnType);
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate()", new Object[]{KriptonContentValues.class});
        } else {
            String psName = method.buildPreparedStatementName();
            classBuilder.addField(FieldSpec.builder((TypeName)TypeName.get(SQLiteStatement.class), (String)psName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build());
            methodBuilder.beginControlFlow("if ($L==null)", new Object[]{psName});
            SqlBuilderHelper.generateSQLForStaticQuery(method, methodBuilder);
            methodBuilder.addStatement("$L = $T.compile(_context, _sql)", new Object[]{psName, KriptonDatabaseWrapper.class});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate($L)", new Object[]{KriptonContentValues.class, psName});
        }
        if (method.jql.containsSelectOperation) {
            GenericSQLHelper.generateGenericExecSQL(methodBuilder, method);
        } else {
            methodBuilder.addCode("\n", new Object[0]);
            List<Pair<String, TypeName>> fieldsToUpdate = method.getParameters();
            fieldsToUpdate = SqlBuilderHelper.orderContentValues(method, fieldsToUpdate);
            for (Pair<String, TypeName> item : fieldsToUpdate) {
                String propertyName = method.findParameterAliasByName((String)item.value0);
                SQLProperty property = (SQLProperty)entity.get(propertyName);
                if (property == null) {
                    throw new PropertyNotFoundException(method, propertyName, (TypeName)item.value1);
                }
                TypeUtility.checkTypeCompatibility(method, item, property);
                if (method.isLogEnabled()) {
                    methodBuilder.addCode("_contentValues.put($S, ", new Object[]{property.columnName});
                } else {
                    methodBuilder.addCode("_contentValues.put(", new Object[0]);
                }
                SQLTransformer.javaMethodParam2ContentValues(methodBuilder, method, (String)item.value0, (TypeName)item.value1, property);
                methodBuilder.addCode(");\n", new Object[0]);
            }
            methodBuilder.addCode("\n", new Object[0]);
            SqlBuilderHelper.generateLog(method, methodBuilder);
            methodBuilder.addComment("insert operation", new Object[0]);
            if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
                SqlBuilderHelper.generateSQLForInsertDynamic(method, methodBuilder);
                methodBuilder.addStatement("long result = $T.insert(_context, _sql, _contentValues)", new Object[]{KriptonDatabaseWrapper.class});
            } else {
                String psName = method.buildPreparedStatementName();
                methodBuilder.addStatement("long result = $T.insert($L, _contentValues)", new Object[]{KriptonDatabaseWrapper.class, psName});
            }
            if (daoDefinition.getParent().generateRx) {
                String rxIdGetter = null;
                if (entity.getPrimaryKey().columnType == ColumnType.PRIMARY_KEY) {
                    rxIdGetter = "result";
                } else {
                    for (Pair<String, TypeName> item : fieldsToUpdate) {
                        String propertyName = method.findParameterAliasByName((String)item.value0);
                        SQLProperty property = (SQLProperty)entity.get(propertyName);
                        if (!property.isPrimaryKey()) continue;
                        rxIdGetter = (String)item.value0;
                    }
                }
                GenericSQLHelper.generateSubjectNext(entity, methodBuilder, GenericSQLHelper.SubjectType.INSERT, rxIdGetter);
            }
            if (daoDefinition.hasLiveData()) {
                methodBuilder.addComment("support for livedata", new Object[0]);
                methodBuilder.addStatement("registryEvent(result>0?1:0)", new Object[0]);
            }
            if (returnType != TypeName.VOID) {
                if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Boolean.TYPE, Boolean.class})) {
                    methodBuilder.addStatement("return result!=-1", new Object[0]);
                } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Long.TYPE, Long.class})) {
                    methodBuilder.addStatement("return result", new Object[0]);
                } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Integer.TYPE, Integer.class})) {
                    methodBuilder.addStatement("return (int)result", new Object[0]);
                } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{String.class})) {
                    methodBuilder.addStatement("return String.valueOf(result)", new Object[0]);
                } else {
                    throw new InvalidMethodSignException(method, "invalid return type");
                }
            }
        }
    }

    public String generateJavaDoc(MethodSpec.Builder methodBuilder, final SQLiteModelMethod method, TypeName returnType) {
        String resolvedName;
        SQLiteEntity entity = method.getEntity();
        final One inColumnValues = new One((Object)false);
        final ArrayList methodParamsUsedAsColumnValue = new ArrayList();
        final ArrayList methodParamsUsedAsParameter = new ArrayList();
        String sqlInsert = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public void onColumnValueSetBegin(JqlParser.Column_value_setContext ctx) {
                inColumnValues.value0 = true;
            }

            @Override
            public void onColumnValueSetEnd(JqlParser.Column_value_setContext ctx) {
                inColumnValues.value0 = false;
            }

            @Override
            public String onColumnName(String columnName) {
                Set<SQLProperty> property = this.currentSchema.getPropertyBySimpleName(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(property != null, method, columnName);
                SQLProperty tempProperty = property.iterator().next();
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                String resolvedParamName = method.findParameterNameByAlias(bindParameterName);
                if (((Boolean)inColumnValues.value0).booleanValue()) {
                    methodParamsUsedAsColumnValue.add(new Pair((Object)resolvedParamName, (Object)method.findParameterType(resolvedParamName)));
                } else {
                    methodParamsUsedAsParameter.add(new Pair((Object)resolvedParamName, (Object)method.findParameterType(resolvedParamName)));
                }
                return SqlAnalyzer.PARAM_PREFIX + resolvedParamName + SqlAnalyzer.PARAM_SUFFIX;
            }
        });
        methodBuilder.addJavadoc("<h2>SQL insert</h2>\n", new Object[0]);
        methodBuilder.addJavadoc("<pre>$L</pre>\n", new Object[]{sqlInsert});
        methodBuilder.addJavadoc("\n", new Object[0]);
        if (methodParamsUsedAsColumnValue.size() > 0) {
            methodBuilder.addJavadoc("<h2>Inserted columns:</strong></h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (Pair property : methodParamsUsedAsColumnValue) {
                resolvedName = method.findParameterNameByAlias((String)property.value0);
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{property.value0});
                methodBuilder.addJavadoc("<dd>is binded to query's parameter <strong>$L</strong> and method's parameter <strong>$L</strong></dd>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + (String)property.value0 + SqlAnalyzer.PARAM_SUFFIX, resolvedName});
            }
            methodBuilder.addJavadoc("</dl>\n\n", new Object[0]);
        }
        if (methodParamsUsedAsParameter.size() > 0) {
            methodBuilder.addJavadoc("<h2>Method parameters used as sql parameters</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (Pair property : methodParamsUsedAsParameter) {
                resolvedName = method.findParameterNameByAlias((String)property.value0);
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{resolvedName});
                methodBuilder.addJavadoc("<dd>is binded to query's parameter <strong>" + SqlAnalyzer.PARAM_PREFIX + "$L" + SqlAnalyzer.PARAM_SUFFIX + "</strong></dd>\n", new Object[]{property.value0});
            }
            methodBuilder.addJavadoc("</dl>\n\n", new Object[0]);
        }
        for (Pair<String, TypeName> param : method.getParameters()) {
            if (methodParamsUsedAsColumnValue.contains(param)) {
                methodBuilder.addJavadoc("@param $L\n", new Object[]{param.value0});
                if (entity.get(method.findParameterAliasByName((String)param.value0)) != null) {
                    methodBuilder.addJavadoc("\tis binded to column value <strong>$L</strong>\n", new Object[]{((SQLProperty)entity.get((String)method.findParameterAliasByName((String)((String)param.value0)))).columnName});
                } else {
                    methodBuilder.addJavadoc("\tis binded to query parameter <strong>$L</strong>\n", new Object[]{param.value0});
                }
            }
            if (!methodParamsUsedAsParameter.contains(param)) continue;
            methodBuilder.addJavadoc("@param $L\n", new Object[]{param.value0});
            methodBuilder.addJavadoc("\tis used as parameter\n", new Object[0]);
        }
        InsertRawHelper.generateJavaDocReturnType(methodBuilder, returnType);
        return sqlInsert;
    }

    public static void generateJavaDocReturnType(MethodSpec.Builder methodBuilder, TypeName returnType) {
        if (returnType != TypeName.VOID) {
            if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Boolean.TYPE, Boolean.class})) {
                methodBuilder.addJavadoc("\n", new Object[0]);
                methodBuilder.addJavadoc("@return <code>true</code> if record is inserted, <code>false</code> otherwise", new Object[0]);
            } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Long.TYPE, Long.class})) {
                methodBuilder.addJavadoc("\n", new Object[0]);
                methodBuilder.addJavadoc("@return <strong>id</strong> of inserted record", new Object[0]);
            } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Integer.TYPE, Integer.class})) {
                methodBuilder.addJavadoc("\n", new Object[0]);
                methodBuilder.addJavadoc("@return <strong>id</strong> of inserted record", new Object[0]);
            }
        }
        methodBuilder.addJavadoc("\n", new Object[0]);
    }
}

