/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.sqlite.SQLiteStatement;
import com.abubusoft.kripton.android.annotation.BindSqlDelete;
import com.abubusoft.kripton.android.annotation.BindSqlUpdate;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.KriptonDatabaseWrapper;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.CodeBuilderUtility;
import com.abubusoft.kripton.processor.sqlite.GenericSQLHelper;
import com.abubusoft.kripton.processor.sqlite.ModifyRawHelper;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlModifyBuilder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;

public class ModifyBeanHelper
implements SqlModifyBuilder.ModifyCodeGenerator {
    @Override
    public void generate(TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, boolean updateMode, SQLiteModelMethod method, TypeName returnType) {
        List<SQLProperty> listUsedProperty;
        String beanNameParameter = (String)method.getParameters().get((int)0).value0;
        AssertKripton.assertTrueOrInvalidMethodSignException(!method.hasAdapterForParam(beanNameParameter), method, "method's parameter '%s' can not use a type adapter", beanNameParameter);
        SqlAnalyzer analyzer = new SqlAnalyzer();
        String whereCondition = ModifyRawHelper.extractWhereConditions(updateMode, method);
        if (StringUtils.hasText((String)whereCondition)) {
            whereCondition = whereCondition.trim();
        }
        analyzer.execute(BaseProcessor.elementUtils, method, whereCondition);
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate()", new Object[]{KriptonContentValues.class});
        } else {
            String psName = method.buildPreparedStatementName();
            classBuilder.addField(FieldSpec.builder((TypeName)TypeName.get(SQLiteStatement.class), (String)psName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build());
            methodBuilder.beginControlFlow("if ($L==null)", new Object[]{psName});
            SqlBuilderHelper.generateSQLForStaticQuery(method, methodBuilder);
            methodBuilder.addStatement("$L = $T.compile(_context, _sql)", new Object[]{psName, KriptonDatabaseWrapper.class});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate($L)", new Object[]{KriptonContentValues.class, psName});
        }
        if (updateMode) {
            listUsedProperty = CodeBuilderUtility.extractUsedProperties(methodBuilder, method, BindSqlUpdate.class);
            AssertKripton.assertTrueOrInvalidMethodSignException(listUsedProperty.size() > 0, method, "no column was selected for update", new Object[0]);
            CodeBuilderUtility.generateContentValuesFromEntity(BaseProcessor.elementUtils, method, BindSqlUpdate.class, methodBuilder, analyzer.getUsedBeanPropertyNames());
        } else {
            listUsedProperty = CodeBuilderUtility.extractUsedProperties(methodBuilder, method, BindSqlDelete.class);
        }
        this.buildJavadoc(methodBuilder, updateMode, method, beanNameParameter, whereCondition, listUsedProperty, analyzer.getUsedBeanPropertyNames());
        this.generateWhereCondition(methodBuilder, method, analyzer);
        methodBuilder.addCode("\n", new Object[0]);
        ModifyBeanHelper.generateModifyQueryCommonPart(method, classBuilder, methodBuilder);
        SQLiteDaoDefinition daoDefinition = method.getParent();
        if (daoDefinition.hasLiveData()) {
            methodBuilder.addComment("support for livedata", new Object[0]);
            methodBuilder.addStatement("registryEvent(result)", new Object[0]);
        }
        this.buildReturnCode(methodBuilder, updateMode, method, returnType);
    }

    static void generateModifyQueryCommonPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder) {
        boolean updateMode = method.jql.operationType == JQL.JQLType.UPDATE;
        SqlModifyBuilder.generateInitForDynamicWhereVariables(method, methodBuilder, method.dynamicWhereParameterName, method.dynamicWhereArgsParameterName);
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            if (method.jql.isWhereConditions()) {
                methodBuilder.addStatement("$T _sqlBuilder=sqlBuilder()", new Object[]{StringBuilder.class});
            }
            SqlBuilderHelper.generateWhereCondition(methodBuilder, method, true);
            SqlModifyBuilder.generateSQL(method, methodBuilder);
        }
        if (method.isLogEnabled()) {
            methodBuilder.addComment("log section BEGIN", new Object[0]);
            methodBuilder.beginControlFlow("if (_context.isLogEnabled())", new Object[0]);
            SqlModifyBuilder.generateLogForModifiers(method, methodBuilder);
            if (method.jql.operationType == JQL.JQLType.UPDATE && method.isLogEnabled()) {
                SqlBuilderHelper.generateLogForContentValues(method, methodBuilder);
            }
            SqlBuilderHelper.generateLogForWhereParameters(method, methodBuilder);
            methodBuilder.endControlFlow();
            methodBuilder.addComment("log section END", new Object[0]);
        }
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            methodBuilder.addStatement("int result = $T.updateDelete(_context, _sql, _contentValues)", new Object[]{KriptonDatabaseWrapper.class});
        } else {
            String psName = method.buildPreparedStatementName();
            methodBuilder.addStatement("int result = $T.updateDelete($L, _contentValues)", new Object[]{KriptonDatabaseWrapper.class, psName});
        }
        if (method.getParent().getParent().generateRx) {
            if (updateMode) {
                GenericSQLHelper.generateSubjectNext(method.getEntity(), methodBuilder, GenericSQLHelper.SubjectType.UPDATE, "result");
            } else {
                GenericSQLHelper.generateSubjectNext(method.getEntity(), methodBuilder, GenericSQLHelper.SubjectType.DELETE, "result");
            }
        }
    }

    public void generateWhereCondition(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, SqlAnalyzer analyzer) {
        SQLiteEntity entity = method.getEntity();
        String beanParamName = (String)method.getParameters().get((int)0).value0;
        TypeName beanClass = TypeUtility.typeName(entity.getElement());
        for (String item : analyzer.getUsedBeanPropertyNames()) {
            SQLProperty property = (SQLProperty)entity.findPropertyByName(item);
            methodBuilder.addCode("_contentValues.addWhereArgs(", new Object[0]);
            boolean nullable = TypeUtility.isNullable(property);
            if (nullable && !property.hasTypeAdapter()) {
                methodBuilder.addCode("($L==null?\"\":", new Object[]{PropertyUtility.getter(beanParamName, beanClass, property)});
            }
            TypeUtility.beginStringConversion(methodBuilder, property);
            SQLTransformer.javaProperty2WhereCondition(methodBuilder, method, beanParamName, beanClass, property);
            TypeUtility.endStringConversion(methodBuilder, property);
            if (nullable && !property.hasTypeAdapter()) {
                methodBuilder.addCode(")", new Object[0]);
            }
            methodBuilder.addCode(");\n", new Object[0]);
        }
    }

    public void buildReturnCode(MethodSpec.Builder methodBuilder, boolean updateMode, SQLiteModelMethod method, TypeName returnType) {
        if (returnType != TypeName.VOID) {
            if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Boolean.TYPE, Boolean.class})) {
                methodBuilder.addJavadoc("\n", new Object[0]);
                if (updateMode) {
                    methodBuilder.addJavadoc("@return <code>true</code> if record is updated, <code>false</code> otherwise", new Object[0]);
                } else {
                    methodBuilder.addJavadoc("@return <code>true</code> if record is deleted, <code>false</code> otherwise", new Object[0]);
                }
                methodBuilder.addJavadoc("\n", new Object[0]);
                methodBuilder.addCode("return result!=0;\n", new Object[0]);
            } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class})) {
                methodBuilder.addJavadoc("\n", new Object[0]);
                if (updateMode) {
                    methodBuilder.addJavadoc("@return number of updated records", new Object[0]);
                } else {
                    methodBuilder.addJavadoc("@return number of deleted records", new Object[0]);
                }
                methodBuilder.addJavadoc("\n", new Object[0]);
                methodBuilder.addCode("return result;\n", new Object[0]);
            } else {
                throw new InvalidMethodSignException(method, "invalid return type");
            }
        }
    }

    public String buildJavadoc(MethodSpec.Builder methodBuilder, boolean updateMode, SQLiteModelMethod method, String beanNameParameter, String whereCondition, List<SQLProperty> listUsedProperty, List<String> attributesUsedInWhereConditions) {
        Pair<String, TypeName> beanParameter = method.getParameters().get(0);
        StringBuilder buffer = new StringBuilder();
        StringBuilder bufferQuestion = new StringBuilder();
        String separator = "";
        for (SQLProperty property : listUsedProperty) {
            buffer.append(String.format("%s%s=" + SqlAnalyzer.PARAM_PREFIX + "%s" + SqlAnalyzer.PARAM_SUFFIX, separator, property.columnName, property.getName()));
            bufferQuestion.append(separator);
            bufferQuestion.append(property.columnName + "=");
            bufferQuestion.append("'\"+StringUtils.checkSize(_contentValues.get(\"" + property.columnName + "\"))+\"'");
            separator = ", ";
        }
        String sqlForJavaDoc = this.extractSQLForJavaDoc(method);
        String sqlResult = method.jql.value;
        if (updateMode) {
            methodBuilder.addJavadoc("<h2>SQL update</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<pre>$L</pre>", new Object[]{sqlForJavaDoc});
            methodBuilder.addJavadoc("\n\n", new Object[0]);
            methodBuilder.addJavadoc("<h2>Updated columns</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (SQLProperty sQLProperty : listUsedProperty) {
                String resolvedName = method.findParameterAliasByName((String)beanParameter.value0);
                methodBuilder.addJavadoc("\t<dt>$L</dt><dd>is mapped to <strong>$L</strong></dd>\n", new Object[]{sQLProperty.columnName, SqlAnalyzer.PARAM_PREFIX + resolvedName + "." + sQLProperty.getName() + SqlAnalyzer.PARAM_SUFFIX});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        } else {
            methodBuilder.addJavadoc("<h2>SQL delete:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<pre>", new Object[0]);
            methodBuilder.addJavadoc("$L", new Object[]{sqlForJavaDoc});
            methodBuilder.addJavadoc("</pre>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (attributesUsedInWhereConditions.size() > 0) {
            methodBuilder.addJavadoc("<h2>Parameters used in where conditions:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (String string : attributesUsedInWhereConditions) {
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{SqlAnalyzer.PARAM_PREFIX + method.findParameterAliasByName((String)beanParameter.value0) + "." + method.findParameterAliasByName(string) + SqlAnalyzer.PARAM_SUFFIX});
                methodBuilder.addJavadoc("<dd>is mapped to method's parameter <strong>$L.$L</strong></dd>\n", new Object[]{beanParameter.value0, string});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (method.hasDynamicWhereConditions()) {
            methodBuilder.addJavadoc("<h2>Method's parameters and associated dynamic parts:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            if (method.hasDynamicWhereConditions()) {
                methodBuilder.addJavadoc("<dt>$L</dt><dd>is part of where conditions resolved at runtime. In above SQL it is displayed as #{$L}</dd>", new Object[]{method.dynamicWhereParameterName, JQL.JQLDynamicStatementType.DYNAMIC_WHERE});
            }
            methodBuilder.addJavadoc("\n</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        for (Pair pair : method.getParameters()) {
            methodBuilder.addJavadoc("@param $L", new Object[]{pair.value0});
            if (method.isThisDynamicWhereConditionsName((String)pair.value0)) {
                methodBuilder.addJavadoc("\n\tis used as dynamic where conditions\n", new Object[0]);
                continue;
            }
            methodBuilder.addJavadoc("\n\tis used as <code>$L</code>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + method.findParameterAliasByName((String)pair.value0) + SqlAnalyzer.PARAM_SUFFIX});
        }
        return sqlResult;
    }

    private String extractSQLForJavaDoc(SQLiteModelMethod method) {
        final One usedInWhere = new One((Object)false);
        String sqlForJavaDoc = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                return ((SQLProperty)this.currentEntity.findPropertyByName((String)columnName)).columnName;
            }

            @Override
            public String onColumnName(String columnName) {
                return ((SQLProperty)this.currentEntity.findPropertyByName((String)columnName)).columnName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                if (!((Boolean)usedInWhere.value0).booleanValue()) {
                    String[] a;
                    if (bindParameterName.contains(".") && (a = bindParameterName.split("\\.")).length == 2) {
                        bindParameterName = a[1];
                    }
                    return ":" + bindParameterName;
                }
                return null;
            }

            @Override
            public void onWhereStatementBegin(JqlParser.Where_stmtContext ctx) {
                usedInWhere.value0 = true;
            }

            @Override
            public void onWhereStatementEnd(JqlParser.Where_stmtContext ctx) {
                usedInWhere.value0 = false;
            }
        });
        return sqlForJavaDoc;
    }
}

