/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.sqlite.TransactionResult;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.concurrent.Future;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public abstract class SchemaUtility {
    /*
     * WARNING - void declaration
     */
    public static void generateTransaction(TypeSpec.Builder classBuilder, SQLiteDatabaseSchema schema, boolean onlyInterface) {
        for (ExecutableElement item : schema.transactions) {
            HashSet<String> daoNames = new HashSet<String>();
            daoNames.addAll(schema.getDaoNameSet());
            MethodSpec.Builder methodBuilderSync = MethodSpec.methodBuilder((String)item.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE);
            MethodSpec.Builder methodBuilderAsync = MethodSpec.methodBuilder((String)(item.getSimpleName().toString() + "Async")).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(Future.class, (Type[])new Type[]{Boolean.class}));
            if (!onlyInterface) {
                methodBuilderSync.addAnnotation(Override.class);
                methodBuilderAsync.addAnnotation(Override.class);
            } else {
                methodBuilderSync.addModifiers(new Modifier[]{Modifier.ABSTRACT});
                methodBuilderAsync.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            }
            methodBuilderSync.addJavadoc("Executes method {@link $L}\n\n@return <code>true</code> if transaction was done succefull.\n", new Object[]{item.getSimpleName().toString()});
            methodBuilderAsync.addJavadoc("Executes method {@link $L} in async mode\n\n@return a <code>Future</code> with true if transaction was done succefull.\n", new Object[]{item.getSimpleName().toString()});
            for (VariableElement variableElement : item.getParameters()) {
                if (daoNames.contains(TypeUtility.typeName(variableElement.asType()).toString())) continue;
                methodBuilderSync.addParameter(TypeUtility.typeName(variableElement.asType()), variableElement.getSimpleName().toString(), new Modifier[0]);
                methodBuilderAsync.addParameter(TypeUtility.typeName(variableElement.asType()), variableElement.getSimpleName().toString(), new Modifier[0]);
            }
            if (!onlyInterface) {
                boolean managedTransationStatus = false;
                if (TypeUtility.isEquals((TypeName)ClassName.get(TransactionResult.class), TypeUtility.typeName(item.getReturnType()))) {
                    managedTransationStatus = true;
                }
                methodBuilderSync.addCode("return $L.this.execute(daoFactory -> {", new Object[]{schema.getGeneratedClassName()});
                methodBuilderSync.addCode("\n$>", new Object[0]);
                if (managedTransationStatus) {
                    methodBuilderSync.addCode("return ", new Object[0]);
                }
                methodBuilderAsync.addCode("return $L.this.executeAsync(daoFactory -> { ", new Object[]{schema.getGeneratedClassName()});
                methodBuilderAsync.addCode("\n$>if (daoFactory.$L(", new Object[]{item.getSimpleName().toString()});
                String string = "";
                for (VariableElement variableElement : item.getParameters()) {
                    void var9_13;
                    if (daoNames.contains(TypeUtility.typeName(variableElement.asType()).toString())) continue;
                    methodBuilderAsync.addCode((String)var9_13 + variableElement.getSimpleName().toString(), new Object[0]);
                    String string2 = ", ";
                }
                methodBuilderAsync.addCode(")==true) { return $T.COMMIT; } else { return $T.ROLLBACK; }", new Object[]{TransactionResult.class, TransactionResult.class});
                methodBuilderAsync.addCode("$<\n});\n", new Object[0]);
                methodBuilderSync.addCode(((TypeElement)schema.getElement()).getSimpleName() + "." + item.getSimpleName().toString() + "(", new Object[0]);
                String separator = "";
                for (VariableElement variableElement : item.getParameters()) {
                    methodBuilderSync.addCode(separator, new Object[0]);
                    if (daoNames.contains(TypeUtility.typeName(variableElement.asType()).toString())) {
                        methodBuilderSync.addCode("daoFactory.get" + TypeUtility.simpleName(TypeUtility.typeName(variableElement.asType())) + "()", new Object[0]);
                    } else {
                        methodBuilderSync.addCode("" + variableElement.getSimpleName(), new Object[0]);
                    }
                    separator = ", ";
                }
                methodBuilderSync.addCode(");", new Object[0]);
                if (!managedTransationStatus) {
                    methodBuilderSync.addCode("\nreturn TransactionResult.COMMIT;", new Object[0]);
                }
                methodBuilderSync.addCode("$<\n", new Object[0]);
                methodBuilderSync.addCode("});\n", new Object[0]);
            }
            classBuilder.addMethod(methodBuilderSync.build());
            classBuilder.addMethod(methodBuilderAsync.build());
        }
    }
}

