/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.Cursor;
import com.abubusoft.kripton.android.annotation.BindSqlPageSize;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.sqlite.OnReadBeanListener;
import com.abubusoft.kripton.android.sqlite.OnReadCursorListener;
import com.abubusoft.kripton.android.sqlite.PagedResultImpl;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.KriptonClassNotFoundException;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.SelectBeanHelper;
import com.abubusoft.kripton.processor.sqlite.SelectBeanListHelper;
import com.abubusoft.kripton.processor.sqlite.SelectBeanListenerHelper;
import com.abubusoft.kripton.processor.sqlite.SelectPaginatedResultHelper;
import com.abubusoft.kripton.processor.sqlite.SelectRawHelper;
import com.abubusoft.kripton.processor.sqlite.SelectRawListenerHelper;
import com.abubusoft.kripton.processor.sqlite.SelectScalarHelper;
import com.abubusoft.kripton.processor.sqlite.SelectScalarListHelper;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.lang.model.element.TypeElement;

public abstract class SelectBuilderUtility {
    public static TypeName extractReturnType(SQLiteModelMethod method) {
        SQLiteEntity daoEntity = method.getParent().getEntity();
        TypeName returnTypeName = method.getReturnClass();
        Object result = null;
        if (TypeUtility.isTypeIncludedIn(returnTypeName, new Type[]{Void.class, Void.TYPE})) {
            Pair<String, TypeName> foundElement = SqlBuilderHelper.searchInEachParameter(method, new SqlBuilderHelper.OnParameterListener(){

                @Override
                public boolean onParameter(Pair<String, TypeName> item) {
                    return item.value1 instanceof ParameterizedTypeName && TypeUtility.isEquals((TypeName)((ParameterizedTypeName)item.value1).rawType, OnReadBeanListener.class.getName());
                }
            });
            if (foundElement != null) {
                result = (TypeName)((ParameterizedTypeName)foundElement.value1).typeArguments.get(0);
            }
        } else if (TypeUtility.isTypeIncludedIn(returnTypeName, new Type[]{Cursor.class})) {
            result = null;
        } else if (returnTypeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName returnParameterizedTypeName = (ParameterizedTypeName)returnTypeName;
            ClassName returnParameterizedClassName = returnParameterizedTypeName.rawType;
            AssertKripton.assertTrueOrInvalidMethodSignException(returnParameterizedTypeName.typeArguments.size() == 1, method, "return type %s is not supported", returnTypeName);
            TypeName elementName = (TypeName)returnParameterizedTypeName.typeArguments.get(0);
            Class<?> wrapperClazz = null;
            try {
                wrapperClazz = Class.forName(returnParameterizedClassName.toString());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new KriptonClassNotFoundException(e);
            }
            result = PagedResultImpl.class.isAssignableFrom(wrapperClazz) || Collection.class.isAssignableFrom(wrapperClazz) ? (SQLTransformer.isSupportedJDKType(elementName) || TypeUtility.isByteArray(elementName) ? null : elementName) : null;
        } else {
            result = TypeUtility.isEquals(returnTypeName, daoEntity) ? null : (SQLTransformer.isSupportedJDKType(returnTypeName) || TypeUtility.isByteArray(returnTypeName) ? null : returnTypeName);
        }
        if (result == null || TypeUtility.isEquals(result, daoEntity)) {
            return null;
        }
        return result;
    }

    public static SelectType detectSelectType(SQLiteModelMethod method) {
        SQLiteEntity entity = method.getEntity();
        SelectType selectResultType = null;
        TypeName returnTypeName = method.getReturnClass();
        ParameterizedTypeName readBeanListener = ParameterizedTypeName.get((ClassName)ClassName.get(OnReadBeanListener.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)((TypeElement)entity.getElement()))});
        ClassName readCursorListener = ClassName.get(OnReadCursorListener.class);
        ModelAnnotation annotation = method.getAnnotation(BindSqlSelect.class);
        int pageSize = annotation.getAttributeAsInt(AnnotationAttributeType.PAGE_SIZE);
        AssertKripton.failWithInvalidMethodSignException(pageSize < 0, method, "@%s#%s must be set with positive number", BindSqlSelect.class.getSimpleName(), AnnotationAttributeType.PAGE_SIZE.getValue());
        AssertKripton.failWithInvalidMethodSignException(pageSize > 0 && method.hasDynamicPageSizeConditions(), method, "can not define @%s#%s and mark a method parameter with @%s ", BindSqlSelect.class.getSimpleName(), BindSqlPageSize.class.getSimpleName(), AnnotationAttributeType.PAGE_SIZE.getValue());
        if (TypeUtility.isTypeIncludedIn(returnTypeName, new Type[]{Void.class, Void.TYPE})) {
            if (SqlBuilderHelper.hasParameterOfType(method, (TypeName)readCursorListener)) {
                selectResultType = SelectType.LISTENER_CURSOR;
            } else if (SqlBuilderHelper.hasParameterOfType(method, (TypeName)readBeanListener)) {
                selectResultType = SelectType.LISTENER_BEAN;
            }
        } else if (TypeUtility.isTypeIncludedIn(returnTypeName, new Type[]{Cursor.class})) {
            selectResultType = SelectType.CURSOR;
        } else if (returnTypeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName returnParameterizedTypeName = (ParameterizedTypeName)returnTypeName;
            ClassName returnParameterizedClassName = returnParameterizedTypeName.rawType;
            AssertKripton.assertTrueOrInvalidMethodSignException(returnParameterizedTypeName.typeArguments.size() == 1, method, "return type %s is not supported", returnTypeName);
            TypeName elementName = (TypeName)returnParameterizedTypeName.typeArguments.get(0);
            Class<?> wrapperClazz = null;
            try {
                wrapperClazz = Class.forName(returnParameterizedClassName.toString());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new KriptonClassNotFoundException(e);
            }
            if (PagedResultImpl.class.isAssignableFrom(wrapperClazz)) {
                AssertKripton.assertTrueOrInvalidMethodSignException(method.hasDynamicPageSizeConditions() || pageSize > 0, method, "use of PaginatedResult requires 'pageSize' attribute or a @%s annotated parameter", returnTypeName, BindSqlPageSize.class.getSimpleName());
                AssertKripton.assertTrueOrInvalidMethodSignException(TypeUtility.isEquals(elementName, entity.getName().toString()), method, "return type %s is not supported", returnTypeName);
                selectResultType = SelectType.PAGED_RESULT;
                method.paginatedResultName = "paginatedResult";
            } else if (Collection.class.isAssignableFrom(wrapperClazz)) {
                if (TypeUtility.isEquals(elementName, entity.getName().toString())) {
                    selectResultType = SelectType.LIST_BEAN;
                } else if (SQLTransformer.isSupportedJDKType(elementName) || TypeUtility.isByteArray(elementName)) {
                    selectResultType = SelectType.LIST_SCALAR;
                } else {
                    AssertKripton.failWithInvalidMethodSignException(true, method, "%s is an invalid return type", method.getReturnClass());
                }
            }
        } else if (TypeUtility.isEquals(returnTypeName, entity)) {
            selectResultType = SelectType.BEAN;
        } else if (SQLTransformer.isSupportedJDKType(returnTypeName) || TypeUtility.isByteArray(returnTypeName)) {
            selectResultType = SelectType.SCALAR;
        }
        AssertKripton.assertTrueOrInvalidMethodSignException(selectResultType != null, method, "'%s' as return type is not supported", returnTypeName);
        return selectResultType;
    }

    public static enum SelectType {
        BEAN(SelectBeanHelper.class, true),
        CURSOR(SelectRawHelper.class, false),
        LIST_BEAN(SelectBeanListHelper.class, true),
        LIST_SCALAR(SelectScalarListHelper.class, false),
        LISTENER_BEAN(SelectBeanListenerHelper.class, true),
        LISTENER_CURSOR(SelectRawListenerHelper.class, false),
        PAGED_RESULT(SelectPaginatedResultHelper.class, true),
        SCALAR(SelectScalarHelper.class, false);

        private SelectCodeGenerator codeGenerator;
        private boolean mapFields;

        private SelectType(Class<? extends AbstractSelectCodeGenerator> codeGenerator, boolean mapFields) {
            try {
                this.mapFields = mapFields;
                this.codeGenerator = codeGenerator.newInstance();
                this.codeGenerator.setSelectResultTye(this);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }

        public void generate(TypeSpec.Builder builder, SQLiteModelMethod method) {
            this.codeGenerator.generate(builder, this.isMapFields(), method);
        }

        public boolean isMapFields() {
            return this.mapFields;
        }

        public void generateLiveData(TypeSpec.Builder builder, SQLiteModelMethod method) {
            this.codeGenerator.generateLiveData(builder, method);
        }
    }

    public static interface SelectCodeGenerator {
        public void generate(TypeSpec.Builder var1, boolean var2, SQLiteModelMethod var3);

        public void generateLiveData(TypeSpec.Builder var1, SQLiteModelMethod var2);

        public void setSelectResultTye(SelectType var1);
    }
}

