/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;

public class SelectScalarHelper
extends AbstractSelectCodeGenerator {
    @Override
    public void generateSpecializedPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean mapFields) {
        TypeName returnTypeName = method.getReturnClass();
        AssertKripton.assertTrueOrInvalidMethodSignException(fieldList.size() == 1, method, "no way to understand which field is the result for this method", new Object[0]);
        SQLTransform t = SQLTransformer.lookup(returnTypeName);
        methodBuilder.addCode("$T result=", new Object[]{returnTypeName});
        t.generateDefaultValue(methodBuilder);
        methodBuilder.addCode(";\n", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        if (TypeUtility.isNullable(returnTypeName)) {
            methodBuilder.addCode("if (_cursor.isNull(0)) { return null; }\n", new Object[0]);
        } else {
            methodBuilder.addCode("if (_cursor.isNull(0)) { return ", new Object[0]);
            t.generateDefaultValue(methodBuilder);
            methodBuilder.addCode("; }\n", new Object[]{t});
        }
        methodBuilder.addCode("result=", new Object[0]);
        t.generateReadValueFromCursor(methodBuilder, method.getParent(), returnTypeName, "_cursor", "0");
        methodBuilder.addCode(";\n", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("return result;\n", new Object[0]);
        methodBuilder.endControlFlow();
    }
}

