/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.MethodParameterNotFoundException;
import com.abubusoft.kripton.processor.exceptions.PropertyInAnnotationNotFoundException;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.util.Elements;

public class SqlAnalyzer {
    public static String PARAM_PREFIX = ":";
    public static String PARAM_SUFFIX = "";
    public static String PARAM_PATTERN = "(\\$\\{\\s*([\\w._]*)\\s*\\})|(\\:\\{\\s*([\\w._]*)\\s*\\})|(\\:\\s*([\\w._]*))";
    private final Pattern PARAMETER = Pattern.compile(PARAM_PATTERN);
    private final Pattern WORD = Pattern.compile("([_a-zA-Z]\\w*)");
    Converter<String, String> propertyConverter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private List<String> paramNames;
    private List<TypeName> paramTypeNames;
    private List<String> usedBeanPropertyNames;
    private List<String> paramGetters;
    private String sqlStatement;
    private Set<String> usedMethodParameters;

    public static String extractParamName(Matcher matcher) {
        int index = StringUtils.hasText((String)matcher.group(2)) ? 2 : (StringUtils.hasText((String)matcher.group(4)) ? 4 : 6);
        return matcher.group(index);
    }

    public List<TypeName> getParamTypeNames() {
        return this.paramTypeNames;
    }

    public List<String> getParamNames() {
        return this.paramNames;
    }

    public List<String> getParamGetters() {
        return this.paramGetters;
    }

    public Set<String> getUsedMethodParameters() {
        return this.usedMethodParameters;
    }

    public void execute(Elements elementUtils, SQLiteModelMethod method, String sqlStatement) {
        SQLiteEntity entity = method.getEntity();
        this.usedMethodParameters = new HashSet<String>();
        this.paramNames = new ArrayList<String>();
        this.paramGetters = new ArrayList<String>();
        this.usedBeanPropertyNames = new ArrayList<String>();
        this.paramTypeNames = new ArrayList<TypeName>();
        Matcher matcher = this.PARAMETER.matcher(sqlStatement);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "?");
            this.paramNames.add(SqlAnalyzer.extractParamName(matcher));
        }
        matcher.appendTail(buffer);
        sqlStatement = buffer.toString();
        matcher = this.WORD.matcher(sqlStatement);
        buffer = new StringBuffer();
        while (matcher.find()) {
            SQLProperty property = (SQLProperty)entity.findPropertyByName(matcher.group(1));
            if (property == null) continue;
            matcher.appendReplacement(buffer, property.columnName);
        }
        matcher.appendTail(buffer);
        sqlStatement = buffer.toString();
        for (String rawName : this.paramNames) {
            JQLChecker.JQLParameterName pName = JQLChecker.JQLParameterName.parse(rawName);
            if (!pName.isNested()) {
                String effectiveName = method.findParameterNameByAlias(pName.getValue());
                TypeName rawNameType = method.findParameterTypeByAliasOrName(effectiveName);
                if (rawNameType == null) {
                    throw new MethodParameterNotFoundException(method, effectiveName);
                }
                this.paramGetters.add(effectiveName);
                this.paramTypeNames.add(rawNameType);
                this.usedMethodParameters.add(effectiveName);
                this.usedBeanPropertyNames.add(null);
                continue;
            }
            if (method.findParameterTypeByAliasOrName(pName.getBeanName()) == null) {
                throw new MethodParameterNotFoundException(method, pName.getBeanName());
            }
            if (TypeUtility.isEquals(method.findParameterTypeByAliasOrName(pName.getBeanName()), entity) && entity.contains(pName.getValue())) {
                this.paramGetters.add(method.findParameterNameByAlias(pName.getBeanName()) + "." + this.getter((ModelProperty)entity.findPropertyByName(pName.getValue())));
                this.usedBeanPropertyNames.add(pName.getValue());
                this.paramTypeNames.add(TypeUtility.typeName(((SQLProperty)entity.findPropertyByName(pName.getValue())).getElement().asType()));
                this.usedMethodParameters.add(method.findParameterNameByAlias(pName.getBeanName()));
                continue;
            }
            throw new PropertyInAnnotationNotFoundException(method, pName.getValue());
        }
        this.sqlStatement = sqlStatement;
    }

    public List<String> getUsedBeanPropertyNames() {
        return this.usedBeanPropertyNames;
    }

    public String getter(ModelProperty property) {
        if (property.isPublicField()) {
            return property.getName();
        }
        if (property.isFieldWithGetter()) {
            return "get" + (String)this.propertyConverter.convert((Object)property.getName()) + "()";
        }
        if (property.isFieldWithIs()) {
            return "is" + (String)this.propertyConverter.convert((Object)property.getName()) + "()";
        }
        return null;
    }

    public String setter(ModelProperty property) {
        if (property.isPublicField()) {
            return property.getName();
        }
        if (property.isFieldWithGetter() || property.isFieldWithIs()) {
            return "set" + (String)this.propertyConverter.convert((Object)property.getName());
        }
        return null;
    }

    public String getSQLStatement() {
        return this.sqlStatement;
    }
}

