/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.exceptions.MethodParameterNotFoundException;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlUtility {
    private static final Pattern PARAMETER = Pattern.compile(SqlAnalyzer.PARAM_PATTERN);
    private static final Pattern WORD = Pattern.compile("([_a-zA-Z]\\w*)");

    public static Pair<String, List<Pair<String, TypeName>>> extractParametersFromString(String value, SQLiteModelMethod method, SQLiteEntity entity) {
        String whereStatement = value;
        Pair result = new Pair();
        result.value1 = new ArrayList();
        Matcher matcher = PARAMETER.matcher(whereStatement);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "?");
            String paramName = SqlAnalyzer.extractParamName(matcher);
            TypeName paramType = method.findParameterTypeByAliasOrName(paramName);
            if (paramType == null) {
                throw new MethodParameterNotFoundException(method, paramName);
            }
            ((List)result.value1).add(new Pair((Object)paramName, (Object)paramType));
        }
        matcher.appendTail(buffer);
        whereStatement = buffer.toString();
        matcher = WORD.matcher(whereStatement);
        StringBuffer buffer2 = new StringBuffer();
        while (matcher.find()) {
            ModelProperty property = (ModelProperty)entity.findPropertyByName(matcher.group(1));
            if (property == null) continue;
            matcher.appendReplacement(buffer2, ((SQLProperty)entity.findPropertyByName((String)matcher.group((int)1))).columnName);
        }
        matcher.appendTail(buffer2);
        whereStatement = buffer2.toString();
        result.value0 = whereStatement;
        return result;
    }

    public static ClassName defineCollection(TypeName listClazzName) {
        try {
            Class clazz = null;
            if (listClazzName instanceof ParameterizedTypeName) {
                ParameterizedTypeName returnListName = (ParameterizedTypeName)listClazzName;
                clazz = Class.forName(returnListName.rawType.toString());
            } else {
                clazz = Class.forName(listClazzName.toString());
            }
            if (clazz.isAssignableFrom(List.class)) {
                clazz = ArrayList.class;
            } else if (clazz.isAssignableFrom(Set.class)) {
                clazz = LinkedHashSet.class;
            } else if (clazz.isAssignableFrom(Collection.class)) {
                clazz = ArrayList.class;
            }
            return ClassName.get(clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

