/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.grammars.jql;

import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindSqlDelete;
import com.abubusoft.kripton.android.annotation.BindSqlDynamicOrderBy;
import com.abubusoft.kripton.android.annotation.BindSqlInsert;
import com.abubusoft.kripton.android.annotation.BindSqlPageSize;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.annotation.BindSqlUpdate;
import com.abubusoft.kripton.android.sqlite.ConflictAlgorithmType;
import com.abubusoft.kripton.common.CollectionUtils;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.IncompatibleAttributesInAnnotationException;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlInsertBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlModifyBuilder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlBaseListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public abstract class JQLBuilder {
    public static JQL buildJQL(final SQLiteModelMethod method, String preparedJql) {
        HashMap<JQL.JQLDynamicStatementType, String> dynamicReplace = new HashMap<JQL.JQLDynamicStatementType, String>();
        final JQL result = new JQL();
        JQLBuilder.forEachParameter(method, new OnMethodParameterListener(){

            @Override
            public void onMethodParameter(VariableElement item) {
                if (((TypeElement)method.getEntity().getElement()).asType().equals(item.asType())) {
                    result.paramBean = item.getSimpleName().toString();
                }
            }
        });
        result.declarationType = JQL.JQLDeclarationType.JQL_COMPACT;
        if (StringUtils.hasText((String)preparedJql)) {
            result.declarationType = JQL.JQLDeclarationType.JQL_EXPLICIT;
        }
        if (method.hasAnnotation(BindSqlSelect.class)) {
            JQLBuilder.checkFieldsDefinitions(method, BindSqlSelect.class);
            return JQLBuilder.buildJQLSelect(method, result, dynamicReplace, preparedJql);
        }
        if (method.hasAnnotation(BindSqlInsert.class)) {
            JQLBuilder.checkFieldsDefinitions(method, BindSqlInsert.class);
            return JQLBuilder.buildJQLInsert(method, result, preparedJql);
        }
        if (method.hasAnnotation(BindSqlUpdate.class)) {
            JQLBuilder.checkFieldsDefinitions(method, BindSqlUpdate.class);
            return JQLBuilder.buildJQLUpdate(method, result, dynamicReplace, preparedJql);
        }
        if (method.hasAnnotation(BindSqlDelete.class)) {
            return JQLBuilder.buildJQLDelete(method, result, dynamicReplace, preparedJql);
        }
        return null;
    }

    private static void checkFieldsDefinitions(SQLiteModelMethod method, Class<? extends Annotation> annotation) {
        List<String> includedFields = AnnotationUtility.extractAsStringArray(method.getElement(), annotation, AnnotationAttributeType.FIELDS);
        List<String> excludedFields = AnnotationUtility.extractAsStringArray(method.getElement(), annotation, AnnotationAttributeType.EXCLUDED_FIELDS);
        if (includedFields.size() > 0 && excludedFields.size() > 0) {
            throw new IncompatibleAttributesInAnnotationException(method.getParent(), method, method.getAnnotation(annotation), AnnotationAttributeType.FIELDS, AnnotationAttributeType.EXCLUDED_FIELDS);
        }
    }

    private static JQL buildJQLDelete(SQLiteModelMethod method, final JQL result, final Map<JQL.JQLDynamicStatementType, String> dynamicReplace, String preparedJql) {
        SQLiteDaoDefinition dao = method.getParent();
        if (StringUtils.hasText((String)preparedJql)) {
            result.value = preparedJql;
            JQLChecker.getInstance().analyze(method, result, new JqlBaseListener(){

                @Override
                public void enterBind_parameter(JqlParser.Bind_parameterContext ctx) {
                    ++result.bindParameterOnWhereStatementCounter;
                }

                @Override
                public void enterBind_dynamic_sql(JqlParser.Bind_dynamic_sqlContext ctx) {
                    JQL.JQLDynamicStatementType dynamicType = JQL.JQLDynamicStatementType.valueOf(ctx.bind_parameter_name().getText().toUpperCase());
                    int start = ctx.getStart().getStartIndex() - 1;
                    int stop = ctx.getStop().getStopIndex() + 1;
                    String dynamicWhere = result.value.substring(start, stop);
                    dynamicReplace.put(dynamicType, dynamicWhere);
                }
            });
            JQLChecker.getInstance().replaceVariableStatements(method, preparedJql, new JQLReplaceVariableStatementListenerImpl(){

                @Override
                public String onWhere(String statement) {
                    result.annotatedWhere = true;
                    result.staticWhereConditions = true;
                    return null;
                }
            });
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("DELETE FROM");
            builder.append(" " + dao.getEntitySimplyClassName());
            builder.append(JQLBuilder.defineWhereStatement(method, result, BindSqlDelete.class, dynamicReplace));
            result.value = builder.toString();
        }
        result.operationType = JQL.JQLType.DELETE;
        result.dynamicReplace = dynamicReplace;
        return result;
    }

    private static JQL buildJQLInsert(SQLiteModelMethod method, final JQL result, String preparedJql) {
        if (StringUtils.hasText((String)preparedJql)) {
            result.value = preparedJql;
            final One inColumnValueSet = new One((Object)false);
            final One inWhereStatement = new One((Object)false);
            JQLChecker.getInstance().analyze(method, result, new JqlBaseListener(){

                @Override
                public void enterConflict_algorithm(JqlParser.Conflict_algorithmContext ctx) {
                    result.conflictAlgorithmType = ConflictAlgorithmType.valueOf((String)ctx.getText().toUpperCase());
                }

                @Override
                public void enterProjected_columns(JqlParser.Projected_columnsContext ctx) {
                    result.containsSelectOperation = true;
                }

                @Override
                public void enterWhere_stmt(JqlParser.Where_stmtContext ctx) {
                    inWhereStatement.value0 = true;
                }

                @Override
                public void exitWhere_stmt(JqlParser.Where_stmtContext ctx) {
                    inWhereStatement.value0 = false;
                }

                @Override
                public void enterColumn_value_set(JqlParser.Column_value_setContext ctx) {
                    inColumnValueSet.value0 = true;
                }

                @Override
                public void exitColumn_value_set(JqlParser.Column_value_setContext ctx) {
                    inColumnValueSet.value0 = false;
                }

                @Override
                public void enterBind_parameter(JqlParser.Bind_parameterContext ctx) {
                    if (((Boolean)inWhereStatement.value0).booleanValue()) {
                        ++result.bindParameterOnWhereStatementCounter;
                    } else if (((Boolean)inColumnValueSet.value0).booleanValue()) {
                        ++result.bindParameterAsColumnValueCounter;
                    }
                    AssertKripton.assertTrue((Boolean)inWhereStatement.value0 != false || (Boolean)inColumnValueSet.value0 != false, "unknown situation!", new Object[0]);
                }
            });
            if (result.containsSelectOperation) {
                AssertKripton.assertTrueOrInvalidMethodSignException(method.getReturnClass().equals((Object)TypeName.VOID), method, "defined JQL requires that method's return type is void", new Object[0]);
            }
        } else {
            Class<BindSqlInsert> annotation = BindSqlInsert.class;
            SQLiteDaoDefinition dao = method.getParent();
            One includePrimaryKey = new One((Object)AnnotationUtility.extractAsBoolean(method.getElement(), annotation, AnnotationAttributeType.INCLUDE_PRIMARY_KEY));
            if (method.getEntity().getPrimaryKey().columnType == ColumnType.PRIMARY_KEY_UNMANGED) {
                includePrimaryKey.value0 = true;
            }
            SqlInsertBuilder.InsertType insertResultType = SqlInsertBuilder.detectInsertType(method);
            HashSet<String> fields = new HashSet();
            switch (insertResultType) {
                case INSERT_BEAN: 
                case INSERT_LIST_BEAN: {
                    fields = JQLBuilder.extractFieldsFromAnnotation(method, annotation, (Boolean)includePrimaryKey.value0);
                    break;
                }
                case INSERT_RAW: {
                    fields = JQLBuilder.extractFieldsFromMethodParameters(method, annotation);
                }
            }
            AssertKripton.assertTrueOrInvalidMethodSignException(fields.size() > 0, method, "no field is included in this query", new Object[0]);
            result.conflictAlgorithmType = ConflictAlgorithmType.valueOf((String)AnnotationUtility.extractAsEnumerationValue(method.getElement(), annotation, AnnotationAttributeType.CONFLICT_ALGORITHM_TYPE));
            StringBuilder builder = new StringBuilder();
            builder.append("INSERT");
            builder.append(" " + result.conflictAlgorithmType.getSqlForInsert());
            builder.append("INTO");
            builder.append(" " + dao.getEntitySimplyClassName());
            builder.append(" (");
            builder.append(JQLBuilder.forEachFields(fields, new OnFieldListener(){

                @Override
                public String onField(String item) {
                    return item;
                }
            }));
            builder.append(") ");
            builder.append("VALUES");
            final One prefix = new One((Object)"");
            if (result.hasParamBean()) {
                prefix.value0 = result.paramBean + ".";
            }
            builder.append(" (");
            builder.append(JQLBuilder.forEachFields(fields, new OnFieldListener(){

                @Override
                public String onField(String item) {
                    return SqlAnalyzer.PARAM_PREFIX + (String)prefix.value0 + item + SqlAnalyzer.PARAM_SUFFIX;
                }
            }));
            builder.append(")");
            result.value = builder.toString();
        }
        result.operationType = JQL.JQLType.INSERT;
        result.dynamicReplace = new HashMap<JQL.JQLDynamicStatementType, String>();
        return result;
    }

    private static Set<String> extractFieldsFromMethodParameters(SQLiteModelMethod method, Class<? extends Annotation> annotationClazz) {
        String annotatedWhere = AnnotationUtility.extractAsString(method.getElement(), annotationClazz, AnnotationAttributeType.WHERE);
        LinkedHashSet<String> annotatedFieldValues = new LinkedHashSet<String>();
        LinkedHashSet<JQLPlaceHolder> parametersUsedInWhereConditions = new LinkedHashSet();
        if (StringUtils.hasText((String)annotatedWhere)) {
            parametersUsedInWhereConditions = JQLChecker.getInstance().extractPlaceHoldersFromVariableStatementAsSet(method, "WHERE " + annotatedWhere);
        }
        for (Pair<String, TypeName> param : method.getParameters()) {
            String nameUsed = method.findParameterAliasByName((String)param.value0);
            if (method.isThisDynamicWhereConditionsName(nameUsed) || method.isThisDynamicWhereArgsName(nameUsed) || JQLBuilder.isInSet(nameUsed, parametersUsedInWhereConditions)) continue;
            annotatedFieldValues.add(nameUsed);
        }
        return annotatedFieldValues;
    }

    private static JQL buildJQLSelect(final SQLiteModelMethod method, final JQL result, final Map<JQL.JQLDynamicStatementType, String> dynamicReplace, String preparedJql) {
        Class<BindSqlSelect> annotation = BindSqlSelect.class;
        SQLiteDaoDefinition dao = method.getParent();
        if (StringUtils.hasText((String)preparedJql)) {
            result.value = preparedJql;
            JQLChecker.getInstance().analyze(method, result, new JqlBaseListener(){

                @Override
                public void enterBind_dynamic_sql(JqlParser.Bind_dynamic_sqlContext ctx) {
                    JQL.JQLDynamicStatementType dynamicType = JQL.JQLDynamicStatementType.valueOf(ctx.bind_parameter_name().getText().toUpperCase());
                    int start = ctx.getStart().getStartIndex() - 1;
                    int stop = ctx.getStop().getStopIndex() + 1;
                    String dynamicWhere = result.value.substring(start, stop);
                    dynamicReplace.put(dynamicType, dynamicWhere);
                }
            });
            JQLChecker.getInstance().replaceVariableStatements(method, preparedJql, new JQLReplaceVariableStatementListenerImpl(){

                @Override
                public String onWhere(String statement) {
                    result.annotatedWhere = true;
                    result.staticWhereConditions = true;
                    return null;
                }

                @Override
                public String onOrderBy(String statement) {
                    result.annotatedOrderBy = true;
                    result.staticOrderBy = true;
                    return null;
                }

                @Override
                public String onOffset(String statement) {
                    result.annotatedOffset = true;
                    return null;
                }

                @Override
                public String onLimit(String statement) {
                    result.annotatedLimit = true;
                    return null;
                }

                @Override
                public String onHaving(String statement) {
                    result.annotatedHaving = true;
                    return null;
                }

                @Override
                public String onGroup(String statement) {
                    result.annotatedGroupBy = true;
                    return null;
                }
            });
            JQLBuilder.forEachParameter(method, new OnMethodParameterListener(){

                @Override
                public void onMethodParameter(VariableElement methodParam) {
                    if (methodParam.getAnnotation(BindSqlDynamicOrderBy.class) != null) {
                        String orderDynamicName;
                        result.paramOrderBy = orderDynamicName = methodParam.getSimpleName().toString();
                        AssertKripton.assertTrueOrInvalidTypeForAnnotationMethodParameterException(TypeUtility.isEquals(TypeUtility.typeName(String.class), TypeUtility.typeName(methodParam)), method.getParent().getElement(), (ExecutableElement)method.getElement(), methodParam, BindSqlDynamicOrderBy.class);
                    }
                }
            });
        } else {
            LinkedHashSet<String> fields = JQLBuilder.extractFieldsFromAnnotation(method, BindSqlSelect.class, true);
            boolean distinct = AnnotationUtility.extractAsBoolean(method.getElement(), annotation, AnnotationAttributeType.DISTINCT);
            String annotatedGroupBy = AnnotationUtility.extractAsString(method.getElement(), annotation, AnnotationAttributeType.GROUP_BY);
            String annotatedHaving = AnnotationUtility.extractAsString(method.getElement(), annotation, AnnotationAttributeType.HAVING);
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT ");
            if (distinct) {
                builder.append("DISTINCT ");
            }
            builder.append(JQLBuilder.forEachFields(fields, new OnFieldListener(){

                @Override
                public String onField(String item) {
                    return item;
                }
            }));
            builder.append(" FROM " + dao.getEntitySimplyClassName());
            builder.append(JQLBuilder.defineWhereStatement(method, result, annotation, dynamicReplace));
            if (StringUtils.hasText((String)annotatedGroupBy)) {
                result.annotatedGroupBy = true;
                builder.append(" GROUP BY " + annotatedGroupBy);
            }
            if (StringUtils.hasText((String)annotatedHaving)) {
                result.annotatedHaving = true;
                builder.append(" HAVING " + annotatedHaving);
            }
            builder.append(JQLBuilder.defineOrderByStatement(method, result, annotation, dynamicReplace));
            builder.append(JQLBuilder.defineLimitStatement(method, result, annotation, dynamicReplace));
            result.value = builder.toString();
        }
        result.value = JQLChecker.getInstance().replace((JQLContext)method, result.value, (JQLReplacerListener)new JQLReplacerListenerImpl(method, true){

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                if (inStatement) {
                    TypeName typeName = method.findParameterType(method.findParameterNameByAlias(bindParameterName));
                    AssertKripton.assertTrueOrInvalidMethodSignException(typeName != null && (TypeUtility.isArray(typeName) || TypeUtility.isCollection(typeName)), method, "'in' condition need an array or collection parameter", new Object[0]);
                    String dynamicSpread = bindParameterName;
                    dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_SPREAD, dynamicSpread);
                    result.spreadParams.add(dynamicSpread);
                    return null;
                }
                return null;
            }
        });
        if (method.isPagedLiveData()) {
            dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_PAGE_OFFSET, "");
            dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_PAGE_SIZE, "");
        }
        result.operationType = JQL.JQLType.SELECT;
        result.dynamicReplace = dynamicReplace;
        return result;
    }

    private static JQL buildJQLUpdate(SQLiteModelMethod method, final JQL result, final Map<JQL.JQLDynamicStatementType, String> dynamicReplace, String preparedJql) {
        Class<BindSqlUpdate> annotation = BindSqlUpdate.class;
        if (StringUtils.hasText((String)preparedJql)) {
            result.value = preparedJql;
            final One inWhereCondition = new One((Object)false);
            final One inColumnsToUpdate = new One((Object)false);
            JQLChecker.getInstance().analyze(method, result, new JqlBaseListener(){

                @Override
                public void enterProjected_columns(JqlParser.Projected_columnsContext ctx) {
                    if (((Boolean)inColumnsToUpdate.value0).booleanValue()) {
                        result.containsSelectOperation = true;
                    }
                }

                @Override
                public void enterConflict_algorithm(JqlParser.Conflict_algorithmContext ctx) {
                    result.conflictAlgorithmType = ConflictAlgorithmType.valueOf((String)ctx.getText().toUpperCase());
                }

                @Override
                public void enterWhere_stmt(JqlParser.Where_stmtContext ctx) {
                    inWhereCondition.value0 = true;
                }

                @Override
                public void exitWhere_stmt_clauses(JqlParser.Where_stmt_clausesContext ctx) {
                    inWhereCondition.value0 = false;
                }

                @Override
                public void enterBind_parameter(JqlParser.Bind_parameterContext ctx) {
                    if (((Boolean)inWhereCondition.value0).booleanValue()) {
                        ++result.bindParameterOnWhereStatementCounter;
                    } else {
                        ++result.bindParameterAsColumnValueCounter;
                    }
                }

                @Override
                public void enterBind_dynamic_sql(JqlParser.Bind_dynamic_sqlContext ctx) {
                    JQL.JQLDynamicStatementType dynamicType = JQL.JQLDynamicStatementType.valueOf(ctx.bind_parameter_name().getText().toUpperCase());
                    int start = ctx.getStart().getStartIndex() - 1;
                    int stop = ctx.getStop().getStopIndex() + 1;
                    String dynamicWhere = result.value.substring(start, stop);
                    dynamicReplace.put(dynamicType, dynamicWhere);
                }

                @Override
                public void enterColumns_to_update(JqlParser.Columns_to_updateContext ctx) {
                    inColumnsToUpdate.value0 = true;
                }

                @Override
                public void exitColumns_to_update(JqlParser.Columns_to_updateContext ctx) {
                    inColumnsToUpdate.value0 = false;
                }
            });
            JQLChecker.getInstance().replaceVariableStatements(method, preparedJql, new JQLReplaceVariableStatementListenerImpl(){

                @Override
                public String onWhere(String statement) {
                    result.annotatedWhere = true;
                    result.staticWhereConditions = true;
                    return null;
                }
            });
            if (result.containsSelectOperation) {
                AssertKripton.assertTrueOrInvalidMethodSignException(method.getReturnClass().equals((Object)TypeName.VOID), method, "defined JQL requires that method's return type is void", new Object[0]);
            }
        } else {
            SQLiteDaoDefinition dao = method.getParent();
            SqlModifyBuilder.ModifyType modifyType = SqlModifyBuilder.detectModifyType(method, JQL.JQLType.UPDATE);
            Set<String> fields = modifyType == SqlModifyBuilder.ModifyType.UPDATE_BEAN ? JQLBuilder.extractFieldsFromAnnotation(method, annotation, false) : JQLBuilder.extractFieldsFromMethodParameters(method, annotation);
            AssertKripton.assertTrueOrInvalidMethodSignException(fields.size() > 0, method, "no field was specified for update", new Object[0]);
            result.conflictAlgorithmType = ConflictAlgorithmType.valueOf((String)AnnotationUtility.extractAsEnumerationValue(method.getElement(), annotation, AnnotationAttributeType.CONFLICT_ALGORITHM_TYPE));
            StringBuilder builder = new StringBuilder();
            builder.append("UPDATE");
            builder.append(" " + result.conflictAlgorithmType.getSqlForInsert());
            builder.append(dao.getEntitySimplyClassName());
            final One prefix = new One((Object)"");
            if (result.hasParamBean()) {
                prefix.value0 = result.paramBean + ".";
            }
            builder.append(" SET ");
            builder.append(JQLBuilder.forEachFields(fields, new OnFieldListener(){

                @Override
                public String onField(String item) {
                    return item + "=" + SqlAnalyzer.PARAM_PREFIX + (String)prefix.value0 + item + SqlAnalyzer.PARAM_SUFFIX;
                }
            }));
            builder.append(JQLBuilder.defineWhereStatement(method, result, annotation, dynamicReplace));
            result.value = builder.toString();
        }
        result.operationType = JQL.JQLType.UPDATE;
        result.dynamicReplace = dynamicReplace;
        return result;
    }

    private static <A extends Annotation> LinkedHashSet<String> extractFieldsFromAnnotation(SQLiteModelMethod method, Class<A> annotationClazz, final boolean includePrimaryKey) {
        final SQLiteEntity entity = method.getEntity();
        List<String> annotatedFieldValues = AnnotationUtility.extractAsStringArray(method.getElement(), annotationClazz, AnnotationAttributeType.FIELDS);
        List<String> annotatedExcludedFieldValues = AnnotationUtility.extractAsStringArray(method.getElement(), annotationClazz, AnnotationAttributeType.EXCLUDED_FIELDS);
        CollectionUtils.trim(annotatedFieldValues);
        CollectionUtils.trim(annotatedExcludedFieldValues);
        final One count = new One((Object)0);
        final LinkedHashSet allFields = new LinkedHashSet();
        JQLBuilder.forEachFields(method, new OnPropertyListener(){

            @Override
            public void onProperty(SQLProperty item) {
                if (!item.isPrimaryKey() || item.isPrimaryKey() && includePrimaryKey) {
                    allFields.add(item.getName());
                }
                if (TypeUtility.isEquals(item.getPropertyType().getTypeName(), TypeUtility.typeName(entity.getElement()))) {
                    Integer n = (Integer)count.value0;
                    One one = count;
                    one.value0 = (Integer)one.value0 + 1;
                    Integer n2 = one.value0;
                }
            }
        });
        if (annotatedFieldValues.size() == 0 && annotatedExcludedFieldValues.size() == 0) {
            annotatedFieldValues.clear();
            annotatedFieldValues.addAll(allFields);
        } else if (annotatedExcludedFieldValues.size() > 0) {
            for (String fieldName : annotatedExcludedFieldValues) {
                if (entity.contains(fieldName)) continue;
                AssertKripton.failUnknownPropertyInJQLException(method, annotationClazz, AnnotationAttributeType.EXCLUDED_FIELDS, fieldName);
            }
            allFields.removeAll(annotatedExcludedFieldValues);
            annotatedFieldValues.clear();
            annotatedFieldValues.addAll(allFields);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(annotatedFieldValues);
        return result;
    }

    private static boolean isInSet(String value, Set<JQLPlaceHolder> parametersUsedInWhereConditions) {
        for (JQLPlaceHolder ph : parametersUsedInWhereConditions) {
            if (!ph.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    private static <L extends Annotation> String defineLimitStatement(final SQLiteModelMethod method, final JQL result, Class<L> annotation, Map<JQL.JQLDynamicStatementType, String> dynamicReplace) {
        StringBuilder builder = new StringBuilder();
        int pageSize = AnnotationUtility.extractAsInt(method.getElement(), annotation, AnnotationAttributeType.PAGE_SIZE);
        if (pageSize > 0) {
            result.annotatedPageSize = true;
        }
        final One pageDynamicName = new One(null);
        JQLBuilder.forEachParameter(method, new OnMethodParameterListener(){

            @Override
            public void onMethodParameter(VariableElement methodParam) {
                if (methodParam.getAnnotation(BindSqlPageSize.class) != null) {
                    pageDynamicName.value0 = methodParam.getSimpleName().toString();
                    result.paramPageSize = (String)pageDynamicName.value0;
                    AssertKripton.assertTrueOrInvalidTypeForAnnotationMethodParameterException(TypeUtility.isEquals(TypeName.INT, TypeUtility.typeName(methodParam)), method.getParent().getElement(), (ExecutableElement)method.getElement(), methodParam, BindSqlPageSize.class);
                }
            }
        });
        if (pageSize > 0 || StringUtils.hasText((String)((String)pageDynamicName.value0)) || method.isPagedLiveData()) {
            builder.append(" LIMIT ");
            if (pageSize > 0) {
                builder.append(pageSize);
            } else {
                String temp0 = "#{" + (Object)((Object)JQL.JQLDynamicStatementType.DYNAMIC_PAGE_SIZE) + "}";
                builder.append(temp0);
                dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_PAGE_SIZE, temp0);
            }
            String temp1 = " OFFSET #{" + (Object)((Object)JQL.JQLDynamicStatementType.DYNAMIC_PAGE_OFFSET) + "}";
            builder.append(temp1);
            dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_PAGE_OFFSET, temp1);
        }
        return builder.toString();
    }

    private static <L extends Annotation> String defineOrderByStatement(final SQLiteModelMethod method, final JQL result, Class<L> annotation, Map<JQL.JQLDynamicStatementType, String> dynamicReplace) {
        StringBuilder builder = new StringBuilder();
        String orderBy = AnnotationUtility.extractAsString(method.getElement(), annotation, AnnotationAttributeType.ORDER_BY);
        if (StringUtils.hasText((String)orderBy)) {
            result.annotatedOrderBy = true;
        }
        final One orderDynamicName = new One(null);
        JQLBuilder.forEachParameter(method, new OnMethodParameterListener(){

            @Override
            public void onMethodParameter(VariableElement methodParam) {
                if (methodParam.getAnnotation(BindSqlDynamicOrderBy.class) != null) {
                    orderDynamicName.value0 = methodParam.getSimpleName().toString();
                    result.paramOrderBy = (String)orderDynamicName.value0;
                    AssertKripton.assertTrueOrInvalidTypeForAnnotationMethodParameterException(TypeUtility.isEquals(TypeUtility.typeName(String.class), TypeUtility.typeName(methodParam)), method.getParent().getElement(), (ExecutableElement)method.getElement(), methodParam, BindSqlDynamicOrderBy.class);
                }
            }
        });
        if (StringUtils.hasText((String)orderBy) || StringUtils.hasText((String)((String)orderDynamicName.value0))) {
            builder.append(" ORDER BY");
            if (StringUtils.hasText((String)orderBy)) {
                result.staticOrderBy = true;
                builder.append(StringUtils.startWithSpace((String)orderBy));
            }
            StringBuilder dynamicBuffer = new StringBuilder();
            if (StringUtils.hasText((String)((String)orderDynamicName.value0))) {
                if (StringUtils.hasText((String)orderBy)) {
                    dynamicBuffer.append(",");
                    builder.append(",");
                }
                dynamicBuffer.append(" #{" + (Object)((Object)JQL.JQLDynamicStatementType.DYNAMIC_ORDER_BY) + "}");
                builder.append(" #{" + (Object)((Object)JQL.JQLDynamicStatementType.DYNAMIC_ORDER_BY) + "}");
                dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_ORDER_BY, dynamicBuffer.toString());
            }
        }
        return builder.toString();
    }

    private static <L extends Annotation> String defineWhereStatement(SQLiteModelMethod method, JQL jql, Class<L> annotation, Map<JQL.JQLDynamicStatementType, String> dynamicReplace) {
        StringBuilder builder = new StringBuilder();
        String where = AnnotationUtility.extractAsString(method.getElement(), annotation, AnnotationAttributeType.WHERE);
        if (StringUtils.hasText((String)where)) {
            jql.annotatedWhere = true;
        }
        if (StringUtils.hasText((String)where) || method.hasDynamicWhereConditions()) {
            builder.append(" WHERE");
            if (StringUtils.hasText((String)where)) {
                jql.staticWhereConditions = true;
                builder.append(StringUtils.startWithSpace((String)where));
            }
            if (StringUtils.hasText((String)method.dynamicWhereParameterName)) {
                StringBuilder dynamicBuffer = new StringBuilder();
                dynamicBuffer.append(" #{" + (Object)((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE) + "}");
                builder.append(" #{" + (Object)((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE) + "}");
                dynamicReplace.put(JQL.JQLDynamicStatementType.DYNAMIC_WHERE, dynamicBuffer.toString());
            }
        }
        return builder.toString();
    }

    private static String forEachFields(Set<String> fields, OnFieldListener listener) {
        StringBuilder builder = new StringBuilder();
        String comma = "";
        for (String item : fields) {
            builder.append(comma + listener.onField(item));
            comma = ", ";
        }
        return builder.toString();
    }

    private static void forEachFields(SQLiteModelMethod method, OnPropertyListener listener) {
        for (SQLProperty item : method.getEntity().getCollection()) {
            listener.onProperty(item);
        }
    }

    private static void forEachParameter(SQLiteModelMethod method, OnMethodParameterListener listener) {
        for (VariableElement variableElement : ((ExecutableElement)method.getElement()).getParameters()) {
            listener.onMethodParameter(variableElement);
        }
    }

    static interface OnPropertyListener {
        public void onProperty(SQLProperty var1);
    }

    static interface OnMethodParameterListener {
        public void onMethodParameter(VariableElement var1);
    }

    public static interface OnFieldListener {
        public String onField(String var1);
    }
}

