/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.grammars.jql;

import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.Finder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLBaseErrorListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlBaseListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlLexer;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class JQLChecker {
    protected static JQLChecker instance;
    ParseTreeWalker walker = new ParseTreeWalker();
    List<Triple<Token, Token, String>> replace = new ArrayList<Triple<Token, Token, String>>();

    public static final JQLChecker getInstance() {
        if (instance == null) {
            instance = new JQLChecker();
        }
        return instance;
    }

    private JQLChecker() {
    }

    protected <L extends JqlBaseListener> void analyzeInternal(JQLContext jqlContext, String jql, L listener) {
        this.walker.walk(listener, (ParseTree)this.prepareParser((JQLContext)jqlContext, (String)jql).value0);
    }

    protected <L extends JqlBaseListener> void analyzeVariableStatementInternal(JQLContext jqlContext, String jql, L listener) {
        this.walker.walk(listener, (ParseTree)this.prepareVariableStatement((JQLContext)jqlContext, (String)jql).value0);
    }

    public <L extends JqlBaseListener> void analyze(JQLContext jqlContext, JQL jql, L listener) {
        this.analyzeInternal(jqlContext, jql.value, listener);
    }

    protected Pair<ParserRuleContext, CommonTokenStream> prepareParser(final JQLContext jqlContext, final String jql) {
        JqlLexer lexer = new JqlLexer((CharStream)CharStreams.fromString((String)jql));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JqlParser parser = new JqlParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new JQLBaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                AssertKripton.assertTrue(false, jqlContext.getContextDescription() + ": unespected char at pos %s of SQL '%s'", charPositionInLine, jql);
            }
        });
        JqlParser.ParseContext context = parser.parse();
        return new Pair((Object)context, (Object)tokens);
    }

    protected Pair<ParserRuleContext, CommonTokenStream> prepareVariableStatement(final JQLContext jqlContext, final String jql) {
        JqlLexer lexer = new JqlLexer((CharStream)CharStreams.fromString((String)jql));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JqlParser parser = new JqlParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new JQLBaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                AssertKripton.assertTrue(false, jqlContext.getContextDescription() + ": unespected char at pos %s of JQL '%s'", charPositionInLine, jql);
            }
        });
        JqlParser.Parse_variableContext context = parser.parse_variable();
        return new Pair((Object)context, (Object)tokens);
    }

    public Set<JQLProjection> extractProjections(final JQLContext jqlContext, String jqlValue, final Finder<SQLProperty> entity) {
        final LinkedHashSet<JQLProjection> result = new LinkedHashSet<JQLProjection>();
        final One projection = new One(null);
        this.analyzeInternal(jqlContext, jqlValue, new JqlBaseListener(){

            @Override
            public void enterProjected_columns(JqlParser.Projected_columnsContext ctx) {
                if (projection.value0 == null) {
                    projection.value0 = true;
                }
            }

            @Override
            public void exitProjected_columns(JqlParser.Projected_columnsContext ctx) {
                projection.value0 = false;
            }

            @Override
            public void enterResult_column(JqlParser.Result_columnContext ctx) {
                if (!((Boolean)projection.value0).booleanValue()) {
                    return;
                }
                JQLProjection.ProjectionBuilder builder = JQLProjection.ProjectionBuilder.create();
                if (ctx.getText().endsWith("*")) {
                    builder.type(JQLProjection.ProjectionType.STAR);
                } else if (ctx.table_name() != null) {
                    builder.table(ctx.expr().table_name().getText());
                } else if (ctx.expr().column_fully_qualified_name() != null && ctx.expr().column_fully_qualified_name().column_simple_name() != null) {
                    Finder<SQLProperty> currentEntity = entity;
                    if (ctx.expr().column_fully_qualified_name().table_simple_name() != null) {
                        String entityName = ctx.expr().column_fully_qualified_name().table_simple_name().getText();
                        builder.table(entityName);
                        currentEntity = jqlContext.findEntityByName(entityName);
                    }
                    String jqlColumnName = ctx.expr().column_fully_qualified_name().column_simple_name().getText();
                    builder.column(jqlColumnName);
                    SQLProperty property = (SQLProperty)currentEntity.findPropertyByName(jqlColumnName);
                    AssertKripton.assertTrueOrUnknownPropertyInJQLException(property != null, jqlContext, jqlColumnName);
                    builder.property(property);
                    builder.type(JQLProjection.ProjectionType.COLUMN);
                    if (ctx.column_alias() != null) {
                        String columnAlias = ctx.column_alias().getText();
                        SQLProperty property1 = (SQLProperty)entity.findPropertyByName(columnAlias);
                        AssertKripton.assertTrueOrUnknownPropertyInJQLException(property1 != null, jqlContext, columnAlias);
                        builder.property(property1);
                        builder.alias(columnAlias);
                    }
                } else {
                    builder.type(JQLProjection.ProjectionType.COMPLEX);
                    builder.expression(ctx.expr().getText());
                    if (ctx.column_alias() != null) {
                        String columnAlias = ctx.column_alias().getText();
                        builder.alias(columnAlias);
                    }
                }
                result.add(builder.build());
            }

            @Override
            public void exitResult_column(JqlParser.Result_columnContext ctx) {
            }
        });
        if (result.size() == 1 && result.toArray(new JQLProjection[1])[0].type == JQLProjection.ProjectionType.STAR) {
            result.clear();
            if (entity != null) {
                for (SQLProperty item : entity.getCollection()) {
                    JQLProjection col = new JQLProjection(JQLProjection.ProjectionType.COLUMN, entity.getSimpleName(), item.getName(), null, null, item);
                    result.add(col);
                }
            }
        }
        return result;
    }

    public Set<String> extractColumnsToInsertOrUpdate(JQLContext jqlContext, String jqlValue, Finder<SQLProperty> entity) {
        final LinkedHashSet<String> result = new LinkedHashSet<String>();
        final One selectionOn = new One(null);
        final One insertOn = new One(null);
        this.analyzeInternal(jqlContext, jqlValue, new JqlBaseListener(){

            @Override
            public void enterColumn_name_set(JqlParser.Column_name_setContext ctx) {
                if (insertOn.value0 == null) {
                    insertOn.value0 = true;
                }
            }

            @Override
            public void exitColumn_name_set(JqlParser.Column_name_setContext ctx) {
                insertOn.value0 = false;
            }

            @Override
            public void enterColumns_to_update(JqlParser.Columns_to_updateContext ctx) {
                if (selectionOn.value0 == null) {
                    selectionOn.value0 = true;
                }
            }

            @Override
            public void exitColumns_to_update(JqlParser.Columns_to_updateContext ctx) {
                selectionOn.value0 = false;
            }

            @Override
            public void enterColumn_name(JqlParser.Column_nameContext ctx) {
                if (insertOn.value0 != null && ((Boolean)insertOn.value0).booleanValue()) {
                    result.add(ctx.getText());
                }
            }

            @Override
            public void enterColumn_name_to_update(JqlParser.Column_name_to_updateContext ctx) {
                result.add(ctx.getText());
            }
        });
        return result;
    }

    public String replaceFromVariableStatement(JQLContext context, String jql, JQLReplacerListener listener) {
        JQLRewriterListener rewriterListener = new JQLRewriterListener();
        rewriterListener.init(listener);
        return this.replaceFromVariableStatementInternal(context, jql, this.replace, rewriterListener);
    }

    public String replace(JQLContext jqlContext, JQL jql, JQLReplacerListener listener) {
        return this.replace(jqlContext, jql.value, listener);
    }

    public String replace(JQLContext jqlContext, String jql, JQLReplacerListener listener) {
        JQLRewriterListener rewriterListener = new JQLRewriterListener();
        rewriterListener.init(listener);
        return this.replaceInternal(jqlContext, jql, this.replace, rewriterListener);
    }

    private String replaceInternal(JQLContext jqlContext, String jql, List<Triple<Token, Token, String>> replace, JqlBaseListener rewriterListener) {
        Pair<ParserRuleContext, CommonTokenStream> parser = this.prepareParser(jqlContext, jql);
        this.walker.walk((ParseTreeListener)rewriterListener, (ParseTree)parser.value0);
        TokenStreamRewriter rewriter = new TokenStreamRewriter((TokenStream)parser.value1);
        for (Triple<Token, Token, String> item : replace) {
            rewriter.replace((Token)item.value0, (Token)item.value1, item.value2);
        }
        return rewriter.getText();
    }

    private String replaceFromVariableStatementInternal(JQLContext context, String jql, List<Triple<Token, Token, String>> replace, JqlBaseListener rewriterListener) {
        Pair<ParserRuleContext, CommonTokenStream> parser = this.prepareVariableStatement(context, jql);
        this.walker.walk((ParseTreeListener)rewriterListener, (ParseTree)parser.value0);
        TokenStreamRewriter rewriter = new TokenStreamRewriter((TokenStream)parser.value1);
        for (Triple<Token, Token, String> item : replace) {
            rewriter.replace((Token)item.value0, (Token)item.value1, item.value2);
        }
        return rewriter.getText();
    }

    public void verify(JQLContext jqlContext, JQL jql) {
        this.analyzeInternal(jqlContext, jql.value, new JqlBaseListener());
    }

    public List<JQLPlaceHolder> extractPlaceHoldersAsList(JQLContext jqlContext, String jql) {
        return this.extractPlaceHolders(jqlContext, jql, new ArrayList());
    }

    public Set<JQLPlaceHolder> extractPlaceHoldersAsSet(JQLContext jqlContext, String jql) {
        return this.extractPlaceHolders(jqlContext, jql, new LinkedHashSet());
    }

    public Set<JQLPlaceHolder> extractPlaceHoldersFromVariableStatementAsSet(JQLContext jqlContext, String jql) {
        return this.extractPlaceHoldersFromVariableStatement(jqlContext, jql, new LinkedHashSet());
    }

    public List<JQLPlaceHolder> extractFromVariableStatement(JQLContext jqlContext, String jql) {
        return this.extractPlaceHoldersFromVariableStatement(jqlContext, jql, new ArrayList());
    }

    private <L extends Collection<JQLPlaceHolder>> L extractPlaceHolders(JQLContext jqlContext, String jql, final L result) {
        One valid = new One();
        valid.value0 = false;
        this.analyzeInternal(jqlContext, jql, new JqlBaseListener(){

            @Override
            public void enterBind_parameter(JqlParser.Bind_parameterContext ctx) {
                String value = ctx.bind_parameter_name() != null ? ctx.bind_parameter_name().getText() : ctx.getText();
                result.add(new JQLPlaceHolder(JQLPlaceHolder.JQLPlaceHolderType.PARAMETER, value));
            }

            @Override
            public void enterBind_dynamic_sql(JqlParser.Bind_dynamic_sqlContext ctx) {
                result.add(new JQLPlaceHolder(JQLPlaceHolder.JQLPlaceHolderType.DYNAMIC_SQL, ctx.bind_parameter_name().getText()));
            }
        });
        return result;
    }

    private <L extends Collection<JQLPlaceHolder>> L extractPlaceHoldersFromVariableStatement(JQLContext jqlContext, String jql, final L result) {
        One valid = new One();
        if (!StringUtils.hasText((String)jql)) {
            return result;
        }
        valid.value0 = false;
        this.analyzeVariableStatementInternal(jqlContext, jql, new JqlBaseListener(){

            @Override
            public void enterBind_parameter(JqlParser.Bind_parameterContext ctx) {
                String parameter = ctx.bind_parameter_name() != null ? ctx.bind_parameter_name().getText() : ctx.getText();
                result.add(new JQLPlaceHolder(JQLPlaceHolder.JQLPlaceHolderType.PARAMETER, parameter));
            }

            @Override
            public void enterBind_dynamic_sql(JqlParser.Bind_dynamic_sqlContext ctx) {
                result.add(new JQLPlaceHolder(JQLPlaceHolder.JQLPlaceHolderType.DYNAMIC_SQL, ctx.bind_parameter_name().getText()));
            }
        });
        return result;
    }

    public String replaceVariableStatements(JQLContext jqlContext, final String jql, final JQLReplaceVariableStatementListener listener) {
        final ArrayList<Triple<Token, Token, String>> replace = new ArrayList<Triple<Token, Token, String>>();
        final One currentSelectLevel = new One((Object)-1);
        JqlBaseListener rewriterListener = new JqlBaseListener(){

            @Override
            public void enterSelect_core(JqlParser.Select_coreContext ctx) {
                Integer n = (Integer)currentSelectLevel.value0;
                One one = currentSelectLevel;
                one.value0 = (Integer)one.value0 + 1;
                Integer n2 = one.value0;
            }

            @Override
            public void enterSelect_or_values(JqlParser.Select_or_valuesContext ctx) {
                Integer n = (Integer)currentSelectLevel.value0;
                One one = currentSelectLevel;
                one.value0 = (Integer)one.value0 + 1;
                Integer n2 = one.value0;
            }

            @Override
            public void exitSelect_core(JqlParser.Select_coreContext ctx) {
                Integer n = (Integer)currentSelectLevel.value0;
                One one = currentSelectLevel;
                one.value0 = (Integer)one.value0 - 1;
                Integer n2 = one.value0;
            }

            @Override
            public void exitSelect_or_values(JqlParser.Select_or_valuesContext ctx) {
                Integer n = (Integer)currentSelectLevel.value0;
                One one = currentSelectLevel;
                one.value0 = (Integer)one.value0 - 1;
                Integer n2 = one.value0;
            }

            @Override
            public void enterProjected_columns(JqlParser.Projected_columnsContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onProjectedColumns(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterWhere_stmt(JqlParser.Where_stmtContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onWhere(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterOrder_stmt(JqlParser.Order_stmtContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onOrderBy(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterGroup_stmt(JqlParser.Group_stmtContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onGroup(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterHaving_stmt(JqlParser.Having_stmtContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onHaving(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterOffset_stmt(JqlParser.Offset_stmtContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onOffset(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterLimit_stmt(JqlParser.Limit_stmtContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 1)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onLimit(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterColumn_name_set(JqlParser.Column_name_setContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 2)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onColumnNameSet(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }

            @Override
            public void enterColumn_value_set(JqlParser.Column_value_setContext ctx) {
                int stop;
                if ((Integer)currentSelectLevel.value0 > 0) {
                    return;
                }
                int start = ctx.getStart().getStartIndex() - 1;
                if (start == (stop = ctx.getStop().getStopIndex() + 2)) {
                    return;
                }
                String statement = jql.substring(start, stop);
                String value = listener.onColumnValueSet(statement);
                if (value != null) {
                    replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
                }
            }
        };
        return this.replaceInternal(jqlContext, jql, replace, rewriterListener);
    }

    public static class JQLParameterName {
        private String[] values;

        private JQLParameterName(String value) {
            this.values = value.split("\\.");
        }

        public String getValue() {
            return this.values[this.values.length - 1];
        }

        public String getBeanName() {
            if (this.isNested()) {
                return this.values[0];
            }
            return "";
        }

        public boolean isNested() {
            return this.values.length > 1;
        }

        public static JQLParameterName parse(String value) {
            return new JQLParameterName(value);
        }
    }

    public class JQLRewriterListener
    extends JqlBaseListener {
        private boolean inStatement = false;
        private JQLReplacerListener listener;

        public void init(JQLReplacerListener listener) {
            this.listener = listener;
            JQLChecker.this.replace.clear();
        }

        @Override
        public void enterTable_name(JqlParser.Table_nameContext ctx) {
            String value = this.listener.onTableName(ctx.getText());
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterBind_parameter(JqlParser.Bind_parameterContext ctx) {
            String value = ctx.bind_parameter_name() != null ? this.listener.onBindParameter(ctx.bind_parameter_name().getText(), this.inStatement) : this.listener.onBindParameter(ctx.getText(), this.inStatement);
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterColumn_name_to_update(JqlParser.Column_name_to_updateContext ctx) {
            String value = this.listener.onColumnNameToUpdate(ctx.getText());
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterColumn_fully_qualified_name(JqlParser.Column_fully_qualified_nameContext ctx) {
            String value = this.listener.onColumnFullyQualifiedName(ctx.table_simple_name() != null ? ctx.table_simple_name().getText() : "", ctx.column_simple_name().getText());
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterColumn_name(JqlParser.Column_nameContext ctx) {
            String value = this.listener.onColumnName(ctx.getText());
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterColumn_alias(JqlParser.Column_aliasContext ctx) {
            String value = this.listener.onColumnAlias(ctx.getText());
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterBind_dynamic_sql(JqlParser.Bind_dynamic_sqlContext ctx) {
            String value = this.listener.onDynamicSQL(JQL.JQLDynamicStatementType.valueOf(ctx.bind_parameter_name().getText()));
            if (value == null) {
                return;
            }
            JQLChecker.this.replace.add((Triple<Token, Token, String>)new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
        }

        @Override
        public void enterWhere_stmt(JqlParser.Where_stmtContext ctx) {
            this.listener.onWhereStatementBegin(ctx);
        }

        @Override
        public void exitWhere_stmt(JqlParser.Where_stmtContext ctx) {
            this.listener.onWhereStatementEnd(ctx);
        }

        @Override
        public void enterColumn_name_set(JqlParser.Column_name_setContext ctx) {
            this.listener.onColumnNameSetBegin(ctx);
        }

        @Override
        public void exitColumn_name_set(JqlParser.Column_name_setContext ctx) {
            this.listener.onColumnNameSetEnd(ctx);
        }

        @Override
        public void enterColumn_value_set(JqlParser.Column_value_setContext ctx) {
            this.listener.onColumnValueSetBegin(ctx);
        }

        @Override
        public void exitColumn_value_set(JqlParser.Column_value_setContext ctx) {
            this.listener.onColumnValueSetEnd(ctx);
        }

        @Override
        public void enterWhere_stmt_in_clause(JqlParser.Where_stmt_in_clauseContext ctx) {
            this.inStatement = true;
        }

        @Override
        public void exitWhere_stmt_in_clause(JqlParser.Where_stmt_in_clauseContext ctx) {
            this.inStatement = false;
        }
    }
}

