/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.grammars.jql;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.Finder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import java.util.Set;

public class JQLReplacerListenerImpl
implements JQLReplacerListener {
    protected SQLiteModelMethod currentMethod;
    protected SQLiteDaoDefinition currentDaoDefinition;
    protected SQLiteDatabaseSchema currentSchema;
    protected SQLiteEntity currentEntity;
    private boolean onlyBindParameter = false;

    public JQLReplacerListenerImpl(SQLiteModelMethod method) {
        this(method, false);
    }

    public JQLReplacerListenerImpl(SQLiteModelMethod method, boolean skipTest) {
        this.onlyBindParameter = skipTest;
        this.currentMethod = method;
        if (method != null) {
            this.currentDaoDefinition = method.getParent();
            this.currentSchema = this.currentDaoDefinition.getParent();
            this.currentEntity = method.getEntity();
        }
    }

    @Override
    public String onBindParameter(String bindParameterName, boolean inStatement) {
        return null;
    }

    @Override
    public String onDynamicSQL(JQL.JQLDynamicStatementType dynamicStatement) {
        return null;
    }

    @Override
    public String onTableName(String tableName) {
        if (this.onlyBindParameter) {
            return null;
        }
        if (this.currentSchema != null) {
            Finder<SQLProperty> finder = this.currentSchema.getEntityBySimpleName(tableName);
            AssertKripton.assertTrueOrUnknownClassInJQLException(finder != null, this.currentMethod, tableName);
            return finder.getTableName();
        }
        return null;
    }

    @Override
    public String onColumnName(String columnName) {
        if (this.onlyBindParameter) {
            return null;
        }
        if (this.currentSchema != null) {
            Set<SQLProperty> props = this.currentSchema.getPropertyBySimpleName(columnName);
            AssertKripton.assertTrueOrUnknownPropertyInJQLException(props != null && props.size() > 0, this.currentMethod, columnName);
            return props.iterator().next().columnName;
        }
        return null;
    }

    @Override
    public String onColumnNameToUpdate(String columnName) {
        if (this.onlyBindParameter) {
            return null;
        }
        if (this.currentSchema != null) {
            Set<SQLProperty> props = this.currentSchema.getPropertyBySimpleName(columnName);
            AssertKripton.assertTrueOrUnknownPropertyInJQLException(props != null && props.size() > 0, this.currentMethod, columnName);
            return props.iterator().next().columnName;
        }
        return null;
    }

    @Override
    public void onWhereStatementBegin(JqlParser.Where_stmtContext ctx) {
    }

    @Override
    public void onWhereStatementEnd(JqlParser.Where_stmtContext ctx) {
    }

    @Override
    public void onColumnNameSetBegin(JqlParser.Column_name_setContext ctx) {
    }

    @Override
    public void onColumnNameSetEnd(JqlParser.Column_name_setContext ctx) {
    }

    @Override
    public void onColumnValueSetBegin(JqlParser.Column_value_setContext ctx) {
    }

    @Override
    public void onColumnValueSetEnd(JqlParser.Column_value_setContext ctx) {
    }

    @Override
    public String onColumnFullyQualifiedName(String tableName, String columnName) {
        if (this.onlyBindParameter) {
            return null;
        }
        return JQLReplacerListenerImpl.resolveFullyQualifiedColumnName(this.currentSchema, this.currentMethod, tableName, columnName);
    }

    public static String resolveFullyQualifiedColumnName(SQLiteDatabaseSchema schema, SQLiteModelMethod method, String className, String columnName) {
        SQLProperty currentProperty;
        Finder<SQLProperty> currentEntity = method.getEntity();
        SQLiteEntity daoEntity = method.getParent().getEntity();
        if (StringUtils.hasText((String)className)) {
            currentEntity = schema.getEntityBySimpleName(className);
            AssertKripton.assertTrueOrUnknownClassInJQLException(currentEntity != null, method, className);
        }
        if ((currentProperty = (SQLProperty)currentEntity.findPropertyByName(columnName)) == null && !currentEntity.getSimpleName().equals(daoEntity.getSimpleName())) {
            currentProperty = (SQLProperty)daoEntity.findPropertyByName(columnName);
        }
        AssertKripton.assertTrueOrUnknownPropertyInJQLException(currentProperty != null, method, columnName);
        return (StringUtils.hasText((String)className) ? currentEntity.getTableName() + "." : "") + currentProperty.columnName;
    }

    @Override
    public String onColumnAlias(String text) {
        return null;
    }
}

