/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.model;

import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.ModelBucket;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeVariableResolver;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelElement;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelElementVisitor;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.TypeName;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public class SQLiteDaoDefinition
extends ModelBucket<SQLiteModelMethod, TypeElement>
implements SQLiteModelElement {
    public static final String PARAM_PARSER_PREFIX = "parser";
    public static final String PARAM_SERIALIZER_PREFIX = "serializer";
    private WeakReference<SQLiteDatabaseSchema> parent;
    private TypeVariableResolver typeVariableResolver;
    private String entityClassName;
    private String entitySimplyClassName;
    private boolean generated;
    public Map<TypeName, String> managedParams = new HashMap<TypeName, String>();
    public boolean contentProviderEnabled;
    public String contentProviderPath;
    public String contentProviderTypeName;
    public List<String> preparedStatementNames = new ArrayList<String>();
    public long contentProviderCounter;
    public Set<TypeName> implementedInterface;
    public String daoUidName;
    public int daoUidValue;

    public SQLiteDatabaseSchema getParent() {
        return (SQLiteDatabaseSchema)this.parent.get();
    }

    public long nextCounter() {
        return this.getParent().nextCounter();
    }

    public long currentCounter() {
        return this.getParent().currentCounter();
    }

    public long getCurrentCounter() {
        return this.getParent().currentCounter();
    }

    void resolveTypeVariable(SQLiteModelMethod value) {
        for (Pair<String, TypeName> item : value.getParameters()) {
            item.value1 = this.typeVariableResolver.resolve((TypeName)item.value1);
        }
        value.setReturnClass(this.typeVariableResolver.resolve(value.getReturnClass()));
    }

    @Override
    public void add(SQLiteModelMethod value) {
        super.add(value);
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public String getEntitySimplyClassName() {
        return this.entitySimplyClassName;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public String getSimpleEntityClassName() {
        return this.entitySimplyClassName;
    }

    public SQLiteDaoDefinition(SQLiteDatabaseSchema databaseSchema, String name, TypeElement element, String entityClassName, boolean generated) {
        super(element.getSimpleName().toString(), element);
        this.generated = generated;
        this.parent = new WeakReference<SQLiteDatabaseSchema>(databaseSchema);
        this.entityClassName = entityClassName;
        int i = 0;
        i = entityClassName.indexOf(".");
        this.entitySimplyClassName = i > 0 ? entityClassName.substring(entityClassName.lastIndexOf(".") + 1) : entityClassName;
        this.typeVariableResolver = TypeVariableResolver.build(element);
        this.implementedInterface = new HashSet<TypeName>();
        i = name.indexOf(".");
        this.name = i > 0 ? name.substring(name.lastIndexOf(".") + 1) : name;
    }

    public TypeName resolveTypeVariable(TypeName inputTypeName) {
        return this.typeVariableResolver.resolve(inputTypeName);
    }

    @Override
    public void accept(SQLiteModelElementVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public SQLiteEntity getEntity() {
        return this.getParent().getEntity(this.getEntityClassName());
    }

    public boolean isLogEnabled() {
        return this.getParent().generateLog;
    }

    String buildPreparedStatementName(String methodName) {
        String name = methodName + "PreparedStatement" + this.preparedStatementNames.size();
        this.preparedStatementNames.add(name);
        return name;
    }

    public String generateJava2ContentSerializer(TypeName paramTypeName) {
        if (!this.managedParams.containsKey(paramTypeName)) {
            this.managedParams.put(paramTypeName, "" + (this.managedParams.size() + 1));
        }
        return PARAM_SERIALIZER_PREFIX + this.managedParams.get(paramTypeName);
    }

    public String generateJava2ContentParser(TypeName paramTypeName) {
        if (!this.managedParams.containsKey(paramTypeName)) {
            this.managedParams.put(paramTypeName, "" + (this.managedParams.size() + 1));
        }
        return PARAM_PARSER_PREFIX + this.managedParams.get(paramTypeName);
    }

    public String contentProviderUri() {
        if (!this.contentProviderEnabled) {
            return "";
        }
        return this.getParent().contentProviderUri() + "/" + this.contentProviderPath;
    }

    public String contentProviderPath() {
        if (!this.contentProviderEnabled) {
            return "";
        }
        return this.contentProviderPath;
    }

    public void addImplementedInterface(TypeName className) {
        this.implementedInterface.add(className);
    }

    public TypeName getTypeName() {
        return TypeUtility.typeName(TypeUtility.extractPackageName((TypeElement)this.element), this.name);
    }

    public boolean hasLiveData() {
        for (SQLiteModelMethod item : this.collection) {
            if (!item.hasLiveData()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSamePackageOfSchema() {
        String packageName = this.getPackageName();
        String schemaPackageName = this.getParent().getPackageName();
        return packageName.equals(schemaPackageName);
    }

    public boolean hasRelations() {
        for (SQLiteModelMethod method : this.collection) {
            if (!method.hasChildrenSelects()) continue;
            return true;
        }
        return false;
    }

    public String getTableName() {
        return this.getEntity().getTableName();
    }
}

