/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.model;

import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.android.annotation.BindDataSourceOptions;
import com.abubusoft.kripton.android.annotation.BindTransaction;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.KriptonOptions;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.Finder;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelBucket;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.element.GeneratedTypeElement;
import com.abubusoft.kripton.processor.sqlite.FindSqlTypeAdapterVisitor;
import com.abubusoft.kripton.processor.sqlite.FindTasksVisitor;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelContentProvider;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class SQLiteDatabaseSchema
extends ModelBucket<SQLiteDaoDefinition, TypeElement> {
    public final String configPopulatorClazz;
    public Converter<String, String> classNameConverter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
    public Converter<String, String> columnNameConverter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
    protected Map<String, SQLiteEntity> entities = new HashMap<String, SQLiteEntity>();
    protected Map<String, SQLiteEntity> entitiesBySimpleName = new HashMap<String, SQLiteEntity>();
    public List<String> sqlForCreate = new ArrayList<String>();
    public List<String> sqlForDrop = new ArrayList<String>();
    protected long globalCounter = 0L;
    public String fileName;
    public String generatedClassName;
    public int version;
    public boolean generateLog;
    public boolean generateAsyncTask;
    public boolean generateCursor;
    public boolean generateSchema;
    public LinkedHashSet<GeneratedTypeElement> generatedEntities;
    public List<ExecutableElement> transactions = new ArrayList<ExecutableElement>();
    public boolean generateContentProvider;
    public SQLiteModelContentProvider contentProvider;
    private Map<String, Set<SQLProperty>> propertyBySimpleName = new HashMap<String, Set<SQLProperty>>();
    private List<String> daoNameSet;
    public boolean generateRx;
    public final ArrayList<Pair<Integer, String>> configUpdateTasks;
    public final boolean configInMemory;
    public final String configCursorFactoryClazz;
    public final boolean configLogEnabled;
    public final String configDatabaseErrorHandlerClazz;
    public final String configDatabaseLifecycleHandlerClazz;
    public final Map<String, String> globalSqlTypeAdapter = new HashMap<String, String>();
    public String schemaLocationDirectory;

    public long nextCounter() {
        return ++this.globalCounter;
    }

    public String getGeneratedClassName() {
        return this.generatedClassName;
    }

    public List<String> getDaoNameSet() {
        return this.daoNameSet;
    }

    public SQLiteDatabaseSchema(TypeElement item, String schemaFileName, int schemaVersion, boolean schema, boolean log, boolean asyncTask, boolean generateCursor, boolean generateRx, List<String> daoIntoDataSource, String configCursorFactoryClass, String configDatabaseErrorHandlerClass, String configDatabaseLifecycleHandlerClass, boolean configInMemory, boolean configLogEnabled, String configPopulatorClass) {
        super(item.getSimpleName().toString(), item);
        this.fileName = schemaFileName;
        this.version = schemaVersion;
        this.generateLog = log;
        this.generateAsyncTask = asyncTask;
        this.generateCursor = generateCursor;
        this.generateSchema = schema;
        this.generatedClassName = "Bind" + this.getName();
        this.generateContentProvider = false;
        this.generateRx = generateRx;
        this.contentProvider = null;
        this.generatedEntities = new LinkedHashSet();
        this.daoNameSet = daoIntoDataSource;
        this.schemaLocationDirectory = KriptonOptions.getSchemaLocation();
        FindTasksVisitor valueVisitor = new FindTasksVisitor();
        FindSqlTypeAdapterVisitor typeAdapterVisitors = new FindSqlTypeAdapterVisitor();
        List<? extends AnnotationMirror> annotationMirrors = item.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String key;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            if (BindDataSourceOptions.class.getName().equals(annotationMirror.getAnnotationType().toString())) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    key = entry.getKey().getSimpleName().toString();
                    entry.getValue().accept(valueVisitor, key);
                }
                continue;
            }
            if (!BindDataSource.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                key = entry.getKey().getSimpleName().toString();
                entry.getValue().accept(typeAdapterVisitors, key);
            }
        }
        List<String> list = typeAdapterVisitors.getAdapters();
        for (String typeAdapter : list) {
            String sourceType = TypeAdapterHelper.detectSourceType(typeAdapter);
            AssertKripton.assertTrueOrInvalidGlobalTypeApdaterException(!this.globalSqlTypeAdapter.containsKey(sourceType), this, typeAdapter, this.globalSqlTypeAdapter.get(sourceType));
            this.globalSqlTypeAdapter.put(sourceType, typeAdapter);
        }
        this.configLogEnabled = configLogEnabled;
        this.configInMemory = configInMemory;
        this.configUpdateTasks = valueVisitor.getTasks();
        this.configCursorFactoryClazz = this.fillClazz(configCursorFactoryClass, "com.abubusoft.kripton.android.sqlite.NoCursorFactory");
        this.configDatabaseErrorHandlerClazz = this.fillClazz(configDatabaseErrorHandlerClass, "com.abubusoft.kripton.android.sqlite.NoDatabaseErrorHandler");
        this.configDatabaseLifecycleHandlerClazz = this.fillClazz(configDatabaseLifecycleHandlerClass, "com.abubusoft.kripton.android.sqlite.NoDatabaseLifecycleHandler");
        this.configPopulatorClazz = this.fillClazz(configPopulatorClass, "com.abubusoft.kripton.android.sqlite.NoPopulator");
        SqlBuilderHelper.forEachMethods((TypeElement)this.element, new AnnotationUtility.MethodFoundListener(){

            @Override
            public void onMethod(ExecutableElement methodElement) {
                if (methodElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    final ArrayList annotationList = new ArrayList();
                    AnnotationUtility.forEachAnnotations(methodElement, new AnnotationUtility.AnnotationFoundListener(){

                        @Override
                        public void onAcceptAnnotation(Element element, String annotationClassName, Map<String, String> attributes) {
                            if (annotationClassName.equals(BindTransaction.class.getCanonicalName())) {
                                ModelAnnotation annotation = new ModelAnnotation(annotationClassName, attributes);
                                annotationList.add(annotation);
                            }
                        }
                    });
                    annotationList.addAll(annotationList);
                    AssertKripton.assertTrueOrInvalidMethodSignException(annotationList.size() != 1, SQLiteDatabaseSchema.this, methodElement);
                    SQLiteDatabaseSchema.this.transactions.add(methodElement);
                }
            }
        });
    }

    private String fillClazz(String configClazz, String clazz) {
        if (!clazz.equals(configClazz)) {
            return configClazz;
        }
        return null;
    }

    public void clear() {
        this.entities.clear();
        this.entitiesBySimpleName.clear();
    }

    public void addEntity(SQLiteEntity value) {
        this.entities.put(value.getName(), value);
        this.entitiesBySimpleName.put(value.getSimpleName().toString().toLowerCase(), value);
        Set<SQLProperty> listEntity = null;
        for (SQLProperty p : value.getCollection()) {
            listEntity = this.propertyBySimpleName.get(p.getName());
            if (listEntity == null) {
                listEntity = new HashSet<SQLProperty>();
            }
            this.checkName(listEntity, p);
            listEntity.add(p);
            this.propertyBySimpleName.put(p.getName().toLowerCase(), listEntity);
        }
    }

    private void checkName(Set<SQLProperty> listEntity, SQLProperty p) {
        for (SQLProperty item : listEntity) {
            AssertKripton.assertTrueOrInvalidPropertyName(item.columnName.equals(p.columnName), item, p);
        }
    }

    public Collection<SQLiteEntity> getEntities() {
        return this.entities.values();
    }

    public List<SQLiteEntity> getEntitiesAsList() {
        return new ArrayList<SQLiteEntity>(this.entities.values());
    }

    public SQLiteEntity getEntity(String entityClassName) {
        return this.entities.get(entityClassName);
    }

    public Finder<SQLProperty> getEntityBySimpleName(String entityName) {
        if (entityName == null) {
            return null;
        }
        SQLiteEntity result = this.entitiesBySimpleName.get(entityName.toLowerCase());
        if (result != null) {
            return result;
        }
        for (GeneratedTypeElement item : this.generatedEntities) {
            if (!item.typeSpec.name.toLowerCase().equals(entityName.toLowerCase())) continue;
            return item;
        }
        return null;
    }

    public Set<SQLProperty> getPropertyBySimpleName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return this.propertyBySimpleName.get(propertyName.toLowerCase());
    }

    public String findColumnNameByPropertyName(SQLiteModelMethod method, String propertyName) {
        Set<SQLProperty> propertiesSet = this.getPropertyBySimpleName(propertyName);
        HashSet<String> set = new HashSet<String>();
        String result = null;
        for (SQLProperty item : propertiesSet) {
            result = item.columnName;
            set.add(item.columnName);
        }
        AssertKripton.assertTrueOrInvalidMethodSignException(result != null && set.size() == 1, method, "in JQL attribute can not translate property %s", propertyName);
        return result;
    }

    public boolean isLogEnabled() {
        return this.generateLog;
    }

    public String contentProviderUri() {
        if (!this.generateContentProvider) {
            return "";
        }
        return this.contentProvider.getUri();
    }

    public ClassName getGeneratedClass() {
        String packageName = ((TypeElement)this.getElement()).asType().toString();
        return TypeUtility.className(packageName.substring(0, packageName.lastIndexOf(".")) + "." + this.getGeneratedClassName());
    }

    public boolean hasLiveData() {
        for (SQLiteDaoDefinition dao : this.getCollection()) {
            if (!dao.hasLiveData()) continue;
            return true;
        }
        return false;
    }

    public SQLiteDaoDefinition findDaoDefinitionForEntity(SQLiteEntity entity) {
        for (SQLiteDaoDefinition item : this.collection) {
            if (!item.getEntity().getName().equals(entity.getName())) continue;
            return item;
        }
        return null;
    }

    public long currentCounter() {
        return this.globalCounter;
    }
}

