/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.model;

import com.abubusoft.kripton.android.annotation.BindSqlType;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.Finder;
import com.abubusoft.kripton.processor.core.ModelClass;
import com.abubusoft.kripton.processor.core.Touple;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLRelationType;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class SQLiteEntity
extends ModelClass<SQLProperty>
implements Finder<SQLProperty> {
    private String tableName;
    public Set<SQLiteEntity> referedEntities = new HashSet<SQLiteEntity>();
    public SQLiteDatabaseSchema schema;
    public List<Touple<SQLProperty, String, SQLiteEntity, SQLRelationType>> relations = new ArrayList<Touple<SQLProperty, String, SQLiteEntity, SQLRelationType>>();

    public SQLiteEntity(SQLiteDatabaseSchema schema, BindEntity bindEntity) {
        super((TypeElement)bindEntity.getElement());
        this.annotations = bindEntity.getAnnotations();
        this.schema = schema;
        this.buildTableName(BaseProcessor.elementUtils, schema);
    }

    public int countPrimaryKeys() {
        int countAnnotation = 0;
        for (SQLProperty item : this.collection) {
            if (!item.isPrimaryKey()) continue;
            ++countAnnotation;
        }
        return countAnnotation;
    }

    public SQLProperty getPrimaryKey() {
        for (SQLProperty item : this.collection) {
            if (!item.isPrimaryKey()) continue;
            return item;
        }
        SQLProperty id = (SQLProperty)this.findPropertyByName("id");
        return id;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    private String buildTableName(Elements elementUtils, SQLiteDatabaseSchema schema) {
        this.tableName = this.getSimpleName();
        this.tableName = (String)schema.classNameConverter.convert((Object)this.tableName);
        String temp = AnnotationUtility.extractAsString(this.getElement(), BindSqlType.class, AnnotationAttributeType.NAME);
        if (StringUtils.hasText((String)temp)) {
            this.tableName = temp;
        }
        return this.tableName;
    }

    public Touple<SQLProperty, String, SQLiteEntity, SQLRelationType> findRelationByParentProperty(String parentFieldName) {
        for (Touple<SQLProperty, String, SQLiteEntity, SQLRelationType> item : this.relations) {
            if (!((SQLProperty)item.value0).getName().equals(parentFieldName)) continue;
            return item;
        }
        return null;
    }

    public List<SQLProperty> getForeignKeysToEntity(SQLiteEntity entity, String fieldName) {
        ArrayList<SQLProperty> result = new ArrayList<SQLProperty>();
        if (StringUtils.hasText((String)fieldName)) {
            for (SQLProperty item : this.collection) {
                if (!item.isForeignKey() || !entity.getName().equals(item.foreignParentClassName) || !item.getName().equals(fieldName)) continue;
                result.add(item);
            }
        } else {
            for (SQLProperty item : this.collection) {
                if (!item.isForeignKey() || !entity.getName().equals(item.foreignParentClassName)) continue;
                result.add(item);
            }
        }
        return result;
    }
}

