/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.transform;

import com.abubusoft.kripton.android.ColumnAffinityType;
import com.abubusoft.kripton.android.annotation.BindSqlParam;
import com.abubusoft.kripton.common.SQLTypeAdapterUtils;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.ArraySQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.BigDecimalSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.BigIntegerSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.BooleanSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.ByteArraySQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.ByteSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.CalendarSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.CharacterSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.CurrencySQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.DateSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.DoubleSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.EnumSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.FloatSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.IntegerSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.ListSQLTransformation;
import com.abubusoft.kripton.processor.sqlite.transform.LocaleSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.LongSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.MapSQLTransformation;
import com.abubusoft.kripton.processor.sqlite.transform.ObjectSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLDateSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTimeSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SetSQLTransformation;
import com.abubusoft.kripton.processor.sqlite.transform.ShortSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.StringSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.TimeZoneSQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.UrlSQLTransform;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.type.TypeMirror;

public abstract class SQLTransformer {
    private static final Map<TypeName, SQLTransform> cache = new ConcurrentHashMap<TypeName, SQLTransform>();

    public static void cursor2Java(MethodSpec.Builder methodBuilder, TypeName beanClass, ModelProperty property, String beanName, String cursorName, String indexName) {
        SQLTransform transform;
        TypeName typeName = property.getPropertyType().getTypeName();
        if (property.hasTypeAdapter()) {
            typeName = TypeUtility.typeName(property.typeAdapter.dataType);
        }
        AssertKripton.assertTrueOrUnsupportedFieldTypeException((transform = SQLTransformer.lookup(typeName)) != null, TypeUtility.typeName(property.getElement().asType()));
        transform.generateReadPropertyFromCursor(methodBuilder, beanClass, beanName, property, cursorName, indexName);
    }

    public static void javaProperty2ContentValues(MethodSpec.Builder methodBuilder, TypeName beanClass, String beanName, ModelProperty property) {
        SQLTransform transform;
        TypeName typeName = null;
        if (property != null && property.getPropertyType() != null) {
            typeName = property.getPropertyType().getTypeName();
        }
        if (property != null && property.hasTypeAdapter()) {
            typeName = TypeUtility.typeName(property.typeAdapter.dataType);
        }
        AssertKripton.assertTrueOrUnsupportedFieldTypeException((transform = SQLTransformer.lookup(typeName)) != null, typeName);
        transform.generateWriteProperty2ContentValues(methodBuilder, beanName, beanClass, property);
    }

    public static void javaProperty2WhereCondition(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String paramName, TypeName paramType, ModelProperty property) {
        if (property != null && property.hasTypeAdapter()) {
            methodBuilder.addCode("$T.toString($T.class, $L)", new Object[]{SQLTypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(paramName, paramType, property)});
        } else if (property != null) {
            SQLTransform transform = SQLTransformer.lookup(property.getPropertyType().getTypeName());
            AssertKripton.assertTrueOrUnsupportedFieldTypeException(transform != null, paramType);
            transform.generateWriteProperty2WhereCondition(methodBuilder, paramName, paramType, property);
        } else {
            AssertKripton.assertTrueOrUnsupportedFieldTypeException(false, paramType);
        }
    }

    public static void javaMethodParam2ContentValues(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String paramName, TypeName paramType, ModelProperty property) {
        AssertKripton.assertTrueOrInvalidMethodSignException(!method.hasAdapterForParam(paramName), method, "method's parameter '%s' can not use a type adapter", paramName);
        SQLTransform transform = property != null && property.hasTypeAdapter() ? SQLTransformer.lookup(TypeUtility.typeName(property.typeAdapter.dataType)) : SQLTransformer.lookup(paramType);
        AssertKripton.assertTrueOrUnsupportedFieldTypeException(transform != null, property != null && property.hasTypeAdapter() ? TypeUtility.typeName(property.typeAdapter.dataType) : paramType);
        transform.generateWriteParam2ContentValues(methodBuilder, method, paramName, paramType, property);
    }

    private static void checkTypeAdapterForParam(SQLiteModelMethod method, String methodParamName, Class<? extends Annotation> annotation) {
        TypeName sourceType;
        TypeName paramType = method.findParameterType(methodParamName);
        if (method.isSpreadParameter(methodParamName)) {
            if (paramType instanceof ArrayTypeName) {
                paramType = ((ArrayTypeName)paramType).componentType;
            } else if (paramType instanceof ParameterizedTypeName) {
                paramType = (TypeName)((ParameterizedTypeName)paramType).typeArguments.get(0);
            }
        }
        TypeName adapterType = method.getAdapterForParam(methodParamName);
        TypeName uboxSourceType = sourceType = TypeUtility.typeName(TypeAdapterHelper.detectSourceType(method, adapterType));
        if (TypeUtility.isTypeWrappedPrimitive(sourceType)) {
            uboxSourceType = sourceType.unbox();
        }
        boolean expr = uboxSourceType.toString().equals(paramType.toString()) || sourceType.toString().equals(paramType.toString());
        AssertKripton.fail(!expr, "In DAO '%s', method '%s' has parameter '%s' uses @%s that manages type '%s' instead of '%s'", method.getParent().getName(), method.getName(), methodParamName, annotation.getSimpleName(), sourceType, paramType);
    }

    public static void javaMethodParam2WhereConditions(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String methodParamName, String paramName, TypeName paramType) {
        if (method.hasAdapterForParam(methodParamName)) {
            SQLTransformer.checkTypeAdapterForParam(method, methodParamName, BindSqlParam.class);
            methodBuilder.addCode("$T.toString($T.class, $L)", new Object[]{SQLTypeAdapterUtils.class, method.getAdapterForParam(methodParamName), paramName});
        } else {
            SQLTransform transform = SQLTransformer.lookup(paramType);
            AssertKripton.assertTrueOrUnsupportedFieldTypeException(transform != null, paramType);
            transform.generateWriteParam2WhereCondition(methodBuilder, method, paramName, paramType);
        }
    }

    public static void javaMethodParam2WhereConditions(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String paramName, TypeName paramType) {
        SQLTransformer.javaMethodParam2WhereConditions(methodBuilder, method, paramName, paramName, paramType);
    }

    public static SQLTransform lookup(TypeMirror typeMirror) {
        TypeName typeName = TypeUtility.typeName(typeMirror);
        return SQLTransformer.lookup(typeName);
    }

    public static SQLTransform lookup(TypeName typeName) {
        SQLTransform transform = cache.get(typeName);
        if (transform != null) {
            return transform;
        }
        transform = SQLTransformer.getTransform(typeName);
        AssertKripton.assertTrueOrUnsupportedFieldTypeException(transform != null, typeName);
        cache.put(typeName, transform);
        return transform;
    }

    private static SQLTransform getTransform(TypeName typeName) {
        String name;
        if (typeName.isPrimitive()) {
            return SQLTransformer.getPrimitiveTransform(typeName);
        }
        if (typeName instanceof ArrayTypeName) {
            ArrayTypeName typeNameArray = (ArrayTypeName)typeName;
            TypeName componentTypeName = typeNameArray.componentType;
            if (TypeUtility.isEquals(componentTypeName, Byte.TYPE.toString())) {
                return new ByteArraySQLTransform();
            }
            return new ArraySQLTransform();
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (TypeUtility.isList((TypeName)parameterizedTypeName)) {
                return new ListSQLTransformation();
            }
            if (TypeUtility.isSet((TypeName)parameterizedTypeName)) {
                return new SetSQLTransformation();
            }
            if (TypeUtility.isMap((TypeName)parameterizedTypeName)) {
                return new MapSQLTransformation();
            }
        }
        if ((name = typeName.toString()).startsWith("java.lang")) {
            return SQLTransformer.getLanguageTransform(typeName);
        }
        if (name.startsWith("java.util")) {
            return SQLTransformer.getUtilTransform(typeName);
        }
        if (name.startsWith("java.math")) {
            return SQLTransformer.getMathTransform(typeName);
        }
        if (name.startsWith("java.net")) {
            return SQLTransformer.getNetTransform(typeName);
        }
        if (name.startsWith("java.sql")) {
            return SQLTransformer.getSqlTransform(typeName);
        }
        if (TypeUtility.isEnum(typeName)) {
            return new EnumSQLTransform(typeName);
        }
        return new ObjectSQLTransform();
    }

    static SQLTransform getSqlTransform(TypeName typeName) {
        if (Time.class.getName().equals(typeName.toString())) {
            return new SQLTimeSQLTransform();
        }
        if (Date.class.getName().equals(typeName.toString())) {
            return new SQLDateSQLTransform();
        }
        return null;
    }

    static SQLTransform getNetTransform(TypeName typeName) {
        if (URL.class.getName().equals(typeName.toString())) {
            return new UrlSQLTransform();
        }
        return null;
    }

    public static boolean isSupportedJDKType(TypeName typeName) {
        if (typeName.isPrimitive()) {
            return SQLTransformer.getPrimitiveTransform(typeName) != null;
        }
        String name = typeName.toString();
        if (name.startsWith("java.lang")) {
            return SQLTransformer.getLanguageTransform(typeName) != null;
        }
        if (name.startsWith("java.util")) {
            return SQLTransformer.getUtilTransform(typeName) != null;
        }
        if (name.startsWith("java.math")) {
            return SQLTransformer.getMathTransform(typeName) != null;
        }
        if (name.startsWith("java.net")) {
            return SQLTransformer.getNetTransform(typeName) != null;
        }
        if (name.startsWith("java.sql")) {
            return SQLTransformer.getSqlTransform(typeName) != null;
        }
        return false;
    }

    static SQLTransform getMathTransform(TypeName typeName) {
        if (BigDecimal.class.getName().equals(typeName.toString())) {
            return new BigDecimalSQLTransform();
        }
        if (BigInteger.class.getName().equals(typeName.toString())) {
            return new BigIntegerSQLTransform();
        }
        return null;
    }

    static SQLTransform getPrimitiveTransform(TypeName type) {
        if (Integer.TYPE.toString().equals(type.toString())) {
            return new IntegerSQLTransform(false);
        }
        if (Boolean.TYPE.toString().equals(type.toString())) {
            return new BooleanSQLTransform(false);
        }
        if (Long.TYPE.toString().equals(type.toString())) {
            return new LongSQLTransform(false);
        }
        if (Double.TYPE.toString().equals(type.toString())) {
            return new DoubleSQLTransform(false);
        }
        if (Float.TYPE.toString().equals(type.toString())) {
            return new FloatSQLTransform(false);
        }
        if (Short.TYPE.toString().equals(type.toString())) {
            return new ShortSQLTransform(false);
        }
        if (Byte.TYPE.toString().equals(type.toString())) {
            return new ByteSQLTransform(false);
        }
        if (Character.TYPE.toString().equals(type.toString())) {
            return new CharacterSQLTransform(false);
        }
        return null;
    }

    static SQLTransform getLanguageTransform(TypeName type) {
        String typeName = type.toString();
        if (Integer.class.getCanonicalName().equals(typeName)) {
            return new IntegerSQLTransform(true);
        }
        if (Boolean.class.getCanonicalName().equals(typeName)) {
            return new BooleanSQLTransform(true);
        }
        if (Long.class.getCanonicalName().equals(typeName)) {
            return new LongSQLTransform(true);
        }
        if (Double.class.getCanonicalName().equals(typeName)) {
            return new DoubleSQLTransform(true);
        }
        if (Float.class.getCanonicalName().equals(typeName)) {
            return new FloatSQLTransform(true);
        }
        if (Short.class.getCanonicalName().equals(typeName)) {
            return new ShortSQLTransform(true);
        }
        if (Byte.class.getCanonicalName().equals(typeName)) {
            return new ByteSQLTransform(true);
        }
        if (Character.class.getCanonicalName().equals(typeName)) {
            return new CharacterSQLTransform(true);
        }
        if (String.class.getCanonicalName().equals(typeName)) {
            return new StringSQLTransform();
        }
        return null;
    }

    static SQLTransform getUtilTransform(TypeName type) {
        String typeName = type.toString();
        if (java.util.Date.class.getCanonicalName().equals(typeName)) {
            return new DateSQLTransform();
        }
        if (Locale.class.getCanonicalName().equals(typeName)) {
            return new LocaleSQLTransform();
        }
        if (Currency.class.getCanonicalName().equals(typeName)) {
            return new CurrencySQLTransform();
        }
        if (Calendar.class.getCanonicalName().equals(typeName)) {
            return new CalendarSQLTransform();
        }
        if (TimeZone.class.getCanonicalName().equals(typeName)) {
            return new TimeZoneSQLTransform();
        }
        return null;
    }

    public static void resetBean(MethodSpec.Builder methodBuilder, TypeName beanClass, String beanName, ModelProperty property, String cursorName, String indexName) {
        SQLTransform transform = SQLTransformer.lookup(property.getElement().asType());
        if (transform == null) {
            throw new IllegalArgumentException("Transform of " + property.getElement().asType() + " not supported");
        }
        transform.generateResetProperty(methodBuilder, beanClass, beanName, property, cursorName, indexName);
    }

    public static String columnTypeAsString(SQLProperty property) {
        SQLTransform transform;
        if (property.columnAffinityType != null && ColumnAffinityType.AUTO != property.columnAffinityType) {
            return property.columnAffinityType.toString();
        }
        TypeName typeName = property.getPropertyType().getTypeName();
        if (property.hasTypeAdapter()) {
            typeName = TypeUtility.typeName(property.typeAdapter.dataType);
        }
        if ((transform = SQLTransformer.lookup(typeName)) == null) {
            throw new IllegalArgumentException("Transform of " + property.getElement().asType() + " not supported");
        }
        return transform.getColumnType().toString();
    }
}

