/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;

public class LiteralType {
    static final Map<String, LiteralType> cached = new HashMap<String, LiteralType>();
    private static final int GROUP_TYPE_GENERIC_INDEX = 1;
    private static final int GROUP_TYPE_PARAMETER_INDEX = 2;
    private static final int GROUP_ARRAY_INDEX = 3;
    private static final int GROUP_SIMPLE_INDEX = 4;
    private String value;
    protected boolean primitive;
    private static final Pattern CLASS_PATTERN = Pattern.compile("([\\w\\.]+)\\<(.*)\\>|([\\w\\.]+)\\[\\]|([\\w\\.]+)");
    public String rawType;
    protected Class<?> resolvedRawType;
    private boolean array;
    private String typeParameter;

    public String getTypeParameter() {
        return this.typeParameter;
    }

    public boolean isParametrizedType() {
        return this.typeParameter != null;
    }

    LiteralType() {
    }

    public static LiteralType parse(String input) {
        LiteralType result = new LiteralType();
        LiteralType.parse(result, input);
        return result;
    }

    static LiteralType parse(LiteralType result, String input) {
        result.value = input;
        Matcher matcher = CLASS_PATTERN.matcher(input);
        while (matcher.find()) {
            Class[] resolved;
            if (matcher.group(4) == null && matcher.group(3) == null && matcher.group(1) == null) continue;
            result.value = matcher.group(4);
            if (result.value == null && matcher.group(3) != null) {
                result.value = matcher.group(3);
                result.array = true;
            }
            if (result.value == null && matcher.group(1) != null) {
                result.value = matcher.group(1);
                result.typeParameter = matcher.group(2);
            }
            if (result.value != null && result.value.indexOf(".") >= 0) {
                result.rawType = result.value;
                if (!result.rawType.startsWith("java")) continue;
                try {
                    result.resolvedRawType = Class.forName(result.rawType);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            result.rawType = result.value;
            result.primitive = true;
            for (Class i : resolved = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                if (!result.rawType.equals(i.getSimpleName())) continue;
                result.resolvedRawType = i;
                break;
            }
            if (!Void.TYPE.getSimpleName().equals(result.rawType)) continue;
            result.resolvedRawType = Void.TYPE;
        }
        return result;
    }

    public boolean isArray() {
        return this.array;
    }

    public static LiteralType of(String clazzString) {
        if (cached.containsKey(clazzString)) {
            return cached.get(clazzString);
        }
        LiteralType newValue = LiteralType.parse(clazzString);
        cached.put(clazzString, newValue);
        return newValue;
    }

    public boolean isCollection() {
        return this.isResolved() && Collection.class.isAssignableFrom(this.resolvedRawType);
    }

    public boolean isResolved() {
        return this.resolvedRawType != null;
    }

    public String getRawType() {
        return this.rawType;
    }

    public TypeKind getKind() {
        return null;
    }

    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        return null;
    }
}

