/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.BindMany2ManySubProcessor;
import com.abubusoft.kripton.processor.BindSharedPreferencesSubProcessor;
import com.abubusoft.kripton.processor.BindTypeSubProcessor;
import com.abubusoft.kripton.processor.KriptonOptions;
import com.sun.source.util.Trees;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public class KriptonProcessor
extends BaseProcessor {
    private BindMany2ManySubProcessor many2ManyProcessor = new BindMany2ManySubProcessor();
    private BindSharedPreferencesSubProcessor sharedPreferencesProcessor = new BindSharedPreferencesSubProcessor();
    private BindDataSourceSubProcessor dataSourceProcessor = new BindDataSourceSubProcessor();
    private BindTypeSubProcessor typeProcessor = new BindTypeSubProcessor();
    public static Trees trees;

    @Override
    public Set<String> getSupportedOptions() {
        LinkedHashSet<String> options = new LinkedHashSet<String>();
        options.add(KriptonOptions.DEBUG);
        options.addAll(this.typeProcessor.getSupportedOptions());
        options.addAll(this.sharedPreferencesProcessor.getSupportedOptions());
        options.addAll(this.dataSourceProcessor.getSupportedOptions());
        options.addAll(this.many2ManyProcessor.getSupportedOptions());
        return options;
    }

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotationClasses() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.addAll(this.typeProcessor.getSupportedAnnotationClasses());
        annotations.addAll(this.sharedPreferencesProcessor.getSupportedAnnotationClasses());
        annotations.addAll(this.dataSourceProcessor.getSupportedAnnotationClasses());
        annotations.addAll(this.many2ManyProcessor.getSupportedAnnotationClasses());
        return annotations;
    }

    public static Set<Class<? extends Annotation>> getAllSupportedAnnotationClasses() {
        KriptonProcessor processor = new KriptonProcessor();
        return processor.getSupportedAnnotationClasses();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        trees = Trees.instance(processingEnv);
        KriptonOptions.init(this, processingEnv);
        this.typeProcessor.init(processingEnv);
        this.many2ManyProcessor.init(processingEnv);
        this.sharedPreferencesProcessor.init(processingEnv);
        this.dataSourceProcessor.init(processingEnv);
        this.count = 0;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ++this.count;
            if (this.count == 1) {
                this.many2ManyProcessor.clear();
                this.typeProcessor.clear();
                this.sharedPreferencesProcessor.clear();
                this.dataSourceProcessor.clear();
                this.many2ManyProcessor.process(annotations, roundEnv);
                this.typeProcessor.process(annotations, roundEnv);
                this.sharedPreferencesProcessor.process(annotations, roundEnv);
                this.sharedPreferencesProcessor.generateClasses();
                this.dataSourceProcessor.generatedEntities = (Set)this.many2ManyProcessor.result.value0;
                this.dataSourceProcessor.generatedDaos = (Set)this.many2ManyProcessor.result.value1;
                this.dataSourceProcessor.analyzeRound(annotations, roundEnv);
                this.dataSourceProcessor.process(annotations, roundEnv);
                this.dataSourceProcessor.generateClasses(roundEnv);
            } else if (this.count == 2) {
                this.dataSourceProcessor.analyzeSecondRound(annotations, roundEnv);
                this.dataSourceProcessor.processSecondRound(annotations, roundEnv);
                this.dataSourceProcessor.generateClassesSecondRound(roundEnv);
            }
            return true;
        }
        catch (Throwable e) {
            String msg = StringUtils.nvl((String)e.getMessage());
            this.error(null, e.getClass().getCanonicalName() + ": " + msg, new Object[0]);
            if (DEBUG_MODE) {
                if (JUNIT_TEST_MODE) {
                    logger.log(Level.SEVERE, msg);
                } else {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement item : stackTrace = e.getStackTrace()) {
                        this.error(null, String.format("\tat %s.%s(%s:%s)", item.getClassName(), item.getMethodName(), item.getFileName(), item.getLineNumber()), new Object[0]);
                    }
                }
            }
            return false;
        }
    }
}

