/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.model.many2many;

import com.abubusoft.kripton.android.annotation.BindDao;
import com.abubusoft.kripton.android.annotation.BindDaoMany2Many;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.model.many2many.M2MBase;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class M2MEntity
extends M2MBase {
    public boolean immutable;
    public TypeName propertyPrimaryKey;
    public TypeName propertyKey1;
    public TypeName propertyKey2;
    private String packageName;
    public ClassName entity1Name;
    public ClassName entity2Name;
    public String idName;
    public String name;
    public String tableName;
    public ClassName daoName;
    public boolean needToCreate;
    public TypeElement daoElement;
    public boolean generateMethods;

    public String getPackageName() {
        return this.packageName;
    }

    public M2MEntity(TypeElement daoElement, String packageName, String entityName, ClassName daoClazzName, ClassName entity1ClazzName, ClassName entity2ClazzName, String idName, String tableName, boolean needToCreate, boolean generatedMethods, boolean immutable) {
        this.packageName = packageName;
        this.entity1Name = entity1ClazzName;
        this.entity2Name = entity2ClazzName;
        this.daoName = daoClazzName;
        this.idName = idName;
        this.name = entityName;
        this.tableName = StringUtils.hasText((String)tableName) ? tableName : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name);
        this.needToCreate = needToCreate;
        this.daoElement = daoElement;
        this.generateMethods = generatedMethods;
        this.immutable = immutable;
    }

    public static String extractClassName(String fullName) {
        int l = fullName.lastIndexOf(".");
        return fullName.substring(l + 1);
    }

    public ClassName getClassName() {
        return TypeUtility.className(this.packageName, this.name);
    }

    public static M2MEntity extractEntityManagedByDAO(TypeElement daoElement) {
        ClassName entity1 = null;
        ClassName entity2 = null;
        String prefixId = null;
        String tableName = null;
        String entityName = null;
        PackageElement pkg = null;
        String packageName = null;
        boolean needToCreate = true;
        boolean generatedMethods = true;
        boolean immutable = true;
        if (daoElement.getAnnotation(BindDaoMany2Many.class) != null) {
            entity1 = TypeUtility.className(AnnotationUtility.extractAsClassName(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.ENTITY_1));
            entity2 = TypeUtility.className(AnnotationUtility.extractAsClassName(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.ENTITY_2));
            prefixId = AnnotationUtility.extractAsString(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.ID_NAME);
            tableName = AnnotationUtility.extractAsString(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.TABLE_NAME);
            tableName = AnnotationUtility.extractAsString(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.TABLE_NAME);
            immutable = AnnotationUtility.extractAsBoolean(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.IMMUTABLE);
            generatedMethods = AnnotationUtility.extractAsBoolean(daoElement, BindDaoMany2Many.class, AnnotationAttributeType.METHODS);
            entityName = entity1.simpleName() + entity2.simpleName();
            pkg = BaseProcessor.elementUtils.getPackageOf(daoElement);
            String string = packageName = pkg.isUnnamed() ? null : pkg.getQualifiedName().toString();
        }
        if (daoElement.getAnnotation(BindDao.class) != null) {
            String derived = AnnotationUtility.extractAsClassName(daoElement, BindDao.class, AnnotationAttributeType.VALUE);
            ClassName clazz = TypeUtility.className(derived);
            packageName = clazz.packageName();
            entityName = clazz.simpleName();
            String tableTemp = AnnotationUtility.extractAsClassName(daoElement, BindDao.class, AnnotationAttributeType.TABLE_NAME);
            if (StringUtils.hasText((String)tableTemp)) {
                tableName = tableTemp;
            }
            needToCreate = false;
        }
        M2MEntity entity = new M2MEntity(daoElement, packageName, entityName, TypeUtility.className(daoElement.asType().toString()), entity1, entity2, prefixId, tableName, needToCreate, generatedMethods, immutable);
        return entity;
    }

    public String getQualifiedName() {
        if (StringUtils.hasText((String)this.packageName)) {
            return this.packageName + "." + this.name;
        }
        return this.name;
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getDaoQualifiedName() {
        return this.daoElement.getQualifiedName().toString();
    }
}

