/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.PrimitiveUtils;
import com.abubusoft.kripton.common.TypeAdapterUtils;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.xml.XmlType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

abstract class AbstractPrimitiveBindTransform
extends AbstractBindTransform {
    protected String JSON_PARSER_METHOD;
    protected String JSON_TYPE;
    protected boolean nullable;
    protected String PRIMITIVE_UTILITY_TYPE;
    protected String XML_ATTRIBUTE_METHOD_POST;
    protected String XML_ATTRIBUTE_METHOD_PRE;
    protected String XML_CAST_TYPE = "";
    protected String XML_TYPE;

    public AbstractPrimitiveBindTransform(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public boolean isTypeAdapterSupported() {
        return true;
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        if (this.nullable && property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            if ("(char)".equals(this.XML_CAST_TYPE)) {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, Character.valueOf((char)$L.$L())+POST_TYPE_ADAPTER"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), parserName, this.JSON_PARSER_METHOD});
            } else {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L.$L())"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), parserName, this.JSON_PARSER_METHOD});
            }
        } else if ("(char)".equals(this.XML_CAST_TYPE)) {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "Character.valueOf((char)$L.$L())"), new Object[]{parserName, this.JSON_PARSER_METHOD});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.$L()"), new Object[]{parserName, this.JSON_PARSER_METHOD});
        }
        if (this.nullable && property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        if (this.nullable && property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.read$L($L.getText(), $L))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.DEFAULT_VALUE});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.read$L($L.getText(), $L)"), new Object[]{PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.DEFAULT_VALUE});
        }
        if (this.nullable && property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L$T.read$L($L.getAttributeValue(attributeIndex), $L))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.XML_CAST_TYPE, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.DEFAULT_VALUE});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L$T.read$L($L.getElementAs$L(), $L))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.XML_CAST_TYPE, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.XML_TYPE, this.DEFAULT_VALUE});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L$T.read$L($L.getText(), $L))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.XML_CAST_TYPE, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.DEFAULT_VALUE});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L$T.read$L($L.getAttributeValue(attributeIndex), $L)"), new Object[]{this.XML_CAST_TYPE, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.DEFAULT_VALUE});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L$T.read$L($L.getElementAs$L(), $L)"), new Object[]{this.XML_CAST_TYPE, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.XML_TYPE, this.DEFAULT_VALUE});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L$T.read$L($L.getText(), $L)"), new Object[]{this.XML_CAST_TYPE, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, parserName, this.DEFAULT_VALUE});
                }
            }
        }
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (this.nullable && property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            if (property.isInCollection()) {
                methodBuilder.addStatement("$L.write$L($T.toData($T.class, $L))", new Object[]{serializerName, this.JSON_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            } else {
                methodBuilder.addStatement("$L.write$LField($S, $T.toData($T.class, $L))", new Object[]{serializerName, this.JSON_TYPE, property.label, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            }
        } else if (property.isInCollection()) {
            methodBuilder.addStatement("$L.write$L($L)", new Object[]{serializerName, this.JSON_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
        } else {
            methodBuilder.addStatement("$L.write$LField($S, $L)", new Object[]{serializerName, this.JSON_TYPE, property.label, PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (this.nullable && property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (this.nullable && property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            if (property.isInCollection()) {
                methodBuilder.addStatement("$L.writeString($T.write$L($T.toData($T.class, $L)))", new Object[]{serializerName, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            } else {
                methodBuilder.addStatement("$L.writeStringField($S, $T.write$L($T.toData($T.class, $L)))", new Object[]{serializerName, property.label, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            }
        } else if (property.isInCollection()) {
            methodBuilder.addStatement("$L.writeString($T.write$L($L))", new Object[]{serializerName, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
        } else {
            methodBuilder.addStatement("$L.writeStringField($S, $T.write$L($L))", new Object[]{serializerName, property.label, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (this.nullable && property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (this.nullable && property.isNullable() && !property.isInCollection()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.write$L($T.toData($T.class, $L)))", new Object[]{serializerName, BindProperty.xmlName(property), PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.write$L($T.toData($T.class, $L))", new Object[]{serializerName, this.XML_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: {
                    methodBuilder.addStatement("$L.write$L($T.toData($T.class, $L))", new Object[]{serializerName, this.XML_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeCData($T.toData($T.class, $T.write$L($L)))", new Object[]{serializerName, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.write$L($L))", new Object[]{serializerName, BindProperty.xmlName(property), PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.write$L($L)", new Object[]{serializerName, this.XML_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: {
                    methodBuilder.addStatement("$L.write$L($L)", new Object[]{serializerName, this.XML_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeCData($T.write$L($L))", new Object[]{serializerName, PrimitiveUtils.class, this.PRIMITIVE_UTILITY_TYPE, PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        }
        if (this.nullable && property.isNullable() && !property.isInCollection()) {
            methodBuilder.endControlFlow();
        }
    }
}

