/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.escape.StringEscapeUtils;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.xml.XmlType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class EnumBindTransform
extends AbstractBindTransform {
    private TypeName typeName;
    protected String METHOD_TO_CONVERT;

    public EnumBindTransform(TypeName typeName) {
        this.typeName = typeName;
        this.METHOD_TO_CONVERT = "toString";
    }

    @Override
    public boolean isTypeAdapterSupported() {
        return false;
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        switch (xmlType) {
            case ATTRIBUTE: {
                methodBuilder.addStatement("$L.writeAttribute($S, $T.escapeXml10($L.$L()))", new Object[]{serializerName, BindProperty.xmlName(property), StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property), this.METHOD_TO_CONVERT});
                break;
            }
            case TAG: {
                methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($L.$L()))", new Object[]{serializerName, StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property), this.METHOD_TO_CONVERT});
                methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                break;
            }
            case VALUE: {
                methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($L.$L()))", new Object[]{serializerName, StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property), this.METHOD_TO_CONVERT});
                break;
            }
            case VALUE_CDATA: {
                methodBuilder.addStatement("$L.writeCData($T.escapeXml10($L.$L()))", new Object[]{serializerName, StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property), this.METHOD_TO_CONVERT});
            }
        }
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (property.isInCollection()) {
            methodBuilder.addStatement("$L.writeString($L.$L())", new Object[]{serializerName, PropertyUtility.getter(beanName, beanClass, property), this.METHOD_TO_CONVERT});
        } else {
            methodBuilder.addStatement("$L.writeStringField($S, $L.$L())", new Object[]{serializerName, property.label, PropertyUtility.getter(beanName, beanClass, property), this.METHOD_TO_CONVERT});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        switch (xmlType) {
            case ATTRIBUTE: {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.valueOf($T.unescapeXml($L.getAttributeValue(attributeIndex)))"), new Object[]{this.typeName, StringEscapeUtils.class, parserName});
                break;
            }
            case TAG: {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.valueOf($T.unescapeXml($L.getElementText()))"), new Object[]{this.typeName, StringEscapeUtils.class, parserName});
                break;
            }
            case VALUE: 
            case VALUE_CDATA: {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.valueOf($T.unescapeXml($L.getText()))"), new Object[]{this.typeName, StringEscapeUtils.class, parserName});
                break;
            }
        }
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJackson(context, methodBuilder, serializerName, beanClass, beanName, property);
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        } else {
            methodBuilder.beginControlFlow("", new Object[0]);
        }
        methodBuilder.addStatement("String tempEnum=$L.getText()", new Object[]{parserName});
        methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.hasText(tempEnum)?$T.valueOf(tempEnum):null"), new Object[]{StringUtils.class, this.typeName});
        methodBuilder.endControlFlow();
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJackson(context, methodBuilder, parserName, beanClass, beanName, property);
    }
}

