/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransformer;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.xml.MapEntryType;
import com.abubusoft.kripton.xml.XmlPullParser;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapBindTransformation
extends AbstractBindTransform {
    static Converter<String, String> nc = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);

    public MapBindTransformation(ParameterizedTypeName clazz) {
    }

    @Override
    public boolean isTypeAdapterSupported() {
        return false;
    }

    private Class<?> defineMapClass(ParameterizedTypeName mapTypeName) {
        if (mapTypeName.rawType.toString().startsWith(Map.class.getCanonicalName())) {
            return HashMap.class;
        }
        if (mapTypeName.rawType.toString().startsWith(SortedMap.class.getCanonicalName())) {
            return TreeMap.class;
        }
        try {
            return Class.forName(mapTypeName.rawType.toString());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        ParameterizedTypeName mapTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
        TypeName keyTypeName = (TypeName)mapTypeName.typeArguments.get(0);
        TypeName valueTypeName = (TypeName)mapTypeName.typeArguments.get(1);
        methodBuilder.beginControlFlow("", new Object[0]);
        methodBuilder.addStatement("$T<$T, $T> collection=new $T<>()", new Object[]{this.defineMapClass(mapTypeName), keyTypeName, valueTypeName, this.defineMapClass(mapTypeName)});
        BindTransform transformKey = BindTransformer.lookup(keyTypeName);
        BindProperty elementKeyProperty = BindProperty.builder(keyTypeName, property).inCollection(true).xmlType(property.xmlInfo.mapEntryType.toXmlType()).elementName(property.mapKeyName).build();
        BindTransform transformValue = BindTransformer.lookup(valueTypeName);
        BindProperty elementValueProperty = BindProperty.builder(valueTypeName, property).xmlType(property.xmlInfo.mapEntryType.toXmlType()).elementName(property.mapValueName).build();
        methodBuilder.addStatement("$T key", new Object[]{elementKeyProperty.getPropertyType().getTypeName()});
        methodBuilder.addStatement("$T value", new Object[]{elementValueProperty.getPropertyType().getTypeName()});
        if (property.xmlInfo.mapEntryType == MapEntryType.ATTRIBUTE) {
            methodBuilder.addStatement("int attributeIndex", new Object[0]);
        }
        if (property.xmlInfo.isWrappedCollection()) {
            methodBuilder.beginControlFlow("while ($L.nextTag() != $T.END_TAG && $L.getName().toString().equals($S))", new Object[]{parserName, XmlPullParser.class, parserName, property.xmlInfo.labelItem});
        } else {
            methodBuilder.addCode("// add first element\n", new Object[0]);
            switch (property.xmlInfo.mapEntryType) {
                case TAG: {
                    methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                    transformKey.generateParseOnXml(context, methodBuilder, parserName, null, "key", elementKeyProperty);
                    methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                    methodBuilder.beginControlFlow("if ($L.isEmptyElement())", new Object[]{parserName});
                    methodBuilder.addStatement("value=null", new Object[0]);
                    methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                    methodBuilder.nextControlFlow("else", new Object[0]);
                    transformValue.generateParseOnXml(context, methodBuilder, parserName, null, "value", elementValueProperty);
                    methodBuilder.endControlFlow();
                    methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                    break;
                }
                case ATTRIBUTE: {
                    methodBuilder.addStatement("attributeIndex=$L.getAttributeIndex(null, $S)", new Object[]{parserName, property.mapKeyName});
                    transformKey.generateParseOnXml(context, methodBuilder, parserName, null, "key", elementKeyProperty);
                    methodBuilder.addStatement("attributeIndex=$L.getAttributeIndex(null, $S)", new Object[]{parserName, property.mapValueName});
                    transformValue.generateParseOnXml(context, methodBuilder, parserName, null, "value", elementValueProperty);
                }
            }
            methodBuilder.addStatement("collection.put(key, value)", new Object[0]);
            methodBuilder.beginControlFlow("while ($L.nextTag() != $T.END_TAG && $L.getName().toString().equals($S))", new Object[]{parserName, XmlPullParser.class, parserName, property.xmlInfo.labelItem});
        }
        switch (property.xmlInfo.mapEntryType) {
            case TAG: {
                methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                transformKey.generateParseOnXml(context, methodBuilder, parserName, null, "key", elementKeyProperty);
                methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                methodBuilder.beginControlFlow("if ($L.isEmptyElement())", new Object[]{parserName});
                methodBuilder.addStatement("value=null", new Object[0]);
                methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                methodBuilder.nextControlFlow("else", new Object[0]);
                transformValue.generateParseOnXml(context, methodBuilder, parserName, null, "value", elementValueProperty);
                methodBuilder.endControlFlow();
                methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
                break;
            }
            case ATTRIBUTE: {
                methodBuilder.addStatement("attributeIndex=$L.getAttributeIndex(null, $S)", new Object[]{parserName, property.mapKeyName});
                transformKey.generateParseOnXml(context, methodBuilder, parserName, null, "key", elementKeyProperty);
                methodBuilder.addStatement("attributeIndex=$L.getAttributeIndex(null, $S)", new Object[]{parserName, property.mapValueName});
                transformValue.generateParseOnXml(context, methodBuilder, parserName, null, "value", elementValueProperty);
            }
        }
        methodBuilder.addStatement("collection.put(key, value)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "collection"), new Object[0]);
        if (!property.xmlInfo.isWrappedCollection()) {
            methodBuilder.addStatement("read=false", new Object[0]);
        }
        methodBuilder.endControlFlow();
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        ParameterizedTypeName mapTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
        TypeName keyTypeName = (TypeName)mapTypeName.typeArguments.get(0);
        TypeName valueTypeName = (TypeName)mapTypeName.typeArguments.get(1);
        methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        if (property.xmlInfo.isWrappedCollection()) {
            methodBuilder.addCode("// write wrapper tag\n", new Object[0]);
            methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
        }
        BindTransform transformKey = BindTransformer.lookup(keyTypeName);
        BindProperty elementKeyProperty = BindProperty.builder(keyTypeName, property).inCollection(false).nullable(false).xmlType(property.xmlInfo.mapEntryType.toXmlType()).elementName(property.mapKeyName).build();
        BindTransform transformValue = BindTransformer.lookup(valueTypeName);
        BindProperty elementValueProperty = BindProperty.builder(valueTypeName, property).inCollection(false).xmlType(property.xmlInfo.mapEntryType.toXmlType()).elementName(property.mapValueName).build();
        methodBuilder.beginControlFlow("for ($T<$T, $T> item: $L.entrySet())", new Object[]{Map.Entry.class, keyTypeName, valueTypeName, PropertyUtility.getter(beanName, beanClass, property)});
        methodBuilder.addStatement("$L.writeStartElement($S)$>", new Object[]{serializerName, property.xmlInfo.labelItem});
        transformKey.generateSerializeOnXml(context, methodBuilder, serializerName, null, "item.getKey()", elementKeyProperty);
        if (elementValueProperty.isNullable()) {
            methodBuilder.beginControlFlow("if (item.getValue()==null)", new Object[0]);
            methodBuilder.addStatement("$L.writeEmptyElement($S)", new Object[]{serializerName, property.mapValueName});
            methodBuilder.nextControlFlow("else", new Object[0]);
            transformValue.generateSerializeOnXml(context, methodBuilder, serializerName, null, "item.getValue()", elementValueProperty);
            methodBuilder.endControlFlow();
        } else {
            transformValue.generateSerializeOnXml(context, methodBuilder, serializerName, null, "item.getValue()", elementValueProperty);
        }
        methodBuilder.addStatement("$<$L.writeEndElement()", new Object[]{serializerName});
        methodBuilder.endControlFlow();
        if (property.xmlInfo.isWrappedCollection()) {
            methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
        }
        methodBuilder.endControlFlow();
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJacksonInternal(context, methodBuilder, serializerName, beanClass, beanName, property, false);
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJacksonInternal(context, methodBuilder, serializerName, beanClass, beanName, property, true);
    }

    void generateSerializeOnJacksonInternal(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property, boolean onString) {
        ParameterizedTypeName mapTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
        TypeName keyTypeName = (TypeName)mapTypeName.typeArguments.get(0);
        TypeName valueTypeName = (TypeName)mapTypeName.typeArguments.get(1);
        methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        BindTransform transformKey = BindTransformer.lookup(keyTypeName);
        BindProperty elementKeyProperty = BindProperty.builder(keyTypeName, property).nullable(false).xmlType(property.xmlInfo.mapEntryType.toXmlType()).inCollection(false).elementName(property.mapKeyName).build();
        BindTransform transformValue = BindTransformer.lookup(valueTypeName);
        BindProperty elementValueProperty = BindProperty.builder(valueTypeName, property).nullable(false).xmlType(property.xmlInfo.mapEntryType.toXmlType()).inCollection(false).elementName(property.mapValueName).build();
        methodBuilder.addCode("// write wrapper tag\n", new Object[0]);
        methodBuilder.beginControlFlow("if ($L.size()>0)", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        methodBuilder.addStatement("$L.writeFieldName($S)", new Object[]{serializerName, property.label});
        methodBuilder.addStatement("$L.writeStartArray()", new Object[]{serializerName});
        methodBuilder.beginControlFlow("for ($T<$T, $T> item: $L.entrySet())", new Object[]{Map.Entry.class, keyTypeName, valueTypeName, PropertyUtility.getter(beanName, beanClass, property)});
        methodBuilder.addStatement("$L.writeStartObject()", new Object[]{serializerName});
        if (onString) {
            transformKey.generateSerializeOnJacksonAsString(context, methodBuilder, serializerName, null, "item.getKey()", elementKeyProperty);
        } else {
            transformKey.generateSerializeOnJackson(context, methodBuilder, serializerName, null, "item.getKey()", elementKeyProperty);
        }
        methodBuilder.beginControlFlow("if (item.getValue()==null)", new Object[0]);
        if (onString) {
            methodBuilder.addStatement("$L.writeStringField($S, \"null\")", new Object[]{serializerName, property.mapValueName});
        } else {
            methodBuilder.addStatement("$L.writeNullField($S)", new Object[]{serializerName, property.mapValueName});
        }
        methodBuilder.nextControlFlow("else", new Object[0]);
        if (onString) {
            transformValue.generateSerializeOnJacksonAsString(context, methodBuilder, serializerName, null, "item.getValue()", elementValueProperty);
        } else {
            transformValue.generateSerializeOnJackson(context, methodBuilder, serializerName, null, "item.getValue()", elementValueProperty);
        }
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$L.writeEndObject()", new Object[]{serializerName});
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$L.writeEndArray()", new Object[]{serializerName});
        methodBuilder.nextControlFlow("else", new Object[0]);
        if (onString) {
            methodBuilder.addStatement("$L.writeStringField($S, \"null\")", new Object[]{serializerName, property.label});
        } else {
            methodBuilder.addStatement("$L.writeNullField($S)", new Object[]{serializerName, property.label});
        }
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJacksonInternal(context, methodBuilder, parserName, beanClass, beanName, property, false);
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJacksonInternal(context, methodBuilder, parserName, beanClass, beanName, property, true);
    }

    public void generateParseOnJacksonInternal(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property, boolean onString) {
        ParameterizedTypeName mapTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
        TypeName keyTypeName = (TypeName)mapTypeName.typeArguments.get(0);
        TypeName valueTypeName = (TypeName)mapTypeName.typeArguments.get(1);
        methodBuilder.beginControlFlow("if ($L.currentToken()==$T.START_ARRAY)", new Object[]{parserName, JsonToken.class});
        methodBuilder.addStatement("$T<$T, $T> collection=new $T<>()", new Object[]{this.defineMapClass(mapTypeName), keyTypeName, valueTypeName, this.defineMapClass(mapTypeName)});
        BindTransform transformKey = BindTransformer.lookup(keyTypeName);
        BindProperty elementKeyProperty = BindProperty.builder(keyTypeName, property).inCollection(false).xmlType(property.xmlInfo.mapEntryType.toXmlType()).elementName(property.mapKeyName).nullable(false).build();
        BindTransform transformValue = BindTransformer.lookup(valueTypeName);
        BindProperty elementValueProperty = BindProperty.builder(valueTypeName, property).inCollection(false).xmlType(property.xmlInfo.mapEntryType.toXmlType()).elementName(property.mapValueName).nullable(true).build();
        methodBuilder.addStatement("$T key=$L", new Object[]{elementKeyProperty.getPropertyType().getTypeName(), this.DEFAULT_VALUE});
        methodBuilder.addStatement("$T value=$L", new Object[]{elementValueProperty.getPropertyType().getTypeName(), this.DEFAULT_VALUE});
        if (onString) {
            methodBuilder.addStatement("$T current", new Object[]{JsonToken.class});
            methodBuilder.addStatement("String tempValue=null", new Object[0]);
        }
        methodBuilder.beginControlFlow("while ($L.nextToken() != $T.END_ARRAY)", new Object[]{parserName, JsonToken.class});
        if (onString) {
            methodBuilder.addStatement("current=$L.currentToken()", new Object[]{parserName});
            methodBuilder.beginControlFlow("for (int i=0; i<2 ;i++)", new Object[0]);
            methodBuilder.beginControlFlow("while (current != $T.FIELD_NAME)", new Object[]{JsonToken.class});
            methodBuilder.addStatement("current=$L.nextToken()", new Object[]{parserName});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$L.nextValue()", new Object[]{parserName});
            methodBuilder.addCode("switch(jacksonParser.getCurrentName()) {\n", new Object[0]);
            methodBuilder.addCode("case $S:$>\n", new Object[]{property.mapKeyName});
            transformKey.generateParseOnJacksonAsString(context, methodBuilder, parserName, null, "key", elementKeyProperty);
            methodBuilder.addStatement("$<break", new Object[0]);
            methodBuilder.addCode("case $S:$>\n", new Object[]{property.mapValueName});
            methodBuilder.addStatement("tempValue=$L.getValueAsString()", new Object[]{parserName});
            methodBuilder.beginControlFlow("if ($L.currentToken()==$T.VALUE_STRING && \"null\".equals(tempValue))", new Object[]{parserName, JsonToken.class});
            methodBuilder.addStatement("value=$L", new Object[]{this.DEFAULT_VALUE});
            methodBuilder.nextControlFlow("else", new Object[0]);
            transformValue.generateParseOnJacksonAsString(context, methodBuilder, parserName, null, "value", elementValueProperty);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$<break", new Object[0]);
            methodBuilder.addCode("}\n", new Object[0]);
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addStatement("$L.nextValue()", new Object[]{parserName});
            transformKey.generateParseOnJackson(context, methodBuilder, parserName, null, "key", elementKeyProperty);
            methodBuilder.addStatement("$L.nextValue()", new Object[]{parserName});
            transformValue.generateParseOnJackson(context, methodBuilder, parserName, null, "value", elementValueProperty);
        }
        methodBuilder.addStatement("collection.put(key, value)", new Object[0]);
        methodBuilder.addStatement("key=$L", new Object[]{this.DEFAULT_VALUE});
        methodBuilder.addStatement("value=$L", new Object[]{this.DEFAULT_VALUE});
        methodBuilder.addStatement("$L.nextToken()", new Object[]{parserName});
        methodBuilder.endControlFlow();
        methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "collection"), new Object[0]);
        methodBuilder.endControlFlow();
    }
}

