/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelClass;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public abstract class ImmutableUtility {
    public static String IMMUTABLE_PREFIX = "__";

    public static void buildConstructors(Elements elementUtils, ModelClass<?> entity) {
        List<? extends Element> list = elementUtils.getAllMembers((TypeElement)entity.getElement());
        ArrayList constructors = new ArrayList();
        for (Element element : list) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            ExecutableElement constructor = (ExecutableElement)element;
            ArrayList<Pair> params = new ArrayList<Pair>();
            for (VariableElement variableElement : constructor.getParameters()) {
                params.add(new Pair((Object)variableElement.getSimpleName().toString(), (Object)TypeName.get((TypeMirror)variableElement.asType())));
            }
            constructors.add(params);
        }
        for (List list2 : constructors) {
            if (list2.size() == 0) {
                entity.emptyContructor = true;
                continue;
            }
            if (list2.size() != entity.getImmutableCollection().size()) continue;
            HashMap<String, ModelProperty> items = new HashMap<String, ModelProperty>();
            for (ModelProperty modelProperty : entity.getImmutableCollection()) {
                items.put(modelProperty.name, modelProperty);
            }
            boolean immutableConstructor = true;
            for (Pair arg : list2) {
                ModelProperty temp = (ModelProperty)items.get(arg.value0);
                if (temp != null && temp.isType((TypeName)arg.value1)) continue;
                immutableConstructor = false;
                break;
            }
            if (!immutableConstructor) continue;
            entity.immutableConstructors = list2;
        }
        if (entity.immutableConstructors != null) {
            for (Pair pair : entity.immutableConstructors) {
                Object associatedProperty = entity.findImmutablePropertyByName((String)pair.value0);
                TypeName associatedType = (TypeName)pair.value1;
                AssertKripton.assertTrueOfInvalidConstructorProperty(associatedProperty == null || TypeUtility.isTypeEquals(((ModelProperty)associatedProperty).getPropertyType().getTypeName(), associatedType), entity, (String)pair.value0);
            }
        }
        boolean allFieldWritable = true;
        for (ModelProperty property : entity.collection) {
            allFieldWritable = allFieldWritable && (property.isPublicField() || property.isFieldWithSetter());
        }
        entity.allPropertyWritable = allFieldWritable;
        AssertKripton.assertTrueOfInvalidConstructor(entity.emptyContructor || entity.immutableConstructors != null, entity);
        if (entity.emptyContructor && entity.immutableConstructors == null) {
            AssertKripton.assertTrueOfInvalidWritable(entity.allPropertyWritable, entity);
        }
    }

    public static void generateImmutableVariableReset(ModelClass<?> entity, MethodSpec.Builder methodBuilder) {
        ImmutableUtility.generateImmutableVariableInternal(entity, methodBuilder, false);
    }

    public static void generateImmutableVariableInit(ModelClass<?> entity, MethodSpec.Builder methodBuilder) {
        ImmutableUtility.generateImmutableVariableInternal(entity, methodBuilder, true);
    }

    public static void generateImmutableVariableCopyFromEntity(ModelClass<?> entity, MethodSpec.Builder methodBuilder, String entityName) {
        methodBuilder.addComment("immutable object: initialize temporary variables for properties with entity propertiy values", new Object[0]);
        for (Pair<String, TypeName> property : entity.getImmutableConstructors()) {
            Object item = entity.findImmutablePropertyByName((String)property.value0);
            AssertKripton.assertTrue(item != null, "Can not found property '%s' (type %s) in class '%s'", property.value0, property.value1, entity.getName());
            methodBuilder.addCode("$L$L=$L.$L;\n", new Object[]{IMMUTABLE_PREFIX, property.value0, entityName, PropertyUtility.getter(item)});
        }
    }

    private static void generateImmutableVariableInternal(ModelClass<?> entity, MethodSpec.Builder methodBuilder, boolean declare) {
        methodBuilder.addComment("immutable object: initialize temporary variables for properties", new Object[0]);
        for (Pair<String, TypeName> property : entity.getImmutableConstructors()) {
            if (declare) {
                methodBuilder.addCode("$T ", new Object[]{property.value1});
            }
            methodBuilder.addCode("$L$L=$L;\n", new Object[]{IMMUTABLE_PREFIX, property.value0, TypeUtility.getDefaultValue((TypeName)property.value1)});
        }
    }

    public static void generateImmutableCollectionIfPossible(ModelClass<?> entity, MethodSpec.Builder methodBuilder, String name, TypeName typeName) {
        if (TypeUtility.isList(typeName) && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(List.class))) {
            methodBuilder.addCode("($L==null ? null : $T.unmodifiableList($L))", new Object[]{name, Collections.class, name});
        } else if (TypeUtility.isSet(typeName) && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(SortedSet.class))) {
            methodBuilder.addCode("($L==null ? null : $T.unmodifiableSortedSet($L))", new Object[]{name, Collections.class, name});
        } else if (TypeUtility.isSet(typeName) && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(Set.class))) {
            methodBuilder.addCode("($L==null ? null : $T.unmodifiableSet($L))", new Object[]{name, Collections.class, name});
        } else if (TypeUtility.isMap(typeName) && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(SortedMap.class))) {
            methodBuilder.addCode("($L==null ? null : $T.unmodifiableSortedMap($L))", new Object[]{name, Collections.class, name});
        } else if (TypeUtility.isMap(typeName) && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(Map.class))) {
            methodBuilder.addCode("($L==null ? null : $T.unmodifiableMap($L))", new Object[]{name, Collections.class, name});
        } else {
            methodBuilder.addCode(name, new Object[0]);
        }
    }

    public static void generateImmutableEntityCreation(ModelClass<?> entity, MethodSpec.Builder methodBuilder, String instanceName, boolean createInstance) {
        String separator = "";
        methodBuilder.addComment("immutable object: inizialize object", new Object[0]);
        if (createInstance) {
            methodBuilder.addCode("$T ", new Object[]{entity.getElement()});
        }
        methodBuilder.addCode("$L=new $T(", new Object[]{instanceName, entity.getElement()});
        for (Pair<String, TypeName> property : entity.getImmutableConstructors()) {
            if (TypeUtility.isList((TypeName)property.value1) && ((ParameterizedTypeName)property.value1).rawType.equals((Object)ClassName.get(List.class))) {
                methodBuilder.addCode(separator + "($L==null ? null : $T.unmodifiableList($L))", new Object[]{IMMUTABLE_PREFIX + (String)property.value0, Collections.class, IMMUTABLE_PREFIX + (String)property.value0});
            } else if (TypeUtility.isSet((TypeName)property.value1) && ((ParameterizedTypeName)property.value1).rawType.equals((Object)ClassName.get(SortedSet.class))) {
                methodBuilder.addCode(separator + "($L==null ? null : $T.unmodifiableSortedSet($L))", new Object[]{IMMUTABLE_PREFIX + (String)property.value0, Collections.class, IMMUTABLE_PREFIX + (String)property.value0});
            } else if (TypeUtility.isSet((TypeName)property.value1) && ((ParameterizedTypeName)property.value1).rawType.equals((Object)ClassName.get(Set.class))) {
                methodBuilder.addCode(separator + "($L==null ? null : $T.unmodifiableSet($L))", new Object[]{IMMUTABLE_PREFIX + (String)property.value0, Collections.class, IMMUTABLE_PREFIX + (String)property.value0});
            } else if (TypeUtility.isMap((TypeName)property.value1) && ((ParameterizedTypeName)property.value1).rawType.equals((Object)ClassName.get(SortedMap.class))) {
                methodBuilder.addCode(separator + "($L==null ? null : $T.unmodifiableSortedMap($L))", new Object[]{IMMUTABLE_PREFIX + (String)property.value0, Collections.class, IMMUTABLE_PREFIX + (String)property.value0});
            } else if (TypeUtility.isMap((TypeName)property.value1) && ((ParameterizedTypeName)property.value1).rawType.equals((Object)ClassName.get(Map.class))) {
                methodBuilder.addCode(separator + "($L==null ? null : $T.unmodifiableMap($L))", new Object[]{IMMUTABLE_PREFIX + (String)property.value0, Collections.class, IMMUTABLE_PREFIX + (String)property.value0});
            } else {
                methodBuilder.addCode(separator + IMMUTABLE_PREFIX + (String)property.value0, new Object[0]);
            }
            separator = ",";
        }
        methodBuilder.addCode(");\n", new Object[0]);
    }
}

