/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.KriptonBinder;
import com.abubusoft.kripton.KriptonJsonContext;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.KriptonByteArrayOutputStream;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.persistence.JacksonWrapperParser;
import com.abubusoft.kripton.persistence.JacksonWrapperSerializer;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.BindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransformer;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ManagedModelProperty;
import com.abubusoft.kripton.processor.core.ModelClass;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Modifier;

public abstract class ManagedPropertyPersistenceHelper {
    public static String DEFAULT_FIELD_NAME = "element";

    public static void generateFieldPersistance(BindTypeContext context, List<? extends ManagedModelProperty> collection, PersistType persistType, boolean forceName, Modifier ... modifiers) {
        for (ManagedModelProperty managedModelProperty : collection) {
            if (managedModelProperty.bindProperty == null || managedModelProperty.hasTypeAdapter()) continue;
            if (forceName) {
                managedModelProperty.bindProperty.label = DEFAULT_FIELD_NAME;
            }
            BindTransformer.checkIfIsInUnsupportedPackage(managedModelProperty.bindProperty.getPropertyType().getTypeName());
            ManagedPropertyPersistenceHelper.generateFieldSerialize(context, persistType, managedModelProperty.bindProperty, modifiers);
            ManagedPropertyPersistenceHelper.generateFieldParser(context, persistType, managedModelProperty.bindProperty, modifiers);
        }
    }

    public static void generateFieldSerialize(BindTypeContext context, PersistType persistType, BindProperty property, Modifier ... modifiers) {
        Converter format = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        String methodName = "serialize" + (String)format.convert((Object)property.getName());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addJavadoc("for attribute $L serialization\n", new Object[]{property.getName()}).addParameter(ParameterSpec.builder((TypeName)TypeUtility.typeName(property.getElement()), (String)"value", (Modifier[])new Modifier[0]).build()).addModifiers(modifiers);
        switch (persistType) {
            case STRING: {
                methodBuilder.returns((TypeName)TypeUtility.className(String.class));
                break;
            }
            case BYTE: {
                methodBuilder.returns((TypeName)TypeUtility.arrayTypeName(Byte.TYPE));
            }
        }
        if (ArrayTypeName.of(Byte.TYPE).equals((Object)property.getPropertyType().getTypeName()) && persistType == PersistType.BYTE) {
            methodBuilder.addStatement("return value", new Object[0]);
        } else {
            methodBuilder.beginControlFlow("if (value==null)", new Object[0]);
            methodBuilder.addStatement("return null", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$T context=$T.jsonBind()", new Object[]{KriptonJsonContext.class, KriptonBinder.class});
            methodBuilder.beginControlFlow("try ($T stream=new $T(); $T wrapper=context.createSerializer(stream))", new Object[]{KriptonByteArrayOutputStream.class, KriptonByteArrayOutputStream.class, JacksonWrapperSerializer.class});
            methodBuilder.addStatement("$T jacksonSerializer=wrapper.jacksonGenerator", new Object[]{JsonGenerator.class});
            if (!property.isBindedObject()) {
                methodBuilder.addStatement("jacksonSerializer.writeStartObject()", new Object[0]);
            }
            methodBuilder.addStatement("int fieldCount=0", new Object[0]);
            BindTransform bindTransform = BindTransformer.lookup(property);
            String serializerName = "jacksonSerializer";
            bindTransform.generateSerializeOnJackson(context, methodBuilder, serializerName, null, "value", property);
            if (!property.isBindedObject()) {
                methodBuilder.addStatement("jacksonSerializer.writeEndObject()", new Object[0]);
            }
            methodBuilder.addStatement("jacksonSerializer.flush()", new Object[0]);
            switch (persistType) {
                case STRING: {
                    methodBuilder.addStatement("return stream.toString()", new Object[0]);
                    break;
                }
                case BYTE: {
                    methodBuilder.addStatement("return stream.toByteArray()", new Object[0]);
                }
            }
            methodBuilder.nextControlFlow("catch($T e)", new Object[]{Exception.class});
            methodBuilder.addStatement("e.printStackTrace()", new Object[0]);
            methodBuilder.addStatement("throw(new $T(e.getMessage()))", new Object[]{KriptonRuntimeException.class});
            methodBuilder.endControlFlow();
        }
        context.builder.addMethod(methodBuilder.build());
    }

    public static void generateFieldParser(BindTypeContext context, PersistType persistType, BindProperty property, Modifier ... modifiers) {
        Converter format = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("parse" + (String)format.convert((Object)property.getName()))).addJavadoc("for attribute $L parsing\n", new Object[]{property.getName()}).returns(TypeUtility.typeName(property.getElement()));
        methodBuilder.addModifiers(modifiers);
        switch (persistType) {
            case STRING: {
                methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.className(String.class), (String)"input", (Modifier[])new Modifier[0]).build());
                break;
            }
            case BYTE: {
                methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.arrayTypeName(Byte.TYPE), (String)"input", (Modifier[])new Modifier[0]).build());
            }
        }
        if (ArrayTypeName.of(Byte.TYPE).equals((Object)property.getPropertyType().getTypeName()) && persistType == PersistType.BYTE) {
            methodBuilder.addStatement("return input", new Object[0]);
        } else {
            methodBuilder.beginControlFlow("if (input==null)", new Object[0]);
            methodBuilder.addStatement("return null", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$T context=$T.jsonBind()", new Object[]{KriptonJsonContext.class, KriptonBinder.class});
            methodBuilder.beginControlFlow("try ($T wrapper=context.createParser(input))", new Object[]{JacksonWrapperParser.class});
            methodBuilder.addStatement("$T jacksonParser=wrapper.jacksonParser", new Object[]{JsonParser.class});
            methodBuilder.addCode("// START_OBJECT\n", new Object[0]);
            methodBuilder.addStatement("jacksonParser.nextToken()", new Object[0]);
            if (!property.isBindedObject()) {
                methodBuilder.addCode("// value of \"element\"\n", new Object[0]);
                methodBuilder.addStatement("jacksonParser.nextValue()", new Object[0]);
            }
            String parserName = "jacksonParser";
            BindTransform bindTransform = BindTransformer.lookup(property);
            if (property.getParent() == null || ((ModelClass)property.getParent()).isMutablePojo()) {
                methodBuilder.addStatement("$T result=null", new Object[]{property.getPropertyType().getTypeName()});
            } else {
                methodBuilder.addStatement("$T $L=null", new Object[]{property.getPropertyType().getTypeName(), ImmutableUtility.IMMUTABLE_PREFIX + property.getName()});
            }
            bindTransform.generateParseOnJackson(context, methodBuilder, parserName, null, "result", property);
            if (property.getParent() == null || ((ModelClass)property.getParent()).isMutablePojo()) {
                methodBuilder.addStatement("return result", new Object[0]);
            } else {
                methodBuilder.addStatement("return $L", new Object[]{ImmutableUtility.IMMUTABLE_PREFIX + property.getName()});
            }
            methodBuilder.nextControlFlow("catch($T e)", new Object[]{Exception.class});
            methodBuilder.addStatement("e.printStackTrace()", new Object[0]);
            methodBuilder.addStatement("throw(new $T(e.getMessage()))", new Object[]{KriptonRuntimeException.class});
            methodBuilder.endControlFlow();
        }
        context.builder.addMethod(methodBuilder.build());
    }

    public static void generateParamSerializer(BindTypeContext context, String propertyName, TypeName parameterTypeName, PersistType persistType) {
        propertyName = "serializer" + propertyName;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)propertyName).addJavadoc("for param $L serialization\n", new Object[]{propertyName}).addParameter(ParameterSpec.builder((TypeName)parameterTypeName, (String)"value", (Modifier[])new Modifier[0]).build());
        methodBuilder.addModifiers(context.modifiers);
        switch (persistType) {
            case STRING: {
                methodBuilder.returns((TypeName)TypeUtility.className(String.class));
                break;
            }
            case BYTE: {
                methodBuilder.returns((TypeName)TypeUtility.arrayTypeName(Byte.TYPE));
            }
        }
        methodBuilder.beginControlFlow("if (value==null)", new Object[0]);
        methodBuilder.addStatement("return null", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$T context=$T.jsonBind()", new Object[]{KriptonJsonContext.class, KriptonBinder.class});
        methodBuilder.beginControlFlow("try ($T stream=new $T(); $T wrapper=context.createSerializer(stream))", new Object[]{KriptonByteArrayOutputStream.class, KriptonByteArrayOutputStream.class, JacksonWrapperSerializer.class});
        methodBuilder.addStatement("$T jacksonSerializer=wrapper.jacksonGenerator", new Object[]{JsonGenerator.class});
        methodBuilder.addStatement("int fieldCount=0", new Object[0]);
        BindTransform bindTransform = BindTransformer.lookup(parameterTypeName);
        String serializerName = "jacksonSerializer";
        boolean isInCollection = true;
        if (!BindTransformer.isBindedObject(parameterTypeName)) {
            methodBuilder.addStatement("$L.writeStartObject()", new Object[]{serializerName});
            isInCollection = false;
        }
        BindProperty property = BindProperty.builder(parameterTypeName).inCollection(isInCollection).elementName(DEFAULT_FIELD_NAME).build();
        bindTransform.generateSerializeOnJackson(context, methodBuilder, serializerName, null, "value", property);
        if (!BindTransformer.isBindedObject(parameterTypeName)) {
            methodBuilder.addStatement("$L.writeEndObject()", new Object[]{serializerName});
        }
        methodBuilder.addStatement("$L.flush()", new Object[]{serializerName});
        switch (persistType) {
            case STRING: {
                methodBuilder.addStatement("return stream.toString()", new Object[0]);
                break;
            }
            case BYTE: {
                methodBuilder.addStatement("return stream.toByteArray()", new Object[0]);
            }
        }
        methodBuilder.nextControlFlow("catch($T e)", new Object[]{Exception.class});
        methodBuilder.addStatement("e.printStackTrace()", new Object[0]);
        methodBuilder.addStatement("throw(new $T(e.getMessage()))", new Object[]{KriptonRuntimeException.class});
        methodBuilder.endControlFlow();
        context.builder.addMethod(methodBuilder.build());
    }

    public static void generateParamParser(BindTypeContext context, String methodName, TypeName parameterTypeName, PersistType persistType) {
        methodName = "parser" + methodName;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addJavadoc("for param $L parsing\n", new Object[]{methodName}).returns(parameterTypeName);
        methodBuilder.addModifiers(context.modifiers);
        switch (persistType) {
            case STRING: {
                methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.className(String.class), (String)"input", (Modifier[])new Modifier[0]).build());
                break;
            }
            case BYTE: {
                methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeUtility.arrayTypeName(Byte.TYPE), (String)"input", (Modifier[])new Modifier[0]).build());
            }
        }
        methodBuilder.beginControlFlow("if (input==null)", new Object[0]);
        methodBuilder.addStatement("return null", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$T context=$T.jsonBind()", new Object[]{KriptonJsonContext.class, KriptonBinder.class});
        methodBuilder.beginControlFlow("try ($T wrapper=context.createParser(input))", new Object[]{JacksonWrapperParser.class});
        methodBuilder.addStatement("$T jacksonParser=wrapper.jacksonParser", new Object[]{JsonParser.class});
        methodBuilder.addCode("// START_OBJECT\n", new Object[0]);
        methodBuilder.addStatement("jacksonParser.nextToken()", new Object[0]);
        methodBuilder.addCode("// value of \"element\"\n", new Object[0]);
        methodBuilder.addStatement("jacksonParser.nextValue()", new Object[0]);
        String parserName = "jacksonParser";
        BindTransform bindTransform = BindTransformer.lookup(parameterTypeName);
        methodBuilder.addStatement("$T result=null", new Object[]{parameterTypeName});
        BindProperty property = BindProperty.builder(parameterTypeName).inCollection(false).elementName(DEFAULT_FIELD_NAME).build();
        bindTransform.generateParseOnJackson(context, methodBuilder, parserName, null, "result", property);
        methodBuilder.addStatement("return result", new Object[0]);
        methodBuilder.nextControlFlow("catch($T e)", new Object[]{Exception.class});
        methodBuilder.addStatement("e.printStackTrace()", new Object[0]);
        methodBuilder.addStatement("throw(new $T(e.getMessage()))", new Object[]{KriptonRuntimeException.class});
        methodBuilder.endControlFlow();
        context.builder.addMethod(methodBuilder.build());
    }

    public static enum PersistType {
        STRING,
        BYTE;

    }
}

