/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelBucket;
import com.abubusoft.kripton.processor.core.ModelElement;
import com.abubusoft.kripton.processor.core.ModelElementVisitor;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.ModelWithAnnotation;
import com.abubusoft.kripton.processor.core.reflect.TypeVariableResolver;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;

@BindType
public class ModelClass<E extends ModelProperty>
extends ModelBucket<E, TypeElement>
implements ModelElement,
ModelWithAnnotation {
    List<E> immutableCollection = new ArrayList();
    protected List<ModelAnnotation> annotations;
    List<Pair<String, TypeName>> immutableConstructors;
    protected TypeVariableResolver typeVariableResolver;
    boolean emptyContructor;
    boolean allPropertyWritable;

    public List<E> getImmutableCollection() {
        return this.immutableCollection;
    }

    public E findImmutablePropertyByName(String name) {
        String lcName = name.toLowerCase();
        for (ModelProperty item : this.immutableCollection) {
            if (!item.getName().toLowerCase().equals(lcName)) continue;
            return (E)item;
        }
        return null;
    }

    public List<Pair<String, TypeName>> getImmutableConstructors() {
        return this.immutableConstructors;
    }

    public List<ModelAnnotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isImmutablePojo() {
        return !this.isMutablePojo();
    }

    public boolean isMutablePojo() {
        return this.emptyContructor && this.allPropertyWritable;
    }

    public ModelClass(TypeElement element) {
        this(element.getQualifiedName().toString(), element, null);
    }

    public ModelClass(String name, TypeElement beanElement, List<ModelAnnotation> annotationList) {
        super(name, beanElement);
        this.annotations = annotationList == null ? new ArrayList() : annotationList;
        this.typeVariableResolver = TypeVariableResolver.build(beanElement);
    }

    public String getSimpleName() {
        return ((TypeElement)this.element).getSimpleName().toString();
    }

    @Override
    public void accept(ModelElementVisitor visitor) throws Exception {
        visitor.visit(null, this);
    }

    @Override
    public ModelAnnotation getAnnotation(Class<? extends Annotation> value) {
        String canonicalName = value.getCanonicalName();
        for (ModelAnnotation item : this.annotations) {
            if (!item.getName().equals(canonicalName)) continue;
            return item;
        }
        return null;
    }

    public void addAnnotation(ModelAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public boolean containsAnnotation(Class<? extends Annotation> annotation) {
        return this.getAnnotation(annotation) != null;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationClazz) {
        return this.getAnnotation(annotationClazz) != null;
    }

    public TypeName resolveTypeVariable(TypeName typeName) {
        return this.typeVariableResolver.resolve(typeName);
    }

    @Override
    public void add(E value) {
        TypeName typeName = ((ModelProperty)value).getPropertyType().getTypeName();
        TypeName resolvedTypeName = this.typeVariableResolver.resolve(typeName);
        ((ModelProperty)value).getPropertyType().setTypeName(resolvedTypeName);
        super.add(value);
    }
}

