/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.ModelWithAnnotation;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ModelMethod
extends ModelEntity<ExecutableElement>
implements ModelWithAnnotation {
    protected List<ModelAnnotation> annotations;
    protected List<Pair<String, TypeName>> parameters = new ArrayList<Pair<String, TypeName>>();
    protected TypeName returnClass;

    @Override
    public ModelAnnotation getAnnotation(Class<? extends Annotation> value) {
        for (ModelAnnotation item : this.annotations) {
            if (!item.getName().equals(value.getCanonicalName())) continue;
            return item;
        }
        return null;
    }

    public ModelMethod(ExecutableElement element) {
        super(element.getSimpleName().toString(), element);
        this.annotations = new ArrayList<ModelAnnotation>();
        for (VariableElement variableElement : element.getParameters()) {
            this.parameters.add((Pair<String, TypeName>)new Pair((Object)variableElement.getSimpleName().toString(), (Object)TypeUtility.typeName(variableElement.asType())));
        }
        this.returnClass = TypeUtility.typeName(element.getReturnType());
    }

    public List<Pair<String, TypeName>> getParameters() {
        return this.parameters;
    }

    public TypeName getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(TypeName returnClass) {
        this.returnClass = returnClass;
    }

    public void addAnnotation(ModelAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public TypeName findParameterType(String name) {
        for (Pair<String, TypeName> item : this.parameters) {
            if (!((String)item.value0).equals(name)) continue;
            return (TypeName)item.value1;
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationClazz) {
        return this.getAnnotation(annotationClazz) != null;
    }
}

