/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core;

import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelElement;
import com.abubusoft.kripton.processor.core.ModelElementVisitor;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.ModelType;
import com.abubusoft.kripton.processor.core.ModelWithAnnotation;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.utils.LiteralType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BindType
public class ModelProperty
extends ModelEntity<Element>
implements ModelElement,
ModelWithAnnotation {
    protected WeakReference<ModelEntity> parent;
    protected List<ModelAnnotation> annotations;
    protected ModelType propertyType;
    public TypeAdapter typeAdapter;
    protected boolean publicField;
    protected boolean fieldWithGetter;
    protected boolean fieldWithSetter;
    protected boolean fieldWithIs;

    protected void checkTypeAdapter(ModelEntity entity, TypeMirror propertyType, TypeAdapter typeAdapter, ModelAnnotation annotation) {
        TypeName sourceType;
        TypeName uboxSourceType = sourceType = TypeUtility.typeName(TypeAdapterHelper.detectSourceType(entity.getElement(), typeAdapter.adapterClazz));
        if (TypeUtility.isTypeWrappedPrimitive(sourceType)) {
            uboxSourceType = sourceType.unbox();
        }
        boolean expr = uboxSourceType.toString().equals(propertyType.toString()) || sourceType.toString().equals(propertyType.toString());
        AssertKripton.fail(!expr, "In class '%s', property '%s' uses @%s that manages type '%s' instead of '%s'", entity.getElement().asType(), this.getName(), annotation.getSimpleName(), this.element.asType().toString(), TypeAdapterHelper.detectSourceType(entity.getElement(), typeAdapter.adapterClazz), this.getPropertyType().getTypeName());
    }

    public ModelEntity getParent() {
        return (ModelEntity)this.parent.get();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.fieldWithGetter ? 1231 : 1237);
        result = 31 * result + (this.fieldWithIs ? 1231 : 1237);
        result = 31 * result + (this.fieldWithSetter ? 1231 : 1237);
        result = 31 * result + (this.publicField ? 1231 : 1237);
        result = 31 * result + (this.propertyType == null ? 0 : this.propertyType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelProperty other = (ModelProperty)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.fieldWithGetter != other.fieldWithGetter) {
            return false;
        }
        if (this.fieldWithIs != other.fieldWithIs) {
            return false;
        }
        if (this.fieldWithSetter != other.fieldWithSetter) {
            return false;
        }
        if (this.publicField != other.publicField) {
            return false;
        }
        return !(this.propertyType == null ? other.propertyType != null : !this.propertyType.equals(other.propertyType));
    }

    public ModelProperty(ModelEntity<?> entity, Element element, List<ModelAnnotation> modelAnnotations) {
        super(element != null ? element.getSimpleName().toString() : null, element);
        this.parent = new WeakReference(entity);
        if (element != null) {
            TypeName temp1 = TypeName.get((TypeMirror)element.asType());
            LiteralType temp2 = LiteralType.of(element.asType().toString());
            AssertKripton.fail(temp1 instanceof ClassName && temp2.isCollection(), "In bean '%s' property '%s' can not use Object as parameter", entity.getElement().asType().toString(), element.getSimpleName().toString());
            this.propertyType = new ModelType(element.asType());
            this.publicField = element.getModifiers().contains((Object)Modifier.PUBLIC);
        }
        this.annotations = new ArrayList<ModelAnnotation>();
        if (modelAnnotations != null) {
            this.annotations.addAll(modelAnnotations);
        }
        this.typeAdapter = new TypeAdapter();
    }

    @Override
    public ModelAnnotation getAnnotation(Class<? extends Annotation> value) {
        for (ModelAnnotation item : this.annotations) {
            if (!item.getName().equals(value.getCanonicalName())) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationClazz) {
        return this.getAnnotation(annotationClazz) != null;
    }

    public ModelType getPropertyType() {
        return this.propertyType;
    }

    public boolean isFieldWithGetter() {
        return this.fieldWithGetter;
    }

    public void setFieldWithGetter(boolean fieldWithGetter) {
        this.fieldWithGetter = fieldWithGetter;
    }

    public boolean isFieldWithSetter() {
        return this.fieldWithSetter;
    }

    public void setFieldWithSetter(boolean fieldWithSetter) {
        this.fieldWithSetter = fieldWithSetter;
    }

    public boolean isFieldWithIs() {
        return this.fieldWithIs;
    }

    public void setFieldWithIs(boolean fieldWithIs) {
        this.fieldWithIs = fieldWithIs;
    }

    public boolean isProperty() {
        return this.element != null;
    }

    public boolean isPublicField() {
        return this.publicField;
    }

    @Override
    public void accept(ModelElementVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public boolean isType(TypeName value) {
        return TypeUtility.isEquals(this.getPropertyType().getTypeName(), value);
    }

    public boolean isType(Type ... types) {
        return TypeUtility.isTypeIncludedIn(this.propertyType.typeName, types);
    }

    public boolean hasTypeAdapter() {
        return this.typeAdapter.adapterClazz != null;
    }

    public class TypeAdapter {
        public String adapterClazz;
        public String dataType;

        public TypeName getAdapterTypeName() {
            return TypeUtility.typeName(this.adapterClazz);
        }

        public TypeName getDataTypeTypename() {
            return TypeUtility.typeName(this.dataType);
        }
    }
}

