/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core.reflect;

import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.ModelMethod;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.ModelWithAnnotation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class AnnotationUtility {
    private static final Pattern classPattern = Pattern.compile("([\\w.]*).class");
    private static final Pattern arrayPattern = Pattern.compile("\"([^\"]*)\"");

    static List<String> extractAsArrayOfClassName(String value) {
        Matcher matcher = classPattern.matcher(value);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public static List<String> extractAsArrayOfString(String value) {
        Matcher matcher = arrayPattern.matcher(value);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(StringEscapeUtils.unescapeEcmaScript((String)matcher.group(1)));
        }
        return result;
    }

    public static void forEachAnnotations(Element currentElement, AnnotationFilter filter, AnnotationFoundListener listener) {
        Elements elementUtils = BaseProcessor.elementUtils;
        List<? extends AnnotationMirror> annotationList = elementUtils.getAllAnnotationMirrors(currentElement);
        for (AnnotationMirror annotationMirror : annotationList) {
            HashMap<String, String> values = new HashMap<String, String>();
            String annotationClassName = annotationMirror.getAnnotationType().asElement().toString();
            if (filter != null && !filter.isAccepted(annotationClassName)) continue;
            values.clear();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> annotationItem : elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
                String value = annotationItem.getValue().toString();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1);
                    value = value.substring(0, value.length() - 1);
                }
                values.put(annotationItem.getKey().getSimpleName().toString(), value);
            }
            if (listener == null) continue;
            listener.onAcceptAnnotation(currentElement, annotationClassName, values);
        }
    }

    public static void forEachAnnotations(Element currentElement, AnnotationFoundListener listener) {
        AnnotationUtility.forEachAnnotations(currentElement, null, listener);
    }

    public static List<String> extractAsClassNameArray(Elements elementUtils, Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attributeName) {
        final One result = new One();
        result.value0 = new ArrayList();
        AnnotationUtility.extractString(elementUtils, item, annotationClass, attributeName, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = AnnotationUtility.extractAsArrayOfClassName(value);
            }
        });
        return (List)result.value0;
    }

    public static String extractAsClassName(Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attributeName) {
        Elements elementUtils = BindDataSourceSubProcessor.elementUtils;
        final One result = new One();
        AnnotationUtility.extractString(elementUtils, item, annotationClass, attributeName, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = AnnotationUtility.extractAsArrayOfClassName(value).get(0);
            }
        });
        return (String)result.value0;
    }

    public static String extractAsString(Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attributeName) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One();
        AnnotationUtility.extractString(elementUtils, item, annotationClass, attributeName, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                List<String> list = AnnotationUtility.extractAsArrayOfString(value);
                result.value0 = list.size() > 0 ? list.get(0) : value;
            }
        });
        return (String)result.value0;
    }

    public static List<String> extractAsStringArray(Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attributeName) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One(new ArrayList());
        AnnotationUtility.extractString(elementUtils, item, annotationClass, attributeName, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                List<String> list;
                result.value0 = list = AnnotationUtility.extractAsArrayOfString(value);
            }
        });
        return (List)result.value0;
    }

    public static String extractAsEnumerationValue(Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attribute) {
        Elements elementUtils = BindDataSourceSubProcessor.elementUtils;
        final One result = new One();
        AnnotationUtility.extractAttributeValue(elementUtils, item, annotationClass.getName(), attribute, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                if (value.indexOf(".") >= 0) {
                    result.value0 = value.substring(value.lastIndexOf(".") + 1);
                }
            }
        });
        return (String)result.value0;
    }

    static void extractString(Elements elementUtils, Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attribute, OnAttributeFoundListener listener) {
        AnnotationUtility.extractAttributeValue(elementUtils, item, annotationClass.getCanonicalName(), attribute, listener);
    }

    static void extractAttributeValue(Elements elementUtils, Element item, String annotationName, AnnotationAttributeType attribute, OnAttributeFoundListener listener) {
        List<? extends AnnotationMirror> annotationList = elementUtils.getAllAnnotationMirrors(item);
        for (AnnotationMirror annotationMirror : annotationList) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().asElement().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> annotationItem : elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
                if (!attribute.isEquals(annotationItem.getKey())) continue;
                listener.onFound(annotationItem.getValue().toString());
                return;
            }
        }
    }

    public static List<String> extractAsStringArray(ModelMethod method, ModelAnnotation annotationClass, AnnotationAttributeType attribute) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One();
        AnnotationUtility.extractAttributeValue(elementUtils, method.getElement(), annotationClass.getName(), attribute, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = AnnotationUtility.extractAsArrayOfString(value);
            }
        });
        return (List)result.value0;
    }

    public static String extractAsEnumerationValue(ModelProperty property, ModelAnnotation annotationClass, AnnotationAttributeType attribute) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One();
        AnnotationUtility.extractAttributeValue(elementUtils, property.getElement(), annotationClass.getName(), attribute, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = value.substring(value.lastIndexOf(".") + 1);
            }
        });
        return (String)result.value0;
    }

    public static List<ModelAnnotation> buildAnnotationList(Element element, AnnotationFilter filter) {
        final ArrayList<ModelAnnotation> annotationList = new ArrayList<ModelAnnotation>();
        AnnotationUtility.forEachAnnotations(element, filter, new AnnotationFoundListener(){

            @Override
            public void onAcceptAnnotation(Element executableMethod, String annotationClassName, Map<String, String> attributes) {
                ModelAnnotation annotation = new ModelAnnotation(annotationClassName, attributes);
                annotationList.add(annotation);
            }
        });
        return annotationList;
    }

    public static List<ModelAnnotation> buildAnnotationList(Element element) {
        return AnnotationUtility.buildAnnotationList(element, null);
    }

    public static int extractAsInt(Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attributeName) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One();
        result.value0 = 0;
        AnnotationUtility.extractString(elementUtils, item, annotationClass, attributeName, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = Integer.parseInt(value);
            }
        });
        return (Integer)result.value0;
    }

    public static boolean extractAsBoolean(Element item, Class<? extends Annotation> annotationClass, AnnotationAttributeType attribute) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One((Object)false);
        AnnotationUtility.extractString(elementUtils, item, annotationClass, attribute, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = Boolean.parseBoolean(value);
            }
        });
        return (Boolean)result.value0;
    }

    public static <E extends ModelEntity<?>> boolean extractAsBoolean(E item, ModelAnnotation annotation, AnnotationAttributeType attribute) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final One result = new One((Object)false);
        AnnotationUtility.extractAttributeValue(elementUtils, item.getElement(), annotation.getName(), attribute, new OnAttributeFoundListener(){

            @Override
            public void onFound(String value) {
                result.value0 = Boolean.valueOf(value);
            }
        });
        return (Boolean)result.value0;
    }

    public static Boolean getAnnotationAttributeAsBoolean(ModelWithAnnotation model, Class<? extends Annotation> annotation, AnnotationAttributeType attribute, Boolean defaultValue) {
        return AnnotationUtility.getAnnotationAttribute(model, annotation, attribute, defaultValue, new OnAnnotationAttributeListener<Boolean>(){

            @Override
            public Boolean onFound(String value) {
                return Boolean.valueOf(value);
            }
        });
    }

    static <T> T getAnnotationAttribute(ModelWithAnnotation model, Class<? extends Annotation> annotation, AnnotationAttributeType attribute, T defaultValue, OnAnnotationAttributeListener<T> listener) {
        ModelAnnotation item = model.getAnnotation(annotation);
        if (item != null) {
            String attributeResult = item.getAttribute(attribute);
            return listener.onFound(attributeResult);
        }
        return defaultValue;
    }

    static interface OnAnnotationAttributeListener<T> {
        public T onFound(String var1);
    }

    public static class AnnotationFilterBuilder {
        Set<String> set = new HashSet<String>();

        AnnotationFilterBuilder() {
        }

        public AnnotationFilterBuilder add(Class<? extends Annotation> annotation) {
            this.set.add(annotation.getCanonicalName());
            return this;
        }

        public AnnotationFilter build() {
            return new AnnotationFilter(this.set);
        }
    }

    public static class AnnotationFilter {
        Set<String> annotationNames;

        AnnotationFilter(Set<String> annotations) {
            this.annotationNames = annotations;
        }

        public boolean isAccepted(String annotationName) {
            return this.annotationNames.contains(annotationName);
        }

        public static AnnotationFilterBuilder builder() {
            return new AnnotationFilterBuilder();
        }
    }

    static interface OnAttributeFoundListener {
        public void onFound(String var1);
    }

    public static interface MethodFoundListener {
        public void onMethod(ExecutableElement var1);
    }

    public static interface AnnotationFoundListener {
        public void onAcceptAnnotation(Element var1, String var2, Map<String, String> var3);
    }
}

