/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.core.reflect;

import com.abubusoft.kripton.annotation.BindTypeVariables;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BindTypeSubProcessor;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class TypeVariableResolver {
    List<TypeName> declaredTypeArgumentList;
    Map<String, TypeName> typeVariableMap;
    TypeElement element;
    boolean active;

    public TypeVariableResolver(TypeElement element, List<TypeName> typeArgs, Map<String, TypeName> typeVariableMap) {
        this.element = element;
        this.declaredTypeArgumentList = typeArgs;
        this.typeVariableMap = typeVariableMap;
        this.active = typeArgs != null && typeArgs.size() > 0 || typeVariableMap.size() > 0;
    }

    public boolean hasTypeVariables() {
        return this.active;
    }

    public static TypeVariableResolver build(TypeElement element) {
        List<TypeName> typeArgs = TypeUtility.getTypeArguments(element);
        HashMap<String, TypeName> typeVariableMap = new HashMap<String, TypeName>();
        BindTypeVariables annotationBeanType = element.getAnnotation(BindTypeVariables.class);
        List<Object> typeVariables = new ArrayList();
        if (annotationBeanType != null) {
            typeVariables = Arrays.asList(annotationBeanType.value());
        }
        List<String> typeParameters = AnnotationUtility.extractAsClassNameArray(BindTypeSubProcessor.elementUtils, element, BindTypeVariables.class, AnnotationAttributeType.TYPE_PARAMETERS);
        AssertKripton.assertTrue(typeVariables.size() >= typeParameters.size(), "%s '%s' has incorrect definition of type variables/parameters on annotation @BindTypeVariables", element.getKind() == ElementKind.CLASS ? "Class" : "Interface", element.asType());
        if (typeVariables.size() > 0) {
            AssertKripton.assertTrue(typeParameters.size() == 0 || typeVariables.size() == typeParameters.size(), "%s '%s' has an incorrect definition of type variables/parameters on annotation @BindTypeVariables(typeVariables, typeParameters)", element.getKind() == ElementKind.CLASS ? "Class" : "Interface", element.asType());
            if (StringUtils.hasText((String)((String)typeVariables.get(0)))) {
                int i = 0;
                for (String string : typeVariables) {
                    if (StringUtils.hasText((String)string)) {
                        String[] temp;
                        for (String alias : temp = string.split(",")) {
                            if (typeParameters.size() > 0) {
                                typeVariableMap.put(alias.trim(), TypeUtility.typeName(typeParameters.get(i)));
                                continue;
                            }
                            typeVariableMap.put(alias.trim(), typeArgs.get(i));
                        }
                    }
                    ++i;
                }
            } else {
                AssertKripton.assertTrue(typeVariableMap == null && typeArgs.size() < 2, "%s '%s' use more than one type variables in its class hierarchy. Try to use @BindTypeVariables", element.getKind() == ElementKind.CLASS ? "Class" : "Interface", element.asType());
            }
        }
        return new TypeVariableResolver(element, typeArgs, typeVariableMap);
    }

    public TypeName resolve(TypeName inputType) {
        if (!this.hasTypeVariables()) {
            return inputType;
        }
        if (inputType.isPrimitive() || inputType.isBoxedPrimitive() || inputType.equals((Object)TypeName.get(String.class))) {
            return inputType;
        }
        if (TypeName.VOID.equals((Object)inputType)) {
            return inputType;
        }
        ArrayTypeName resolved = null;
        if (inputType instanceof ParameterizedTypeName) {
            ParameterizedTypeName inputParametrizedTypeName = (ParameterizedTypeName)inputType;
            TypeName[] typeArguments = new TypeName[inputParametrizedTypeName.typeArguments.size()];
            int i = 0;
            for (TypeName item : inputParametrizedTypeName.typeArguments) {
                typeArguments[i] = this.resolve(item);
                ++i;
            }
            resolved = ParameterizedTypeName.get((ClassName)((ClassName)this.resolve((TypeName)inputParametrizedTypeName.rawType)), (TypeName[])typeArguments);
            return resolved;
        }
        if (inputType instanceof ArrayTypeName) {
            ArrayTypeName inputTypeName = (ArrayTypeName)inputType;
            resolved = ArrayTypeName.of((TypeName)this.resolve(inputTypeName.componentType));
            return resolved;
        }
        if (inputType.toString().contains(".")) {
            return inputType;
        }
        if (this.typeVariableMap.containsKey(inputType.toString())) {
            TypeName type = this.typeVariableMap.get(inputType.toString());
            return type;
        }
        if (this.declaredTypeArgumentList.size() == 1) {
            resolved = this.declaredTypeArgumentList.get(0);
            return resolved;
        }
        AssertKripton.assertTrue(false, "In type hierarchy of %s '%s' there is a unresolved type variable named '%s'. Define it with @BindTypeVariables", this.element.getKind() == ElementKind.CLASS ? "class" : "interface", this.element.getQualifiedName(), inputType.toString());
        return resolved;
    }
}

