/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sharedprefs.model;

import com.abubusoft.kripton.android.annotation.BindPreference;
import com.abubusoft.kripton.android.annotation.BindPreferenceAdapter;
import com.abubusoft.kripton.android.sharedprefs.PreferenceType;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ManagedModelProperty;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsEntity;
import com.abubusoft.kripton.processor.sharedprefs.transform.PrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.PrefsTransformer;
import java.util.List;
import javax.lang.model.element.Element;

public class PrefsProperty
extends ManagedModelProperty {
    private static Converter<String, String> converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
    protected String preferenceKey;
    protected boolean generateRx;
    protected boolean generateLiveData;
    protected PreferenceType preferenceType;

    public PrefsProperty(PrefsEntity entity, Element element, List<ModelAnnotation> modelAnnotations) {
        super((ModelEntity)entity, element, modelAnnotations);
        ModelAnnotation annotationBindAdapter;
        String name = AnnotationUtility.extractAsString(element, BindPreference.class, AnnotationAttributeType.VALUE);
        if (!StringUtils.hasText((String)name)) {
            name = (String)converter.convert((Object)element.getSimpleName().toString());
        }
        this.preferenceKey = name;
        this.generateRx = entity.generateGlobalRx;
        this.generateLiveData = entity.generateGlobalLiveData;
        if (element.getAnnotation(BindPreference.class) != null) {
            this.generateRx = entity.generateGlobalRx && AnnotationUtility.extractAsBoolean(element, BindPreference.class, AnnotationAttributeType.GENERATE_RX);
            boolean bl = this.generateLiveData = entity.generateGlobalLiveData && AnnotationUtility.extractAsBoolean(element, BindPreference.class, AnnotationAttributeType.GENERATE_LIVE_DATA);
        }
        if ((annotationBindAdapter = this.getAnnotation(BindPreferenceAdapter.class)) != null) {
            this.typeAdapter.adapterClazz = annotationBindAdapter.getAttributeAsClassName(AnnotationAttributeType.ADAPTER);
            this.typeAdapter.dataType = TypeAdapterHelper.detectDestinationType(entity.getElement(), this.typeAdapter.adapterClazz);
            this.checkTypeAdapter(entity, element.asType(), this.typeAdapter, annotationBindAdapter);
            PrefsTransform transform = PrefsTransformer.lookup(TypeUtility.typeName(this.typeAdapter.dataType));
            AssertKripton.assertTrueOfInvalidDefinition(transform.isTypeAdapterAware(), this, String.format("property is converted into an unsupported target type '%s' by @%s", TypeUtility.typeName(this.typeAdapter.dataType), BindPreferenceAdapter.class.getSimpleName()));
        }
    }

    public boolean isGenerateRx() {
        return this.generateRx;
    }

    public boolean isGenerateLiveData() {
        return this.generateLiveData;
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public PreferenceType getPreferenceType() {
        return this.preferenceType;
    }

    public void setPreferenceType(PreferenceType preferenceType) {
        this.preferenceType = preferenceType;
    }
}

