/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sharedprefs.transform;

import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.UnsupportedFieldTypeException;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsProperty;
import com.abubusoft.kripton.processor.sharedprefs.transform.ArrayPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.BigDecimalPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.BigIntegerPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.BooleanPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.ByteArrayPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.BytePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.CalendarPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.CharacterPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.CurrencyPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.DatePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.DoublePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.EnumPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.FloatPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.IntegerPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.ListPrefsTransformation;
import com.abubusoft.kripton.processor.sharedprefs.transform.LocalePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.LongPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.MapPrefsTransformation;
import com.abubusoft.kripton.processor.sharedprefs.transform.ObjectPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.PrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.SQLDatePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.SQLTimePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.SetPrefsTransformation;
import com.abubusoft.kripton.processor.sharedprefs.transform.ShortPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.StringPrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.TimeZonePrefsTransform;
import com.abubusoft.kripton.processor.sharedprefs.transform.UrlPrefsTransform;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.type.TypeMirror;

public abstract class PrefsTransformer {
    private static final Map<TypeName, PrefsTransform> cache = new ConcurrentHashMap<TypeName, PrefsTransform>();

    public static void register(TypeName type, PrefsTransform transform) {
        cache.put(type, transform);
    }

    public static PrefsTransform lookup(PrefsProperty property) {
        TypeMirror typeMirror = property.getElement().asType();
        TypeName typeName = TypeUtility.typeName(typeMirror);
        return PrefsTransformer.lookup(typeName);
    }

    public static PrefsTransform lookup(TypeName typeName) {
        PrefsTransform transform = cache.get(typeName);
        if (transform != null) {
            return transform;
        }
        transform = PrefsTransformer.getTransform(typeName);
        AssertKripton.assertNotNull(transform, new UnsupportedFieldTypeException(typeName));
        cache.put(typeName, transform);
        return transform;
    }

    private static PrefsTransform getTransform(TypeName typeName) {
        PrefsTransform transform;
        if (typeName.isPrimitive()) {
            return PrefsTransformer.getPrimitiveTransform(typeName);
        }
        if (typeName instanceof ArrayTypeName) {
            ArrayTypeName typeNameArray = (ArrayTypeName)typeName;
            TypeName componentTypeName = typeNameArray.componentType;
            if (TypeUtility.isEquals(componentTypeName, Byte.TYPE.toString())) {
                return new ByteArrayPrefsTransform();
            }
            return new ArrayPrefsTransform();
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (TypeUtility.isList((TypeName)parameterizedTypeName)) {
                return new ListPrefsTransformation();
            }
            if (TypeUtility.isSet((TypeName)parameterizedTypeName)) {
                return new SetPrefsTransformation();
            }
            if (TypeUtility.isMap((TypeName)parameterizedTypeName)) {
                return new MapPrefsTransformation();
            }
        }
        if ((transform = PrefsTransformer.getLanguageTransform(typeName)) != null) {
            return transform;
        }
        transform = PrefsTransformer.getUtilTransform(typeName);
        if (transform != null) {
            return transform;
        }
        transform = PrefsTransformer.getMathTransform(typeName);
        if (transform != null) {
            return transform;
        }
        transform = PrefsTransformer.getNetTransform(typeName);
        if (transform != null) {
            return transform;
        }
        transform = PrefsTransformer.getSqlTransform(typeName);
        if (transform != null) {
            return transform;
        }
        if (TypeUtility.isEnum(typeName)) {
            return new EnumPrefsTransform(typeName);
        }
        return new ObjectPrefsTransform();
    }

    static PrefsTransform getSqlTransform(TypeName typeName) {
        if (Time.class.getName().equals(typeName.toString())) {
            return new SQLTimePrefsTransform();
        }
        if (Date.class.getName().equals(typeName.toString())) {
            return new SQLDatePrefsTransform();
        }
        return null;
    }

    static PrefsTransform getNetTransform(TypeName typeName) {
        if (URL.class.getName().equals(typeName.toString())) {
            return new UrlPrefsTransform();
        }
        return null;
    }

    static PrefsTransform getMathTransform(TypeName typeName) {
        if (BigDecimal.class.getName().equals(typeName.toString())) {
            return new BigDecimalPrefsTransform();
        }
        if (BigInteger.class.getName().equals(typeName.toString())) {
            return new BigIntegerPrefsTransform();
        }
        return null;
    }

    static PrefsTransform getPrimitiveTransform(TypeName type) {
        if (Integer.TYPE.toString().equals(type.toString())) {
            return new IntegerPrefsTransform(false);
        }
        if (Boolean.TYPE.toString().equals(type.toString())) {
            return new BooleanPrefsTransform(false);
        }
        if (Long.TYPE.toString().equals(type.toString())) {
            return new LongPrefsTransform(false);
        }
        if (Double.TYPE.toString().equals(type.toString())) {
            return new DoublePrefsTransform(false);
        }
        if (Float.TYPE.toString().equals(type.toString())) {
            return new FloatPrefsTransform(false);
        }
        if (Short.TYPE.toString().equals(type.toString())) {
            return new ShortPrefsTransform(false);
        }
        if (Byte.TYPE.toString().equals(type.toString())) {
            return new BytePrefsTransform(false);
        }
        if (Character.TYPE.toString().equals(type.toString())) {
            return new CharacterPrefsTransform(false);
        }
        return null;
    }

    static PrefsTransform getLanguageTransform(TypeName type) {
        String typeName = type.toString();
        if (Integer.class.getCanonicalName().equals(typeName)) {
            return new IntegerPrefsTransform(true);
        }
        if (Boolean.class.getCanonicalName().equals(typeName)) {
            return new BooleanPrefsTransform(true);
        }
        if (Long.class.getCanonicalName().equals(typeName)) {
            return new LongPrefsTransform(true);
        }
        if (Double.class.getCanonicalName().equals(typeName)) {
            return new DoublePrefsTransform(true);
        }
        if (Float.class.getCanonicalName().equals(typeName)) {
            return new FloatPrefsTransform(true);
        }
        if (Short.class.getCanonicalName().equals(typeName)) {
            return new ShortPrefsTransform(true);
        }
        if (Byte.class.getCanonicalName().equals(typeName)) {
            return new BytePrefsTransform(true);
        }
        if (Character.class.getCanonicalName().equals(typeName)) {
            return new CharacterPrefsTransform(true);
        }
        if (String.class.getCanonicalName().equals(typeName)) {
            return new StringPrefsTransform();
        }
        return null;
    }

    static PrefsTransform getUtilTransform(TypeName type) {
        String typeName = type.toString();
        if (java.util.Date.class.getCanonicalName().equals(typeName)) {
            return new DatePrefsTransform();
        }
        if (Locale.class.getCanonicalName().equals(typeName)) {
            return new LocalePrefsTransform();
        }
        if (Currency.class.getCanonicalName().equals(typeName)) {
            return new CurrencyPrefsTransform();
        }
        if (Calendar.class.getCanonicalName().equals(typeName)) {
            return new CalendarPrefsTransform();
        }
        if (TimeZone.class.getCanonicalName().equals(typeName)) {
            return new TimeZonePrefsTransform();
        }
        return null;
    }
}

