/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.os.AsyncTask;
import com.abubusoft.kripton.android.BindAsyncTaskType;
import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;

public class BindAsyncTaskBuilder {
    public static final String PREFIX = "Bind";
    public static final String SUFFIX = "AsyncTask";
    private static TypeSpec.Builder builder;

    public static void generate(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws IOException {
        String className = schema.getName();
        String dataSourceName = PREFIX + className;
        className = className.replaceAll("DataSource", SUFFIX);
        className = PREFIX + className;
        PackageElement pkg = elementUtils.getPackageOf((Element)schema.getElement());
        String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDataSource.class, packageName, className);
        builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addTypeVariable(TypeVariableName.get((String)"I")).addTypeVariable(TypeVariableName.get((String)"U")).addTypeVariable(TypeVariableName.get((String)"R"));
        builder.addJavadoc("\n<p>\nSpecialized async task to make async database operation on activity\n</p>\n", new Object[0]);
        builder.addJavadoc("\n<p>\nUnlike standard async task, for an instance of this class can be used many time.\n</p>\n", new Object[0]);
        builder.addJavadoc("\n<p>\nWhen method <code>execute</code> is invoked, an inner async task is created.\n</p>\n\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(builder);
        builder.addJavadoc("@param I input param\n", new Object[0]);
        builder.addJavadoc("@param U update param\n", new Object[0]);
        builder.addJavadoc("@param R result param\n\n", new Object[0]);
        builder.addJavadoc("@see $T\n", new Object[]{TypeUtility.className(className.replaceAll(SUFFIX, "DaoFactory"))});
        builder.addJavadoc("@see $T\n", new Object[]{TypeUtility.className(dataSourceName)});
        builder.addJavadoc("@see $T\n", new Object[]{BindAsyncTaskType.class});
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this($T.READ)", new Object[]{BindAsyncTaskType.class}).addJavadoc("<p>\nWith this constructor, a read only database connection will be used\n</p>\n", new Object[0]).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("<p>\nWith this constructor it is possible to specify which type of database use in async task\n</p>\n\n", new Object[0]).addJavadoc("@param mode allows to specify if and how open a data source connection\n", new Object[0]).addParameter(BindAsyncTaskType.class, "mode", new Modifier[0]).addCode("this.mode = mode;", new Object[0]).build());
        FieldSpec.Builder fieldSpec = FieldSpec.builder(BindAsyncTaskType.class, (String)"mode", (Modifier[])new Modifier[]{Modifier.PROTECTED});
        fieldSpec.addJavadoc("Allows to specify how async task interacts with data source.\n\n", new Object[0]);
        builder.addField(fieldSpec.build());
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)TypeUtility.className(AsyncTask.class), (TypeName[])new TypeName[]{TypeUtility.typeName("I"), TypeUtility.typeName("U"), TypeUtility.typeName("R")});
        FieldSpec.Builder fieldSpec2 = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"asyncTask", (Modifier[])new Modifier[]{Modifier.PROTECTED});
        fieldSpec2.addJavadoc("Async task wrapped by this class\n\n", new Object[0]);
        builder.addField(fieldSpec2.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"onPreExecute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Use this method for operations on UI-thread before start execution\n", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"onExecute").returns(TypeUtility.typeName("R")).addParameter(TypeUtility.typeName(dataSourceName), "dataSource", new Modifier[0]).addJavadoc("Method used to encapsulate operations on datasource\n\n@param dataSource\n\tuse it to retrieve DAO\n@return\n\tresult of operation (list, bean, etc) and execute transactions.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addException(Throwable.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"onFinish").addParameter(TypeUtility.typeName("R"), "result", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addJavadoc("Use this method for operations on UI-thread after execution\n", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"onProgressUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of((TypeName)TypeUtility.typeName("U")), (String)"update", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).build()).varargs().addJavadoc("Override this method to KRIPTON_DEBUG operation progress on UI-Thread\n", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"onError").addParameter(Throwable.class, "exception", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("This method is invoked when <code>onExecute</code> method generate an exception.\n@param exception exception generated\n", new Object[0]).addStatement("$T.error(exception.getMessage())", new Object[]{Logger.class}).addStatement("exception.printStackTrace()", new Object[0]).build());
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"execute").addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of((TypeName)TypeUtility.className("I")), (String)"params", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).build()).varargs(true).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Method to start operations.\n\n@param executor used executor\n@param data input\n", new Object[0]);
        executeBuilder.addStatement("executeOnExecutor($T.SERIAL_EXECUTOR, params)", new Object[]{AsyncTask.class});
        builder.addMethod(executeBuilder.build());
        executeBuilder = MethodSpec.methodBuilder((String)"executeOnExecutor").addParameter(Executor.class, "executor", new Modifier[0]).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of((TypeName)TypeUtility.className("I")), (String)"params", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).build()).varargs(true).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Method to start operations.\n\n@param executor used executor\n@param data input\n", new Object[0]);
        TypeSpec.Builder anonymous = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(AsyncTask.class), (TypeName[])new TypeName[]{TypeUtility.className("I"), TypeUtility.className("U"), TypeUtility.className("R")}));
        anonymous.addMethod(MethodSpec.methodBuilder((String)"onPreExecute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$L.this.onPreExecute()", new Object[]{className}).build());
        anonymous.addMethod(MethodSpec.methodBuilder((String)"doInBackground").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeUtility.typeName("R")).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of((TypeName)TypeUtility.className("I")), (String)"params", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).build()).varargs(true).addStatement("$L dataSource=$L.getInstance()", new Object[]{dataSourceName, dataSourceName}).addStatement("R result=null", new Object[0]).addStatement("boolean needToOpened=false", new Object[0]).addCode("if (mode==$T.READ) { needToOpened=true; dataSource.openReadOnlyDatabase(); } else if (mode==$T.READ_WRITE) { needToOpened=true; dataSource.openWritableDatabase();}\n", new Object[]{BindAsyncTaskType.class, BindAsyncTaskType.class}).beginControlFlow("try", new Object[0]).addStatement("result=onExecute(dataSource)", new Object[0]).nextControlFlow("catch(Throwable e)", new Object[0]).addStatement("onError(e)", new Object[0]).nextControlFlow("finally", new Object[0]).beginControlFlow("if (needToOpened)", new Object[0]).addStatement("dataSource.close()", new Object[0]).endControlFlow().endControlFlow().addStatement("return result", new Object[0]).build());
        anonymous.addMethod(MethodSpec.methodBuilder((String)"onProgressUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of((TypeName)TypeUtility.className("U")), (String)"values", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).build()).varargs(true).addStatement("$L.this.onProgressUpdate(values)", new Object[]{className}).build());
        anonymous.addMethod(MethodSpec.methodBuilder((String)"onPostExecute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)TypeUtility.className("R"), (String)"result", (Modifier[])new Modifier[0]).build()).addStatement("$L.this.onFinish(result)", new Object[]{className}).build());
        executeBuilder.addStatement("asyncTask=$L", new Object[]{anonymous.build()});
        executeBuilder.addStatement("asyncTask.executeOnExecutor(executor, params)", new Object[]{anonymous.build()});
        builder.addMethod(executeBuilder.build());
        anonymous.addMethod(MethodSpec.methodBuilder((String)"cancel").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(Boolean.TYPE, "mayInterruptIfRunning", new Modifier[0]).beginControlFlow("if (asyncTask!=null, args)", new Object[0]).addStatement("return asyncTask.cancel(mayInterruptIfRunning)", new Object[0]).endControlFlow().addStatement("return false", new Object[0]).build());
        builder.addType(TypeSpec.classBuilder((String)"Simple").addJavadoc("Simple implementation of async task. It uses read only database.\n\n", new Object[0]).addJavadoc("@see $T\n", new Object[]{TypeUtility.typeName(className.replaceAll(SUFFIX, "DaoFactory"))}).addJavadoc("@see $T\n", new Object[]{TypeUtility.typeName(dataSourceName)}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addTypeVariable(TypeVariableName.get((String)"R")).superclass((TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(className), (TypeName[])new TypeName[]{TypeUtility.className("Void"), TypeUtility.className("Void"), TypeUtility.className("R")})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Create an simple async task allowing user to decide which kind of operation can be done on datasource", new Object[0]).addParameter(BindAsyncTaskType.class, "mode", new Modifier[0]).addStatement("super(mode)", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Create an simple async task for data source read only operation", new Object[0]).addStatement("super($T.READ)", new Object[]{BindAsyncTaskType.class}).build()).build());
        TypeSpec typeSpec = builder.build();
        JavaWriterHelper.writeJava2File(filer, packageName, typeSpec);
    }
}

