/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.LiveDataHandler;
import com.abubusoft.kripton.android.annotation.BindDao;
import com.abubusoft.kripton.android.annotation.BindDaoMany2Many;
import com.abubusoft.kripton.android.annotation.BindGeneratedDao;
import com.abubusoft.kripton.android.annotation.BindSqlDelete;
import com.abubusoft.kripton.android.annotation.BindSqlInsert;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.annotation.BindSqlUpdate;
import com.abubusoft.kripton.android.sqlite.Dao;
import com.abubusoft.kripton.android.sqlite.SQLiteEvent;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.bind.transform.BindTransformer;
import com.abubusoft.kripton.processor.core.ManagedPropertyPersistenceHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.BindDaoFactoryBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDataSourceBuilder;
import com.abubusoft.kripton.processor.sqlite.BindTableGenerator;
import com.abubusoft.kripton.processor.sqlite.SqlInsertBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlModifyBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlSelectBuilder;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelElementVisitor;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.reactivex.subjects.PublishSubject;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class BindDaoBuilder
implements SQLiteModelElementVisitor {
    public static final String METHOD_NAME_REGISTRY_EVENT = "registryEvent";
    public static final String METHOD_NAME_INVALIDATE_LIVE_DATA = "invalidateLiveData";
    public static final String METHOD_NAME_REGISTRY_LIVE_DATA = "registryLiveData";
    public static final String SUFFIX = "Impl";
    protected Elements elementUtils;
    protected Filer filer;
    private TypeSpec.Builder builder;
    private SQLiteDaoDefinition currentDaoDefinition;

    public BindDaoBuilder(Elements elementUtils, Filer filer) {
        this.elementUtils = elementUtils;
        this.filer = filer;
    }

    public static void generate(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        BindDaoBuilder visitor = new BindDaoBuilder(elementUtils, filer);
        for (SQLiteDaoDefinition item : schema.getCollection()) {
            item.accept(visitor);
        }
    }

    public static void generateSecondRound(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        BindDaoBuilder visitor = new BindDaoBuilder(elementUtils, filer);
        for (SQLiteDaoDefinition item : schema.getCollection()) {
            if (!item.isGenerated()) continue;
            item.accept(visitor);
        }
    }

    @Override
    public void visit(SQLiteDaoDefinition value) throws Exception {
        this.currentDaoDefinition = value;
        if (((TypeElement)value.getElement()).getAnnotation(BindDaoMany2Many.class) != null && ((TypeElement)value.getElement()).getAnnotation(BindGeneratedDao.class) == null) {
            return;
        }
        String classTableName = BindDaoBuilder.daoName(value);
        PackageElement pkg = this.elementUtils.getPackageOf((Element)value.getElement());
        String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDao.class, packageName, classTableName);
        this.builder = TypeSpec.classBuilder((String)classTableName).superclass(Dao.class).addSuperinterface(TypeUtility.typeName(value.getElement())).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TypeName item : value.implementedInterface) {
            this.builder.addSuperinterface(item);
        }
        BindTypeContext context = new BindTypeContext(this.builder, TypeUtility.typeName(packageName, classTableName), Modifier.PRIVATE);
        String entityName = BindDataSourceSubProcessor.generateEntityName(value, value.getEntity());
        this.builder.addJavadoc("<p>", new Object[0]);
        this.builder.addJavadoc("\nDAO implementation for entity <code>$L</code>, based on interface <code>$L</code>\n", new Object[]{entityName, ((TypeElement)value.getElement()).getSimpleName().toString()});
        this.builder.addJavadoc("</p>\n\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.builder);
        this.builder.addJavadoc(" @see $T\n", new Object[]{TypeUtility.className(value.getEntityClassName())});
        this.builder.addJavadoc(" @see $T\n", new Object[]{TypeUtility.className(((TypeElement)value.getElement()).getQualifiedName().toString())});
        this.builder.addJavadoc(" @see $T\n", new Object[]{BindTableGenerator.tableClassName(value, value.getEntity())});
        Object methodBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)BindDaoFactoryBuilder.generateDaoFactoryClassName(value.getParent()), "daoFactory", new Modifier[0]);
        methodBuilder.addStatement("super(daoFactory.context())", new Object[0]);
        if (value.hasRelations()) {
            methodBuilder.addStatement("this.daoFactory=daoFactory", new Object[0]);
            this.builder.addField((TypeName)BindDaoFactoryBuilder.generateDaoFactoryClassName(value.getParent()), "daoFactory", new Modifier[]{Modifier.PRIVATE});
        }
        this.builder.addMethod(methodBuilder.build());
        for (SQLiteModelMethod sQLiteModelMethod : value.getCollection()) {
            sQLiteModelMethod.accept(this);
        }
        if (value.hasLiveData()) {
            methodBuilder = MethodSpec.methodBuilder((String)METHOD_NAME_REGISTRY_EVENT).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(Integer.TYPE, "affectedRows", new Modifier[0]);
            methodBuilder.beginControlFlow("if (affectedRows==0)", new Object[0]);
            methodBuilder.addStatement("return", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.beginControlFlow("if (_context.isInSession())", new Object[0]);
            methodBuilder.addStatement("_context.registrySQLEvent($T.$L)", new Object[]{BindDataSourceBuilder.generateDataSourceName(value.getParent()), value.daoUidName});
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("invalidateLiveData()", new Object[0]);
            methodBuilder.endControlFlow();
            this.builder.addMethod(methodBuilder.build());
            methodBuilder = MethodSpec.methodBuilder((String)"registryChange").addModifiers(new Modifier[]{Modifier.PUBLIC});
            methodBuilder.addJavadoc("<p>Allows to registry change on this DAO in a transaction, in an batch operation or in a standalone operation.</p>\n\n", new Object[0]);
            methodBuilder.addStatement("registryEvent(1)", new Object[0]);
            this.builder.addMethod(methodBuilder.build());
            FieldSpec.Builder liveDataBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(WeakReference.class), (TypeName[])new TypeName[]{ClassName.get(LiveDataHandler.class)})}), (String)"liveDatas", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(CodeBlock.builder().add("new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CopyOnWriteArraySet.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(WeakReference.class), (TypeName[])new TypeName[]{ClassName.get(LiveDataHandler.class)})})}).build());
            this.builder.addField(liveDataBuilder.build());
            methodBuilder = MethodSpec.methodBuilder((String)METHOD_NAME_REGISTRY_LIVE_DATA).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)ClassName.get(LiveDataHandler.class), "value", new Modifier[0]);
            methodBuilder.addStatement("liveDatas.add(new $T(value))", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(WeakReference.class), (TypeName[])new TypeName[]{ClassName.get(LiveDataHandler.class)})});
            this.builder.addMethod(methodBuilder.build());
            methodBuilder = MethodSpec.methodBuilder((String)METHOD_NAME_INVALIDATE_LIVE_DATA).addJavadoc("<p>Invalidate livedata.</p>\n\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC});
            methodBuilder.beginControlFlow("for ($T item: liveDatas)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(WeakReference.class), (TypeName[])new TypeName[]{ClassName.get(LiveDataHandler.class)})});
            methodBuilder.beginControlFlow("if (item.get()!=null)", new Object[0]);
            methodBuilder.addStatement("item.get().invalidate()", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.endControlFlow();
            this.builder.addMethod(methodBuilder.build());
        }
        for (Map.Entry entry : this.currentDaoDefinition.managedParams.entrySet()) {
            BindTransformer.checkIfIsInUnsupportedPackage((TypeName)entry.getKey());
            ManagedPropertyPersistenceHelper.generateParamSerializer(context, (String)entry.getValue(), (TypeName)entry.getKey(), ManagedPropertyPersistenceHelper.PersistType.BYTE);
            ManagedPropertyPersistenceHelper.generateParamParser(context, (String)entry.getValue(), (TypeName)entry.getKey(), ManagedPropertyPersistenceHelper.PersistType.BYTE);
        }
        if (this.currentDaoDefinition.getParent().generateRx) {
            ParameterizedTypeName subjectTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(PublishSubject.class), (TypeName[])new TypeName[]{ClassName.get(SQLiteEvent.class)});
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSubject").addModifiers(new Modifier[]{Modifier.PUBLIC});
            builder.addStatement("return subject", new Object[0]).returns((TypeName)subjectTypeName);
            this.builder.addMethod(builder.build());
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)subjectTypeName, (String)"subject", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$T.create()", new Object[]{ClassName.get(PublishSubject.class)});
            this.builder.addField(fieldBuilder.build());
        }
        methodBuilder = MethodSpec.methodBuilder((String)"clearCompiledStatements").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE);
        for (String item : value.preparedStatementNames) {
            methodBuilder.beginControlFlow("if ($L!=null)", new Object[]{item});
            methodBuilder.addStatement("$L.close()", new Object[]{item});
            methodBuilder.addStatement("$L=null", new Object[]{item});
            methodBuilder.endControlFlow();
        }
        this.builder.addMethod(methodBuilder.build());
        TypeSpec typeSpec = this.builder.build();
        JavaWriterHelper.writeJava2File(this.filer, packageName, typeSpec);
    }

    public static String daoName(SQLiteDaoDefinition value) {
        String classTableName = value.getName();
        classTableName = classTableName + SUFFIX;
        return classTableName;
    }

    public static TypeName daoTypeName(SQLiteDaoDefinition value) {
        return TypeUtility.mergeTypeNameWithSuffix(value.getTypeName(), SUFFIX);
    }

    public static TypeName daoInterfaceTypeName(SQLiteDaoDefinition value) {
        return value.getTypeName();
    }

    @Override
    public void visit(SQLiteModelMethod value) throws Exception {
        if (value.getAnnotation(BindSqlInsert.class) != null) {
            SqlInsertBuilder.generate(this.builder, value);
        } else if (value.getAnnotation(BindSqlUpdate.class) != null) {
            SqlModifyBuilder.generate(this.builder, value);
        } else if (value.getAnnotation(BindSqlDelete.class) != null) {
            SqlModifyBuilder.generate(this.builder, value);
        } else if (value.getAnnotation(BindSqlSelect.class) != null) {
            SqlSelectBuilder.generateSelect(this.builder, value);
        }
    }
}

