/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.android.sqlite.BindDaoFactory;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDaoBuilder;
import com.abubusoft.kripton.processor.sqlite.SchemaUtility;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class BindDaoFactoryBuilder
extends AbstractBuilder {
    public static final String PREFIX = "Bind";
    public static final String SUFFIX = "DaoFactory";

    public BindDaoFactoryBuilder(Elements elementUtils, Filer filer, SQLiteDatabaseSchema model) {
        super(elementUtils, filer, model);
    }

    public static String generateDaoFactoryName(SQLiteDatabaseSchema schema) {
        String schemaName = BindDaoFactoryBuilder.buildDaoFactoryName(schema);
        return schemaName;
    }

    public static ClassName generateDaoFactoryClassName(SQLiteDatabaseSchema schema) {
        String schemaName = BindDaoFactoryBuilder.buildDaoFactoryName(schema);
        String packageName = TypeUtility.extractPackageName((TypeElement)schema.getElement());
        return ClassName.get((String)packageName, (String)schemaName, (String[])new String[0]);
    }

    public String buildDaoFactoryInterface(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        String schemaName = BindDaoFactoryBuilder.generateDaoFactoryName(schema);
        PackageElement pkg = elementUtils.getPackageOf((Element)schema.getElement());
        String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindDataSource.class, packageName, schemaName);
        this.classBuilder = this.buildDaoFactoryInterfaceInternal(elementUtils, filer, schema);
        TypeSpec typeSpec = this.classBuilder.build();
        JavaWriterHelper.writeJava2File(filer, packageName, typeSpec);
        return schemaName;
    }

    public TypeSpec.Builder buildDaoFactoryInterfaceInternal(Elements elementUtils, Filer filer, SQLiteDatabaseSchema schema) throws Exception {
        String schemaName = BindDaoFactoryBuilder.buildDaoFactoryName(schema);
        this.classBuilder = TypeSpec.interfaceBuilder((String)schemaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(BindDaoFactory.class);
        this.classBuilder.addJavadoc("<p>\n", new Object[0]);
        this.classBuilder.addJavadoc("Represents dao factory interface for $L.\n", new Object[]{schema.getName()});
        this.classBuilder.addJavadoc("This class expose database interface through Dao attribute.\n", new Object[]{schema.getName()});
        this.classBuilder.addJavadoc("</p>\n\n", new Object[0]);
        JavadocUtility.generateJavadocGeneratedBy(this.classBuilder);
        this.classBuilder.addJavadoc("@see $T\n", new Object[]{TypeUtility.typeName(schema.getElement())});
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            TypeName daoName = BindDaoBuilder.daoInterfaceTypeName(dao);
            TypeName daoImplName = BindDaoBuilder.daoTypeName(dao);
            this.classBuilder.addJavadoc("@see $T\n", new Object[]{daoName});
            this.classBuilder.addJavadoc("@see $T\n", new Object[]{daoImplName});
            String entity = BindDataSourceSubProcessor.generateEntityName(dao, dao.getEntity());
            this.classBuilder.addJavadoc("@see $T\n", new Object[]{TypeUtility.typeName(entity)});
        }
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            TypeName daoImplName = BindDaoBuilder.daoTypeName(dao);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("get" + dao.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc("Retrieve dao $L.\n\n@return dao implementation\n", new Object[]{dao.getName()}).returns(daoImplName);
            this.classBuilder.addMethod(methodBuilder.build());
        }
        SchemaUtility.generateTransaction(this.classBuilder, schema, true);
        return this.classBuilder;
    }

    public static String buildDaoFactoryName(SQLiteDatabaseSchema schema) {
        String schemaName = schema.getName();
        schemaName = PREFIX + schemaName;
        schemaName = schemaName.replace("DataSource", SUFFIX);
        return schemaName;
    }
}

