/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.sqlite.SQLiteEvent;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.PropertyNotFoundException;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;

public abstract class GenericSQLHelper {
    public static void generateSubjectNext(SQLiteEntity entity, MethodSpec.Builder methodBuilder, SubjectType subjectType, String value) {
        String subInsertType = "";
        if (subjectType == SubjectType.INSERT) {
            subInsertType = entity.getPrimaryKey().isType(new Type[]{String.class}) ? "WithUid" : "WithId";
        }
        methodBuilder.beginControlFlow("if (result>0)", new Object[0]);
        methodBuilder.addComment("rx management ", new Object[0]);
        methodBuilder.addStatement("subject.onNext($T.create$L$L($L))", new Object[]{SQLiteEvent.class, subjectType.value(), subInsertType, value});
        methodBuilder.endControlFlow();
    }

    public static void generateGenericExecSQL(MethodSpec.Builder methodBuilder, final SQLiteModelMethod method) {
        final ArrayList paramsList = new ArrayList();
        final ArrayList contentValueList = new ArrayList();
        final One columnsToUpdate = new One((Object)true);
        String sql = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public void onWhereStatementBegin(JqlParser.Where_stmtContext ctx) {
                super.onWhereStatementBegin(ctx);
                columnsToUpdate.value0 = false;
            }

            @Override
            public void onWhereStatementEnd(JqlParser.Where_stmtContext ctx) {
                super.onWhereStatementEnd(ctx);
                columnsToUpdate.value0 = true;
            }

            @Override
            public String onColumnName(String columnName) {
                String resolvedName = this.currentSchema.findColumnNameByPropertyName(method, columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(resolvedName != null, method, columnName);
                return resolvedName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                String propertyName = method.findParameterAliasByName(bindParameterName);
                if (((Boolean)columnsToUpdate.value0).booleanValue()) {
                    contentValueList.add(propertyName);
                } else {
                    paramsList.add(propertyName);
                }
                return "?";
            }
        });
        SQLiteEntity entity = method.getEntity();
        for (String item : contentValueList) {
            String propertyName = method.findParameterNameByAlias(item);
            TypeName paramType = method.findParameterTypeByAliasOrName(item);
            SQLProperty property = (SQLProperty)entity.get(item);
            if (propertyName == null) {
                throw new PropertyNotFoundException(method, propertyName, paramType);
            }
            Pair methodParam = new Pair((Object)propertyName, (Object)paramType);
            TypeUtility.checkTypeCompatibility(method, (Pair<String, TypeName>)methodParam, property);
            if (method.isLogEnabled()) {
                methodBuilder.addCode("_contentValues.put($S, ", new Object[]{property.columnName});
            } else {
                methodBuilder.addCode("_contentValues.put(", new Object[0]);
            }
            SQLTransformer.javaMethodParam2ContentValues(methodBuilder, method, (String)methodParam.value0, (TypeName)methodParam.value1, property);
            methodBuilder.addCode(");\n", new Object[0]);
        }
        methodBuilder.addComment("build where condition", new Object[0]);
        for (String item : paramsList) {
            methodBuilder.addCode("_contentValues.addWhereArgs(", new Object[0]);
            TypeName paramType = method.findParameterTypeByAliasOrName(item);
            String realName = method.findParameterNameByAlias(item);
            AssertKripton.assertTrueOrUnknownPropertyInJQLException(paramType != null, method, item);
            boolean nullable = TypeUtility.isNullable(paramType);
            if (nullable) {
                methodBuilder.addCode("($L==null?\"\":", new Object[]{realName});
            }
            TypeUtility.beginStringConversion(methodBuilder, paramType);
            SQLTransformer.javaMethodParam2ContentValues(methodBuilder, method, realName, paramType, null);
            TypeUtility.endStringConversion(methodBuilder, paramType);
            if (nullable) {
                methodBuilder.addCode(")", new Object[0]);
            }
            methodBuilder.addCode(");\n", new Object[0]);
        }
        SqlBuilderHelper.generateLog(method, methodBuilder);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addStatement("database().execSQL($S, _contentValues.whereArgsAsArray())", new Object[]{sql});
    }

    public static enum SubjectType {
        INSERT("Insert"),
        UPDATE("Update"),
        DELETE("Delete");

        private String value;

        private SubjectType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

