/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.sqlite.SQLiteStatement;
import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindSqlInsert;
import com.abubusoft.kripton.android.sqlite.ConflictAlgorithmType;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.KriptonDatabaseWrapper;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.CodeBuilderUtility;
import com.abubusoft.kripton.processor.sqlite.GenericSQLHelper;
import com.abubusoft.kripton.processor.sqlite.InsertRawHelper;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlInsertBuilder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class InsertBeanHelper
implements SqlInsertBuilder.InsertCodeGenerator {
    @Override
    public void generate(TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, boolean mapFields, SQLiteModelMethod method, TypeName returnType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        String entityParamName = (String)method.getParameters().get((int)0).value0;
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate()", new Object[]{KriptonContentValues.class});
        } else {
            String psName = method.buildPreparedStatementName();
            classBuilder.addField(FieldSpec.builder((TypeName)TypeName.get(SQLiteStatement.class), (String)psName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build());
            methodBuilder.beginControlFlow("if ($L==null)", new Object[]{psName});
            SqlBuilderHelper.generateSQLForStaticQuery(method, methodBuilder);
            methodBuilder.addStatement("$L = $T.compile(_context, _sql)", new Object[]{psName, KriptonDatabaseWrapper.class});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate($L)", new Object[]{KriptonContentValues.class, psName});
        }
        List<SQLProperty> listUsedProperty = CodeBuilderUtility.extractUsedProperties(methodBuilder, method, BindSqlInsert.class);
        CodeBuilderUtility.generateContentValuesFromEntity(BaseProcessor.elementUtils, method, BindSqlInsert.class, methodBuilder, null);
        SQLProperty primaryKey = entity.getPrimaryKey();
        this.generateJavaDoc(methodBuilder, method, returnType, listUsedProperty, primaryKey);
        SqlBuilderHelper.generateLog(method, methodBuilder);
        methodBuilder.addComment("insert operation", new Object[0]);
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            SqlBuilderHelper.generateSQLForInsertDynamic(method, methodBuilder);
            methodBuilder.addStatement("long result = $T.insert(_context, _sql, _contentValues)", new Object[]{KriptonDatabaseWrapper.class});
        } else {
            String psName = method.buildPreparedStatementName();
            methodBuilder.addStatement("long result = $T.insert($L, _contentValues)", new Object[]{KriptonDatabaseWrapper.class, psName});
        }
        if (entity.isImmutablePojo()) {
            if (TypeUtility.isEquals(returnType, entity)) {
                methodBuilder.addComment("immutable POJO - create a copy with new id", new Object[0]);
                ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
                ImmutableUtility.generateImmutableVariableCopyFromEntity(entity, methodBuilder, entityParamName);
                if (primaryKey != null && !primaryKey.isType(new Type[]{String.class}) && primaryKey.columnType != ColumnType.PRIMARY_KEY_UNMANGED) {
                    methodBuilder.addCode("$L$L=result;\n", new Object[]{ImmutableUtility.IMMUTABLE_PREFIX, primaryKey.getName()});
                }
                ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, entityParamName, false);
            }
        } else if (primaryKey != null && !primaryKey.isType(new Type[]{String.class}) && primaryKey.columnType != ColumnType.PRIMARY_KEY_UNMANGED) {
            methodBuilder.addComment("if PK string, can not overwrite id (with a long) same thing if column type is UNMANAGED (user manage PK)", new Object[0]);
            if (primaryKey.isPublicField()) {
                methodBuilder.addCode("$L.$L=result;\n", new Object[]{entityParamName, primaryKey.getName()});
            } else {
                methodBuilder.addCode("$L(result);\n", new Object[]{PropertyUtility.setter(TypeUtility.typeName(entity.getElement()), entityParamName, primaryKey)});
            }
        }
        if (method.getParent().getParent().generateRx) {
            String rxIdGetter = null;
            if (entity.getPrimaryKey().columnType == ColumnType.PRIMARY_KEY) {
                rxIdGetter = "result";
            } else {
                for (SQLProperty item : listUsedProperty) {
                    if (!item.isPrimaryKey()) continue;
                    rxIdGetter = entityParamName + "." + PropertyUtility.getter(item);
                    break;
                }
            }
            GenericSQLHelper.generateSubjectNext(entity, methodBuilder, GenericSQLHelper.SubjectType.INSERT, rxIdGetter);
        }
        if (daoDefinition.hasLiveData()) {
            methodBuilder.addComment("support for livedata", new Object[0]);
            methodBuilder.addStatement("registryEvent(result>0?1:0)", new Object[0]);
        }
        if (returnType != TypeName.VOID) {
            if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{String.class})) {
                methodBuilder.addCode("\n", new Object[0]);
                methodBuilder.addCode("return String.valueOf(result);\n", new Object[0]);
            } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Boolean.TYPE, Boolean.class})) {
                methodBuilder.addCode("\n", new Object[0]);
                methodBuilder.addCode("return result!=-1;\n", new Object[0]);
            } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Long.TYPE, Long.class})) {
                methodBuilder.addCode("\n", new Object[0]);
                methodBuilder.addCode("return result;\n", new Object[0]);
            } else if (TypeUtility.isTypeIncludedIn(returnType, new Type[]{Integer.TYPE, Integer.class})) {
                methodBuilder.addCode("\n", new Object[0]);
                methodBuilder.addCode("return (int)result;\n", new Object[0]);
            } else if (TypeUtility.isEquals(returnType, entity)) {
                methodBuilder.addCode("\n", new Object[0]);
                methodBuilder.addCode("return $L;\n", new Object[]{entityParamName});
            } else {
                throw new InvalidMethodSignException(method, "invalid return type");
            }
        }
    }

    public void generateJavaDoc(MethodSpec.Builder methodBuilder, final SQLiteModelMethod method, TypeName returnType, List<SQLProperty> listUsedProperty, ModelProperty primaryKey) {
        String sqlInsert = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnName(String columnName) {
                Set<SQLProperty> property = this.currentSchema.getPropertyBySimpleName(columnName);
                SQLProperty tempProperty = property.iterator().next();
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                String resolvedParamName = method.findParameterNameByAlias(bindParameterName);
                return SqlAnalyzer.PARAM_PREFIX + resolvedParamName + SqlAnalyzer.PARAM_SUFFIX;
            }
        });
        String beanNameParameter = method.findParameterAliasByName((String)method.getParameters().get((int)0).value0);
        methodBuilder.addJavadoc("<h2>SQL insert</h2>\n", new Object[0]);
        methodBuilder.addJavadoc("<pre>$L</pre>\n\n", new Object[]{sqlInsert});
        methodBuilder.addJavadoc("<p><code>$L.$L</code> is automatically updated because it is the primary key</p>\n", new Object[]{beanNameParameter, primaryKey.getName()});
        methodBuilder.addJavadoc("\n", new Object[0]);
        methodBuilder.addJavadoc("<p><strong>Inserted columns:</strong></p>\n", new Object[0]);
        methodBuilder.addJavadoc("<dl>\n", new Object[0]);
        for (SQLProperty sQLProperty : listUsedProperty) {
            methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{sQLProperty.columnName});
            methodBuilder.addJavadoc("<dd>is mapped to <strong>$L</strong></dd>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + method.findParameterAliasByName((String)method.getParameters().get((int)0).value0) + "." + method.findParameterNameByAlias(sQLProperty.getName()) + SqlAnalyzer.PARAM_SUFFIX});
        }
        methodBuilder.addJavadoc("</dl>\n\n", new Object[0]);
        for (Pair pair : method.getParameters()) {
            methodBuilder.addJavadoc("@param $L", new Object[]{pair.value0});
            methodBuilder.addJavadoc("\n\tis mapped to parameter <strong>$L</strong>\n", new Object[]{method.findParameterAliasByName((String)pair.value0)});
        }
        InsertRawHelper.generateJavaDocReturnType(methodBuilder, returnType);
    }

    public static ConflictAlgorithmType getConflictAlgorithmType(SQLiteModelMethod method) {
        ModelAnnotation annotation = method.getAnnotation(BindSqlInsert.class);
        String value = annotation.getAttribute(AnnotationAttributeType.CONFLICT_ALGORITHM_TYPE);
        if (value != null && value.indexOf(".") > -1) {
            value = value.substring(value.lastIndexOf(".") + 1);
        }
        ConflictAlgorithmType conflictAlgorithmType = ConflictAlgorithmType.valueOf((String)value);
        return conflictAlgorithmType;
    }
}

